import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNetworkEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name for a specific VM instance that the IP address belongs to.
     *
     * This is required for network endpoints of type GCE_VM_IP_PORT.
     * The instance must be in the same zone of network endpoint group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#instance ComputeNetworkEndpoint#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * IPv4 address of network endpoint.
     *
     * The IP address must belong
     * to a VM in GCE (either the primary IP or as part of an aliased IP
     * range).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#ip_address ComputeNetworkEndpoint#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress: string;
    /**
     * The network endpoint group this endpoint is part of.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#network_endpoint_group ComputeNetworkEndpoint#network_endpoint_group}
     *
     * @stability stable
     */
    readonly networkEndpointGroup: string;
    /**
     * Port number of network endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#port ComputeNetworkEndpoint#port}
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#project ComputeNetworkEndpoint#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Zone where the containing network endpoint group is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#zone ComputeNetworkEndpoint#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#timeouts ComputeNetworkEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNetworkEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNetworkEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#create ComputeNetworkEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html#delete ComputeNetworkEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeNetworkEndpointTimeoutsToTerraform(struct?: ComputeNetworkEndpointTimeoutsOutputReference | ComputeNetworkEndpointTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeNetworkEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeNetworkEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeNetworkEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html google_compute_network_endpoint}.
 *
 * @stability stable
 */
export declare class ComputeNetworkEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint.html google_compute_network_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkEndpointConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    set ipAddress(value: string);
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _networkEndpointGroup?;
    /**
     * @stability stable
     */
    get networkEndpointGroup(): string;
    /**
     * @stability stable
     */
    set networkEndpointGroup(value: string);
    /**
     * @stability stable
     */
    get networkEndpointGroupInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNetworkEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeNetworkEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNetworkEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
