import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The project ID. Changing this forces a new project to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project.html#project_id DataGoogleProject#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/project.html google_project}.
 *
 * @stability stable
 */
export declare class DataGoogleProject extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/project.html google_project} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleProjectConfig);
    /**
     * @stability stable
     */
    get autoCreateNetwork(): any;
    /**
     * @stability stable
     */
    get billingAccount(): string;
    /**
     * @stability stable
     */
    get folderId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get number(): string;
    /**
     * @stability stable
     */
    get orgId(): string;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get skipDelete(): any;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
