import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the patch deployment. Length of the description is limited to 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#description OsConfigPatchDeployment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Duration of the patch.
     *
     * After the duration ends, the patch times out.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#duration OsConfigPatchDeployment#duration}
     *
     * @stability stable
     */
    readonly duration?: string;
    /**
     * A name for the patch deployment in the project.
     *
     * When creating a name the following rules apply:
     * Must contain only lowercase letters, numbers, and hyphens.
     * Must start with a letter.
     * Must be between 1-63 characters.
     * Must end with a number or a letter.
     * Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#patch_deployment_id OsConfigPatchDeployment#patch_deployment_id}
     *
     * @stability stable
     */
    readonly patchDeploymentId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#project OsConfigPatchDeployment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * instance_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instance_filter OsConfigPatchDeployment#instance_filter}
     *
     * @stability stable
     */
    readonly instanceFilter: OsConfigPatchDeploymentInstanceFilter;
    /**
     * one_time_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#one_time_schedule OsConfigPatchDeployment#one_time_schedule}
     *
     * @stability stable
     */
    readonly oneTimeSchedule?: OsConfigPatchDeploymentOneTimeSchedule;
    /**
     * patch_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#patch_config OsConfigPatchDeployment#patch_config}
     *
     * @stability stable
     */
    readonly patchConfig?: OsConfigPatchDeploymentPatchConfig;
    /**
     * recurring_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#recurring_schedule OsConfigPatchDeployment#recurring_schedule}
     *
     * @stability stable
     */
    readonly recurringSchedule?: OsConfigPatchDeploymentRecurringSchedule;
    /**
     * rollout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#rollout OsConfigPatchDeployment#rollout}
     *
     * @stability stable
     */
    readonly rollout?: OsConfigPatchDeploymentRollout;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#timeouts OsConfigPatchDeployment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OsConfigPatchDeploymentTimeouts;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentInstanceFilterGroupLabels {
    /**
     * Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#labels OsConfigPatchDeployment#labels}
     *
     * @stability stable
     */
    readonly labels: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentInstanceFilterGroupLabelsToTerraform(struct?: OsConfigPatchDeploymentInstanceFilterGroupLabels): any;
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentInstanceFilter {
    /**
     * Target all VM instances in the project. If true, no other criteria is permitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#all OsConfigPatchDeployment#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * Targets VMs whose name starts with one of these prefixes.
     *
     * Similar to labels, this is another way to group
     * VMs when targeting configs, for example prefix="prod-".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instance_name_prefixes OsConfigPatchDeployment#instance_name_prefixes}
     *
     * @stability stable
     */
    readonly instanceNamePrefixes?: string[];
    /**
     * Targets any of the VM instances specified. Instances are specified by their URI in the 'form zones/{{zone}}/instances/{{instance_name}}', 'projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}', or 'https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instances OsConfigPatchDeployment#instances}
     *
     * @stability stable
     */
    readonly instances?: string[];
    /**
     * Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#zones OsConfigPatchDeployment#zones}
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * group_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#group_labels OsConfigPatchDeployment#group_labels}
     *
     * @stability stable
     */
    readonly groupLabels?: OsConfigPatchDeploymentInstanceFilterGroupLabels[];
}
export declare function osConfigPatchDeploymentInstanceFilterToTerraform(struct?: OsConfigPatchDeploymentInstanceFilterOutputReference | OsConfigPatchDeploymentInstanceFilter): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentInstanceFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentInstanceFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentInstanceFilter | undefined);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceNamePrefixes?;
    /**
     * @stability stable
     */
    get instanceNamePrefixes(): string[];
    /**
     * @stability stable
     */
    set instanceNamePrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetInstanceNamePrefixes(): void;
    /**
     * @stability stable
     */
    get instanceNamePrefixesInput(): string[] | undefined;
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): string[];
    /**
     * @stability stable
     */
    set instances(value: string[]);
    /**
     * @stability stable
     */
    resetInstances(): void;
    /**
     * @stability stable
     */
    get instancesInput(): string[] | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _groupLabels?;
    /**
     * @stability stable
     */
    get groupLabels(): OsConfigPatchDeploymentInstanceFilterGroupLabels[];
    /**
     * @stability stable
     */
    set groupLabels(value: OsConfigPatchDeploymentInstanceFilterGroupLabels[]);
    /**
     * @stability stable
     */
    resetGroupLabels(): void;
    /**
     * @stability stable
     */
    get groupLabelsInput(): OsConfigPatchDeploymentInstanceFilterGroupLabels[] | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentOneTimeSchedule {
    /**
     * The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#execute_time OsConfigPatchDeployment#execute_time}
     *
     * @stability stable
     */
    readonly executeTime: string;
}
export declare function osConfigPatchDeploymentOneTimeScheduleToTerraform(struct?: OsConfigPatchDeploymentOneTimeScheduleOutputReference | OsConfigPatchDeploymentOneTimeSchedule): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentOneTimeScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentOneTimeSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentOneTimeSchedule | undefined);
    private _executeTime?;
    /**
     * @stability stable
     */
    get executeTime(): string;
    /**
     * @stability stable
     */
    set executeTime(value: string);
    /**
     * @stability stable
     */
    get executeTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigApt {
    /**
     * List of packages to exclude from update. These packages will be excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of packages to be updated.
     *
     * These are the only packages that will be updated.
     * If these packages are not installed, they will be ignored. This field cannot be specified with
     * any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
     *
     * @stability stable
     */
    readonly exclusivePackages?: string[];
    /**
     * By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead. Possible values: ["DIST", "UPGRADE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#type OsConfigPatchDeployment#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function osConfigPatchDeploymentPatchConfigAptToTerraform(struct?: OsConfigPatchDeploymentPatchConfigAptOutputReference | OsConfigPatchDeploymentPatchConfigApt): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigAptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigApt | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigApt | undefined);
    private _excludes?;
    /**
     * @stability stable
     */
    get excludes(): string[];
    /**
     * @stability stable
     */
    set excludes(value: string[]);
    /**
     * @stability stable
     */
    resetExcludes(): void;
    /**
     * @stability stable
     */
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    /**
     * @stability stable
     */
    get exclusivePackages(): string[];
    /**
     * @stability stable
     */
    set exclusivePackages(value: string[]);
    /**
     * @stability stable
     */
    resetExclusivePackages(): void;
    /**
     * @stability stable
     */
    get exclusivePackagesInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigGoo {
    /**
     * goo update settings. Use this setting to override the default goo patch rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#enabled OsConfigPatchDeployment#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentPatchConfigGooToTerraform(struct?: OsConfigPatchDeploymentPatchConfigGooOutputReference | OsConfigPatchDeploymentPatchConfigGoo): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigGooOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigGoo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigGoo | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _generationNumber?;
    /**
     * @stability stable
     */
    get generationNumber(): string;
    /**
     * @stability stable
     */
    set generationNumber(value: string);
    /**
     * @stability stable
     */
    get generationNumberInput(): string | undefined;
    private _object?;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    get objectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    /**
     * @stability stable
     */
    get allowedSuccessCodes(): number[];
    /**
     * @stability stable
     */
    set allowedSuccessCodes(value: number[]);
    /**
     * @stability stable
     */
    resetAllowedSuccessCodes(): void;
    /**
     * @stability stable
     */
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    /**
     * @stability stable
     */
    get interpreter(): string;
    /**
     * @stability stable
     */
    set interpreter(value: string);
    /**
     * @stability stable
     */
    resetInterpreter(): void;
    /**
     * @stability stable
     */
    get interpreterInput(): string | undefined;
    private _localPath?;
    /**
     * @stability stable
     */
    get localPath(): string;
    /**
     * @stability stable
     */
    set localPath(value: string);
    /**
     * @stability stable
     */
    resetLocalPath(): void;
    /**
     * @stability stable
     */
    get localPathInput(): string | undefined;
    private _gcsObject;
    /**
     * @stability stable
     */
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference;
    /**
     * @stability stable
     */
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject): void;
    /**
     * @stability stable
     */
    resetGcsObject(): void;
    /**
     * @stability stable
     */
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _generationNumber?;
    /**
     * @stability stable
     */
    get generationNumber(): string;
    /**
     * @stability stable
     */
    set generationNumber(value: string);
    /**
     * @stability stable
     */
    get generationNumberInput(): string | undefined;
    private _object?;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    get objectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    /**
     * @stability stable
     */
    get allowedSuccessCodes(): number[];
    /**
     * @stability stable
     */
    set allowedSuccessCodes(value: number[]);
    /**
     * @stability stable
     */
    resetAllowedSuccessCodes(): void;
    /**
     * @stability stable
     */
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    /**
     * @stability stable
     */
    get interpreter(): string;
    /**
     * @stability stable
     */
    set interpreter(value: string);
    /**
     * @stability stable
     */
    resetInterpreter(): void;
    /**
     * @stability stable
     */
    get interpreterInput(): string | undefined;
    private _localPath?;
    /**
     * @stability stable
     */
    get localPath(): string;
    /**
     * @stability stable
     */
    set localPath(value: string);
    /**
     * @stability stable
     */
    resetLocalPath(): void;
    /**
     * @stability stable
     */
    get localPathInput(): string | undefined;
    private _gcsObject;
    /**
     * @stability stable
     */
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference;
    /**
     * @stability stable
     */
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject): void;
    /**
     * @stability stable
     */
    resetGcsObject(): void;
    /**
     * @stability stable
     */
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStep {
    /**
     * linux_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
     *
     * @stability stable
     */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig;
    /**
     * windows_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
     *
     * @stability stable
     */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepOutputReference | OsConfigPatchDeploymentPatchConfigPostStep): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPostStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStep | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStep | undefined);
    private _linuxExecStepConfig;
    /**
     * @stability stable
     */
    get linuxExecStepConfig(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference;
    /**
     * @stability stable
     */
    putLinuxExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig): void;
    /**
     * @stability stable
     */
    resetLinuxExecStepConfig(): void;
    /**
     * @stability stable
     */
    get linuxExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig;
    /**
     * @stability stable
     */
    get windowsExecStepConfig(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference;
    /**
     * @stability stable
     */
    putWindowsExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig): void;
    /**
     * @stability stable
     */
    resetWindowsExecStepConfig(): void;
    /**
     * @stability stable
     */
    get windowsExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _generationNumber?;
    /**
     * @stability stable
     */
    get generationNumber(): string;
    /**
     * @stability stable
     */
    set generationNumber(value: string);
    /**
     * @stability stable
     */
    get generationNumberInput(): string | undefined;
    private _object?;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    get objectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    /**
     * @stability stable
     */
    get allowedSuccessCodes(): number[];
    /**
     * @stability stable
     */
    set allowedSuccessCodes(value: number[]);
    /**
     * @stability stable
     */
    resetAllowedSuccessCodes(): void;
    /**
     * @stability stable
     */
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    /**
     * @stability stable
     */
    get interpreter(): string;
    /**
     * @stability stable
     */
    set interpreter(value: string);
    /**
     * @stability stable
     */
    resetInterpreter(): void;
    /**
     * @stability stable
     */
    get interpreterInput(): string | undefined;
    private _localPath?;
    /**
     * @stability stable
     */
    get localPath(): string;
    /**
     * @stability stable
     */
    set localPath(value: string);
    /**
     * @stability stable
     */
    resetLocalPath(): void;
    /**
     * @stability stable
     */
    get localPathInput(): string | undefined;
    private _gcsObject;
    /**
     * @stability stable
     */
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference;
    /**
     * @stability stable
     */
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject): void;
    /**
     * @stability stable
     */
    resetGcsObject(): void;
    /**
     * @stability stable
     */
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _generationNumber?;
    /**
     * @stability stable
     */
    get generationNumber(): string;
    /**
     * @stability stable
     */
    set generationNumber(value: string);
    /**
     * @stability stable
     */
    get generationNumberInput(): string | undefined;
    private _object?;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    get objectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    /**
     * @stability stable
     */
    get allowedSuccessCodes(): number[];
    /**
     * @stability stable
     */
    set allowedSuccessCodes(value: number[]);
    /**
     * @stability stable
     */
    resetAllowedSuccessCodes(): void;
    /**
     * @stability stable
     */
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    /**
     * @stability stable
     */
    get interpreter(): string;
    /**
     * @stability stable
     */
    set interpreter(value: string);
    /**
     * @stability stable
     */
    resetInterpreter(): void;
    /**
     * @stability stable
     */
    get interpreterInput(): string | undefined;
    private _localPath?;
    /**
     * @stability stable
     */
    get localPath(): string;
    /**
     * @stability stable
     */
    set localPath(value: string);
    /**
     * @stability stable
     */
    resetLocalPath(): void;
    /**
     * @stability stable
     */
    get localPathInput(): string | undefined;
    private _gcsObject;
    /**
     * @stability stable
     */
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference;
    /**
     * @stability stable
     */
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject): void;
    /**
     * @stability stable
     */
    resetGcsObject(): void;
    /**
     * @stability stable
     */
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStep {
    /**
     * linux_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
     *
     * @stability stable
     */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig;
    /**
     * windows_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
     *
     * @stability stable
     */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepOutputReference | OsConfigPatchDeploymentPatchConfigPreStep): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigPreStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStep | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStep | undefined);
    private _linuxExecStepConfig;
    /**
     * @stability stable
     */
    get linuxExecStepConfig(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference;
    /**
     * @stability stable
     */
    putLinuxExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig): void;
    /**
     * @stability stable
     */
    resetLinuxExecStepConfig(): void;
    /**
     * @stability stable
     */
    get linuxExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig;
    /**
     * @stability stable
     */
    get windowsExecStepConfig(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference;
    /**
     * @stability stable
     */
    putWindowsExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig): void;
    /**
     * @stability stable
     */
    resetWindowsExecStepConfig(): void;
    /**
     * @stability stable
     */
    get windowsExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigWindowsUpdate {
    /**
     * Only apply updates of these windows update classifications.
     *
     * If empty, all updates are applied. Possible values: ["CRITICAL", "SECURITY", "DEFINITION", "DRIVER", "FEATURE_PACK", "SERVICE_PACK", "TOOL", "UPDATE_ROLLUP", "UPDATE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#classifications OsConfigPatchDeployment#classifications}
     *
     * @stability stable
     */
    readonly classifications?: string[];
    /**
     * List of KBs to exclude from update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of kbs to be updated.
     *
     * These are the only patches that will be updated.
     * This field must not be used with other patch configurations.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
     *
     * @stability stable
     */
    readonly exclusivePatches?: string[];
}
export declare function osConfigPatchDeploymentPatchConfigWindowsUpdateToTerraform(struct?: OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference | OsConfigPatchDeploymentPatchConfigWindowsUpdate): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined);
    private _classifications?;
    /**
     * @stability stable
     */
    get classifications(): string[];
    /**
     * @stability stable
     */
    set classifications(value: string[]);
    /**
     * @stability stable
     */
    resetClassifications(): void;
    /**
     * @stability stable
     */
    get classificationsInput(): string[] | undefined;
    private _excludes?;
    /**
     * @stability stable
     */
    get excludes(): string[];
    /**
     * @stability stable
     */
    set excludes(value: string[]);
    /**
     * @stability stable
     */
    resetExcludes(): void;
    /**
     * @stability stable
     */
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    /**
     * @stability stable
     */
    get exclusivePatches(): string[];
    /**
     * @stability stable
     */
    set exclusivePatches(value: string[]);
    /**
     * @stability stable
     */
    resetExclusivePatches(): void;
    /**
     * @stability stable
     */
    get exclusivePatchesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigYum {
    /**
     * List of packages to exclude from update. These packages will be excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of packages to be updated.
     *
     * These are the only packages that will be updated.
     * If these packages are not installed, they will be ignored. This field cannot be specified with
     * any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
     *
     * @stability stable
     */
    readonly exclusivePackages?: string[];
    /**
     * Will cause patch to run yum update-minimal instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#minimal OsConfigPatchDeployment#minimal}
     *
     * @stability stable
     */
    readonly minimal?: boolean | cdktf.IResolvable;
    /**
     * Adds the --security flag to yum update. Not supported on all platforms.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#security OsConfigPatchDeployment#security}
     *
     * @stability stable
     */
    readonly security?: boolean | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentPatchConfigYumToTerraform(struct?: OsConfigPatchDeploymentPatchConfigYumOutputReference | OsConfigPatchDeploymentPatchConfigYum): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigYumOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigYum | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigYum | undefined);
    private _excludes?;
    /**
     * @stability stable
     */
    get excludes(): string[];
    /**
     * @stability stable
     */
    set excludes(value: string[]);
    /**
     * @stability stable
     */
    resetExcludes(): void;
    /**
     * @stability stable
     */
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    /**
     * @stability stable
     */
    get exclusivePackages(): string[];
    /**
     * @stability stable
     */
    set exclusivePackages(value: string[]);
    /**
     * @stability stable
     */
    resetExclusivePackages(): void;
    /**
     * @stability stable
     */
    get exclusivePackagesInput(): string[] | undefined;
    private _minimal?;
    /**
     * @stability stable
     */
    get minimal(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set minimal(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMinimal(): void;
    /**
     * @stability stable
     */
    get minimalInput(): boolean | cdktf.IResolvable | undefined;
    private _security?;
    /**
     * @stability stable
     */
    get security(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set security(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecurity(): void;
    /**
     * @stability stable
     */
    get securityInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigZypper {
    /**
     * Install only patches with these categories. Common categories include security, recommended, and feature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#categories OsConfigPatchDeployment#categories}
     *
     * @stability stable
     */
    readonly categories?: string[];
    /**
     * List of packages to exclude from update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of patches to be updated.
     *
     * These are the only patches that will be installed using 'zypper patch patch:' command.
     * This field must not be used with any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
     *
     * @stability stable
     */
    readonly exclusivePatches?: string[];
    /**
     * Install only patches with these severities. Common severities include critical, important, moderate, and low.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#severities OsConfigPatchDeployment#severities}
     *
     * @stability stable
     */
    readonly severities?: string[];
    /**
     * Adds the --with-optional flag to zypper patch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#with_optional OsConfigPatchDeployment#with_optional}
     *
     * @stability stable
     */
    readonly withOptional?: boolean | cdktf.IResolvable;
    /**
     * Adds the --with-update flag, to zypper patch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#with_update OsConfigPatchDeployment#with_update}
     *
     * @stability stable
     */
    readonly withUpdate?: boolean | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentPatchConfigZypperToTerraform(struct?: OsConfigPatchDeploymentPatchConfigZypperOutputReference | OsConfigPatchDeploymentPatchConfigZypper): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigZypperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfigZypper | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfigZypper | undefined);
    private _categories?;
    /**
     * @stability stable
     */
    get categories(): string[];
    /**
     * @stability stable
     */
    set categories(value: string[]);
    /**
     * @stability stable
     */
    resetCategories(): void;
    /**
     * @stability stable
     */
    get categoriesInput(): string[] | undefined;
    private _excludes?;
    /**
     * @stability stable
     */
    get excludes(): string[];
    /**
     * @stability stable
     */
    set excludes(value: string[]);
    /**
     * @stability stable
     */
    resetExcludes(): void;
    /**
     * @stability stable
     */
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    /**
     * @stability stable
     */
    get exclusivePatches(): string[];
    /**
     * @stability stable
     */
    set exclusivePatches(value: string[]);
    /**
     * @stability stable
     */
    resetExclusivePatches(): void;
    /**
     * @stability stable
     */
    get exclusivePatchesInput(): string[] | undefined;
    private _severities?;
    /**
     * @stability stable
     */
    get severities(): string[];
    /**
     * @stability stable
     */
    set severities(value: string[]);
    /**
     * @stability stable
     */
    resetSeverities(): void;
    /**
     * @stability stable
     */
    get severitiesInput(): string[] | undefined;
    private _withOptional?;
    /**
     * @stability stable
     */
    get withOptional(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withOptional(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithOptional(): void;
    /**
     * @stability stable
     */
    get withOptionalInput(): boolean | cdktf.IResolvable | undefined;
    private _withUpdate?;
    /**
     * @stability stable
     */
    get withUpdate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withUpdate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithUpdate(): void;
    /**
     * @stability stable
     */
    get withUpdateInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfig {
    /**
     * Post-patch reboot settings. Possible values: ["DEFAULT", "ALWAYS", "NEVER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#reboot_config OsConfigPatchDeployment#reboot_config}
     *
     * @stability stable
     */
    readonly rebootConfig?: string;
    /**
     * apt block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#apt OsConfigPatchDeployment#apt}
     *
     * @stability stable
     */
    readonly apt?: OsConfigPatchDeploymentPatchConfigApt;
    /**
     * goo block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#goo OsConfigPatchDeployment#goo}
     *
     * @stability stable
     */
    readonly goo?: OsConfigPatchDeploymentPatchConfigGoo;
    /**
     * post_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#post_step OsConfigPatchDeployment#post_step}
     *
     * @stability stable
     */
    readonly postStep?: OsConfigPatchDeploymentPatchConfigPostStep;
    /**
     * pre_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#pre_step OsConfigPatchDeployment#pre_step}
     *
     * @stability stable
     */
    readonly preStep?: OsConfigPatchDeploymentPatchConfigPreStep;
    /**
     * windows_update block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_update OsConfigPatchDeployment#windows_update}
     *
     * @stability stable
     */
    readonly windowsUpdate?: OsConfigPatchDeploymentPatchConfigWindowsUpdate;
    /**
     * yum block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#yum OsConfigPatchDeployment#yum}
     *
     * @stability stable
     */
    readonly yum?: OsConfigPatchDeploymentPatchConfigYum;
    /**
     * zypper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#zypper OsConfigPatchDeployment#zypper}
     *
     * @stability stable
     */
    readonly zypper?: OsConfigPatchDeploymentPatchConfigZypper;
}
export declare function osConfigPatchDeploymentPatchConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigOutputReference | OsConfigPatchDeploymentPatchConfig): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentPatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentPatchConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentPatchConfig | undefined);
    private _rebootConfig?;
    /**
     * @stability stable
     */
    get rebootConfig(): string;
    /**
     * @stability stable
     */
    set rebootConfig(value: string);
    /**
     * @stability stable
     */
    resetRebootConfig(): void;
    /**
     * @stability stable
     */
    get rebootConfigInput(): string | undefined;
    private _apt;
    /**
     * @stability stable
     */
    get apt(): OsConfigPatchDeploymentPatchConfigAptOutputReference;
    /**
     * @stability stable
     */
    putApt(value: OsConfigPatchDeploymentPatchConfigApt): void;
    /**
     * @stability stable
     */
    resetApt(): void;
    /**
     * @stability stable
     */
    get aptInput(): OsConfigPatchDeploymentPatchConfigApt | undefined;
    private _goo;
    /**
     * @stability stable
     */
    get goo(): OsConfigPatchDeploymentPatchConfigGooOutputReference;
    /**
     * @stability stable
     */
    putGoo(value: OsConfigPatchDeploymentPatchConfigGoo): void;
    /**
     * @stability stable
     */
    resetGoo(): void;
    /**
     * @stability stable
     */
    get gooInput(): OsConfigPatchDeploymentPatchConfigGoo | undefined;
    private _postStep;
    /**
     * @stability stable
     */
    get postStep(): OsConfigPatchDeploymentPatchConfigPostStepOutputReference;
    /**
     * @stability stable
     */
    putPostStep(value: OsConfigPatchDeploymentPatchConfigPostStep): void;
    /**
     * @stability stable
     */
    resetPostStep(): void;
    /**
     * @stability stable
     */
    get postStepInput(): OsConfigPatchDeploymentPatchConfigPostStep | undefined;
    private _preStep;
    /**
     * @stability stable
     */
    get preStep(): OsConfigPatchDeploymentPatchConfigPreStepOutputReference;
    /**
     * @stability stable
     */
    putPreStep(value: OsConfigPatchDeploymentPatchConfigPreStep): void;
    /**
     * @stability stable
     */
    resetPreStep(): void;
    /**
     * @stability stable
     */
    get preStepInput(): OsConfigPatchDeploymentPatchConfigPreStep | undefined;
    private _windowsUpdate;
    /**
     * @stability stable
     */
    get windowsUpdate(): OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference;
    /**
     * @stability stable
     */
    putWindowsUpdate(value: OsConfigPatchDeploymentPatchConfigWindowsUpdate): void;
    /**
     * @stability stable
     */
    resetWindowsUpdate(): void;
    /**
     * @stability stable
     */
    get windowsUpdateInput(): OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined;
    private _yum;
    /**
     * @stability stable
     */
    get yum(): OsConfigPatchDeploymentPatchConfigYumOutputReference;
    /**
     * @stability stable
     */
    putYum(value: OsConfigPatchDeploymentPatchConfigYum): void;
    /**
     * @stability stable
     */
    resetYum(): void;
    /**
     * @stability stable
     */
    get yumInput(): OsConfigPatchDeploymentPatchConfigYum | undefined;
    private _zypper;
    /**
     * @stability stable
     */
    get zypper(): OsConfigPatchDeploymentPatchConfigZypperOutputReference;
    /**
     * @stability stable
     */
    putZypper(value: OsConfigPatchDeploymentPatchConfigZypper): void;
    /**
     * @stability stable
     */
    resetZypper(): void;
    /**
     * @stability stable
     */
    get zypperInput(): OsConfigPatchDeploymentPatchConfigZypper | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth {
    /**
     * A day of the week. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#day_of_week OsConfigPatchDeployment#day_of_week}
     *
     * @stability stable
     */
    readonly dayOfWeek: string;
    /**
     * Week number in a month.
     *
     * 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#week_ordinal OsConfigPatchDeployment#week_ordinal}
     *
     * @stability stable
     */
    readonly weekOrdinal: number;
}
export declare function osConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference | OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined);
    private _dayOfWeek?;
    /**
     * @stability stable
     */
    get dayOfWeek(): string;
    /**
     * @stability stable
     */
    set dayOfWeek(value: string);
    /**
     * @stability stable
     */
    get dayOfWeekInput(): string | undefined;
    private _weekOrdinal?;
    /**
     * @stability stable
     */
    get weekOrdinal(): number;
    /**
     * @stability stable
     */
    set weekOrdinal(value: number);
    /**
     * @stability stable
     */
    get weekOrdinalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleMonthly {
    /**
     * One day of the month.
     *
     * 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
     * Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
     * will not run in February, April, June, etc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#month_day OsConfigPatchDeployment#month_day}
     *
     * @stability stable
     */
    readonly monthDay?: number;
    /**
     * week_day_of_month block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#week_day_of_month OsConfigPatchDeployment#week_day_of_month}
     *
     * @stability stable
     */
    readonly weekDayOfMonth?: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth;
}
export declare function osConfigPatchDeploymentRecurringScheduleMonthlyToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference | OsConfigPatchDeploymentRecurringScheduleMonthly): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleMonthly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleMonthly | undefined);
    private _monthDay?;
    /**
     * @stability stable
     */
    get monthDay(): number;
    /**
     * @stability stable
     */
    set monthDay(value: number);
    /**
     * @stability stable
     */
    resetMonthDay(): void;
    /**
     * @stability stable
     */
    get monthDayInput(): number | undefined;
    private _weekDayOfMonth;
    /**
     * @stability stable
     */
    get weekDayOfMonth(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference;
    /**
     * @stability stable
     */
    putWeekDayOfMonth(value: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth): void;
    /**
     * @stability stable
     */
    resetWeekDayOfMonth(): void;
    /**
     * @stability stable
     */
    get weekDayOfMonthInput(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleTimeOfDay {
    /**
     * Hours of day in 24 hour format.
     *
     * Should be from 0 to 23.
     * An API may choose to allow the value "24:00:00" for scenarios like business closing time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#hours OsConfigPatchDeployment#hours}
     *
     * @stability stable
     */
    readonly hours?: number;
    /**
     * Minutes of hour of day. Must be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#minutes OsConfigPatchDeployment#minutes}
     *
     * @stability stable
     */
    readonly minutes?: number;
    /**
     * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#nanos OsConfigPatchDeployment#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Seconds of minutes of the time.
     *
     * Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#seconds OsConfigPatchDeployment#seconds}
     *
     * @stability stable
     */
    readonly seconds?: number;
}
export declare function osConfigPatchDeploymentRecurringScheduleTimeOfDayToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference | OsConfigPatchDeploymentRecurringScheduleTimeOfDay): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined);
    private _hours?;
    /**
     * @stability stable
     */
    get hours(): number;
    /**
     * @stability stable
     */
    set hours(value: number);
    /**
     * @stability stable
     */
    resetHours(): void;
    /**
     * @stability stable
     */
    get hoursInput(): number | undefined;
    private _minutes?;
    /**
     * @stability stable
     */
    get minutes(): number;
    /**
     * @stability stable
     */
    set minutes(value: number);
    /**
     * @stability stable
     */
    resetMinutes(): void;
    /**
     * @stability stable
     */
    get minutesInput(): number | undefined;
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    set nanos(value: number);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    resetSeconds(): void;
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleTimeZone {
    /**
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#id OsConfigPatchDeployment#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * IANA Time Zone Database version number, e.g. "2019a".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#version OsConfigPatchDeployment#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
export declare function osConfigPatchDeploymentRecurringScheduleTimeZoneToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference | OsConfigPatchDeploymentRecurringScheduleTimeZone): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleTimeZone | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleTimeZone | undefined);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleWeekly {
    /**
     * IANA Time Zone Database time zone, e.g. "America/New_York". Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#day_of_week OsConfigPatchDeployment#day_of_week}
     *
     * @stability stable
     */
    readonly dayOfWeek: string;
}
export declare function osConfigPatchDeploymentRecurringScheduleWeeklyToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference | OsConfigPatchDeploymentRecurringScheduleWeekly): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleWeekly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleWeekly | undefined);
    private _dayOfWeek?;
    /**
     * @stability stable
     */
    get dayOfWeek(): string;
    /**
     * @stability stable
     */
    set dayOfWeek(value: string);
    /**
     * @stability stable
     */
    get dayOfWeekInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringSchedule {
    /**
     * The end time at which a recurring patch deployment schedule is no longer active.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#end_time OsConfigPatchDeployment#end_time}
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * The time that the recurring schedule becomes effective.
     *
     * Defaults to createTime of the patch deployment.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#start_time OsConfigPatchDeployment#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * monthly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#monthly OsConfigPatchDeployment#monthly}
     *
     * @stability stable
     */
    readonly monthly?: OsConfigPatchDeploymentRecurringScheduleMonthly;
    /**
     * time_of_day block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#time_of_day OsConfigPatchDeployment#time_of_day}
     *
     * @stability stable
     */
    readonly timeOfDay: OsConfigPatchDeploymentRecurringScheduleTimeOfDay;
    /**
     * time_zone block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#time_zone OsConfigPatchDeployment#time_zone}
     *
     * @stability stable
     */
    readonly timeZone: OsConfigPatchDeploymentRecurringScheduleTimeZone;
    /**
     * weekly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#weekly OsConfigPatchDeployment#weekly}
     *
     * @stability stable
     */
    readonly weekly?: OsConfigPatchDeploymentRecurringScheduleWeekly;
}
export declare function osConfigPatchDeploymentRecurringScheduleToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleOutputReference | OsConfigPatchDeploymentRecurringSchedule): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRecurringScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRecurringSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRecurringSchedule | undefined);
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _monthly;
    /**
     * @stability stable
     */
    get monthly(): OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference;
    /**
     * @stability stable
     */
    putMonthly(value: OsConfigPatchDeploymentRecurringScheduleMonthly): void;
    /**
     * @stability stable
     */
    resetMonthly(): void;
    /**
     * @stability stable
     */
    get monthlyInput(): OsConfigPatchDeploymentRecurringScheduleMonthly | undefined;
    private _timeOfDay;
    /**
     * @stability stable
     */
    get timeOfDay(): OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference;
    /**
     * @stability stable
     */
    putTimeOfDay(value: OsConfigPatchDeploymentRecurringScheduleTimeOfDay): void;
    /**
     * @stability stable
     */
    get timeOfDayInput(): OsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined;
    private _timeZone;
    /**
     * @stability stable
     */
    get timeZone(): OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference;
    /**
     * @stability stable
     */
    putTimeZone(value: OsConfigPatchDeploymentRecurringScheduleTimeZone): void;
    /**
     * @stability stable
     */
    get timeZoneInput(): OsConfigPatchDeploymentRecurringScheduleTimeZone | undefined;
    private _weekly;
    /**
     * @stability stable
     */
    get weekly(): OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference;
    /**
     * @stability stable
     */
    putWeekly(value: OsConfigPatchDeploymentRecurringScheduleWeekly): void;
    /**
     * @stability stable
     */
    resetWeekly(): void;
    /**
     * @stability stable
     */
    get weeklyInput(): OsConfigPatchDeploymentRecurringScheduleWeekly | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRolloutDisruptionBudget {
    /**
     * Specifies a fixed value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#fixed OsConfigPatchDeployment#fixed}
     *
     * @stability stable
     */
    readonly fixed?: number;
    /**
     * Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#percentage OsConfigPatchDeployment#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
}
export declare function osConfigPatchDeploymentRolloutDisruptionBudgetToTerraform(struct?: OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference | OsConfigPatchDeploymentRolloutDisruptionBudget): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRolloutDisruptionBudget | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRolloutDisruptionBudget | undefined);
    private _fixed?;
    /**
     * @stability stable
     */
    get fixed(): number;
    /**
     * @stability stable
     */
    set fixed(value: number);
    /**
     * @stability stable
     */
    resetFixed(): void;
    /**
     * @stability stable
     */
    get fixedInput(): number | undefined;
    private _percentage?;
    /**
     * @stability stable
     */
    get percentage(): number;
    /**
     * @stability stable
     */
    set percentage(value: number);
    /**
     * @stability stable
     */
    resetPercentage(): void;
    /**
     * @stability stable
     */
    get percentageInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRollout {
    /**
     * Mode of the patch rollout. Possible values: ["ZONE_BY_ZONE", "CONCURRENT_ZONES"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#mode OsConfigPatchDeployment#mode}
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * disruption_budget block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#disruption_budget OsConfigPatchDeployment#disruption_budget}
     *
     * @stability stable
     */
    readonly disruptionBudget: OsConfigPatchDeploymentRolloutDisruptionBudget;
}
export declare function osConfigPatchDeploymentRolloutToTerraform(struct?: OsConfigPatchDeploymentRolloutOutputReference | OsConfigPatchDeploymentRollout): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentRolloutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentRollout | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentRollout | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _disruptionBudget;
    /**
     * @stability stable
     */
    get disruptionBudget(): OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference;
    /**
     * @stability stable
     */
    putDisruptionBudget(value: OsConfigPatchDeploymentRolloutDisruptionBudget): void;
    /**
     * @stability stable
     */
    get disruptionBudgetInput(): OsConfigPatchDeploymentRolloutDisruptionBudget | undefined;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#create OsConfigPatchDeployment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#delete OsConfigPatchDeployment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function osConfigPatchDeploymentTimeoutsToTerraform(struct?: OsConfigPatchDeploymentTimeoutsOutputReference | OsConfigPatchDeploymentTimeouts): any;
/**
 * @stability stable
 */
export declare class OsConfigPatchDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OsConfigPatchDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OsConfigPatchDeploymentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html google_os_config_patch_deployment}.
 *
 * @stability stable
 */
export declare class OsConfigPatchDeployment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html google_os_config_patch_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OsConfigPatchDeploymentConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    resetDuration(): void;
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastExecuteTime(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _patchDeploymentId?;
    /**
     * @stability stable
     */
    get patchDeploymentId(): string;
    /**
     * @stability stable
     */
    set patchDeploymentId(value: string);
    /**
     * @stability stable
     */
    get patchDeploymentIdInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _instanceFilter;
    /**
     * @stability stable
     */
    get instanceFilter(): OsConfigPatchDeploymentInstanceFilterOutputReference;
    /**
     * @stability stable
     */
    putInstanceFilter(value: OsConfigPatchDeploymentInstanceFilter): void;
    /**
     * @stability stable
     */
    get instanceFilterInput(): OsConfigPatchDeploymentInstanceFilter | undefined;
    private _oneTimeSchedule;
    /**
     * @stability stable
     */
    get oneTimeSchedule(): OsConfigPatchDeploymentOneTimeScheduleOutputReference;
    /**
     * @stability stable
     */
    putOneTimeSchedule(value: OsConfigPatchDeploymentOneTimeSchedule): void;
    /**
     * @stability stable
     */
    resetOneTimeSchedule(): void;
    /**
     * @stability stable
     */
    get oneTimeScheduleInput(): OsConfigPatchDeploymentOneTimeSchedule | undefined;
    private _patchConfig;
    /**
     * @stability stable
     */
    get patchConfig(): OsConfigPatchDeploymentPatchConfigOutputReference;
    /**
     * @stability stable
     */
    putPatchConfig(value: OsConfigPatchDeploymentPatchConfig): void;
    /**
     * @stability stable
     */
    resetPatchConfig(): void;
    /**
     * @stability stable
     */
    get patchConfigInput(): OsConfigPatchDeploymentPatchConfig | undefined;
    private _recurringSchedule;
    /**
     * @stability stable
     */
    get recurringSchedule(): OsConfigPatchDeploymentRecurringScheduleOutputReference;
    /**
     * @stability stable
     */
    putRecurringSchedule(value: OsConfigPatchDeploymentRecurringSchedule): void;
    /**
     * @stability stable
     */
    resetRecurringSchedule(): void;
    /**
     * @stability stable
     */
    get recurringScheduleInput(): OsConfigPatchDeploymentRecurringSchedule | undefined;
    private _rollout;
    /**
     * @stability stable
     */
    get rollout(): OsConfigPatchDeploymentRolloutOutputReference;
    /**
     * @stability stable
     */
    putRollout(value: OsConfigPatchDeploymentRollout): void;
    /**
     * @stability stable
     */
    resetRollout(): void;
    /**
     * @stability stable
     */
    get rolloutInput(): OsConfigPatchDeploymentRollout | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): OsConfigPatchDeploymentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: OsConfigPatchDeploymentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OsConfigPatchDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
