# mypy: allow-untyped-defs, allow-incomplete-defs, allow-any-generics
# fmt: off

from typing import Any, Callable, ClassVar, Dict, List, Optional, Tuple, Union, overload

YARAMOD_VERSION: str
YARAMOD_VERSION_MAJOR: int
YARAMOD_VERSION_MINOR: int
YARAMOD_VERSION_PATCH: int
YARA_SYNTAX_VERSION: str

class AllExpression(KeywordExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class AndExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class AnyExpression(KeywordExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class ArrayAccessExpression(IdExpression):
    accessor: Expression
    array: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class ArraySymbol(Symbol):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def element_type(self) -> ExpressionType: ...
    @property
    def structure(self) -> Symbol: ...

class AsciiStringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...

class Base64StringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def has_alphabet(self) -> bool: ...

class Base64WideStringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def has_alphabet(self) -> bool: ...

class BinaryOpExpression(Expression):
    left_operand: Expression
    right_operand: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class BitwiseAndExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class BitwiseNotExpression(UnaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class BitwiseOrExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class BitwiseXorExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class BoolLiteralExpression(_BoolLiteralExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class ContainsExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class DefinedExpression(UnaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class DictionarySymbol(Symbol):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def element_type(self) -> ExpressionType: ...
    @property
    def structure(self) -> Symbol: ...

class DivideExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class DoubleLiteralExpression(_DoubleLiteralExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class EndsWithExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class EntrypointExpression(KeywordExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class EqExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class Expression:
    def __init__(self, *args, **kwargs) -> None: ...
    def accept(self, arg0) -> Union[Expression,VisitAction]: ...
    def exchange_tokens(self, arg0: Expression) -> None: ...
    def get_text(self, indent: str = ...) -> str: ...
    @property
    def text(self) -> str: ...
    @property
    def token_first(self) -> Token: ...
    @property
    def token_last(self) -> Token: ...
    @property
    def tokenstream(self) -> TokenStream: ...
    @property
    def uid(self) -> int: ...

class ExpressionType:
    __members__: ClassVar[dict] = ...  # read-only
    Bool: ClassVar[ExpressionType] = ...
    Float: ClassVar[ExpressionType] = ...
    Int: ClassVar[ExpressionType] = ...
    Object: ClassVar[ExpressionType] = ...
    Regexp: ClassVar[ExpressionType] = ...
    String: ClassVar[ExpressionType] = ...
    Undefined: ClassVar[ExpressionType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Features:
    __members__: ClassVar[dict] = ...  # read-only
    AllCurrent: ClassVar[Features] = ...
    Avast: ClassVar[Features] = ...
    AvastOnly: ClassVar[Features] = ...
    Basic: ClassVar[Features] = ...
    Everything: ClassVar[Features] = ...
    VirusTotal: ClassVar[Features] = ...
    VirusTotalOnly: ClassVar[Features] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class FilesizeExpression(KeywordExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class ForArrayExpression(ForExpression):
    id: str
    def __init__(self, *args, **kwargs) -> None: ...

class ForDictExpression(ForExpression):
    id1: str
    id2: str
    def __init__(self, *args, **kwargs) -> None: ...

class ForExpression(Expression):
    body: Expression
    iterable: Expression
    variable: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class ForStringExpression(ForExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class FullwordStringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...

class FunctionCallExpression(IdExpression):
    arguments: List[Expression]
    function: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class FunctionSymbol(Symbol):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def argument_names(self) -> List[List[str]]: ...
    @property
    def documentations(self) -> List[str]: ...
    @property
    def overloads(self) -> List[List[ExpressionType]]: ...
    @property
    def return_type(self) -> ExpressionType: ...

class GeExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class GtExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class HexString(String):
    def __init__(self, *args, **kwargs) -> None: ...

class IdExpression(Expression):
    symbol: Symbol
    def __init__(self, *args, **kwargs) -> None: ...

class IdWildcardExpression(Expression):
    id: str
    def __init__(self, *args, **kwargs) -> None: ...

class IcontainsExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class IendsWithExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class IequalsExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class IstartsWithExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class IntFunctionEndianness:
    __members__: ClassVar[dict] = ...  # read-only
    Big: ClassVar[IntFunctionEndianness] = ...
    Little: ClassVar[IntFunctionEndianness] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class IntFunctionExpression(Expression):
    argument: Expression
    function: str
    def __init__(self, *args, **kwargs) -> None: ...

class IntLiteralExpression(_IntLiteralExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class IntMultiplier:
    __members__: ClassVar[dict] = ...  # read-only
    Empty: ClassVar[IntMultiplier] = ...
    Kilobytes: ClassVar[IntMultiplier] = ...
    Megabytes: ClassVar[IntMultiplier] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class IterableExpression(Expression):
    elements: List[Expression]
    def __init__(self, *args, **kwargs) -> None: ...

class KeywordExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...

class LeExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class Literal:
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, arg0: bool) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    @overload
    def __init__(self, arg0: int, arg1: str) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: str) -> None: ...
    @overload
    def __init__(self, arg0) -> None: ...
    @property
    def float(self) -> float: ...
    @property
    def is_bool(self) -> bool: ...
    @property
    def is_float(self) -> bool: ...
    @property
    def is_int(self) -> bool: ...
    @property
    def is_string(self) -> bool: ...
    @property
    def is_symbol(self) -> bool: ...
    @property
    def pure_text(self) -> str: ...
    @property
    def string(self) -> str: ...
    @property
    def symbol(self) -> Symbol: ...
    @property
    def text(self) -> str: ...
    @property
    def uint(self) -> int: ...
    @property
    def bool(self) -> bool: ...
    @property
    def int(self) -> int: ...

class Location:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def begin(self) -> Position: ...
    @property
    def end(self) -> Position: ...
    @property
    def file_path(self) -> str: ...
    @property
    def line_number(self) -> int: ...
    @property
    def text(self) -> str: ...

class LtExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class MatchesExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class Meta:
    key: str
    value: Literal
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def token_key(self) -> Token: ...
    @property
    def token_value(self) -> Token: ...

class MinusExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class ModifyingVisitor(Visitor):
    def __init__(self) -> None: ...
    def cleanup_tokenstreams(self, context: TokenStreamContext, new_expression: Expression) -> None: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: StringAtExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: StringInRangeExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: StringOffsetExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: StringLengthExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: NotExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: DefinedExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: PercentualExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: UnaryMinusExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: BitwiseNotExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: AndExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: OrExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: LtExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: GtExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: LeExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: GeExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: EqExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: NeqExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ContainsExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: MatchesExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: IcontainsExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: IendsWithExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: IequalsExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: IstartsWithExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: StartsWithExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: EndsWithExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: PlusExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: MinusExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: MultiplyExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: DivideExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ModuloExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: BitwiseXorExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: BitwiseAndExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: BitwiseOrExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ShiftLeftExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ShiftRightExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ForDictExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction], arg4: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ForArrayExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction], arg4: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ForStringExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction], arg4: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: OfExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction], arg4: Union[Expression,VisitAction], arg5: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: IterableExpression, arg2: List[Union[Expression,VisitAction]]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: SetExpression, arg2: List[Union[Expression,VisitAction]]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: RangeExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: StructAccessExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ArrayAccessExpression, arg2: Union[Expression,VisitAction], arg3: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: FunctionCallExpression, arg2: Union[Expression,VisitAction], arg3: List[Union[Expression,VisitAction]]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: ParenthesesExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    @overload
    def default_handler(self, arg0: TokenStreamContext, arg1: IntFunctionExpression, arg2: Union[Expression,VisitAction]) -> Union[Expression,VisitAction]: ...
    def modify(self, expr: Expression, when_deleted: Expression = ...) -> Expression: ...
    def visit_AllExpression(self, arg0: AllExpression) -> Union[Expression,VisitAction]: ...
    def visit_AndExpression(self, arg0: AndExpression) -> Union[Expression,VisitAction]: ...
    def visit_AnyExpression(self, arg0: AnyExpression) -> Union[Expression,VisitAction]: ...
    def visit_ArrayAccessExpression(self, arg0: ArrayAccessExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseAndExpression(self, arg0: BitwiseAndExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseNotExpression(self, arg0: BitwiseNotExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseOrExpression(self, arg0: BitwiseOrExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseXorExpression(self, arg0: BitwiseXorExpression) -> Union[Expression,VisitAction]: ...
    def visit_BoolLiteralExpression(self, arg0: BoolLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_ContainsExpression(self, arg0: ContainsExpression) -> Union[Expression,VisitAction]: ...
    def visit_DefinedExpression(self, arg0: DefinedExpression) -> Union[Expression,VisitAction]: ...
    def visit_DivideExpression(self, arg0: DivideExpression) -> Union[Expression,VisitAction]: ...
    def visit_DoubleLiteralExpression(self, arg0: DoubleLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_EndsWithExpression(self, arg0: EndsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_EntrypointExpression(self, arg0: EntrypointExpression) -> Union[Expression,VisitAction]: ...
    def visit_EqExpression(self, arg0: EqExpression) -> Union[Expression,VisitAction]: ...
    def visit_FilesizeExpression(self, arg0: FilesizeExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForArrayExpression(self, arg0: ForArrayExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForDictExpression(self, arg0: ForDictExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForStringExpression(self, arg0: ForStringExpression) -> Union[Expression,VisitAction]: ...
    def visit_FunctionCallExpression(self, arg0: FunctionCallExpression) -> Union[Expression,VisitAction]: ...
    def visit_GeExpression(self, arg0: GeExpression) -> Union[Expression,VisitAction]: ...
    def visit_GtExpression(self, arg0: GtExpression) -> Union[Expression,VisitAction]: ...
    def visit_IcontainsExpression(self, arg0: IcontainsExpression) -> Union[Expression,VisitAction]: ...
    def visit_IdExpression(self, arg0: IdExpression) -> Union[Expression,VisitAction]: ...
    def visit_IdWildcardExpression(self, arg0: IdWildcardExpression) -> Union[Expression,VisitAction]: ...
    def visit_IendsWithExpression(self, arg0: IendsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_IequalsExpression(self, arg0: IequalsExpression) -> Union[Expression,VisitAction]: ...
    def visit_IntFunctionExpression(self, arg0: IntFunctionExpression) -> Union[Expression,VisitAction]: ...
    def visit_IntLiteralExpression(self, arg0: IntLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_IstartsWithExpression(self, arg0: IstartsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_IterableExpression(self, arg0: IterableExpression) -> Union[Expression,VisitAction]: ...
    def visit_LeExpression(self, arg0: LeExpression) -> Union[Expression,VisitAction]: ...
    def visit_LtExpression(self, arg0: LtExpression) -> Union[Expression,VisitAction]: ...
    def visit_MatchesExpression(self, arg0: MatchesExpression) -> Union[Expression,VisitAction]: ...
    def visit_MinusExpression(self, arg0: MinusExpression) -> Union[Expression,VisitAction]: ...
    def visit_ModuloExpression(self, arg0: ModuloExpression) -> Union[Expression,VisitAction]: ...
    def visit_MultiplyExpression(self, arg0: MultiplyExpression) -> Union[Expression,VisitAction]: ...
    def visit_NeqExpression(self, arg0: NeqExpression) -> Union[Expression,VisitAction]: ...
    def visit_NoneExpression(self, arg0: NoneExpression) -> Union[Expression,VisitAction]: ...
    def visit_NotExpression(self, arg0: NotExpression) -> Union[Expression,VisitAction]: ...
    def visit_OfExpression(self, arg0: OfExpression) -> Union[Expression,VisitAction]: ...
    def visit_OrExpression(self, arg0: OrExpression) -> Union[Expression,VisitAction]: ...
    def visit_ParenthesesExpression(self, arg0: ParenthesesExpression) -> Union[Expression,VisitAction]: ...
    def visit_PercentualExpression(self, arg0: PercentualExpression) -> Union[Expression,VisitAction]: ...
    def visit_PlusExpression(self, arg0: PlusExpression) -> Union[Expression,VisitAction]: ...
    def visit_RangeExpression(self, arg0: RangeExpression) -> Union[Expression,VisitAction]: ...
    def visit_RegexpExpression(self, arg0: RegexpExpression) -> Union[Expression,VisitAction]: ...
    def visit_SetExpression(self, arg0: SetExpression) -> Union[Expression,VisitAction]: ...
    def visit_ShiftLeftExpression(self, arg0: ShiftLeftExpression) -> Union[Expression,VisitAction]: ...
    def visit_ShiftRightExpression(self, arg0: ShiftRightExpression) -> Union[Expression,VisitAction]: ...
    def visit_StartsWithExpression(self, arg0: StartsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringAtExpression(self, arg0: StringAtExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringCountExpression(self, arg0: StringCountExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringExpression(self, arg0: StringExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringInRangeExpression(self, arg0: StringInRangeExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringLengthExpression(self, arg0: StringLengthExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringLiteralExpression(self, arg0: StringLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringOffsetExpression(self, arg0: StringOffsetExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringWildcardExpression(self, arg0: StringWildcardExpression) -> Union[Expression,VisitAction]: ...
    def visit_StructAccessExpression(self, arg0: StructAccessExpression) -> Union[Expression,VisitAction]: ...
    def visit_ThemExpression(self, arg0: ThemExpression) -> Union[Expression,VisitAction]: ...
    def visit_UnaryMinusExpression(self, arg0: UnaryMinusExpression) -> Union[Expression,VisitAction]: ...

class Module:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def structure(self) -> StructureSymbol: ...

class ModuloExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class MultiplyExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class NeqExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class NocaseStringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...

class NoneExpression(KeywordExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class NotExpression(UnaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class ObservingRegexpVisitor(RegexpVisitor):
    def __init__(self) -> None: ...
    def observe(self, arg0: RegexpUnit) -> Union[RegexpUnit,float]: ...
    def visit_RegexpAnyChar(self, arg0: RegexpAnyChar) -> Union[RegexpUnit,float]: ...
    def visit_RegexpClass(self, arg0: RegexpClass) -> Union[RegexpUnit,float]: ...
    def visit_RegexpConcat(self, arg0: RegexpConcat) -> Union[RegexpUnit,float]: ...
    def visit_RegexpDigit(self, arg0: RegexpDigit) -> Union[RegexpUnit,float]: ...
    def visit_RegexpEndOfLine(self, arg0: RegexpEndOfLine) -> Union[RegexpUnit,float]: ...
    def visit_RegexpGroup(self, arg0: RegexpGroup) -> Union[RegexpUnit,float]: ...
    def visit_RegexpIteration(self, arg0: RegexpIteration) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonDigit(self, arg0: RegexpNonDigit) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonSpace(self, arg0: RegexpNonSpace) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonWordBoundary(self, arg0: RegexpNonWordBoundary) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonWordChar(self, arg0: RegexpNonWordChar) -> Union[RegexpUnit,float]: ...
    def visit_RegexpOptional(self, arg0: RegexpOptional) -> Union[RegexpUnit,float]: ...
    def visit_RegexpOr(self, arg0: RegexpOr) -> Union[RegexpUnit,float]: ...
    def visit_RegexpPositiveIteration(self, arg0: RegexpPositiveIteration) -> Union[RegexpUnit,float]: ...
    def visit_RegexpRange(self, arg0: RegexpRange) -> Union[RegexpUnit,float]: ...
    def visit_RegexpSpace(self, arg0: RegexpSpace) -> Union[RegexpUnit,float]: ...
    def visit_RegexpStartOfLine(self, arg0: RegexpStartOfLine) -> Union[RegexpUnit,float]: ...
    def visit_RegexpText(self, arg0: RegexpText) -> Union[RegexpUnit,float]: ...
    def visit_RegexpWordBoundary(self, arg0: RegexpWordBoundary) -> Union[RegexpUnit,float]: ...
    def visit_RegexpWordChar(self, arg0: RegexpWordChar) -> Union[RegexpUnit,float]: ...

class ObservingVisitor(Visitor):
    def __init__(self) -> None: ...
    def observe(self, arg0: Expression) -> None: ...
    def visit_AllExpression(self, arg0: AllExpression) -> Union[Expression,VisitAction]: ...
    def visit_AndExpression(self, arg0: AndExpression) -> Union[Expression,VisitAction]: ...
    def visit_AnyExpression(self, arg0: AnyExpression) -> Union[Expression,VisitAction]: ...
    def visit_ArrayAccessExpression(self, arg0: ArrayAccessExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseAndExpression(self, arg0: BitwiseAndExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseNotExpression(self, arg0: BitwiseNotExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseOrExpression(self, arg0: BitwiseOrExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseXorExpression(self, arg0: BitwiseXorExpression) -> Union[Expression,VisitAction]: ...
    def visit_BoolLiteralExpression(self, arg0: BoolLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_ContainsExpression(self, arg0: ContainsExpression) -> Union[Expression,VisitAction]: ...
    def visit_DefinedExpression(self, arg0: DefinedExpression) -> Union[Expression,VisitAction]: ...
    def visit_DivideExpression(self, arg0: DivideExpression) -> Union[Expression,VisitAction]: ...
    def visit_DoubleLiteralExpression(self, arg0: DoubleLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_EndsWithExpression(self, arg0: EndsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_EntrypointExpression(self, arg0: EntrypointExpression) -> Union[Expression,VisitAction]: ...
    def visit_EqExpression(self, arg0: EqExpression) -> Union[Expression,VisitAction]: ...
    def visit_FilesizeExpression(self, arg0: FilesizeExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForArrayExpression(self, arg0: ForArrayExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForDictExpression(self, arg0: ForDictExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForStringExpression(self, arg0: ForStringExpression) -> Union[Expression,VisitAction]: ...
    def visit_FunctionCallExpression(self, arg0: FunctionCallExpression) -> Union[Expression,VisitAction]: ...
    def visit_GeExpression(self, arg0: GeExpression) -> Union[Expression,VisitAction]: ...
    def visit_GtExpression(self, arg0: GtExpression) -> Union[Expression,VisitAction]: ...
    def visit_IcontainsExpression(self, arg0: IcontainsExpression) -> Union[Expression,VisitAction]: ...
    def visit_IdExpression(self, arg0: IdExpression) -> Union[Expression,VisitAction]: ...
    def visit_IdWildcardExpression(self, arg0: IdWildcardExpression) -> Union[Expression,VisitAction]: ...
    def visit_IendsWithExpression(self, arg0: IendsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_IequalsExpression(self, arg0: IequalsExpression) -> Union[Expression,VisitAction]: ...
    def visit_IntFunctionExpression(self, arg0: IntFunctionExpression) -> Union[Expression,VisitAction]: ...
    def visit_IntLiteralExpression(self, arg0: IntLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_IstartsWithExpression(self, arg0: IstartsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_IterableExpression(self, arg0: IterableExpression) -> Union[Expression,VisitAction]: ...
    def visit_LeExpression(self, arg0: LeExpression) -> Union[Expression,VisitAction]: ...
    def visit_LtExpression(self, arg0: LtExpression) -> Union[Expression,VisitAction]: ...
    def visit_MatchesExpression(self, arg0: MatchesExpression) -> Union[Expression,VisitAction]: ...
    def visit_MinusExpression(self, arg0: MinusExpression) -> Union[Expression,VisitAction]: ...
    def visit_ModuloExpression(self, arg0: ModuloExpression) -> Union[Expression,VisitAction]: ...
    def visit_MultiplyExpression(self, arg0: MultiplyExpression) -> Union[Expression,VisitAction]: ...
    def visit_NeqExpression(self, arg0: NeqExpression) -> Union[Expression,VisitAction]: ...
    def visit_NoneExpression(self, arg0: NoneExpression) -> Union[Expression,VisitAction]: ...
    def visit_NotExpression(self, arg0: NotExpression) -> Union[Expression,VisitAction]: ...
    def visit_OfExpression(self, arg0: OfExpression) -> Union[Expression,VisitAction]: ...
    def visit_OrExpression(self, arg0: OrExpression) -> Union[Expression,VisitAction]: ...
    def visit_ParenthesesExpression(self, arg0: ParenthesesExpression) -> Union[Expression,VisitAction]: ...
    def visit_PercentualExpression(self, arg0: PercentualExpression) -> Union[Expression,VisitAction]: ...
    def visit_PlusExpression(self, arg0: PlusExpression) -> Union[Expression,VisitAction]: ...
    def visit_RangeExpression(self, arg0: RangeExpression) -> Union[Expression,VisitAction]: ...
    def visit_RegexpExpression(self, arg0: RegexpExpression) -> Union[Expression,VisitAction]: ...
    def visit_SetExpression(self, arg0: SetExpression) -> Union[Expression,VisitAction]: ...
    def visit_ShiftLeftExpression(self, arg0: ShiftLeftExpression) -> Union[Expression,VisitAction]: ...
    def visit_ShiftRightExpression(self, arg0: ShiftRightExpression) -> Union[Expression,VisitAction]: ...
    def visit_StartsWithExpression(self, arg0: StartsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringAtExpression(self, arg0: StringAtExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringCountExpression(self, arg0: StringCountExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringExpression(self, arg0: StringExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringInRangeExpression(self, arg0: StringInRangeExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringLengthExpression(self, arg0: StringLengthExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringLiteralExpression(self, arg0: StringLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringOffsetExpression(self, arg0: StringOffsetExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringWildcardExpression(self, arg0: StringWildcardExpression) -> Union[Expression,VisitAction]: ...
    def visit_StructAccessExpression(self, arg0: StructAccessExpression) -> Union[Expression,VisitAction]: ...
    def visit_ThemExpression(self, arg0: ThemExpression) -> Union[Expression,VisitAction]: ...
    def visit_UnaryMinusExpression(self, arg0: UnaryMinusExpression) -> Union[Expression,VisitAction]: ...

class OfExpression(ForExpression):
    range: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class OrExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class ParenthesesExpression(Expression):
    enclosed_expr: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class ParserError(Exception): ...

class ParserMode:
    __members__: ClassVar[dict] = ...  # read-only
    IncludeGuarded: ClassVar[ParserMode] = ...
    Incomplete: ClassVar[ParserMode] = ...
    Regular: ClassVar[ParserMode] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PercentualExpression(UnaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class PlainString(String):
    def __init__(self, *args, **kwargs) -> None: ...

class PlusExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class Position:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def column(self) -> int: ...
    @property
    def line(self) -> int: ...

class PrivateStringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...

class RangeExpression(Expression):
    high: Expression
    low: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class ReferenceSymbol(Symbol):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def symbol(self) -> Symbol: ...

class Regexp(String):
    unit: RegexpUnit
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def suffix_modifiers(self) -> str: ...

class RegexpAnyChar(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpClass(RegexpUnit):
    characters: str
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def is_negative(self) -> bool: ...

class RegexpConcat(RegexpUnit):
    units: List[RegexpUnit]
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpDigit(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpEndOfLine(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpExpression(Expression):
    regexp_string: String
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpGroup(RegexpUnit):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def unit(self) -> RegexpUnit: ...

class RegexpIteration(RegexpOperation):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpNonDigit(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpNonSpace(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpNonWordBoundary(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpNonWordChar(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpOperation(RegexpUnit):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def is_greedy(self) -> bool: ...
    @property
    def operand(self) -> RegexpUnit: ...
    @property
    def operation(self) -> str: ...

class RegexpOptional(RegexpOperation):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpOr(RegexpUnit):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def left(self) -> RegexpUnit: ...
    @property
    def right(self) -> RegexpUnit: ...

class RegexpPositiveIteration(RegexpOperation):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpRange(RegexpOperation):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def range(self) -> Tuple[Optional[int],Optional[int]]: ...

class RegexpSpace(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpStartOfLine(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpText(RegexpUnit):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def text(self) -> str: ...

class RegexpUnit:
    def __init__(self, *args, **kwargs) -> None: ...
    def accept(self, arg0) -> Union[RegexpUnit,float]: ...
    @property
    def text(self) -> str: ...

class RegexpVisitor:
    def __init__(self) -> None: ...
    def visit_RegexpAnyChar(self, arg0: RegexpAnyChar) -> Union[RegexpUnit,float]: ...
    def visit_RegexpClass(self, arg0: RegexpClass) -> Union[RegexpUnit,float]: ...
    def visit_RegexpConcat(self, arg0: RegexpConcat) -> Union[RegexpUnit,float]: ...
    def visit_RegexpDigit(self, arg0: RegexpDigit) -> Union[RegexpUnit,float]: ...
    def visit_RegexpEndOfLine(self, arg0: RegexpEndOfLine) -> Union[RegexpUnit,float]: ...
    def visit_RegexpGroup(self, arg0: RegexpGroup) -> Union[RegexpUnit,float]: ...
    def visit_RegexpIteration(self, arg0: RegexpIteration) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonDigit(self, arg0: RegexpNonDigit) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonSpace(self, arg0: RegexpNonSpace) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonWordBoundary(self, arg0: RegexpNonWordBoundary) -> Union[RegexpUnit,float]: ...
    def visit_RegexpNonWordChar(self, arg0: RegexpNonWordChar) -> Union[RegexpUnit,float]: ...
    def visit_RegexpOptional(self, arg0: RegexpOptional) -> Union[RegexpUnit,float]: ...
    def visit_RegexpOr(self, arg0: RegexpOr) -> Union[RegexpUnit,float]: ...
    def visit_RegexpPositiveIteration(self, arg0: RegexpPositiveIteration) -> Union[RegexpUnit,float]: ...
    def visit_RegexpRange(self, arg0: RegexpRange) -> Union[RegexpUnit,float]: ...
    def visit_RegexpSpace(self, arg0: RegexpSpace) -> Union[RegexpUnit,float]: ...
    def visit_RegexpStartOfLine(self, arg0: RegexpStartOfLine) -> Union[RegexpUnit,float]: ...
    def visit_RegexpText(self, arg0: RegexpText) -> Union[RegexpUnit,float]: ...
    def visit_RegexpWordBoundary(self, arg0: RegexpWordBoundary) -> Union[RegexpUnit,float]: ...
    def visit_RegexpWordChar(self, arg0: RegexpWordChar) -> Union[RegexpUnit,float]: ...

class RegexpWordBoundary(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class RegexpWordChar(RegexpText):
    def __init__(self, *args, **kwargs) -> None: ...

class Rule:
    condition: Expression
    metas: List[Meta]
    modifier: RuleModifier
    name: str
    tags: List[str]
    variables: List[Variable]
    def __init__(self, *args, **kwargs) -> None: ...
    def add_meta(self, name: str, value: Literal) -> None: ...
    def add_tag(self, tag: str) -> None: ...
    def get_meta_with_name(self, name: str) -> Meta: ...
    def remove_metas(self, name: str) -> None: ...
    def remove_string(self, id: str) -> None: ...
    def remove_tags(self, tag: str) -> None: ...
    @property
    def is_global(self) -> bool: ...
    @property
    def is_private(self) -> bool: ...
    @property
    def location(self) -> Location: ...
    @property
    def strings(self) -> List[String]: ...
    @property
    def symbol(self) -> List[Symbol]: ...
    @property
    def text(self) -> str: ...
    @property
    def token_first(self) -> Token: ...
    @property
    def token_last(self) -> Token: ...

class RuleModifier:
    __members__: ClassVar[dict] = ...  # read-only
    Empty: ClassVar[RuleModifier] = ...
    Global: ClassVar[RuleModifier] = ...
    Private: ClassVar[RuleModifier] = ...
    PrivateGlobal: ClassVar[RuleModifier] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SetExpression(Expression):
    elements: List[Expression]
    def __init__(self, *args, **kwargs) -> None: ...

class ShiftLeftExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class ShiftRightExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class StartsWithExpression(BinaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class String:
    def __init__(self, *args, **kwargs) -> None: ...
    def remove_modifiers(self) -> None: ...
    @property
    def identifier(self) -> str: ...
    @property
    def is_ascii(self) -> bool: ...
    @property
    def is_base64(self) -> bool: ...
    @property
    def is_base64_wide(self) -> bool: ...
    @property
    def is_fullword(self) -> bool: ...
    @property
    def is_hex(self) -> bool: ...
    @property
    def is_nocase(self) -> bool: ...
    @property
    def is_plain(self) -> bool: ...
    @property
    def is_private(self) -> bool: ...
    @property
    def is_regexp(self) -> bool: ...
    @property
    def is_wide(self) -> bool: ...
    @property
    def is_xor(self) -> bool: ...
    @property
    def location(self) -> Location: ...
    @property
    def modifiers(self) -> List[StringModifier]: ...
    @property
    def modifiers_text(self) -> str: ...
    @property
    def pure_text(self) -> bytes: ...
    @property
    def text(self) -> str: ...
    @property
    def token_assign(self) -> Token: ...
    @property
    def token_first(self) -> Token: ...
    @property
    def token_id(self) -> Token: ...
    @property
    def token_last(self) -> Token: ...
    @property
    def type(self) -> StringType: ...

class StringAtExpression(Expression):
    at_expr: Expression
    id: str
    def __init__(self, *args, **kwargs) -> None: ...

class StringCountExpression(Expression):
    id: str
    def __init__(self, *args, **kwargs) -> None: ...

class StringExpression(Expression):
    id: str
    def __init__(self, *args, **kwargs) -> None: ...

class StringInRangeExpression(Expression):
    id: str
    range_expr: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class StringLengthExpression(Expression):
    id: str
    index_expr: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class StringLiteralExpression(_StringLiteralExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class StringModifier:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def is_ascii(self) -> bool: ...
    @property
    def is_base64(self) -> bool: ...
    @property
    def is_base64_wide(self) -> bool: ...
    @property
    def is_fullword(self) -> bool: ...
    @property
    def is_nocase(self) -> bool: ...
    @property
    def is_private(self) -> bool: ...
    @property
    def is_wide(self) -> bool: ...
    @property
    def is_xor(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def text(self) -> str: ...
    @property
    def type(self) -> StringModifierType: ...

class StringModifierType:
    __members__: ClassVar[dict] = ...  # read-only
    Ascii: ClassVar[StringModifierType] = ...
    Base64: ClassVar[StringModifierType] = ...
    Base64Wide: ClassVar[StringModifierType] = ...
    Fullword: ClassVar[StringModifierType] = ...
    Nocase: ClassVar[StringModifierType] = ...
    Private: ClassVar[StringModifierType] = ...
    Wide: ClassVar[StringModifierType] = ...
    Xor: ClassVar[StringModifierType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class StringOffsetExpression(Expression):
    id: str
    index_expr: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class StringType:
    __members__: ClassVar[dict] = ...  # read-only
    Hex: ClassVar[StringType] = ...
    Plain: ClassVar[StringType] = ...
    Regexp: ClassVar[StringType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class StringWildcardExpression(Expression):
    id: str
    def __init__(self, *args, **kwargs) -> None: ...

class StructAccessExpression(IdExpression):
    structure: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class StructureSymbol(Symbol):
    def __init__(self, *args, **kwargs) -> None: ...
    def get_attribute(self, arg0: str) -> Symbol: ...
    @property
    def attributes(self) -> Dict[str,Symbol]: ...

class Symbol:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def data_type(self) -> ExpressionType: ...
    @property
    def documentation(self) -> str: ...
    @property
    def is_array(self) -> bool: ...
    @property
    def is_dictionary(self) -> bool: ...
    @property
    def is_function(self) -> bool: ...
    @property
    def is_reference(self) -> bool: ...
    @property
    def is_structure(self) -> bool: ...
    @property
    def is_value(self) -> bool: ...
    @property
    def name(self) -> str: ...

class ThemExpression(KeywordExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class Token:
    def __init__(self, arg0: TokenType, arg1: Literal) -> None: ...
    @property
    def float(self) -> float: ...
    @property
    def is_bool(self) -> bool: ...
    @property
    def is_float(self) -> bool: ...
    @property
    def is_int(self) -> bool: ...
    @property
    def is_string(self) -> bool: ...
    @property
    def is_symbol(self) -> bool: ...
    @property
    def literal(self) -> Literal: ...
    @property
    def literal_reference(self) -> Literal: ...
    @property
    def location(self) -> Location: ...
    @property
    def pure_text(self) -> str: ...
    @property
    def string(self) -> str: ...
    @property
    def symbol(self) -> Symbol: ...
    @property
    def text(self) -> str: ...
    @property
    def type(self) -> TokenType: ...
    @property
    def uint(self) -> int: ...
    @property
    def bool(self) -> bool: ...
    @property
    def int(self) -> int: ...

class TokenIt:
    def __init__(self) -> None: ...
    def decrement(self) -> None: ...
    def increment(self) -> None: ...
    def next(self) -> TokenIt: ...
    def previous(self) -> TokenIt: ...
    @property
    def value(self) -> Token: ...

class TokenStream:
    def __init__(self) -> None: ...
    def comment_before_token(self, message: str, insert_before: TokenIt, multiline: bool = ..., indent: str = ..., linebreak: bool = ...) -> None: ...
    def erase(self, itr: TokenIt) -> TokenIt: ...
    def erase_range(self, first: TokenIt, last: TokenIt) -> TokenIt: ...
    def find(self, type: TokenType) -> TokenIt: ...
    def find_range(self, type: TokenType, start: TokenIt, stop: TokenIt) -> TokenIt: ...
    def insert(self, before: TokenIt, type: TokenType, literal: Literal) -> TokenIt: ...
    @property
    def back(self) -> Token: ...
    @property
    def begin(self) -> TokenIt: ...
    @property
    def empty(self) -> bool: ...
    @property
    def end(self) -> TokenIt: ...
    @property
    def front(self) -> Token: ...
    @property
    def size(self) -> int: ...
    @property
    def tokens(self) -> List[Token]: ...
    @property
    def tokens_as_text(self) -> List[str]: ...

class TokenStreamContext:
    def __init__(self, arg0: Expression) -> None: ...

class TokenType:
    __members__: ClassVar[dict] = ...  # read-only
    All: ClassVar[TokenType] = ...
    And: ClassVar[TokenType] = ...
    Any: ClassVar[TokenType] = ...
    ArraySymbol: ClassVar[TokenType] = ...
    Ascii: ClassVar[TokenType] = ...
    Assign: ClassVar[TokenType] = ...
    Base64: ClassVar[TokenType] = ...
    Base64Wide: ClassVar[TokenType] = ...
    BitwiseAnd: ClassVar[TokenType] = ...
    BitwiseNot: ClassVar[TokenType] = ...
    BitwiseOr: ClassVar[TokenType] = ...
    BitwiseXor: ClassVar[TokenType] = ...
    BoolFalse: ClassVar[TokenType] = ...
    BoolTrue: ClassVar[TokenType] = ...
    Colon: ClassVar[TokenType] = ...
    ColonBeforeNewline: ClassVar[TokenType] = ...
    Comma: ClassVar[TokenType] = ...
    Comment: ClassVar[TokenType] = ...
    Condition: ClassVar[TokenType] = ...
    Contains: ClassVar[TokenType] = ...
    Dash: ClassVar[TokenType] = ...
    Defined: ClassVar[TokenType] = ...
    DictionarySymbol: ClassVar[TokenType] = ...
    Divide: ClassVar[TokenType] = ...
    Dot: ClassVar[TokenType] = ...
    Double: ClassVar[TokenType] = ...
    DoubleDot: ClassVar[TokenType] = ...
    EndsWith: ClassVar[TokenType] = ...
    Entrypoint: ClassVar[TokenType] = ...
    Eq: ClassVar[TokenType] = ...
    Filesize: ClassVar[TokenType] = ...
    For: ClassVar[TokenType] = ...
    Fullword: ClassVar[TokenType] = ...
    FunctionCallLp: ClassVar[TokenType] = ...
    FunctionCallRp: ClassVar[TokenType] = ...
    FunctionSymbol: ClassVar[TokenType] = ...
    Ge: ClassVar[TokenType] = ...
    Global: ClassVar[TokenType] = ...
    Gt: ClassVar[TokenType] = ...
    HexAlt: ClassVar[TokenType] = ...
    HexAltLeftBracket: ClassVar[TokenType] = ...
    HexAltRightBracket: ClassVar[TokenType] = ...
    HexEndBracket: ClassVar[TokenType] = ...
    HexJumpFixed: ClassVar[TokenType] = ...
    HexJumpLeftBracket: ClassVar[TokenType] = ...
    HexJumpRightBracket: ClassVar[TokenType] = ...
    HexNibble: ClassVar[TokenType] = ...
    HexStartBracket: ClassVar[TokenType] = ...
    HexWildcard: ClassVar[TokenType] = ...
    HexWildcardHigh: ClassVar[TokenType] = ...
    HexWildcardLow: ClassVar[TokenType] = ...
    Icontains: ClassVar[TokenType] = ...
    Id: ClassVar[TokenType] = ...
    IdWildcard: ClassVar[TokenType] = ...
    IendsWith: ClassVar[TokenType] = ...
    Iequals: ClassVar[TokenType] = ...
    ImportKeyword: ClassVar[TokenType] = ...
    ImportModule: ClassVar[TokenType] = ...
    IncludeDirective: ClassVar[TokenType] = ...
    IncludePath: ClassVar[TokenType] = ...
    Integer: ClassVar[TokenType] = ...
    IntegerFunction: ClassVar[TokenType] = ...
    Invalid: ClassVar[TokenType] = ...
    IstartsWith: ClassVar[TokenType] = ...
    Lcb: ClassVar[TokenType] = ...
    Le: ClassVar[TokenType] = ...
    Lp: ClassVar[TokenType] = ...
    LpEnumeration: ClassVar[TokenType] = ...
    LpWithSpaceAfter: ClassVar[TokenType] = ...
    LpWithSpaces: ClassVar[TokenType] = ...
    Lquote: ClassVar[TokenType] = ...
    Lsqb: ClassVar[TokenType] = ...
    LsqbEnumeration: ClassVar[TokenType] = ...
    Lt: ClassVar[TokenType] = ...
    Matches: ClassVar[TokenType] = ...
    Meta: ClassVar[TokenType] = ...
    MetaKey: ClassVar[TokenType] = ...
    MetaValue: ClassVar[TokenType] = ...
    Minus: ClassVar[TokenType] = ...
    Multiply: ClassVar[TokenType] = ...
    Neq: ClassVar[TokenType] = ...
    NewLine: ClassVar[TokenType] = ...
    Nocase: ClassVar[TokenType] = ...
    NoneToken: ClassVar[TokenType] = ...
    Not: ClassVar[TokenType] = ...
    Of: ClassVar[TokenType] = ...
    OnelineComment: ClassVar[TokenType] = ...
    OpAt: ClassVar[TokenType] = ...
    OpIn: ClassVar[TokenType] = ...
    Or: ClassVar[TokenType] = ...
    Percent: ClassVar[TokenType] = ...
    Plus: ClassVar[TokenType] = ...
    Private: ClassVar[TokenType] = ...
    PrivateStringModifier: ClassVar[TokenType] = ...
    Range: ClassVar[TokenType] = ...
    Rcb: ClassVar[TokenType] = ...
    ReferenceSymbol: ClassVar[TokenType] = ...
    RegexpChar: ClassVar[TokenType] = ...
    RegexpClassNegative: ClassVar[TokenType] = ...
    RegexpEndSlash: ClassVar[TokenType] = ...
    RegexpGreedy: ClassVar[TokenType] = ...
    RegexpIter: ClassVar[TokenType] = ...
    RegexpModifiers: ClassVar[TokenType] = ...
    RegexpOptional: ClassVar[TokenType] = ...
    RegexpOr: ClassVar[TokenType] = ...
    RegexpPiter: ClassVar[TokenType] = ...
    RegexpRange: ClassVar[TokenType] = ...
    RegexpStartSlash: ClassVar[TokenType] = ...
    RegexpText: ClassVar[TokenType] = ...
    Rp: ClassVar[TokenType] = ...
    RpEnumeration: ClassVar[TokenType] = ...
    RpWithSpaceBefore: ClassVar[TokenType] = ...
    RpWithSpaces: ClassVar[TokenType] = ...
    Rquote: ClassVar[TokenType] = ...
    Rsqb: ClassVar[TokenType] = ...
    RsqbEnumeration: ClassVar[TokenType] = ...
    Rule: ClassVar[TokenType] = ...
    RuleBegin: ClassVar[TokenType] = ...
    RuleEnd: ClassVar[TokenType] = ...
    RuleName: ClassVar[TokenType] = ...
    ShiftLeft: ClassVar[TokenType] = ...
    ShiftRight: ClassVar[TokenType] = ...
    Slash: ClassVar[TokenType] = ...
    StartsWith: ClassVar[TokenType] = ...
    StringCount: ClassVar[TokenType] = ...
    StringId: ClassVar[TokenType] = ...
    StringIdAfterNewline: ClassVar[TokenType] = ...
    StringIdWildcard: ClassVar[TokenType] = ...
    StringKey: ClassVar[TokenType] = ...
    StringLength: ClassVar[TokenType] = ...
    StringLiteral: ClassVar[TokenType] = ...
    StringOffset: ClassVar[TokenType] = ...
    Strings: ClassVar[TokenType] = ...
    StructureSymbol: ClassVar[TokenType] = ...
    Tag: ClassVar[TokenType] = ...
    Them: ClassVar[TokenType] = ...
    UnaryMinus: ClassVar[TokenType] = ...
    ValueSymbol: ClassVar[TokenType] = ...
    VariableKey: ClassVar[TokenType] = ...
    Variables: ClassVar[TokenType] = ...
    Wide: ClassVar[TokenType] = ...
    Xor: ClassVar[TokenType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class UnaryMinusExpression(UnaryOpExpression):
    def __init__(self, *args, **kwargs) -> None: ...

class UnaryOpExpression(Expression):
    operand: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class ValueSymbol(Symbol):
    def __init__(self, *args, **kwargs) -> None: ...

class Variable:
    key: str
    value: Expression
    def __init__(self, *args, **kwargs) -> None: ...

class VisitAction:
    __members__: ClassVar[dict] = ...  # read-only
    Delete: ClassVar[VisitAction] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Visitor:
    def __init__(self) -> None: ...
    def visit_AllExpression(self, arg0: AllExpression) -> Union[Expression,VisitAction]: ...
    def visit_AndExpression(self, arg0: AndExpression) -> Union[Expression,VisitAction]: ...
    def visit_AnyExpression(self, arg0: AnyExpression) -> Union[Expression,VisitAction]: ...
    def visit_ArrayAccessExpression(self, arg0: ArrayAccessExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseAndExpression(self, arg0: BitwiseAndExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseNotExpression(self, arg0: BitwiseNotExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseOrExpression(self, arg0: BitwiseOrExpression) -> Union[Expression,VisitAction]: ...
    def visit_BitwiseXorExpression(self, arg0: BitwiseXorExpression) -> Union[Expression,VisitAction]: ...
    def visit_BoolLiteralExpression(self, arg0: BoolLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_ContainsExpression(self, arg0: ContainsExpression) -> Union[Expression,VisitAction]: ...
    def visit_DefinedExpression(self, arg0: DefinedExpression) -> Union[Expression,VisitAction]: ...
    def visit_DivideExpression(self, arg0: DivideExpression) -> Union[Expression,VisitAction]: ...
    def visit_DoubleLiteralExpression(self, arg0: DoubleLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_EndsWithExpression(self, arg0: EndsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_EntrypointExpression(self, arg0: EntrypointExpression) -> Union[Expression,VisitAction]: ...
    def visit_EqExpression(self, arg0: EqExpression) -> Union[Expression,VisitAction]: ...
    def visit_FilesizeExpression(self, arg0: FilesizeExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForArrayExpression(self, arg0: ForArrayExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForDictExpression(self, arg0: ForDictExpression) -> Union[Expression,VisitAction]: ...
    def visit_ForStringExpression(self, arg0: ForStringExpression) -> Union[Expression,VisitAction]: ...
    def visit_FunctionCallExpression(self, arg0: FunctionCallExpression) -> Union[Expression,VisitAction]: ...
    def visit_GeExpression(self, arg0: GeExpression) -> Union[Expression,VisitAction]: ...
    def visit_GtExpression(self, arg0: GtExpression) -> Union[Expression,VisitAction]: ...
    def visit_IcontainsExpression(self, arg0: IcontainsExpression) -> Union[Expression,VisitAction]: ...
    def visit_IdExpression(self, arg0: IdExpression) -> Union[Expression,VisitAction]: ...
    def visit_IdWildcardExpression(self, arg0: IdWildcardExpression) -> Union[Expression,VisitAction]: ...
    def visit_IendsWithExpression(self, arg0: IendsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_IequalsExpression(self, arg0: IequalsExpression) -> Union[Expression,VisitAction]: ...
    def visit_IntFunctionExpression(self, arg0: IntFunctionExpression) -> Union[Expression,VisitAction]: ...
    def visit_IntLiteralExpression(self, arg0: IntLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_IstartsWithExpression(self, arg0: IstartsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_IterableExpression(self, arg0: IterableExpression) -> Union[Expression,VisitAction]: ...
    def visit_LeExpression(self, arg0: LeExpression) -> Union[Expression,VisitAction]: ...
    def visit_LtExpression(self, arg0: LtExpression) -> Union[Expression,VisitAction]: ...
    def visit_MatchesExpression(self, arg0: MatchesExpression) -> Union[Expression,VisitAction]: ...
    def visit_MinusExpression(self, arg0: MinusExpression) -> Union[Expression,VisitAction]: ...
    def visit_ModuloExpression(self, arg0: ModuloExpression) -> Union[Expression,VisitAction]: ...
    def visit_MultiplyExpression(self, arg0: MultiplyExpression) -> Union[Expression,VisitAction]: ...
    def visit_NeqExpression(self, arg0: NeqExpression) -> Union[Expression,VisitAction]: ...
    def visit_NoneExpression(self, arg0: NoneExpression) -> Union[Expression,VisitAction]: ...
    def visit_NotExpression(self, arg0: NotExpression) -> Union[Expression,VisitAction]: ...
    def visit_OfExpression(self, arg0: OfExpression) -> Union[Expression,VisitAction]: ...
    def visit_OrExpression(self, arg0: OrExpression) -> Union[Expression,VisitAction]: ...
    def visit_ParenthesesExpression(self, arg0: ParenthesesExpression) -> Union[Expression,VisitAction]: ...
    def visit_PercentualExpression(self, arg0: PercentualExpression) -> Union[Expression,VisitAction]: ...
    def visit_PlusExpression(self, arg0: PlusExpression) -> Union[Expression,VisitAction]: ...
    def visit_RangeExpression(self, arg0: RangeExpression) -> Union[Expression,VisitAction]: ...
    def visit_RegexpExpression(self, arg0: RegexpExpression) -> Union[Expression,VisitAction]: ...
    def visit_SetExpression(self, arg0: SetExpression) -> Union[Expression,VisitAction]: ...
    def visit_ShiftLeftExpression(self, arg0: ShiftLeftExpression) -> Union[Expression,VisitAction]: ...
    def visit_ShiftRightExpression(self, arg0: ShiftRightExpression) -> Union[Expression,VisitAction]: ...
    def visit_StartsWithExpression(self, arg0: StartsWithExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringAtExpression(self, arg0: StringAtExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringCountExpression(self, arg0: StringCountExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringExpression(self, arg0: StringExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringInRangeExpression(self, arg0: StringInRangeExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringLengthExpression(self, arg0: StringLengthExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringLiteralExpression(self, arg0: StringLiteralExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringOffsetExpression(self, arg0: StringOffsetExpression) -> Union[Expression,VisitAction]: ...
    def visit_StringWildcardExpression(self, arg0: StringWildcardExpression) -> Union[Expression,VisitAction]: ...
    def visit_StructAccessExpression(self, arg0: StructAccessExpression) -> Union[Expression,VisitAction]: ...
    def visit_ThemExpression(self, arg0: ThemExpression) -> Union[Expression,VisitAction]: ...
    def visit_UnaryMinusExpression(self, arg0: UnaryMinusExpression) -> Union[Expression,VisitAction]: ...

class WideStringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...

class XorStringModifier(StringModifier):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def is_range(self) -> bool: ...
    @property
    def is_single_key(self) -> bool: ...

class YaraExpressionBuilder:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Expression) -> None: ...
    def access(self, arg0: str) -> YaraExpressionBuilder: ...
    def comment(self, message: str, multiline: bool = ..., indent: str = ..., linebreak: bool = ...) -> YaraExpressionBuilder: ...
    def comment_behind(self, message: str, multiline: bool = ..., indent: str = ..., linebreak: bool = ...) -> YaraExpressionBuilder: ...
    def contains(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def defined(self) -> YaraExpressionBuilder: ...
    def endswith(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def get(self) -> Expression: ...
    def icontains(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def iendswith(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def iequals(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def istartswith(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def matches(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def percent(self) -> YaraExpressionBuilder: ...
    def read_int16(self, arg0: IntFunctionEndianness) -> YaraExpressionBuilder: ...
    def read_int32(self, arg0: IntFunctionEndianness) -> YaraExpressionBuilder: ...
    def read_int8(self, arg0: IntFunctionEndianness) -> YaraExpressionBuilder: ...
    def read_uint16(self, arg0: IntFunctionEndianness) -> YaraExpressionBuilder: ...
    def read_uint32(self, arg0: IntFunctionEndianness) -> YaraExpressionBuilder: ...
    def read_uint8(self, arg0: IntFunctionEndianness) -> YaraExpressionBuilder: ...
    def startswith(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __add__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __and__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __call__(self, *args) -> YaraExpressionBuilder: ...
    def __ge__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __getitem__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __gt__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __invert__(self) -> YaraExpressionBuilder: ...
    def __le__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __lshift__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __lt__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __mod__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __mul__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __neg__(self) -> YaraExpressionBuilder: ...
    def __or__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __rshift__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __sub__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __truediv__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
    def __xor__(self, arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...

class YaraFile:
    def __init__(self, *args, **kwargs) -> None: ...
    def add_rule(self, rule: Rule) -> None: ...
    def expand_rule_prefix_from_origin(self, prefix: str, origin: Rule) -> List[str]: ...
    def find_symbol(self, name: str) -> Symbol: ...
    def insert_rule(self, position: int, rule: Rule) -> None: ...
    def remove_imports(self, pred: Callable[[Module], bool]) -> None: ...
    def remove_rules(self, pred: Callable[[Rule], bool]) -> None: ...
    @property
    def imports(self) -> List[Module]: ...
    @property
    def rules(self) -> List[Rule]: ...
    @property
    def text(self) -> str: ...
    @property
    def text_formatted(self) -> str: ...
    @property
    def tokenstream(self) -> TokenStream: ...

class YaraFileBuilder:
    def __init__(self, import_features: Features = ..., modules_directory: str = ...) -> None: ...
    def get(self, recheck: bool = ...) -> YaraFile: ...
    def with_module(self, arg0: str) -> YaraFileBuilder: ...
    def with_rule(self, arg0: Rule) -> YaraFileBuilder: ...

class YaraHexStringBuilder:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    @overload
    def __init__(self, arg0: List[int]) -> None: ...
    @overload
    def __init__(self, arg0) -> None: ...
    def add(self, arg0: YaraHexStringBuilder) -> YaraHexStringBuilder: ...
    def get(self) -> HexString: ...

class YaraRuleBuilder:
    def __init__(self) -> None: ...
    def ascii(self) -> YaraRuleBuilder: ...
    def base64(self, *args) -> YaraRuleBuilder: ...
    def base64wide(self, *args) -> YaraRuleBuilder: ...
    def fullword(self) -> YaraRuleBuilder: ...
    def get(self) -> Rule: ...
    def nocase(self) -> YaraRuleBuilder: ...
    def private(self) -> YaraRuleBuilder: ...
    def wide(self) -> YaraRuleBuilder: ...
    def with_bool_meta(self, arg0: str, arg1: bool) -> YaraRuleBuilder: ...
    def with_bool_variable(self, arg0: str, arg1: bool) -> YaraRuleBuilder: ...
    def with_comment(self, comment: str, multiline: bool = ...) -> YaraRuleBuilder: ...
    def with_condition(self, arg0: Expression) -> YaraRuleBuilder: ...
    def with_double_variable(self, arg0: str, arg1: float) -> YaraRuleBuilder: ...
    def with_hex_int_meta(self, arg0: str, arg1: int) -> YaraRuleBuilder: ...
    def with_hex_int_variable(self, arg0: str, arg1: int) -> YaraRuleBuilder: ...
    def with_hex_string(self, arg0: str, arg1: HexString) -> YaraRuleBuilder: ...
    def with_int_meta(self, arg0: str, arg1: int) -> YaraRuleBuilder: ...
    def with_int_variable(self, arg0: str, arg1: int) -> YaraRuleBuilder: ...
    def with_modifier(self, arg0: RuleModifier) -> YaraRuleBuilder: ...
    def with_name(self, arg0: str) -> YaraRuleBuilder: ...
    def with_plain_string(self, id: str, value: str) -> YaraRuleBuilder: ...
    def with_regexp(self, id: str, value: str, suffix_mods: str = ...) -> YaraRuleBuilder: ...
    def with_string_meta(self, arg0: str, arg1: str) -> YaraRuleBuilder: ...
    def with_string_variable(self, arg0: str, arg1: str) -> YaraRuleBuilder: ...
    def with_struct_variable(self, arg0: str, arg1: str) -> YaraRuleBuilder: ...
    def with_tag(self, arg0: str) -> YaraRuleBuilder: ...
    def with_uint_meta(self, arg0: str, arg1: int) -> YaraRuleBuilder: ...
    def with_uint_variable(self, arg0: str, arg1: int) -> YaraRuleBuilder: ...
    def xor(self, *args) -> YaraRuleBuilder: ...

class Yaramod:
    def __init__(self, import_features: Features = ..., modules_directory: str = ...) -> None: ...
    def parse_file(self, file_path: str, parser_mode: ParserMode = ...) -> YaraFile: ...
    def parse_string(self, str: str, parser_mode: ParserMode = ...) -> YaraFile: ...
    @property
    def modules(self) -> Dict[str,Module]: ...
    @property
    def yara_file(self) -> YaraFile: ...

class _BoolLiteralExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def value(self) -> bool: ...

class _DoubleLiteralExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def value(self) -> float: ...

class _IntLiteralExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def value(self) -> int: ...

class _StringLiteralExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def value(self) -> str: ...

def all() -> YaraExpressionBuilder: ...
def alt(arg0: List[YaraHexStringBuilder]) -> YaraHexStringBuilder: ...
def any() -> YaraExpressionBuilder: ...
def bool_val(arg0: bool) -> YaraExpressionBuilder: ...
@overload
def conjunction(terms: List[YaraExpressionBuilder], linebreaks: bool = ...) -> YaraExpressionBuilder: ...
@overload
def conjunction(terms: List[Tuple[YaraExpressionBuilder,str]]) -> YaraExpressionBuilder: ...
@overload
def disjunction(terms: List[YaraExpressionBuilder], linebreaks: bool = ...) -> YaraExpressionBuilder: ...
@overload
def disjunction(terms: List[Tuple[YaraExpressionBuilder,str]]) -> YaraExpressionBuilder: ...
def double_val(arg0: float) -> YaraExpressionBuilder: ...
def entrypoint() -> YaraExpressionBuilder: ...
def filesize() -> YaraExpressionBuilder: ...
@overload
def for_loop(arg0: YaraExpressionBuilder, arg1: str, arg2: str, arg3: YaraExpressionBuilder, arg4: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
@overload
def for_loop(arg0: YaraExpressionBuilder, arg1: str, arg2: YaraExpressionBuilder, arg3: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
@overload
def for_loop(arg0: YaraExpressionBuilder, arg1: YaraExpressionBuilder, arg2: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
def hex_int_val(arg0: int) -> YaraExpressionBuilder: ...
def id(arg0: str) -> YaraExpressionBuilder: ...
def int_val(value: int, mult: IntMultiplier = ...) -> YaraExpressionBuilder: ...
def iterable(arg0: List[YaraExpressionBuilder]) -> YaraExpressionBuilder: ...
def jump_fixed(arg0: int) -> YaraHexStringBuilder: ...
def jump_range(arg0: int, arg1: int) -> YaraHexStringBuilder: ...
def jump_varying() -> YaraHexStringBuilder: ...
def jump_varying_range(arg0: int) -> YaraHexStringBuilder: ...
def match_at(arg0: str, arg1: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
def match_count(arg0: str) -> YaraExpressionBuilder: ...
def match_in_range(arg0: str, arg1: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
@overload
def match_length(arg0: str) -> YaraExpressionBuilder: ...
@overload
def match_length(arg0: str, arg1: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
@overload
def match_offset(arg0: str) -> YaraExpressionBuilder: ...
@overload
def match_offset(arg0: str, arg1: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
def not_(arg0: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
def not_byte(arg0: int) -> YaraHexStringBuilder: ...
def not_wildcard_high(arg0: int) -> YaraHexStringBuilder: ...
def not_wildcard_low(arg0: int) -> YaraHexStringBuilder: ...
@overload
def of(arg0: YaraExpressionBuilder, arg1: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
@overload
def of(arg0: YaraExpressionBuilder, arg1: YaraExpressionBuilder, arg2: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
def paren(enclosed_expr: YaraExpressionBuilder, linebreaks: bool = ...) -> YaraExpressionBuilder: ...
def range(arg0: YaraExpressionBuilder, arg1: YaraExpressionBuilder) -> YaraExpressionBuilder: ...
def regexp(arg0: str, arg1: str) -> YaraExpressionBuilder: ...
def set(arg0: List[YaraExpressionBuilder]) -> YaraExpressionBuilder: ...
def string_ref(arg0: str) -> YaraExpressionBuilder: ...
def string_val(arg0: str) -> YaraExpressionBuilder: ...
def them() -> YaraExpressionBuilder: ...
def uint_val(value: int, mult: IntMultiplier = ...) -> YaraExpressionBuilder: ...
def wildcard() -> YaraHexStringBuilder: ...
def wildcard_high(arg0: int) -> YaraHexStringBuilder: ...
def wildcard_low(arg0: int) -> YaraHexStringBuilder: ...
