# Generated by Django 2.1.8 on 2019-04-15 14:35

import core.fields
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0009_alter_user_last_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='InteractiveUser',
            fields=[
                ('id', models.AutoField(db_column='UserID', primary_key=True, serialize=False)),
                ('legacy_id', models.IntegerField(blank=True, db_column='LegacyID', null=True)),
                ('last_name', models.CharField(db_column='LastName', max_length=100)),
                ('other_names', models.CharField(db_column='OtherNames', max_length=100)),
                ('phone', models.CharField(blank=True, db_column='Phone', max_length=50, null=True)),
                ('login_name', models.CharField(db_column='LoginName', max_length=25)),
                ('role_id', models.IntegerField(db_column='RoleID')),
                ('health_facility_id', models.IntegerField(blank=True, db_column='HFID', null=True)),
                ('validity_from', core.fields.DateTimeField(db_column='ValidityFrom')),
                ('validity_to', core.fields.DateTimeField(blank=True, db_column='ValidityTo', null=True)),
                ('audit_user_id', models.IntegerField(db_column='AuditUserID')),
                ('email', models.CharField(blank=True, db_column='EmailId', max_length=200, null=True)),
            ],
            options={
                'db_table': 'tblUsers',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('code', models.CharField(db_column='LanguageCode', max_length=2, primary_key=True, serialize=False)),
                ('name', models.CharField(db_column='LanguageName', max_length=50)),
                ('sort_order', models.IntegerField(blank=True, db_column='SortOrder', null=True)),
            ],
            options={
                'db_table': 'tblLanguages',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('username', models.CharField(max_length=25, unique=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('i_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.InteractiveUser')),
            ],
            options={
                'db_table': 'core_User',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='ModuleConfiguration',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('module', models.CharField(max_length=20)),
                ('version', models.CharField(max_length=10)),
                ('config', models.TextField()),
            ],
            options={
                'db_table': 'core_ModuleConfiguration',
            },
        ),
        migrations.CreateModel(
            name='TechnicalUser',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('username', models.CharField(max_length=150, unique=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('is_superuser', models.BooleanField(default=False)),
                ('validity_from', models.DateTimeField(blank=True, null=True)),
                ('validity_to', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'db_table': 'core_TechnicalUser',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='user',
            name='t_user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.TechnicalUser'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
    ]
