# Automatically generated by pb2py
# fmt: off
# isort:skip_file

from enum import IntEnum
from typing import Sequence, Optional

from . import protobuf


class BinanceOrderType(IntEnum):
    OT_UNKNOWN = 0
    MARKET = 1
    LIMIT = 2
    OT_RESERVED = 3


class BinanceOrderSide(IntEnum):
    SIDE_UNKNOWN = 0
    BUY = 1
    SELL = 2


class BinanceTimeInForce(IntEnum):
    TIF_UNKNOWN = 0
    GTE = 1
    TIF_RESERVED = 2
    IOC = 3


class MessageType(IntEnum):
    Initialize = 0
    Ping = 1
    Success = 2
    Failure = 3
    ChangePin = 4
    WipeDevice = 5
    GetEntropy = 9
    Entropy = 10
    LoadDevice = 13
    ResetDevice = 14
    SetBusy = 16
    Features = 17
    PinMatrixRequest = 18
    PinMatrixAck = 19
    Cancel = 20
    LockDevice = 24
    ApplySettings = 25
    ButtonRequest = 26
    ButtonAck = 27
    ApplyFlags = 28
    GetNonce = 31
    Nonce = 33
    BackupDevice = 34
    EntropyRequest = 35
    EntropyAck = 36
    PassphraseRequest = 41
    PassphraseAck = 42
    RecoveryDevice = 45
    WordRequest = 46
    WordAck = 47
    GetFeatures = 55
    SdProtect = 79
    ChangeWipeCode = 82
    EndSession = 83
    DoPreauthorized = 84
    PreauthorizedRequest = 85
    CancelAuthorization = 86
    RebootToBootloader = 87
    GetFirmwareHash = 88
    FirmwareHash = 89
    UnlockPath = 93
    UnlockedPathRequest = 94
    SetU2FCounter = 63
    GetNextU2FCounter = 80
    NextU2FCounter = 81
    Deprecated_PassphraseStateRequest = 77
    Deprecated_PassphraseStateAck = 78
    FirmwareErase = 6
    FirmwareUpload = 7
    FirmwareRequest = 8
    SelfTest = 32
    GetPublicKey = 11
    PublicKey = 12
    SignTx = 15
    TxRequest = 21
    TxAck = 22
    GetAddress = 29
    Address = 30
    TxAckPaymentRequest = 37
    SignMessage = 38
    VerifyMessage = 39
    MessageSignature = 40
    GetOwnershipId = 43
    OwnershipId = 44
    GetOwnershipProof = 49
    OwnershipProof = 50
    AuthorizeCoinJoin = 51
    CipherKeyValue = 23
    CipheredKeyValue = 48
    SignIdentity = 53
    SignedIdentity = 54
    GetECDHSessionKey = 61
    ECDHSessionKey = 62
    CosiCommit = 71
    CosiCommitment = 72
    CosiSign = 73
    CosiSignature = 74
    DebugLinkDecision = 100
    DebugLinkGetState = 101
    DebugLinkState = 102
    DebugLinkStop = 103
    DebugLinkLog = 104
    DebugLinkMemoryRead = 110
    DebugLinkMemory = 111
    DebugLinkMemoryWrite = 112
    DebugLinkFlashErase = 113
    DebugLinkLayout = 9001
    DebugLinkReseedRandom = 9002
    DebugLinkRecordScreen = 9003
    DebugLinkEraseSdCard = 9005
    DebugLinkWatchLayout = 9006
    EthereumGetPublicKey = 450
    EthereumPublicKey = 451
    EthereumGetAddress = 56
    EthereumAddress = 57
    EthereumSignTx = 58
    EthereumSignTxEIP1559 = 452
    EthereumTxRequest = 59
    EthereumTxAck = 60
    EthereumSignMessage = 64
    EthereumVerifyMessage = 65
    EthereumMessageSignature = 66
    EthereumSignTypedData = 464
    EthereumTypedDataStructRequest = 465
    EthereumTypedDataStructAck = 466
    EthereumTypedDataValueRequest = 467
    EthereumTypedDataValueAck = 468
    EthereumTypedDataSignature = 469
    EthereumSignTypedHash = 470
    NEMGetAddress = 67
    NEMAddress = 68
    NEMSignTx = 69
    NEMSignedTx = 70
    NEMDecryptMessage = 75
    NEMDecryptedMessage = 76
    TezosGetAddress = 150
    TezosAddress = 151
    TezosSignTx = 152
    TezosSignedTx = 153
    TezosGetPublicKey = 154
    TezosPublicKey = 155
    StellarSignTx = 202
    StellarTxOpRequest = 203
    StellarGetAddress = 207
    StellarAddress = 208
    StellarCreateAccountOp = 210
    StellarPaymentOp = 211
    StellarPathPaymentStrictReceiveOp = 212
    StellarManageSellOfferOp = 213
    StellarCreatePassiveSellOfferOp = 214
    StellarSetOptionsOp = 215
    StellarChangeTrustOp = 216
    StellarAllowTrustOp = 217
    StellarAccountMergeOp = 218
    StellarManageDataOp = 220
    StellarBumpSequenceOp = 221
    StellarManageBuyOfferOp = 222
    StellarPathPaymentStrictSendOp = 223
    StellarSignedTx = 230
    CardanoGetPublicKey = 305
    CardanoPublicKey = 306
    CardanoGetAddress = 307
    CardanoAddress = 308
    CardanoTxItemAck = 313
    CardanoTxAuxiliaryDataSupplement = 314
    CardanoTxWitnessRequest = 315
    CardanoTxWitnessResponse = 316
    CardanoTxHostAck = 317
    CardanoTxBodyHash = 318
    CardanoSignTxFinished = 319
    CardanoSignTxInit = 320
    CardanoTxInput = 321
    CardanoTxOutput = 322
    CardanoAssetGroup = 323
    CardanoToken = 324
    CardanoTxCertificate = 325
    CardanoTxWithdrawal = 326
    CardanoTxAuxiliaryData = 327
    CardanoPoolOwner = 328
    CardanoPoolRelayParameters = 329
    CardanoGetNativeScriptHash = 330
    CardanoNativeScriptHash = 331
    CardanoTxMint = 332
    CardanoTxCollateralInput = 333
    CardanoTxRequiredSigner = 334
    CardanoTxInlineDatumChunk = 335
    CardanoTxReferenceScriptChunk = 336
    CardanoTxReferenceInput = 337
    RippleGetAddress = 400
    RippleAddress = 401
    RippleSignTx = 402
    RippleSignedTx = 403
    MoneroTransactionInitRequest = 501
    MoneroTransactionInitAck = 502
    MoneroTransactionSetInputRequest = 503
    MoneroTransactionSetInputAck = 504
    MoneroTransactionInputViniRequest = 507
    MoneroTransactionInputViniAck = 508
    MoneroTransactionAllInputsSetRequest = 509
    MoneroTransactionAllInputsSetAck = 510
    MoneroTransactionSetOutputRequest = 511
    MoneroTransactionSetOutputAck = 512
    MoneroTransactionAllOutSetRequest = 513
    MoneroTransactionAllOutSetAck = 514
    MoneroTransactionSignInputRequest = 515
    MoneroTransactionSignInputAck = 516
    MoneroTransactionFinalRequest = 517
    MoneroTransactionFinalAck = 518
    MoneroKeyImageExportInitRequest = 530
    MoneroKeyImageExportInitAck = 531
    MoneroKeyImageSyncStepRequest = 532
    MoneroKeyImageSyncStepAck = 533
    MoneroKeyImageSyncFinalRequest = 534
    MoneroKeyImageSyncFinalAck = 535
    MoneroGetAddress = 540
    MoneroAddress = 541
    MoneroGetWatchKey = 542
    MoneroWatchKey = 543
    DebugMoneroDiagRequest = 546
    DebugMoneroDiagAck = 547
    MoneroGetTxKeyRequest = 550
    MoneroGetTxKeyAck = 551
    MoneroLiveRefreshStartRequest = 552
    MoneroLiveRefreshStartAck = 553
    MoneroLiveRefreshStepRequest = 554
    MoneroLiveRefreshStepAck = 555
    MoneroLiveRefreshFinalRequest = 556
    MoneroLiveRefreshFinalAck = 557
    EosGetPublicKey = 600
    EosPublicKey = 601
    EosSignTx = 602
    EosTxActionRequest = 603
    EosTxActionAck = 604
    EosSignedTx = 605
    BinanceGetAddress = 700
    BinanceAddress = 701
    BinanceGetPublicKey = 702
    BinancePublicKey = 703
    BinanceSignTx = 704
    BinanceTxRequest = 705
    BinanceTransferMsg = 706
    BinanceOrderMsg = 707
    BinanceCancelMsg = 708
    BinanceSignedTx = 709
    WebAuthnListResidentCredentials = 800
    WebAuthnCredentials = 801
    WebAuthnAddResidentCredential = 802
    WebAuthnRemoveResidentCredential = 803


class FailureType(IntEnum):
    UnexpectedMessage = 1
    ButtonExpected = 2
    DataError = 3
    ActionCancelled = 4
    PinExpected = 5
    PinCancelled = 6
    PinInvalid = 7
    InvalidSignature = 8
    ProcessError = 9
    NotEnoughFunds = 10
    NotInitialized = 11
    PinMismatch = 12
    WipeCodeMismatch = 13
    InvalidSession = 14
    FirmwareError = 99


class ButtonRequestType(IntEnum):
    Other = 1
    FeeOverThreshold = 2
    ConfirmOutput = 3
    ResetDevice = 4
    ConfirmWord = 5
    WipeDevice = 6
    ProtectCall = 7
    SignTx = 8
    FirmwareCheck = 9
    Address = 10
    PublicKey = 11
    MnemonicWordCount = 12
    MnemonicInput = 13
    _Deprecated_ButtonRequest_PassphraseType = 14
    UnknownDerivationPath = 15
    RecoveryHomepage = 16
    Success = 17
    Warning = 18
    PassphraseEntry = 19
    PinEntry = 20


class PinMatrixRequestType(IntEnum):
    Current = 1
    NewFirst = 2
    NewSecond = 3
    WipeCodeFirst = 4
    WipeCodeSecond = 5


class InputScriptType(IntEnum):
    SPENDADDRESS = 0
    SPENDMULTISIG = 1
    EXTERNAL = 2
    SPENDWITNESS = 3
    SPENDP2SHWITNESS = 4
    SPENDTAPROOT = 5


class OutputScriptType(IntEnum):
    PAYTOADDRESS = 0
    PAYTOSCRIPTHASH = 1
    PAYTOMULTISIG = 2
    PAYTOOPRETURN = 3
    PAYTOWITNESS = 4
    PAYTOP2SHWITNESS = 5
    PAYTOTAPROOT = 6


class DecredStakingSpendType(IntEnum):
    SSGen = 0
    SSRTX = 1


class AmountUnit(IntEnum):
    BITCOIN = 0
    MILLIBITCOIN = 1
    MICROBITCOIN = 2
    SATOSHI = 3


class RequestType(IntEnum):
    TXINPUT = 0
    TXOUTPUT = 1
    TXMETA = 2
    TXFINISHED = 3
    TXEXTRADATA = 4
    TXORIGINPUT = 5
    TXORIGOUTPUT = 6
    TXPAYMENTREQ = 7


class CardanoDerivationType(IntEnum):
    LEDGER = 0
    ICARUS = 1
    ICARUS_TREZOR = 2


class CardanoAddressType(IntEnum):
    BASE = 0
    BASE_SCRIPT_KEY = 1
    BASE_KEY_SCRIPT = 2
    BASE_SCRIPT_SCRIPT = 3
    POINTER = 4
    POINTER_SCRIPT = 5
    ENTERPRISE = 6
    ENTERPRISE_SCRIPT = 7
    BYRON = 8
    REWARD = 14
    REWARD_SCRIPT = 15


class CardanoNativeScriptType(IntEnum):
    PUB_KEY = 0
    ALL = 1
    ANY = 2
    N_OF_K = 3
    INVALID_BEFORE = 4
    INVALID_HEREAFTER = 5


class CardanoNativeScriptHashDisplayFormat(IntEnum):
    HIDE = 0
    BECH32 = 1
    POLICY_ID = 2


class CardanoTxOutputSerializationFormat(IntEnum):
    ARRAY_LEGACY = 0
    MAP_BABBAGE = 1


class CardanoCertificateType(IntEnum):
    STAKE_REGISTRATION = 0
    STAKE_DEREGISTRATION = 1
    STAKE_DELEGATION = 2
    STAKE_POOL_REGISTRATION = 3


class CardanoPoolRelayType(IntEnum):
    SINGLE_HOST_IP = 0
    SINGLE_HOST_NAME = 1
    MULTIPLE_HOST_NAME = 2


class CardanoTxAuxiliaryDataSupplementType(IntEnum):
    NONE = 0
    GOVERNANCE_REGISTRATION_SIGNATURE = 1


class CardanoGovernanceRegistrationFormat(IntEnum):
    CIP15 = 0
    CIP36 = 1


class CardanoTxSigningMode(IntEnum):
    ORDINARY_TRANSACTION = 0
    POOL_REGISTRATION_AS_OWNER = 1
    MULTISIG_TRANSACTION = 2
    PLUTUS_TRANSACTION = 3


class CardanoTxWitnessType(IntEnum):
    BYRON_WITNESS = 0
    SHELLEY_WITNESS = 1


class BackupType(IntEnum):
    Bip39 = 0
    Slip39_Basic = 1
    Slip39_Advanced = 2


class SafetyCheckLevel(IntEnum):
    Strict = 0
    PromptAlways = 1
    PromptTemporarily = 2


class Capability(IntEnum):
    Bitcoin = 1
    Bitcoin_like = 2
    Binance = 3
    Cardano = 4
    Crypto = 5
    EOS = 6
    Ethereum = 7
    Lisk = 8
    Monero = 9
    NEM = 10
    Ripple = 11
    Stellar = 12
    Tezos = 13
    U2F = 14
    Shamir = 15
    ShamirGroups = 16
    PassphraseEntry = 17


class SdProtectOperationType(IntEnum):
    DISABLE = 0
    ENABLE = 1
    REFRESH = 2


class RecoveryDeviceType(IntEnum):
    ScrambledWords = 0
    Matrix = 1


class WordRequestType(IntEnum):
    Plain = 0
    Matrix9 = 1
    Matrix6 = 2


class DebugSwipeDirection(IntEnum):
    UP = 0
    DOWN = 1
    LEFT = 2
    RIGHT = 3


class DebugButton(IntEnum):
    NO = 0
    YES = 1
    INFO = 2


class EthereumDataType(IntEnum):
    UINT = 1
    INT = 2
    BYTES = 3
    STRING = 4
    BOOL = 5
    ADDRESS = 6
    ARRAY = 7
    STRUCT = 8


class MoneroNetworkType(IntEnum):
    MAINNET = 0
    TESTNET = 1
    STAGENET = 2
    FAKECHAIN = 3


class NEMMosaicLevy(IntEnum):
    MosaicLevy_Absolute = 1
    MosaicLevy_Percentile = 2


class NEMSupplyChangeType(IntEnum):
    SupplyChange_Increase = 1
    SupplyChange_Decrease = 2


class NEMModificationType(IntEnum):
    CosignatoryModification_Add = 1
    CosignatoryModification_Delete = 2


class NEMImportanceTransferMode(IntEnum):
    ImportanceTransfer_Activate = 1
    ImportanceTransfer_Deactivate = 2


class StellarAssetType(IntEnum):
    NATIVE = 0
    ALPHANUM4 = 1
    ALPHANUM12 = 2


class StellarMemoType(IntEnum):
    NONE = 0
    TEXT = 1
    ID = 2
    HASH = 3
    RETURN = 4


class StellarSignerType(IntEnum):
    ACCOUNT = 0
    PRE_AUTH = 1
    HASH = 2


class TezosContractType(IntEnum):
    Implicit = 0
    Originated = 1


class TezosBallotType(IntEnum):
    Yay = 0
    Nay = 1
    Pass = 2


class BinanceGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 700
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class BinanceAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 701
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
    ) -> None:
        self.address = address


class BinanceGetPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 702
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class BinancePublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 703
    FIELDS = {
        1: protobuf.Field("public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        public_key: "bytes",
    ) -> None:
        self.public_key = public_key


class BinanceSignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 704
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("msg_count", "uint32", repeated=False, required=True),
        3: protobuf.Field("account_number", "sint64", repeated=False, required=True),
        4: protobuf.Field("chain_id", "string", repeated=False, required=False, default=None),
        5: protobuf.Field("memo", "string", repeated=False, required=False, default=None),
        6: protobuf.Field("sequence", "sint64", repeated=False, required=True),
        7: protobuf.Field("source", "sint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        msg_count: "int",
        account_number: "int",
        sequence: "int",
        source: "int",
        address_n: Optional[Sequence["int"]] = None,
        chain_id: Optional["str"] = None,
        memo: Optional["str"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.msg_count = msg_count
        self.account_number = account_number
        self.sequence = sequence
        self.source = source
        self.chain_id = chain_id
        self.memo = memo


class BinanceTxRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 705


class BinanceTransferMsg(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 706
    FIELDS = {
        1: protobuf.Field("inputs", "BinanceInputOutput", repeated=True, required=False, default=None),
        2: protobuf.Field("outputs", "BinanceInputOutput", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        inputs: Optional[Sequence["BinanceInputOutput"]] = None,
        outputs: Optional[Sequence["BinanceInputOutput"]] = None,
    ) -> None:
        self.inputs: Sequence["BinanceInputOutput"] = inputs if inputs is not None else []
        self.outputs: Sequence["BinanceInputOutput"] = outputs if outputs is not None else []


class BinanceOrderMsg(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 707
    FIELDS = {
        1: protobuf.Field("id", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("ordertype", "BinanceOrderType", repeated=False, required=True),
        3: protobuf.Field("price", "sint64", repeated=False, required=True),
        4: protobuf.Field("quantity", "sint64", repeated=False, required=True),
        5: protobuf.Field("sender", "string", repeated=False, required=False, default=None),
        6: protobuf.Field("side", "BinanceOrderSide", repeated=False, required=True),
        7: protobuf.Field("symbol", "string", repeated=False, required=False, default=None),
        8: protobuf.Field("timeinforce", "BinanceTimeInForce", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        ordertype: "BinanceOrderType",
        price: "int",
        quantity: "int",
        side: "BinanceOrderSide",
        timeinforce: "BinanceTimeInForce",
        id: Optional["str"] = None,
        sender: Optional["str"] = None,
        symbol: Optional["str"] = None,
    ) -> None:
        self.ordertype = ordertype
        self.price = price
        self.quantity = quantity
        self.side = side
        self.timeinforce = timeinforce
        self.id = id
        self.sender = sender
        self.symbol = symbol


class BinanceCancelMsg(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 708
    FIELDS = {
        1: protobuf.Field("refid", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("sender", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("symbol", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        refid: Optional["str"] = None,
        sender: Optional["str"] = None,
        symbol: Optional["str"] = None,
    ) -> None:
        self.refid = refid
        self.sender = sender
        self.symbol = symbol


class BinanceSignedTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 709
    FIELDS = {
        1: protobuf.Field("signature", "bytes", repeated=False, required=True),
        2: protobuf.Field("public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "bytes",
        public_key: "bytes",
    ) -> None:
        self.signature = signature
        self.public_key = public_key


class BinanceInputOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("coins", "BinanceCoin", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address: "str",
        coins: Optional[Sequence["BinanceCoin"]] = None,
    ) -> None:
        self.coins: Sequence["BinanceCoin"] = coins if coins is not None else []
        self.address = address


class BinanceCoin(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "sint64", repeated=False, required=True),
        2: protobuf.Field("denom", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        amount: "int",
        denom: "str",
    ) -> None:
        self.amount = amount
        self.denom = denom


class Success(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 2
    FIELDS = {
        1: protobuf.Field("message", "string", repeated=False, required=False, default=''),
    }

    def __init__(
        self,
        *,
        message: Optional["str"] = '',
    ) -> None:
        self.message = message


class Failure(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 3
    FIELDS = {
        1: protobuf.Field("code", "FailureType", repeated=False, required=False, default=None),
        2: protobuf.Field("message", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        code: Optional["FailureType"] = None,
        message: Optional["str"] = None,
    ) -> None:
        self.code = code
        self.message = message


class ButtonRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 26
    FIELDS = {
        1: protobuf.Field("code", "ButtonRequestType", repeated=False, required=False, default=None),
        2: protobuf.Field("pages", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        code: Optional["ButtonRequestType"] = None,
        pages: Optional["int"] = None,
    ) -> None:
        self.code = code
        self.pages = pages


class ButtonAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 27


class PinMatrixRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 18
    FIELDS = {
        1: protobuf.Field("type", "PinMatrixRequestType", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        type: Optional["PinMatrixRequestType"] = None,
    ) -> None:
        self.type = type


class PinMatrixAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 19
    FIELDS = {
        1: protobuf.Field("pin", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        pin: "str",
    ) -> None:
        self.pin = pin


class PassphraseRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 41
    FIELDS = {
        1: protobuf.Field("_on_device", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        _on_device: Optional["bool"] = None,
    ) -> None:
        self._on_device = _on_device


class PassphraseAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 42
    FIELDS = {
        1: protobuf.Field("passphrase", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("_state", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("on_device", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        passphrase: Optional["str"] = None,
        _state: Optional["bytes"] = None,
        on_device: Optional["bool"] = None,
    ) -> None:
        self.passphrase = passphrase
        self._state = _state
        self.on_device = on_device


class Deprecated_PassphraseStateRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 77
    FIELDS = {
        1: protobuf.Field("state", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        state: Optional["bytes"] = None,
    ) -> None:
        self.state = state


class Deprecated_PassphraseStateAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 78


class HDNodeType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("depth", "uint32", repeated=False, required=True),
        2: protobuf.Field("fingerprint", "uint32", repeated=False, required=True),
        3: protobuf.Field("child_num", "uint32", repeated=False, required=True),
        4: protobuf.Field("chain_code", "bytes", repeated=False, required=True),
        5: protobuf.Field("private_key", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        depth: "int",
        fingerprint: "int",
        child_num: "int",
        chain_code: "bytes",
        public_key: "bytes",
        private_key: Optional["bytes"] = None,
    ) -> None:
        self.depth = depth
        self.fingerprint = fingerprint
        self.child_num = child_num
        self.chain_code = chain_code
        self.public_key = public_key
        self.private_key = private_key


class MultisigRedeemScriptType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("pubkeys", "HDNodePathType", repeated=True, required=False, default=None),
        2: protobuf.Field("signatures", "bytes", repeated=True, required=False, default=None),
        3: protobuf.Field("m", "uint32", repeated=False, required=True),
        4: protobuf.Field("nodes", "HDNodeType", repeated=True, required=False, default=None),
        5: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        m: "int",
        pubkeys: Optional[Sequence["HDNodePathType"]] = None,
        signatures: Optional[Sequence["bytes"]] = None,
        nodes: Optional[Sequence["HDNodeType"]] = None,
        address_n: Optional[Sequence["int"]] = None,
    ) -> None:
        self.pubkeys: Sequence["HDNodePathType"] = pubkeys if pubkeys is not None else []
        self.signatures: Sequence["bytes"] = signatures if signatures is not None else []
        self.nodes: Sequence["HDNodeType"] = nodes if nodes is not None else []
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.m = m


class GetPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 11
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("ecdsa_curve_name", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
        4: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
        5: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDADDRESS),
        6: protobuf.Field("ignore_xpub_magic", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        ecdsa_curve_name: Optional["str"] = None,
        show_display: Optional["bool"] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        ignore_xpub_magic: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.ecdsa_curve_name = ecdsa_curve_name
        self.show_display = show_display
        self.coin_name = coin_name
        self.script_type = script_type
        self.ignore_xpub_magic = ignore_xpub_magic


class PublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 12
    FIELDS = {
        1: protobuf.Field("node", "HDNodeType", repeated=False, required=True),
        2: protobuf.Field("xpub", "string", repeated=False, required=True),
        3: protobuf.Field("root_fingerprint", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        node: "HDNodeType",
        xpub: "str",
        root_fingerprint: Optional["int"] = None,
    ) -> None:
        self.node = node
        self.xpub = xpub
        self.root_fingerprint = root_fingerprint


class GetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 29
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
        3: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
        4: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False, default=None),
        5: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDADDRESS),
        6: protobuf.Field("ignore_xpub_magic", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        show_display: Optional["bool"] = None,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        ignore_xpub_magic: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.coin_name = coin_name
        self.show_display = show_display
        self.multisig = multisig
        self.script_type = script_type
        self.ignore_xpub_magic = ignore_xpub_magic


class Address(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 30
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("mac", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address: "str",
        mac: Optional["bytes"] = None,
    ) -> None:
        self.address = address
        self.mac = mac


class GetOwnershipId(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 43
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
        3: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False, default=None),
        4: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDADDRESS),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        multisig: Optional["MultisigRedeemScriptType"] = None,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.coin_name = coin_name
        self.multisig = multisig
        self.script_type = script_type


class OwnershipId(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 44
    FIELDS = {
        1: protobuf.Field("ownership_id", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        ownership_id: "bytes",
    ) -> None:
        self.ownership_id = ownership_id


class SignMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 38
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("message", "bytes", repeated=False, required=True),
        3: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
        4: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDADDRESS),
        5: protobuf.Field("no_script_type", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        message: "bytes",
        address_n: Optional[Sequence["int"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        no_script_type: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.message = message
        self.coin_name = coin_name
        self.script_type = script_type
        self.no_script_type = no_script_type


class MessageSignature(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 40
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
        signature: "bytes",
    ) -> None:
        self.address = address
        self.signature = signature


class VerifyMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 39
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
        3: protobuf.Field("message", "bytes", repeated=False, required=True),
        4: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
    }

    def __init__(
        self,
        *,
        address: "str",
        signature: "bytes",
        message: "bytes",
        coin_name: Optional["str"] = 'Bitcoin',
    ) -> None:
        self.address = address
        self.signature = signature
        self.message = message
        self.coin_name = coin_name


class SignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 15
    FIELDS = {
        1: protobuf.Field("outputs_count", "uint32", repeated=False, required=True),
        2: protobuf.Field("inputs_count", "uint32", repeated=False, required=True),
        3: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
        4: protobuf.Field("version", "uint32", repeated=False, required=False, default=1),
        5: protobuf.Field("lock_time", "uint32", repeated=False, required=False, default=0),
        6: protobuf.Field("expiry", "uint32", repeated=False, required=False, default=None),
        7: protobuf.Field("overwintered", "bool", repeated=False, required=False, default=None),
        8: protobuf.Field("version_group_id", "uint32", repeated=False, required=False, default=None),
        9: protobuf.Field("timestamp", "uint32", repeated=False, required=False, default=None),
        10: protobuf.Field("branch_id", "uint32", repeated=False, required=False, default=None),
        11: protobuf.Field("amount_unit", "AmountUnit", repeated=False, required=False, default=AmountUnit.BITCOIN),
        12: protobuf.Field("decred_staking_ticket", "bool", repeated=False, required=False, default=False),
        13: protobuf.Field("serialize", "bool", repeated=False, required=False, default=True),
        14: protobuf.Field("coinjoin_request", "CoinJoinRequest", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        outputs_count: "int",
        inputs_count: "int",
        coin_name: Optional["str"] = 'Bitcoin',
        version: Optional["int"] = 1,
        lock_time: Optional["int"] = 0,
        expiry: Optional["int"] = None,
        overwintered: Optional["bool"] = None,
        version_group_id: Optional["int"] = None,
        timestamp: Optional["int"] = None,
        branch_id: Optional["int"] = None,
        amount_unit: Optional["AmountUnit"] = AmountUnit.BITCOIN,
        decred_staking_ticket: Optional["bool"] = False,
        serialize: Optional["bool"] = True,
        coinjoin_request: Optional["CoinJoinRequest"] = None,
    ) -> None:
        self.outputs_count = outputs_count
        self.inputs_count = inputs_count
        self.coin_name = coin_name
        self.version = version
        self.lock_time = lock_time
        self.expiry = expiry
        self.overwintered = overwintered
        self.version_group_id = version_group_id
        self.timestamp = timestamp
        self.branch_id = branch_id
        self.amount_unit = amount_unit
        self.decred_staking_ticket = decred_staking_ticket
        self.serialize = serialize
        self.coinjoin_request = coinjoin_request


class TxRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 21
    FIELDS = {
        1: protobuf.Field("request_type", "RequestType", repeated=False, required=False, default=None),
        2: protobuf.Field("details", "TxRequestDetailsType", repeated=False, required=False, default=None),
        3: protobuf.Field("serialized", "TxRequestSerializedType", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        request_type: Optional["RequestType"] = None,
        details: Optional["TxRequestDetailsType"] = None,
        serialized: Optional["TxRequestSerializedType"] = None,
    ) -> None:
        self.request_type = request_type
        self.details = details
        self.serialized = serialized


class TxAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TransactionType", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        tx: Optional["TransactionType"] = None,
    ) -> None:
        self.tx = tx


class TxInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
        4: protobuf.Field("script_sig", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("sequence", "uint32", repeated=False, required=False, default=4294967295),
        6: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDADDRESS),
        7: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False, default=None),
        8: protobuf.Field("amount", "uint64", repeated=False, required=True),
        9: protobuf.Field("decred_tree", "uint32", repeated=False, required=False, default=None),
        13: protobuf.Field("witness", "bytes", repeated=False, required=False, default=None),
        14: protobuf.Field("ownership_proof", "bytes", repeated=False, required=False, default=None),
        15: protobuf.Field("commitment_data", "bytes", repeated=False, required=False, default=None),
        16: protobuf.Field("orig_hash", "bytes", repeated=False, required=False, default=None),
        17: protobuf.Field("orig_index", "uint32", repeated=False, required=False, default=None),
        18: protobuf.Field("decred_staking_spend", "DecredStakingSpendType", repeated=False, required=False, default=None),
        19: protobuf.Field("script_pubkey", "bytes", repeated=False, required=False, default=None),
        20: protobuf.Field("coinjoin_flags", "uint32", repeated=False, required=False, default=0),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
        amount: "int",
        address_n: Optional[Sequence["int"]] = None,
        script_sig: Optional["bytes"] = None,
        sequence: Optional["int"] = 4294967295,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        decred_tree: Optional["int"] = None,
        witness: Optional["bytes"] = None,
        ownership_proof: Optional["bytes"] = None,
        commitment_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
        decred_staking_spend: Optional["DecredStakingSpendType"] = None,
        script_pubkey: Optional["bytes"] = None,
        coinjoin_flags: Optional["int"] = 0,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.prev_hash = prev_hash
        self.prev_index = prev_index
        self.amount = amount
        self.script_sig = script_sig
        self.sequence = sequence
        self.script_type = script_type
        self.multisig = multisig
        self.decred_tree = decred_tree
        self.witness = witness
        self.ownership_proof = ownership_proof
        self.commitment_data = commitment_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index
        self.decred_staking_spend = decred_staking_spend
        self.script_pubkey = script_pubkey
        self.coinjoin_flags = coinjoin_flags


class TxOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        3: protobuf.Field("amount", "uint64", repeated=False, required=True),
        4: protobuf.Field("script_type", "OutputScriptType", repeated=False, required=False, default=OutputScriptType.PAYTOADDRESS),
        5: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False, default=None),
        6: protobuf.Field("op_return_data", "bytes", repeated=False, required=False, default=None),
        10: protobuf.Field("orig_hash", "bytes", repeated=False, required=False, default=None),
        11: protobuf.Field("orig_index", "uint32", repeated=False, required=False, default=None),
        12: protobuf.Field("payment_req_index", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        amount: "int",
        address_n: Optional[Sequence["int"]] = None,
        address: Optional["str"] = None,
        script_type: Optional["OutputScriptType"] = OutputScriptType.PAYTOADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        op_return_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
        payment_req_index: Optional["int"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.amount = amount
        self.address = address
        self.script_type = script_type
        self.multisig = multisig
        self.op_return_data = op_return_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index
        self.payment_req_index = payment_req_index


class PrevTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("version", "uint32", repeated=False, required=True),
        4: protobuf.Field("lock_time", "uint32", repeated=False, required=True),
        6: protobuf.Field("inputs_count", "uint32", repeated=False, required=True),
        7: protobuf.Field("outputs_count", "uint32", repeated=False, required=True),
        9: protobuf.Field("extra_data_len", "uint32", repeated=False, required=False, default=0),
        10: protobuf.Field("expiry", "uint32", repeated=False, required=False, default=None),
        12: protobuf.Field("version_group_id", "uint32", repeated=False, required=False, default=None),
        13: protobuf.Field("timestamp", "uint32", repeated=False, required=False, default=None),
        14: protobuf.Field("branch_id", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        version: "int",
        lock_time: "int",
        inputs_count: "int",
        outputs_count: "int",
        extra_data_len: Optional["int"] = 0,
        expiry: Optional["int"] = None,
        version_group_id: Optional["int"] = None,
        timestamp: Optional["int"] = None,
        branch_id: Optional["int"] = None,
    ) -> None:
        self.version = version
        self.lock_time = lock_time
        self.inputs_count = inputs_count
        self.outputs_count = outputs_count
        self.extra_data_len = extra_data_len
        self.expiry = expiry
        self.version_group_id = version_group_id
        self.timestamp = timestamp
        self.branch_id = branch_id


class PrevInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        2: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
        4: protobuf.Field("script_sig", "bytes", repeated=False, required=True),
        5: protobuf.Field("sequence", "uint32", repeated=False, required=True),
        9: protobuf.Field("decred_tree", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
        script_sig: "bytes",
        sequence: "int",
        decred_tree: Optional["int"] = None,
    ) -> None:
        self.prev_hash = prev_hash
        self.prev_index = prev_index
        self.script_sig = script_sig
        self.sequence = sequence
        self.decred_tree = decred_tree


class PrevOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "uint64", repeated=False, required=True),
        2: protobuf.Field("script_pubkey", "bytes", repeated=False, required=True),
        3: protobuf.Field("decred_script_version", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        amount: "int",
        script_pubkey: "bytes",
        decred_script_version: Optional["int"] = None,
    ) -> None:
        self.amount = amount
        self.script_pubkey = script_pubkey
        self.decred_script_version = decred_script_version


class TxAckPaymentRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 37
    FIELDS = {
        1: protobuf.Field("nonce", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("recipient_name", "string", repeated=False, required=True),
        3: protobuf.Field("memos", "PaymentRequestMemo", repeated=True, required=False, default=None),
        4: protobuf.Field("amount", "uint64", repeated=False, required=False, default=None),
        5: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        recipient_name: "str",
        signature: "bytes",
        memos: Optional[Sequence["PaymentRequestMemo"]] = None,
        nonce: Optional["bytes"] = None,
        amount: Optional["int"] = None,
    ) -> None:
        self.memos: Sequence["PaymentRequestMemo"] = memos if memos is not None else []
        self.recipient_name = recipient_name
        self.signature = signature
        self.nonce = nonce
        self.amount = amount


class TxAckInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckInputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckInputWrapper",
    ) -> None:
        self.tx = tx


class TxAckOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckOutputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckOutputWrapper",
    ) -> None:
        self.tx = tx


class TxAckPrevMeta(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "PrevTx", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "PrevTx",
    ) -> None:
        self.tx = tx


class TxAckPrevInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckPrevInputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckPrevInputWrapper",
    ) -> None:
        self.tx = tx


class TxAckPrevOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckPrevOutputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckPrevOutputWrapper",
    ) -> None:
        self.tx = tx


class TxAckPrevExtraData(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckPrevExtraDataWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckPrevExtraDataWrapper",
    ) -> None:
        self.tx = tx


class GetOwnershipProof(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 49
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
        3: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDWITNESS),
        4: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False, default=None),
        5: protobuf.Field("user_confirmation", "bool", repeated=False, required=False, default=False),
        6: protobuf.Field("ownership_ids", "bytes", repeated=True, required=False, default=None),
        7: protobuf.Field("commitment_data", "bytes", repeated=False, required=False, default=b''),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        ownership_ids: Optional[Sequence["bytes"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDWITNESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        user_confirmation: Optional["bool"] = False,
        commitment_data: Optional["bytes"] = b'',
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.ownership_ids: Sequence["bytes"] = ownership_ids if ownership_ids is not None else []
        self.coin_name = coin_name
        self.script_type = script_type
        self.multisig = multisig
        self.user_confirmation = user_confirmation
        self.commitment_data = commitment_data


class OwnershipProof(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 50
    FIELDS = {
        1: protobuf.Field("ownership_proof", "bytes", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        ownership_proof: "bytes",
        signature: "bytes",
    ) -> None:
        self.ownership_proof = ownership_proof
        self.signature = signature


class AuthorizeCoinJoin(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 51
    FIELDS = {
        1: protobuf.Field("coordinator", "string", repeated=False, required=True),
        2: protobuf.Field("max_rounds", "uint64", repeated=False, required=True),
        3: protobuf.Field("max_coordinator_fee_rate", "uint32", repeated=False, required=True),
        4: protobuf.Field("max_fee_per_kvbyte", "uint32", repeated=False, required=True),
        5: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        6: protobuf.Field("coin_name", "string", repeated=False, required=False, default='Bitcoin'),
        7: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDADDRESS),
        8: protobuf.Field("amount_unit", "AmountUnit", repeated=False, required=False, default=AmountUnit.BITCOIN),
    }

    def __init__(
        self,
        *,
        coordinator: "str",
        max_rounds: "int",
        max_coordinator_fee_rate: "int",
        max_fee_per_kvbyte: "int",
        address_n: Optional[Sequence["int"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        amount_unit: Optional["AmountUnit"] = AmountUnit.BITCOIN,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.coordinator = coordinator
        self.max_rounds = max_rounds
        self.max_coordinator_fee_rate = max_coordinator_fee_rate
        self.max_fee_per_kvbyte = max_fee_per_kvbyte
        self.coin_name = coin_name
        self.script_type = script_type
        self.amount_unit = amount_unit


class HDNodePathType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("node", "HDNodeType", repeated=False, required=True),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        node: "HDNodeType",
        address_n: Optional[Sequence["int"]] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.node = node


class CoinJoinRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("fee_rate", "uint32", repeated=False, required=True),
        2: protobuf.Field("no_fee_threshold", "uint64", repeated=False, required=True),
        3: protobuf.Field("min_registrable_amount", "uint64", repeated=False, required=True),
        4: protobuf.Field("mask_public_key", "bytes", repeated=False, required=True),
        5: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        fee_rate: "int",
        no_fee_threshold: "int",
        min_registrable_amount: "int",
        mask_public_key: "bytes",
        signature: "bytes",
    ) -> None:
        self.fee_rate = fee_rate
        self.no_fee_threshold = no_fee_threshold
        self.min_registrable_amount = min_registrable_amount
        self.mask_public_key = mask_public_key
        self.signature = signature


class TxRequestDetailsType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("request_index", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("tx_hash", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("extra_data_len", "uint32", repeated=False, required=False, default=None),
        4: protobuf.Field("extra_data_offset", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        request_index: Optional["int"] = None,
        tx_hash: Optional["bytes"] = None,
        extra_data_len: Optional["int"] = None,
        extra_data_offset: Optional["int"] = None,
    ) -> None:
        self.request_index = request_index
        self.tx_hash = tx_hash
        self.extra_data_len = extra_data_len
        self.extra_data_offset = extra_data_offset


class TxRequestSerializedType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("signature_index", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("signature", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("serialized_tx", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        signature_index: Optional["int"] = None,
        signature: Optional["bytes"] = None,
        serialized_tx: Optional["bytes"] = None,
    ) -> None:
        self.signature_index = signature_index
        self.signature = signature
        self.serialized_tx = serialized_tx


class TransactionType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("version", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("inputs", "TxInputType", repeated=True, required=False, default=None),
        3: protobuf.Field("bin_outputs", "TxOutputBinType", repeated=True, required=False, default=None),
        4: protobuf.Field("lock_time", "uint32", repeated=False, required=False, default=None),
        5: protobuf.Field("outputs", "TxOutputType", repeated=True, required=False, default=None),
        6: protobuf.Field("inputs_cnt", "uint32", repeated=False, required=False, default=None),
        7: protobuf.Field("outputs_cnt", "uint32", repeated=False, required=False, default=None),
        8: protobuf.Field("extra_data", "bytes", repeated=False, required=False, default=None),
        9: protobuf.Field("extra_data_len", "uint32", repeated=False, required=False, default=None),
        10: protobuf.Field("expiry", "uint32", repeated=False, required=False, default=None),
        11: protobuf.Field("overwintered", "bool", repeated=False, required=False, default=None),
        12: protobuf.Field("version_group_id", "uint32", repeated=False, required=False, default=None),
        13: protobuf.Field("timestamp", "uint32", repeated=False, required=False, default=None),
        14: protobuf.Field("branch_id", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        inputs: Optional[Sequence["TxInputType"]] = None,
        bin_outputs: Optional[Sequence["TxOutputBinType"]] = None,
        outputs: Optional[Sequence["TxOutputType"]] = None,
        version: Optional["int"] = None,
        lock_time: Optional["int"] = None,
        inputs_cnt: Optional["int"] = None,
        outputs_cnt: Optional["int"] = None,
        extra_data: Optional["bytes"] = None,
        extra_data_len: Optional["int"] = None,
        expiry: Optional["int"] = None,
        overwintered: Optional["bool"] = None,
        version_group_id: Optional["int"] = None,
        timestamp: Optional["int"] = None,
        branch_id: Optional["int"] = None,
    ) -> None:
        self.inputs: Sequence["TxInputType"] = inputs if inputs is not None else []
        self.bin_outputs: Sequence["TxOutputBinType"] = bin_outputs if bin_outputs is not None else []
        self.outputs: Sequence["TxOutputType"] = outputs if outputs is not None else []
        self.version = version
        self.lock_time = lock_time
        self.inputs_cnt = inputs_cnt
        self.outputs_cnt = outputs_cnt
        self.extra_data = extra_data
        self.extra_data_len = extra_data_len
        self.expiry = expiry
        self.overwintered = overwintered
        self.version_group_id = version_group_id
        self.timestamp = timestamp
        self.branch_id = branch_id


class TxInputType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
        4: protobuf.Field("script_sig", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("sequence", "uint32", repeated=False, required=False, default=4294967295),
        6: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False, default=InputScriptType.SPENDADDRESS),
        7: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False, default=None),
        8: protobuf.Field("amount", "uint64", repeated=False, required=False, default=None),
        9: protobuf.Field("decred_tree", "uint32", repeated=False, required=False, default=None),
        13: protobuf.Field("witness", "bytes", repeated=False, required=False, default=None),
        14: protobuf.Field("ownership_proof", "bytes", repeated=False, required=False, default=None),
        15: protobuf.Field("commitment_data", "bytes", repeated=False, required=False, default=None),
        16: protobuf.Field("orig_hash", "bytes", repeated=False, required=False, default=None),
        17: protobuf.Field("orig_index", "uint32", repeated=False, required=False, default=None),
        18: protobuf.Field("decred_staking_spend", "DecredStakingSpendType", repeated=False, required=False, default=None),
        19: protobuf.Field("script_pubkey", "bytes", repeated=False, required=False, default=None),
        20: protobuf.Field("coinjoin_flags", "uint32", repeated=False, required=False, default=0),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
        address_n: Optional[Sequence["int"]] = None,
        script_sig: Optional["bytes"] = None,
        sequence: Optional["int"] = 4294967295,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        amount: Optional["int"] = None,
        decred_tree: Optional["int"] = None,
        witness: Optional["bytes"] = None,
        ownership_proof: Optional["bytes"] = None,
        commitment_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
        decred_staking_spend: Optional["DecredStakingSpendType"] = None,
        script_pubkey: Optional["bytes"] = None,
        coinjoin_flags: Optional["int"] = 0,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.prev_hash = prev_hash
        self.prev_index = prev_index
        self.script_sig = script_sig
        self.sequence = sequence
        self.script_type = script_type
        self.multisig = multisig
        self.amount = amount
        self.decred_tree = decred_tree
        self.witness = witness
        self.ownership_proof = ownership_proof
        self.commitment_data = commitment_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index
        self.decred_staking_spend = decred_staking_spend
        self.script_pubkey = script_pubkey
        self.coinjoin_flags = coinjoin_flags


class TxOutputBinType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "uint64", repeated=False, required=True),
        2: protobuf.Field("script_pubkey", "bytes", repeated=False, required=True),
        3: protobuf.Field("decred_script_version", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        amount: "int",
        script_pubkey: "bytes",
        decred_script_version: Optional["int"] = None,
    ) -> None:
        self.amount = amount
        self.script_pubkey = script_pubkey
        self.decred_script_version = decred_script_version


class TxOutputType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        3: protobuf.Field("amount", "uint64", repeated=False, required=True),
        4: protobuf.Field("script_type", "OutputScriptType", repeated=False, required=False, default=OutputScriptType.PAYTOADDRESS),
        5: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False, default=None),
        6: protobuf.Field("op_return_data", "bytes", repeated=False, required=False, default=None),
        10: protobuf.Field("orig_hash", "bytes", repeated=False, required=False, default=None),
        11: protobuf.Field("orig_index", "uint32", repeated=False, required=False, default=None),
        12: protobuf.Field("payment_req_index", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        amount: "int",
        address_n: Optional[Sequence["int"]] = None,
        address: Optional["str"] = None,
        script_type: Optional["OutputScriptType"] = OutputScriptType.PAYTOADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        op_return_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
        payment_req_index: Optional["int"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.amount = amount
        self.address = address
        self.script_type = script_type
        self.multisig = multisig
        self.op_return_data = op_return_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index
        self.payment_req_index = payment_req_index


class PaymentRequestMemo(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("text_memo", "TextMemo", repeated=False, required=False, default=None),
        2: protobuf.Field("refund_memo", "RefundMemo", repeated=False, required=False, default=None),
        3: protobuf.Field("coin_purchase_memo", "CoinPurchaseMemo", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        text_memo: Optional["TextMemo"] = None,
        refund_memo: Optional["RefundMemo"] = None,
        coin_purchase_memo: Optional["CoinPurchaseMemo"] = None,
    ) -> None:
        self.text_memo = text_memo
        self.refund_memo = refund_memo
        self.coin_purchase_memo = coin_purchase_memo


class TextMemo(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("text", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        text: "str",
    ) -> None:
        self.text = text


class RefundMemo(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("mac", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
        mac: "bytes",
    ) -> None:
        self.address = address
        self.mac = mac


class CoinPurchaseMemo(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("coin_type", "uint32", repeated=False, required=True),
        2: protobuf.Field("amount", "string", repeated=False, required=True),
        3: protobuf.Field("address", "string", repeated=False, required=True),
        4: protobuf.Field("mac", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        coin_type: "int",
        amount: "str",
        address: "str",
        mac: "bytes",
    ) -> None:
        self.coin_type = coin_type
        self.amount = amount
        self.address = address
        self.mac = mac


class TxAckInputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        2: protobuf.Field("input", "TxInput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        input: "TxInput",
    ) -> None:
        self.input = input


class TxAckOutputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        5: protobuf.Field("output", "TxOutput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        output: "TxOutput",
    ) -> None:
        self.output = output


class TxAckPrevInputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        2: protobuf.Field("input", "PrevInput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        input: "PrevInput",
    ) -> None:
        self.input = input


class TxAckPrevOutputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        3: protobuf.Field("output", "PrevOutput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        output: "PrevOutput",
    ) -> None:
        self.output = output


class TxAckPrevExtraDataWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        8: protobuf.Field("extra_data_chunk", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        extra_data_chunk: "bytes",
    ) -> None:
        self.extra_data_chunk = extra_data_chunk


class FirmwareErase(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 6
    FIELDS = {
        1: protobuf.Field("length", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        length: Optional["int"] = None,
    ) -> None:
        self.length = length


class FirmwareRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 8
    FIELDS = {
        1: protobuf.Field("offset", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("length", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        offset: Optional["int"] = None,
        length: Optional["int"] = None,
    ) -> None:
        self.offset = offset
        self.length = length


class FirmwareUpload(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 7
    FIELDS = {
        1: protobuf.Field("payload", "bytes", repeated=False, required=True),
        2: protobuf.Field("hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        payload: "bytes",
        hash: Optional["bytes"] = None,
    ) -> None:
        self.payload = payload
        self.hash = hash


class SelfTest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 32
    FIELDS = {
        1: protobuf.Field("payload", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        payload: Optional["bytes"] = None,
    ) -> None:
        self.payload = payload


class CardanoBlockchainPointerType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("block_index", "uint32", repeated=False, required=True),
        2: protobuf.Field("tx_index", "uint32", repeated=False, required=True),
        3: protobuf.Field("certificate_index", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        block_index: "int",
        tx_index: "int",
        certificate_index: "int",
    ) -> None:
        self.block_index = block_index
        self.tx_index = tx_index
        self.certificate_index = certificate_index


class CardanoNativeScript(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("type", "CardanoNativeScriptType", repeated=False, required=True),
        2: protobuf.Field("scripts", "CardanoNativeScript", repeated=True, required=False, default=None),
        3: protobuf.Field("key_hash", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("key_path", "uint32", repeated=True, required=False, default=None),
        5: protobuf.Field("required_signatures_count", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("invalid_before", "uint64", repeated=False, required=False, default=None),
        7: protobuf.Field("invalid_hereafter", "uint64", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        type: "CardanoNativeScriptType",
        scripts: Optional[Sequence["CardanoNativeScript"]] = None,
        key_path: Optional[Sequence["int"]] = None,
        key_hash: Optional["bytes"] = None,
        required_signatures_count: Optional["int"] = None,
        invalid_before: Optional["int"] = None,
        invalid_hereafter: Optional["int"] = None,
    ) -> None:
        self.scripts: Sequence["CardanoNativeScript"] = scripts if scripts is not None else []
        self.key_path: Sequence["int"] = key_path if key_path is not None else []
        self.type = type
        self.key_hash = key_hash
        self.required_signatures_count = required_signatures_count
        self.invalid_before = invalid_before
        self.invalid_hereafter = invalid_hereafter


class CardanoGetNativeScriptHash(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 330
    FIELDS = {
        1: protobuf.Field("script", "CardanoNativeScript", repeated=False, required=True),
        2: protobuf.Field("display_format", "CardanoNativeScriptHashDisplayFormat", repeated=False, required=True),
        3: protobuf.Field("derivation_type", "CardanoDerivationType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        script: "CardanoNativeScript",
        display_format: "CardanoNativeScriptHashDisplayFormat",
        derivation_type: "CardanoDerivationType",
    ) -> None:
        self.script = script
        self.display_format = display_format
        self.derivation_type = derivation_type


class CardanoNativeScriptHash(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 331
    FIELDS = {
        1: protobuf.Field("script_hash", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        script_hash: "bytes",
    ) -> None:
        self.script_hash = script_hash


class CardanoAddressParametersType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address_type", "CardanoAddressType", repeated=False, required=True),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        3: protobuf.Field("address_n_staking", "uint32", repeated=True, required=False, default=None),
        4: protobuf.Field("staking_key_hash", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("certificate_pointer", "CardanoBlockchainPointerType", repeated=False, required=False, default=None),
        6: protobuf.Field("script_payment_hash", "bytes", repeated=False, required=False, default=None),
        7: protobuf.Field("script_staking_hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_type: "CardanoAddressType",
        address_n: Optional[Sequence["int"]] = None,
        address_n_staking: Optional[Sequence["int"]] = None,
        staking_key_hash: Optional["bytes"] = None,
        certificate_pointer: Optional["CardanoBlockchainPointerType"] = None,
        script_payment_hash: Optional["bytes"] = None,
        script_staking_hash: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.address_n_staking: Sequence["int"] = address_n_staking if address_n_staking is not None else []
        self.address_type = address_type
        self.staking_key_hash = staking_key_hash
        self.certificate_pointer = certificate_pointer
        self.script_payment_hash = script_payment_hash
        self.script_staking_hash = script_staking_hash


class CardanoGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 307
    FIELDS = {
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=False),
        3: protobuf.Field("protocol_magic", "uint32", repeated=False, required=True),
        4: protobuf.Field("network_id", "uint32", repeated=False, required=True),
        5: protobuf.Field("address_parameters", "CardanoAddressParametersType", repeated=False, required=True),
        6: protobuf.Field("derivation_type", "CardanoDerivationType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        protocol_magic: "int",
        network_id: "int",
        address_parameters: "CardanoAddressParametersType",
        derivation_type: "CardanoDerivationType",
        show_display: Optional["bool"] = False,
    ) -> None:
        self.protocol_magic = protocol_magic
        self.network_id = network_id
        self.address_parameters = address_parameters
        self.derivation_type = derivation_type
        self.show_display = show_display


class CardanoAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 308
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
    ) -> None:
        self.address = address


class CardanoGetPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 305
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
        3: protobuf.Field("derivation_type", "CardanoDerivationType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        derivation_type: "CardanoDerivationType",
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.derivation_type = derivation_type
        self.show_display = show_display


class CardanoPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 306
    FIELDS = {
        1: protobuf.Field("xpub", "string", repeated=False, required=True),
        2: protobuf.Field("node", "HDNodeType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        xpub: "str",
        node: "HDNodeType",
    ) -> None:
        self.xpub = xpub
        self.node = node


class CardanoSignTxInit(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 320
    FIELDS = {
        1: protobuf.Field("signing_mode", "CardanoTxSigningMode", repeated=False, required=True),
        2: protobuf.Field("protocol_magic", "uint32", repeated=False, required=True),
        3: protobuf.Field("network_id", "uint32", repeated=False, required=True),
        4: protobuf.Field("inputs_count", "uint32", repeated=False, required=True),
        5: protobuf.Field("outputs_count", "uint32", repeated=False, required=True),
        6: protobuf.Field("fee", "uint64", repeated=False, required=True),
        7: protobuf.Field("ttl", "uint64", repeated=False, required=False, default=None),
        8: protobuf.Field("certificates_count", "uint32", repeated=False, required=True),
        9: protobuf.Field("withdrawals_count", "uint32", repeated=False, required=True),
        10: protobuf.Field("has_auxiliary_data", "bool", repeated=False, required=True),
        11: protobuf.Field("validity_interval_start", "uint64", repeated=False, required=False, default=None),
        12: protobuf.Field("witness_requests_count", "uint32", repeated=False, required=True),
        13: protobuf.Field("minting_asset_groups_count", "uint32", repeated=False, required=True),
        14: protobuf.Field("derivation_type", "CardanoDerivationType", repeated=False, required=True),
        15: protobuf.Field("include_network_id", "bool", repeated=False, required=False, default=False),
        16: protobuf.Field("script_data_hash", "bytes", repeated=False, required=False, default=None),
        17: protobuf.Field("collateral_inputs_count", "uint32", repeated=False, required=True),
        18: protobuf.Field("required_signers_count", "uint32", repeated=False, required=True),
        19: protobuf.Field("has_collateral_return", "bool", repeated=False, required=False, default=False),
        20: protobuf.Field("total_collateral", "uint64", repeated=False, required=False, default=None),
        21: protobuf.Field("reference_inputs_count", "uint32", repeated=False, required=False, default=0),
    }

    def __init__(
        self,
        *,
        signing_mode: "CardanoTxSigningMode",
        protocol_magic: "int",
        network_id: "int",
        inputs_count: "int",
        outputs_count: "int",
        fee: "int",
        certificates_count: "int",
        withdrawals_count: "int",
        has_auxiliary_data: "bool",
        witness_requests_count: "int",
        minting_asset_groups_count: "int",
        derivation_type: "CardanoDerivationType",
        collateral_inputs_count: "int",
        required_signers_count: "int",
        ttl: Optional["int"] = None,
        validity_interval_start: Optional["int"] = None,
        include_network_id: Optional["bool"] = False,
        script_data_hash: Optional["bytes"] = None,
        has_collateral_return: Optional["bool"] = False,
        total_collateral: Optional["int"] = None,
        reference_inputs_count: Optional["int"] = 0,
    ) -> None:
        self.signing_mode = signing_mode
        self.protocol_magic = protocol_magic
        self.network_id = network_id
        self.inputs_count = inputs_count
        self.outputs_count = outputs_count
        self.fee = fee
        self.certificates_count = certificates_count
        self.withdrawals_count = withdrawals_count
        self.has_auxiliary_data = has_auxiliary_data
        self.witness_requests_count = witness_requests_count
        self.minting_asset_groups_count = minting_asset_groups_count
        self.derivation_type = derivation_type
        self.collateral_inputs_count = collateral_inputs_count
        self.required_signers_count = required_signers_count
        self.ttl = ttl
        self.validity_interval_start = validity_interval_start
        self.include_network_id = include_network_id
        self.script_data_hash = script_data_hash
        self.has_collateral_return = has_collateral_return
        self.total_collateral = total_collateral
        self.reference_inputs_count = reference_inputs_count


class CardanoTxInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 321
    FIELDS = {
        1: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        2: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
    ) -> None:
        self.prev_hash = prev_hash
        self.prev_index = prev_index


class CardanoTxOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 322
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("address_parameters", "CardanoAddressParametersType", repeated=False, required=False, default=None),
        3: protobuf.Field("amount", "uint64", repeated=False, required=True),
        4: protobuf.Field("asset_groups_count", "uint32", repeated=False, required=True),
        5: protobuf.Field("datum_hash", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("format", "CardanoTxOutputSerializationFormat", repeated=False, required=False, default=CardanoTxOutputSerializationFormat.ARRAY_LEGACY),
        7: protobuf.Field("inline_datum_size", "uint32", repeated=False, required=False, default=0),
        8: protobuf.Field("reference_script_size", "uint32", repeated=False, required=False, default=0),
    }

    def __init__(
        self,
        *,
        amount: "int",
        asset_groups_count: "int",
        address: Optional["str"] = None,
        address_parameters: Optional["CardanoAddressParametersType"] = None,
        datum_hash: Optional["bytes"] = None,
        format: Optional["CardanoTxOutputSerializationFormat"] = CardanoTxOutputSerializationFormat.ARRAY_LEGACY,
        inline_datum_size: Optional["int"] = 0,
        reference_script_size: Optional["int"] = 0,
    ) -> None:
        self.amount = amount
        self.asset_groups_count = asset_groups_count
        self.address = address
        self.address_parameters = address_parameters
        self.datum_hash = datum_hash
        self.format = format
        self.inline_datum_size = inline_datum_size
        self.reference_script_size = reference_script_size


class CardanoAssetGroup(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 323
    FIELDS = {
        1: protobuf.Field("policy_id", "bytes", repeated=False, required=True),
        2: protobuf.Field("tokens_count", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        policy_id: "bytes",
        tokens_count: "int",
    ) -> None:
        self.policy_id = policy_id
        self.tokens_count = tokens_count


class CardanoToken(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 324
    FIELDS = {
        1: protobuf.Field("asset_name_bytes", "bytes", repeated=False, required=True),
        2: protobuf.Field("amount", "uint64", repeated=False, required=False, default=None),
        3: protobuf.Field("mint_amount", "sint64", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        asset_name_bytes: "bytes",
        amount: Optional["int"] = None,
        mint_amount: Optional["int"] = None,
    ) -> None:
        self.asset_name_bytes = asset_name_bytes
        self.amount = amount
        self.mint_amount = mint_amount


class CardanoTxInlineDatumChunk(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 335
    FIELDS = {
        1: protobuf.Field("data", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        data: "bytes",
    ) -> None:
        self.data = data


class CardanoTxReferenceScriptChunk(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 336
    FIELDS = {
        1: protobuf.Field("data", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        data: "bytes",
    ) -> None:
        self.data = data


class CardanoPoolOwner(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 328
    FIELDS = {
        1: protobuf.Field("staking_key_path", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("staking_key_hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        staking_key_path: Optional[Sequence["int"]] = None,
        staking_key_hash: Optional["bytes"] = None,
    ) -> None:
        self.staking_key_path: Sequence["int"] = staking_key_path if staking_key_path is not None else []
        self.staking_key_hash = staking_key_hash


class CardanoPoolRelayParameters(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 329
    FIELDS = {
        1: protobuf.Field("type", "CardanoPoolRelayType", repeated=False, required=True),
        2: protobuf.Field("ipv4_address", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("ipv6_address", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("host_name", "string", repeated=False, required=False, default=None),
        5: protobuf.Field("port", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        type: "CardanoPoolRelayType",
        ipv4_address: Optional["bytes"] = None,
        ipv6_address: Optional["bytes"] = None,
        host_name: Optional["str"] = None,
        port: Optional["int"] = None,
    ) -> None:
        self.type = type
        self.ipv4_address = ipv4_address
        self.ipv6_address = ipv6_address
        self.host_name = host_name
        self.port = port


class CardanoPoolMetadataType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("url", "string", repeated=False, required=True),
        2: protobuf.Field("hash", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        url: "str",
        hash: "bytes",
    ) -> None:
        self.url = url
        self.hash = hash


class CardanoPoolParametersType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("pool_id", "bytes", repeated=False, required=True),
        2: protobuf.Field("vrf_key_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("pledge", "uint64", repeated=False, required=True),
        4: protobuf.Field("cost", "uint64", repeated=False, required=True),
        5: protobuf.Field("margin_numerator", "uint64", repeated=False, required=True),
        6: protobuf.Field("margin_denominator", "uint64", repeated=False, required=True),
        7: protobuf.Field("reward_account", "string", repeated=False, required=True),
        10: protobuf.Field("metadata", "CardanoPoolMetadataType", repeated=False, required=False, default=None),
        11: protobuf.Field("owners_count", "uint32", repeated=False, required=True),
        12: protobuf.Field("relays_count", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        pool_id: "bytes",
        vrf_key_hash: "bytes",
        pledge: "int",
        cost: "int",
        margin_numerator: "int",
        margin_denominator: "int",
        reward_account: "str",
        owners_count: "int",
        relays_count: "int",
        metadata: Optional["CardanoPoolMetadataType"] = None,
    ) -> None:
        self.pool_id = pool_id
        self.vrf_key_hash = vrf_key_hash
        self.pledge = pledge
        self.cost = cost
        self.margin_numerator = margin_numerator
        self.margin_denominator = margin_denominator
        self.reward_account = reward_account
        self.owners_count = owners_count
        self.relays_count = relays_count
        self.metadata = metadata


class CardanoTxCertificate(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 325
    FIELDS = {
        1: protobuf.Field("type", "CardanoCertificateType", repeated=False, required=True),
        2: protobuf.Field("path", "uint32", repeated=True, required=False, default=None),
        3: protobuf.Field("pool", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("pool_parameters", "CardanoPoolParametersType", repeated=False, required=False, default=None),
        5: protobuf.Field("script_hash", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("key_hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        type: "CardanoCertificateType",
        path: Optional[Sequence["int"]] = None,
        pool: Optional["bytes"] = None,
        pool_parameters: Optional["CardanoPoolParametersType"] = None,
        script_hash: Optional["bytes"] = None,
        key_hash: Optional["bytes"] = None,
    ) -> None:
        self.path: Sequence["int"] = path if path is not None else []
        self.type = type
        self.pool = pool
        self.pool_parameters = pool_parameters
        self.script_hash = script_hash
        self.key_hash = key_hash


class CardanoTxWithdrawal(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 326
    FIELDS = {
        1: protobuf.Field("path", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("amount", "uint64", repeated=False, required=True),
        3: protobuf.Field("script_hash", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("key_hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        amount: "int",
        path: Optional[Sequence["int"]] = None,
        script_hash: Optional["bytes"] = None,
        key_hash: Optional["bytes"] = None,
    ) -> None:
        self.path: Sequence["int"] = path if path is not None else []
        self.amount = amount
        self.script_hash = script_hash
        self.key_hash = key_hash


class CardanoGovernanceRegistrationDelegation(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("voting_public_key", "bytes", repeated=False, required=True),
        2: protobuf.Field("weight", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        voting_public_key: "bytes",
        weight: "int",
    ) -> None:
        self.voting_public_key = voting_public_key
        self.weight = weight


class CardanoGovernanceRegistrationParametersType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("voting_public_key", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("staking_path", "uint32", repeated=True, required=False, default=None),
        3: protobuf.Field("reward_address_parameters", "CardanoAddressParametersType", repeated=False, required=True),
        4: protobuf.Field("nonce", "uint64", repeated=False, required=True),
        5: protobuf.Field("format", "CardanoGovernanceRegistrationFormat", repeated=False, required=False, default=CardanoGovernanceRegistrationFormat.CIP15),
        6: protobuf.Field("delegations", "CardanoGovernanceRegistrationDelegation", repeated=True, required=False, default=None),
        7: protobuf.Field("voting_purpose", "uint64", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        reward_address_parameters: "CardanoAddressParametersType",
        nonce: "int",
        staking_path: Optional[Sequence["int"]] = None,
        delegations: Optional[Sequence["CardanoGovernanceRegistrationDelegation"]] = None,
        voting_public_key: Optional["bytes"] = None,
        format: Optional["CardanoGovernanceRegistrationFormat"] = CardanoGovernanceRegistrationFormat.CIP15,
        voting_purpose: Optional["int"] = None,
    ) -> None:
        self.staking_path: Sequence["int"] = staking_path if staking_path is not None else []
        self.delegations: Sequence["CardanoGovernanceRegistrationDelegation"] = delegations if delegations is not None else []
        self.reward_address_parameters = reward_address_parameters
        self.nonce = nonce
        self.voting_public_key = voting_public_key
        self.format = format
        self.voting_purpose = voting_purpose


class CardanoTxAuxiliaryData(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 327
    FIELDS = {
        1: protobuf.Field("governance_registration_parameters", "CardanoGovernanceRegistrationParametersType", repeated=False, required=False, default=None),
        2: protobuf.Field("hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        governance_registration_parameters: Optional["CardanoGovernanceRegistrationParametersType"] = None,
        hash: Optional["bytes"] = None,
    ) -> None:
        self.governance_registration_parameters = governance_registration_parameters
        self.hash = hash


class CardanoTxMint(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 332
    FIELDS = {
        1: protobuf.Field("asset_groups_count", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        asset_groups_count: "int",
    ) -> None:
        self.asset_groups_count = asset_groups_count


class CardanoTxCollateralInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 333
    FIELDS = {
        1: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        2: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
    ) -> None:
        self.prev_hash = prev_hash
        self.prev_index = prev_index


class CardanoTxRequiredSigner(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 334
    FIELDS = {
        1: protobuf.Field("key_hash", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("key_path", "uint32", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        key_path: Optional[Sequence["int"]] = None,
        key_hash: Optional["bytes"] = None,
    ) -> None:
        self.key_path: Sequence["int"] = key_path if key_path is not None else []
        self.key_hash = key_hash


class CardanoTxReferenceInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 337
    FIELDS = {
        1: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        2: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
    ) -> None:
        self.prev_hash = prev_hash
        self.prev_index = prev_index


class CardanoTxItemAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 313


class CardanoTxAuxiliaryDataSupplement(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 314
    FIELDS = {
        1: protobuf.Field("type", "CardanoTxAuxiliaryDataSupplementType", repeated=False, required=True),
        2: protobuf.Field("auxiliary_data_hash", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("governance_signature", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        type: "CardanoTxAuxiliaryDataSupplementType",
        auxiliary_data_hash: Optional["bytes"] = None,
        governance_signature: Optional["bytes"] = None,
    ) -> None:
        self.type = type
        self.auxiliary_data_hash = auxiliary_data_hash
        self.governance_signature = governance_signature


class CardanoTxWitnessRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 315
    FIELDS = {
        1: protobuf.Field("path", "uint32", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        path: Optional[Sequence["int"]] = None,
    ) -> None:
        self.path: Sequence["int"] = path if path is not None else []


class CardanoTxWitnessResponse(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 316
    FIELDS = {
        1: protobuf.Field("type", "CardanoTxWitnessType", repeated=False, required=True),
        2: protobuf.Field("pub_key", "bytes", repeated=False, required=True),
        3: protobuf.Field("signature", "bytes", repeated=False, required=True),
        4: protobuf.Field("chain_code", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        type: "CardanoTxWitnessType",
        pub_key: "bytes",
        signature: "bytes",
        chain_code: Optional["bytes"] = None,
    ) -> None:
        self.type = type
        self.pub_key = pub_key
        self.signature = signature
        self.chain_code = chain_code


class CardanoTxHostAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 317


class CardanoTxBodyHash(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 318
    FIELDS = {
        1: protobuf.Field("tx_hash", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx_hash: "bytes",
    ) -> None:
        self.tx_hash = tx_hash


class CardanoSignTxFinished(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 319


class CipherKeyValue(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 23
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("key", "string", repeated=False, required=True),
        3: protobuf.Field("value", "bytes", repeated=False, required=True),
        4: protobuf.Field("encrypt", "bool", repeated=False, required=False, default=None),
        5: protobuf.Field("ask_on_encrypt", "bool", repeated=False, required=False, default=None),
        6: protobuf.Field("ask_on_decrypt", "bool", repeated=False, required=False, default=None),
        7: protobuf.Field("iv", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        key: "str",
        value: "bytes",
        address_n: Optional[Sequence["int"]] = None,
        encrypt: Optional["bool"] = None,
        ask_on_encrypt: Optional["bool"] = None,
        ask_on_decrypt: Optional["bool"] = None,
        iv: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.key = key
        self.value = value
        self.encrypt = encrypt
        self.ask_on_encrypt = ask_on_encrypt
        self.ask_on_decrypt = ask_on_decrypt
        self.iv = iv


class CipheredKeyValue(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 48
    FIELDS = {
        1: protobuf.Field("value", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        value: "bytes",
    ) -> None:
        self.value = value


class IdentityType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("proto", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("user", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("host", "string", repeated=False, required=False, default=None),
        4: protobuf.Field("port", "string", repeated=False, required=False, default=None),
        5: protobuf.Field("path", "string", repeated=False, required=False, default=None),
        6: protobuf.Field("index", "uint32", repeated=False, required=False, default=0),
    }

    def __init__(
        self,
        *,
        proto: Optional["str"] = None,
        user: Optional["str"] = None,
        host: Optional["str"] = None,
        port: Optional["str"] = None,
        path: Optional["str"] = None,
        index: Optional["int"] = 0,
    ) -> None:
        self.proto = proto
        self.user = user
        self.host = host
        self.port = port
        self.path = path
        self.index = index


class SignIdentity(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 53
    FIELDS = {
        1: protobuf.Field("identity", "IdentityType", repeated=False, required=True),
        2: protobuf.Field("challenge_hidden", "bytes", repeated=False, required=False, default=b''),
        3: protobuf.Field("challenge_visual", "string", repeated=False, required=False, default=''),
        4: protobuf.Field("ecdsa_curve_name", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        identity: "IdentityType",
        challenge_hidden: Optional["bytes"] = b'',
        challenge_visual: Optional["str"] = '',
        ecdsa_curve_name: Optional["str"] = None,
    ) -> None:
        self.identity = identity
        self.challenge_hidden = challenge_hidden
        self.challenge_visual = challenge_visual
        self.ecdsa_curve_name = ecdsa_curve_name


class SignedIdentity(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 54
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("public_key", "bytes", repeated=False, required=True),
        3: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        public_key: "bytes",
        signature: "bytes",
        address: Optional["str"] = None,
    ) -> None:
        self.public_key = public_key
        self.signature = signature
        self.address = address


class GetECDHSessionKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 61
    FIELDS = {
        1: protobuf.Field("identity", "IdentityType", repeated=False, required=True),
        2: protobuf.Field("peer_public_key", "bytes", repeated=False, required=True),
        3: protobuf.Field("ecdsa_curve_name", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        identity: "IdentityType",
        peer_public_key: "bytes",
        ecdsa_curve_name: Optional["str"] = None,
    ) -> None:
        self.identity = identity
        self.peer_public_key = peer_public_key
        self.ecdsa_curve_name = ecdsa_curve_name


class ECDHSessionKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 62
    FIELDS = {
        1: protobuf.Field("session_key", "bytes", repeated=False, required=True),
        2: protobuf.Field("public_key", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        session_key: "bytes",
        public_key: Optional["bytes"] = None,
    ) -> None:
        self.session_key = session_key
        self.public_key = public_key


class CosiCommit(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 71
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("data", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        data: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.data = data


class CosiCommitment(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 72
    FIELDS = {
        1: protobuf.Field("commitment", "bytes", repeated=False, required=True),
        2: protobuf.Field("pubkey", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        commitment: "bytes",
        pubkey: "bytes",
    ) -> None:
        self.commitment = commitment
        self.pubkey = pubkey


class CosiSign(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 73
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("data", "bytes", repeated=False, required=True),
        3: protobuf.Field("global_commitment", "bytes", repeated=False, required=True),
        4: protobuf.Field("global_pubkey", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        data: "bytes",
        global_commitment: "bytes",
        global_pubkey: "bytes",
        address_n: Optional[Sequence["int"]] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.data = data
        self.global_commitment = global_commitment
        self.global_pubkey = global_pubkey


class CosiSignature(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 74
    FIELDS = {
        1: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "bytes",
    ) -> None:
        self.signature = signature


class Initialize(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 0
    FIELDS = {
        1: protobuf.Field("session_id", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("_skip_passphrase", "bool", repeated=False, required=False, default=None),
        3: protobuf.Field("derive_cardano", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        session_id: Optional["bytes"] = None,
        _skip_passphrase: Optional["bool"] = None,
        derive_cardano: Optional["bool"] = None,
    ) -> None:
        self.session_id = session_id
        self._skip_passphrase = _skip_passphrase
        self.derive_cardano = derive_cardano


class GetFeatures(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 55


class Features(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 17
    FIELDS = {
        1: protobuf.Field("vendor", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("major_version", "uint32", repeated=False, required=True),
        3: protobuf.Field("minor_version", "uint32", repeated=False, required=True),
        4: protobuf.Field("patch_version", "uint32", repeated=False, required=True),
        5: protobuf.Field("bootloader_mode", "bool", repeated=False, required=False, default=None),
        6: protobuf.Field("device_id", "string", repeated=False, required=False, default=None),
        7: protobuf.Field("pin_protection", "bool", repeated=False, required=False, default=None),
        8: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False, default=None),
        9: protobuf.Field("language", "string", repeated=False, required=False, default=None),
        10: protobuf.Field("label", "string", repeated=False, required=False, default=None),
        12: protobuf.Field("initialized", "bool", repeated=False, required=False, default=None),
        13: protobuf.Field("revision", "bytes", repeated=False, required=False, default=None),
        14: protobuf.Field("bootloader_hash", "bytes", repeated=False, required=False, default=None),
        15: protobuf.Field("imported", "bool", repeated=False, required=False, default=None),
        16: protobuf.Field("unlocked", "bool", repeated=False, required=False, default=None),
        17: protobuf.Field("_passphrase_cached", "bool", repeated=False, required=False, default=None),
        18: protobuf.Field("firmware_present", "bool", repeated=False, required=False, default=None),
        19: protobuf.Field("needs_backup", "bool", repeated=False, required=False, default=None),
        20: protobuf.Field("flags", "uint32", repeated=False, required=False, default=None),
        21: protobuf.Field("model", "string", repeated=False, required=False, default=None),
        22: protobuf.Field("fw_major", "uint32", repeated=False, required=False, default=None),
        23: protobuf.Field("fw_minor", "uint32", repeated=False, required=False, default=None),
        24: protobuf.Field("fw_patch", "uint32", repeated=False, required=False, default=None),
        25: protobuf.Field("fw_vendor", "string", repeated=False, required=False, default=None),
        27: protobuf.Field("unfinished_backup", "bool", repeated=False, required=False, default=None),
        28: protobuf.Field("no_backup", "bool", repeated=False, required=False, default=None),
        29: protobuf.Field("recovery_mode", "bool", repeated=False, required=False, default=None),
        30: protobuf.Field("capabilities", "Capability", repeated=True, required=False, default=None),
        31: protobuf.Field("backup_type", "BackupType", repeated=False, required=False, default=None),
        32: protobuf.Field("sd_card_present", "bool", repeated=False, required=False, default=None),
        33: protobuf.Field("sd_protection", "bool", repeated=False, required=False, default=None),
        34: protobuf.Field("wipe_code_protection", "bool", repeated=False, required=False, default=None),
        35: protobuf.Field("session_id", "bytes", repeated=False, required=False, default=None),
        36: protobuf.Field("passphrase_always_on_device", "bool", repeated=False, required=False, default=None),
        37: protobuf.Field("safety_checks", "SafetyCheckLevel", repeated=False, required=False, default=None),
        38: protobuf.Field("auto_lock_delay_ms", "uint32", repeated=False, required=False, default=None),
        39: protobuf.Field("display_rotation", "uint32", repeated=False, required=False, default=None),
        40: protobuf.Field("experimental_features", "bool", repeated=False, required=False, default=None),
        41: protobuf.Field("busy", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        major_version: "int",
        minor_version: "int",
        patch_version: "int",
        capabilities: Optional[Sequence["Capability"]] = None,
        vendor: Optional["str"] = None,
        bootloader_mode: Optional["bool"] = None,
        device_id: Optional["str"] = None,
        pin_protection: Optional["bool"] = None,
        passphrase_protection: Optional["bool"] = None,
        language: Optional["str"] = None,
        label: Optional["str"] = None,
        initialized: Optional["bool"] = None,
        revision: Optional["bytes"] = None,
        bootloader_hash: Optional["bytes"] = None,
        imported: Optional["bool"] = None,
        unlocked: Optional["bool"] = None,
        _passphrase_cached: Optional["bool"] = None,
        firmware_present: Optional["bool"] = None,
        needs_backup: Optional["bool"] = None,
        flags: Optional["int"] = None,
        model: Optional["str"] = None,
        fw_major: Optional["int"] = None,
        fw_minor: Optional["int"] = None,
        fw_patch: Optional["int"] = None,
        fw_vendor: Optional["str"] = None,
        unfinished_backup: Optional["bool"] = None,
        no_backup: Optional["bool"] = None,
        recovery_mode: Optional["bool"] = None,
        backup_type: Optional["BackupType"] = None,
        sd_card_present: Optional["bool"] = None,
        sd_protection: Optional["bool"] = None,
        wipe_code_protection: Optional["bool"] = None,
        session_id: Optional["bytes"] = None,
        passphrase_always_on_device: Optional["bool"] = None,
        safety_checks: Optional["SafetyCheckLevel"] = None,
        auto_lock_delay_ms: Optional["int"] = None,
        display_rotation: Optional["int"] = None,
        experimental_features: Optional["bool"] = None,
        busy: Optional["bool"] = None,
    ) -> None:
        self.capabilities: Sequence["Capability"] = capabilities if capabilities is not None else []
        self.major_version = major_version
        self.minor_version = minor_version
        self.patch_version = patch_version
        self.vendor = vendor
        self.bootloader_mode = bootloader_mode
        self.device_id = device_id
        self.pin_protection = pin_protection
        self.passphrase_protection = passphrase_protection
        self.language = language
        self.label = label
        self.initialized = initialized
        self.revision = revision
        self.bootloader_hash = bootloader_hash
        self.imported = imported
        self.unlocked = unlocked
        self._passphrase_cached = _passphrase_cached
        self.firmware_present = firmware_present
        self.needs_backup = needs_backup
        self.flags = flags
        self.model = model
        self.fw_major = fw_major
        self.fw_minor = fw_minor
        self.fw_patch = fw_patch
        self.fw_vendor = fw_vendor
        self.unfinished_backup = unfinished_backup
        self.no_backup = no_backup
        self.recovery_mode = recovery_mode
        self.backup_type = backup_type
        self.sd_card_present = sd_card_present
        self.sd_protection = sd_protection
        self.wipe_code_protection = wipe_code_protection
        self.session_id = session_id
        self.passphrase_always_on_device = passphrase_always_on_device
        self.safety_checks = safety_checks
        self.auto_lock_delay_ms = auto_lock_delay_ms
        self.display_rotation = display_rotation
        self.experimental_features = experimental_features
        self.busy = busy


class LockDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 24


class SetBusy(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 16
    FIELDS = {
        1: protobuf.Field("expiry_ms", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        expiry_ms: Optional["int"] = None,
    ) -> None:
        self.expiry_ms = expiry_ms


class EndSession(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 83


class ApplySettings(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 25
    FIELDS = {
        1: protobuf.Field("language", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("label", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("use_passphrase", "bool", repeated=False, required=False, default=None),
        4: protobuf.Field("homescreen", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("_passphrase_source", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("auto_lock_delay_ms", "uint32", repeated=False, required=False, default=None),
        7: protobuf.Field("display_rotation", "uint32", repeated=False, required=False, default=None),
        8: protobuf.Field("passphrase_always_on_device", "bool", repeated=False, required=False, default=None),
        9: protobuf.Field("safety_checks", "SafetyCheckLevel", repeated=False, required=False, default=None),
        10: protobuf.Field("experimental_features", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        language: Optional["str"] = None,
        label: Optional["str"] = None,
        use_passphrase: Optional["bool"] = None,
        homescreen: Optional["bytes"] = None,
        _passphrase_source: Optional["int"] = None,
        auto_lock_delay_ms: Optional["int"] = None,
        display_rotation: Optional["int"] = None,
        passphrase_always_on_device: Optional["bool"] = None,
        safety_checks: Optional["SafetyCheckLevel"] = None,
        experimental_features: Optional["bool"] = None,
    ) -> None:
        self.language = language
        self.label = label
        self.use_passphrase = use_passphrase
        self.homescreen = homescreen
        self._passphrase_source = _passphrase_source
        self.auto_lock_delay_ms = auto_lock_delay_ms
        self.display_rotation = display_rotation
        self.passphrase_always_on_device = passphrase_always_on_device
        self.safety_checks = safety_checks
        self.experimental_features = experimental_features


class ApplyFlags(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 28
    FIELDS = {
        1: protobuf.Field("flags", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        flags: "int",
    ) -> None:
        self.flags = flags


class ChangePin(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 4
    FIELDS = {
        1: protobuf.Field("remove", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        remove: Optional["bool"] = None,
    ) -> None:
        self.remove = remove


class ChangeWipeCode(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 82
    FIELDS = {
        1: protobuf.Field("remove", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        remove: Optional["bool"] = None,
    ) -> None:
        self.remove = remove


class SdProtect(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 79
    FIELDS = {
        1: protobuf.Field("operation", "SdProtectOperationType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        operation: "SdProtectOperationType",
    ) -> None:
        self.operation = operation


class Ping(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 1
    FIELDS = {
        1: protobuf.Field("message", "string", repeated=False, required=False, default=''),
        2: protobuf.Field("button_protection", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        message: Optional["str"] = '',
        button_protection: Optional["bool"] = None,
    ) -> None:
        self.message = message
        self.button_protection = button_protection


class Cancel(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 20


class GetEntropy(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9
    FIELDS = {
        1: protobuf.Field("size", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        size: "int",
    ) -> None:
        self.size = size


class Entropy(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 10
    FIELDS = {
        1: protobuf.Field("entropy", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        entropy: "bytes",
    ) -> None:
        self.entropy = entropy


class GetFirmwareHash(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 88
    FIELDS = {
        1: protobuf.Field("challenge", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        challenge: Optional["bytes"] = None,
    ) -> None:
        self.challenge = challenge


class FirmwareHash(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 89
    FIELDS = {
        1: protobuf.Field("hash", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        hash: "bytes",
    ) -> None:
        self.hash = hash


class WipeDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 5


class LoadDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 13
    FIELDS = {
        1: protobuf.Field("mnemonics", "string", repeated=True, required=False, default=None),
        3: protobuf.Field("pin", "string", repeated=False, required=False, default=None),
        4: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False, default=None),
        5: protobuf.Field("language", "string", repeated=False, required=False, default='en-US'),
        6: protobuf.Field("label", "string", repeated=False, required=False, default=None),
        7: protobuf.Field("skip_checksum", "bool", repeated=False, required=False, default=None),
        8: protobuf.Field("u2f_counter", "uint32", repeated=False, required=False, default=None),
        9: protobuf.Field("needs_backup", "bool", repeated=False, required=False, default=None),
        10: protobuf.Field("no_backup", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        mnemonics: Optional[Sequence["str"]] = None,
        pin: Optional["str"] = None,
        passphrase_protection: Optional["bool"] = None,
        language: Optional["str"] = 'en-US',
        label: Optional["str"] = None,
        skip_checksum: Optional["bool"] = None,
        u2f_counter: Optional["int"] = None,
        needs_backup: Optional["bool"] = None,
        no_backup: Optional["bool"] = None,
    ) -> None:
        self.mnemonics: Sequence["str"] = mnemonics if mnemonics is not None else []
        self.pin = pin
        self.passphrase_protection = passphrase_protection
        self.language = language
        self.label = label
        self.skip_checksum = skip_checksum
        self.u2f_counter = u2f_counter
        self.needs_backup = needs_backup
        self.no_backup = no_backup


class ResetDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 14
    FIELDS = {
        1: protobuf.Field("display_random", "bool", repeated=False, required=False, default=None),
        2: protobuf.Field("strength", "uint32", repeated=False, required=False, default=256),
        3: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False, default=None),
        4: protobuf.Field("pin_protection", "bool", repeated=False, required=False, default=None),
        5: protobuf.Field("language", "string", repeated=False, required=False, default='en-US'),
        6: protobuf.Field("label", "string", repeated=False, required=False, default=None),
        7: protobuf.Field("u2f_counter", "uint32", repeated=False, required=False, default=None),
        8: protobuf.Field("skip_backup", "bool", repeated=False, required=False, default=None),
        9: protobuf.Field("no_backup", "bool", repeated=False, required=False, default=None),
        10: protobuf.Field("backup_type", "BackupType", repeated=False, required=False, default=BackupType.Bip39),
    }

    def __init__(
        self,
        *,
        display_random: Optional["bool"] = None,
        strength: Optional["int"] = 256,
        passphrase_protection: Optional["bool"] = None,
        pin_protection: Optional["bool"] = None,
        language: Optional["str"] = 'en-US',
        label: Optional["str"] = None,
        u2f_counter: Optional["int"] = None,
        skip_backup: Optional["bool"] = None,
        no_backup: Optional["bool"] = None,
        backup_type: Optional["BackupType"] = BackupType.Bip39,
    ) -> None:
        self.display_random = display_random
        self.strength = strength
        self.passphrase_protection = passphrase_protection
        self.pin_protection = pin_protection
        self.language = language
        self.label = label
        self.u2f_counter = u2f_counter
        self.skip_backup = skip_backup
        self.no_backup = no_backup
        self.backup_type = backup_type


class BackupDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 34


class EntropyRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 35


class EntropyAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 36
    FIELDS = {
        1: protobuf.Field("entropy", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        entropy: "bytes",
    ) -> None:
        self.entropy = entropy


class RecoveryDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 45
    FIELDS = {
        1: protobuf.Field("word_count", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False, default=None),
        3: protobuf.Field("pin_protection", "bool", repeated=False, required=False, default=None),
        4: protobuf.Field("language", "string", repeated=False, required=False, default=None),
        5: protobuf.Field("label", "string", repeated=False, required=False, default=None),
        6: protobuf.Field("enforce_wordlist", "bool", repeated=False, required=False, default=None),
        8: protobuf.Field("type", "RecoveryDeviceType", repeated=False, required=False, default=None),
        9: protobuf.Field("u2f_counter", "uint32", repeated=False, required=False, default=None),
        10: protobuf.Field("dry_run", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        word_count: Optional["int"] = None,
        passphrase_protection: Optional["bool"] = None,
        pin_protection: Optional["bool"] = None,
        language: Optional["str"] = None,
        label: Optional["str"] = None,
        enforce_wordlist: Optional["bool"] = None,
        type: Optional["RecoveryDeviceType"] = None,
        u2f_counter: Optional["int"] = None,
        dry_run: Optional["bool"] = None,
    ) -> None:
        self.word_count = word_count
        self.passphrase_protection = passphrase_protection
        self.pin_protection = pin_protection
        self.language = language
        self.label = label
        self.enforce_wordlist = enforce_wordlist
        self.type = type
        self.u2f_counter = u2f_counter
        self.dry_run = dry_run


class WordRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 46
    FIELDS = {
        1: protobuf.Field("type", "WordRequestType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        type: "WordRequestType",
    ) -> None:
        self.type = type


class WordAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 47
    FIELDS = {
        1: protobuf.Field("word", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        word: "str",
    ) -> None:
        self.word = word


class SetU2FCounter(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 63
    FIELDS = {
        1: protobuf.Field("u2f_counter", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        u2f_counter: "int",
    ) -> None:
        self.u2f_counter = u2f_counter


class GetNextU2FCounter(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 80


class NextU2FCounter(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 81
    FIELDS = {
        1: protobuf.Field("u2f_counter", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        u2f_counter: "int",
    ) -> None:
        self.u2f_counter = u2f_counter


class DoPreauthorized(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 84


class PreauthorizedRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 85


class CancelAuthorization(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 86


class RebootToBootloader(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 87


class GetNonce(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 31


class Nonce(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 33
    FIELDS = {
        1: protobuf.Field("nonce", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        nonce: "bytes",
    ) -> None:
        self.nonce = nonce


class UnlockPath(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 93
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("mac", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        mac: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.mac = mac


class UnlockedPathRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 94
    FIELDS = {
        1: protobuf.Field("mac", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        mac: Optional["bytes"] = None,
    ) -> None:
        self.mac = mac


class DebugLinkDecision(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 100
    FIELDS = {
        1: protobuf.Field("button", "DebugButton", repeated=False, required=False, default=None),
        2: protobuf.Field("swipe", "DebugSwipeDirection", repeated=False, required=False, default=None),
        3: protobuf.Field("input", "string", repeated=False, required=False, default=None),
        4: protobuf.Field("x", "uint32", repeated=False, required=False, default=None),
        5: protobuf.Field("y", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("wait", "bool", repeated=False, required=False, default=None),
        7: protobuf.Field("hold_ms", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        button: Optional["DebugButton"] = None,
        swipe: Optional["DebugSwipeDirection"] = None,
        input: Optional["str"] = None,
        x: Optional["int"] = None,
        y: Optional["int"] = None,
        wait: Optional["bool"] = None,
        hold_ms: Optional["int"] = None,
    ) -> None:
        self.button = button
        self.swipe = swipe
        self.input = input
        self.x = x
        self.y = y
        self.wait = wait
        self.hold_ms = hold_ms


class DebugLinkLayout(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9001
    FIELDS = {
        1: protobuf.Field("lines", "string", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        lines: Optional[Sequence["str"]] = None,
    ) -> None:
        self.lines: Sequence["str"] = lines if lines is not None else []


class DebugLinkReseedRandom(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9002
    FIELDS = {
        1: protobuf.Field("value", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        value: Optional["int"] = None,
    ) -> None:
        self.value = value


class DebugLinkRecordScreen(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9003
    FIELDS = {
        1: protobuf.Field("target_directory", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        target_directory: Optional["str"] = None,
    ) -> None:
        self.target_directory = target_directory


class DebugLinkGetState(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 101
    FIELDS = {
        1: protobuf.Field("wait_word_list", "bool", repeated=False, required=False, default=None),
        2: protobuf.Field("wait_word_pos", "bool", repeated=False, required=False, default=None),
        3: protobuf.Field("wait_layout", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        wait_word_list: Optional["bool"] = None,
        wait_word_pos: Optional["bool"] = None,
        wait_layout: Optional["bool"] = None,
    ) -> None:
        self.wait_word_list = wait_word_list
        self.wait_word_pos = wait_word_pos
        self.wait_layout = wait_layout


class DebugLinkState(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 102
    FIELDS = {
        1: protobuf.Field("layout", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("pin", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("matrix", "string", repeated=False, required=False, default=None),
        4: protobuf.Field("mnemonic_secret", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("node", "HDNodeType", repeated=False, required=False, default=None),
        6: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False, default=None),
        7: protobuf.Field("reset_word", "string", repeated=False, required=False, default=None),
        8: protobuf.Field("reset_entropy", "bytes", repeated=False, required=False, default=None),
        9: protobuf.Field("recovery_fake_word", "string", repeated=False, required=False, default=None),
        10: protobuf.Field("recovery_word_pos", "uint32", repeated=False, required=False, default=None),
        11: protobuf.Field("reset_word_pos", "uint32", repeated=False, required=False, default=None),
        12: protobuf.Field("mnemonic_type", "BackupType", repeated=False, required=False, default=None),
        13: protobuf.Field("layout_lines", "string", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        layout_lines: Optional[Sequence["str"]] = None,
        layout: Optional["bytes"] = None,
        pin: Optional["str"] = None,
        matrix: Optional["str"] = None,
        mnemonic_secret: Optional["bytes"] = None,
        node: Optional["HDNodeType"] = None,
        passphrase_protection: Optional["bool"] = None,
        reset_word: Optional["str"] = None,
        reset_entropy: Optional["bytes"] = None,
        recovery_fake_word: Optional["str"] = None,
        recovery_word_pos: Optional["int"] = None,
        reset_word_pos: Optional["int"] = None,
        mnemonic_type: Optional["BackupType"] = None,
    ) -> None:
        self.layout_lines: Sequence["str"] = layout_lines if layout_lines is not None else []
        self.layout = layout
        self.pin = pin
        self.matrix = matrix
        self.mnemonic_secret = mnemonic_secret
        self.node = node
        self.passphrase_protection = passphrase_protection
        self.reset_word = reset_word
        self.reset_entropy = reset_entropy
        self.recovery_fake_word = recovery_fake_word
        self.recovery_word_pos = recovery_word_pos
        self.reset_word_pos = reset_word_pos
        self.mnemonic_type = mnemonic_type


class DebugLinkStop(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 103


class DebugLinkLog(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 104
    FIELDS = {
        1: protobuf.Field("level", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("bucket", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("text", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        level: Optional["int"] = None,
        bucket: Optional["str"] = None,
        text: Optional["str"] = None,
    ) -> None:
        self.level = level
        self.bucket = bucket
        self.text = text


class DebugLinkMemoryRead(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 110
    FIELDS = {
        1: protobuf.Field("address", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("length", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address: Optional["int"] = None,
        length: Optional["int"] = None,
    ) -> None:
        self.address = address
        self.length = length


class DebugLinkMemory(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 111
    FIELDS = {
        1: protobuf.Field("memory", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        memory: Optional["bytes"] = None,
    ) -> None:
        self.memory = memory


class DebugLinkMemoryWrite(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 112
    FIELDS = {
        1: protobuf.Field("address", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("memory", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("flash", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address: Optional["int"] = None,
        memory: Optional["bytes"] = None,
        flash: Optional["bool"] = None,
    ) -> None:
        self.address = address
        self.memory = memory
        self.flash = flash


class DebugLinkFlashErase(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 113
    FIELDS = {
        1: protobuf.Field("sector", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        sector: Optional["int"] = None,
    ) -> None:
        self.sector = sector


class DebugLinkEraseSdCard(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9005
    FIELDS = {
        1: protobuf.Field("format", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        format: Optional["bool"] = None,
    ) -> None:
        self.format = format


class DebugLinkWatchLayout(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9006
    FIELDS = {
        1: protobuf.Field("watch", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        watch: Optional["bool"] = None,
    ) -> None:
        self.watch = watch


class EosGetPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 600
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class EosPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 601
    FIELDS = {
        1: protobuf.Field("wif_public_key", "string", repeated=False, required=True),
        2: protobuf.Field("raw_public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        wif_public_key: "str",
        raw_public_key: "bytes",
    ) -> None:
        self.wif_public_key = wif_public_key
        self.raw_public_key = raw_public_key


class EosSignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 602
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("chain_id", "bytes", repeated=False, required=True),
        3: protobuf.Field("header", "EosTxHeader", repeated=False, required=True),
        4: protobuf.Field("num_actions", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        chain_id: "bytes",
        header: "EosTxHeader",
        num_actions: "int",
        address_n: Optional[Sequence["int"]] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.chain_id = chain_id
        self.header = header
        self.num_actions = num_actions


class EosTxActionRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 603
    FIELDS = {
        1: protobuf.Field("data_size", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        data_size: Optional["int"] = None,
    ) -> None:
        self.data_size = data_size


class EosTxActionAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 604
    FIELDS = {
        1: protobuf.Field("common", "EosActionCommon", repeated=False, required=True),
        2: protobuf.Field("transfer", "EosActionTransfer", repeated=False, required=False, default=None),
        3: protobuf.Field("delegate", "EosActionDelegate", repeated=False, required=False, default=None),
        4: protobuf.Field("undelegate", "EosActionUndelegate", repeated=False, required=False, default=None),
        5: protobuf.Field("refund", "EosActionRefund", repeated=False, required=False, default=None),
        6: protobuf.Field("buy_ram", "EosActionBuyRam", repeated=False, required=False, default=None),
        7: protobuf.Field("buy_ram_bytes", "EosActionBuyRamBytes", repeated=False, required=False, default=None),
        8: protobuf.Field("sell_ram", "EosActionSellRam", repeated=False, required=False, default=None),
        9: protobuf.Field("vote_producer", "EosActionVoteProducer", repeated=False, required=False, default=None),
        10: protobuf.Field("update_auth", "EosActionUpdateAuth", repeated=False, required=False, default=None),
        11: protobuf.Field("delete_auth", "EosActionDeleteAuth", repeated=False, required=False, default=None),
        12: protobuf.Field("link_auth", "EosActionLinkAuth", repeated=False, required=False, default=None),
        13: protobuf.Field("unlink_auth", "EosActionUnlinkAuth", repeated=False, required=False, default=None),
        14: protobuf.Field("new_account", "EosActionNewAccount", repeated=False, required=False, default=None),
        15: protobuf.Field("unknown", "EosActionUnknown", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        common: "EosActionCommon",
        transfer: Optional["EosActionTransfer"] = None,
        delegate: Optional["EosActionDelegate"] = None,
        undelegate: Optional["EosActionUndelegate"] = None,
        refund: Optional["EosActionRefund"] = None,
        buy_ram: Optional["EosActionBuyRam"] = None,
        buy_ram_bytes: Optional["EosActionBuyRamBytes"] = None,
        sell_ram: Optional["EosActionSellRam"] = None,
        vote_producer: Optional["EosActionVoteProducer"] = None,
        update_auth: Optional["EosActionUpdateAuth"] = None,
        delete_auth: Optional["EosActionDeleteAuth"] = None,
        link_auth: Optional["EosActionLinkAuth"] = None,
        unlink_auth: Optional["EosActionUnlinkAuth"] = None,
        new_account: Optional["EosActionNewAccount"] = None,
        unknown: Optional["EosActionUnknown"] = None,
    ) -> None:
        self.common = common
        self.transfer = transfer
        self.delegate = delegate
        self.undelegate = undelegate
        self.refund = refund
        self.buy_ram = buy_ram
        self.buy_ram_bytes = buy_ram_bytes
        self.sell_ram = sell_ram
        self.vote_producer = vote_producer
        self.update_auth = update_auth
        self.delete_auth = delete_auth
        self.link_auth = link_auth
        self.unlink_auth = unlink_auth
        self.new_account = new_account
        self.unknown = unknown


class EosSignedTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 605
    FIELDS = {
        1: protobuf.Field("signature", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "str",
    ) -> None:
        self.signature = signature


class EosTxHeader(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("expiration", "uint32", repeated=False, required=True),
        2: protobuf.Field("ref_block_num", "uint32", repeated=False, required=True),
        3: protobuf.Field("ref_block_prefix", "uint32", repeated=False, required=True),
        4: protobuf.Field("max_net_usage_words", "uint32", repeated=False, required=True),
        5: protobuf.Field("max_cpu_usage_ms", "uint32", repeated=False, required=True),
        6: protobuf.Field("delay_sec", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        expiration: "int",
        ref_block_num: "int",
        ref_block_prefix: "int",
        max_net_usage_words: "int",
        max_cpu_usage_ms: "int",
        delay_sec: "int",
    ) -> None:
        self.expiration = expiration
        self.ref_block_num = ref_block_num
        self.ref_block_prefix = ref_block_prefix
        self.max_net_usage_words = max_net_usage_words
        self.max_cpu_usage_ms = max_cpu_usage_ms
        self.delay_sec = delay_sec


class EosAsset(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "sint64", repeated=False, required=True),
        2: protobuf.Field("symbol", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        amount: "int",
        symbol: "int",
    ) -> None:
        self.amount = amount
        self.symbol = symbol


class EosPermissionLevel(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("actor", "uint64", repeated=False, required=True),
        2: protobuf.Field("permission", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        actor: "int",
        permission: "int",
    ) -> None:
        self.actor = actor
        self.permission = permission


class EosAuthorizationKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("type", "uint32", repeated=False, required=True),
        2: protobuf.Field("key", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        4: protobuf.Field("weight", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        type: "int",
        weight: "int",
        address_n: Optional[Sequence["int"]] = None,
        key: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.type = type
        self.weight = weight
        self.key = key


class EosAuthorizationAccount(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "EosPermissionLevel", repeated=False, required=True),
        2: protobuf.Field("weight", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        account: "EosPermissionLevel",
        weight: "int",
    ) -> None:
        self.account = account
        self.weight = weight


class EosAuthorizationWait(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("wait_sec", "uint32", repeated=False, required=True),
        2: protobuf.Field("weight", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        wait_sec: "int",
        weight: "int",
    ) -> None:
        self.wait_sec = wait_sec
        self.weight = weight


class EosAuthorization(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("threshold", "uint32", repeated=False, required=True),
        2: protobuf.Field("keys", "EosAuthorizationKey", repeated=True, required=False, default=None),
        3: protobuf.Field("accounts", "EosAuthorizationAccount", repeated=True, required=False, default=None),
        4: protobuf.Field("waits", "EosAuthorizationWait", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        threshold: "int",
        keys: Optional[Sequence["EosAuthorizationKey"]] = None,
        accounts: Optional[Sequence["EosAuthorizationAccount"]] = None,
        waits: Optional[Sequence["EosAuthorizationWait"]] = None,
    ) -> None:
        self.keys: Sequence["EosAuthorizationKey"] = keys if keys is not None else []
        self.accounts: Sequence["EosAuthorizationAccount"] = accounts if accounts is not None else []
        self.waits: Sequence["EosAuthorizationWait"] = waits if waits is not None else []
        self.threshold = threshold


class EosActionCommon(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "uint64", repeated=False, required=True),
        2: protobuf.Field("name", "uint64", repeated=False, required=True),
        3: protobuf.Field("authorization", "EosPermissionLevel", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        account: "int",
        name: "int",
        authorization: Optional[Sequence["EosPermissionLevel"]] = None,
    ) -> None:
        self.authorization: Sequence["EosPermissionLevel"] = authorization if authorization is not None else []
        self.account = account
        self.name = name


class EosActionTransfer(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("sender", "uint64", repeated=False, required=True),
        2: protobuf.Field("receiver", "uint64", repeated=False, required=True),
        3: protobuf.Field("quantity", "EosAsset", repeated=False, required=True),
        4: protobuf.Field("memo", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        sender: "int",
        receiver: "int",
        quantity: "EosAsset",
        memo: "str",
    ) -> None:
        self.sender = sender
        self.receiver = receiver
        self.quantity = quantity
        self.memo = memo


class EosActionDelegate(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("sender", "uint64", repeated=False, required=True),
        2: protobuf.Field("receiver", "uint64", repeated=False, required=True),
        3: protobuf.Field("net_quantity", "EosAsset", repeated=False, required=True),
        4: protobuf.Field("cpu_quantity", "EosAsset", repeated=False, required=True),
        5: protobuf.Field("transfer", "bool", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        sender: "int",
        receiver: "int",
        net_quantity: "EosAsset",
        cpu_quantity: "EosAsset",
        transfer: "bool",
    ) -> None:
        self.sender = sender
        self.receiver = receiver
        self.net_quantity = net_quantity
        self.cpu_quantity = cpu_quantity
        self.transfer = transfer


class EosActionUndelegate(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("sender", "uint64", repeated=False, required=True),
        2: protobuf.Field("receiver", "uint64", repeated=False, required=True),
        3: protobuf.Field("net_quantity", "EosAsset", repeated=False, required=True),
        4: protobuf.Field("cpu_quantity", "EosAsset", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        sender: "int",
        receiver: "int",
        net_quantity: "EosAsset",
        cpu_quantity: "EosAsset",
    ) -> None:
        self.sender = sender
        self.receiver = receiver
        self.net_quantity = net_quantity
        self.cpu_quantity = cpu_quantity


class EosActionRefund(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("owner", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        owner: "int",
    ) -> None:
        self.owner = owner


class EosActionBuyRam(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("payer", "uint64", repeated=False, required=True),
        2: protobuf.Field("receiver", "uint64", repeated=False, required=True),
        3: protobuf.Field("quantity", "EosAsset", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        payer: "int",
        receiver: "int",
        quantity: "EosAsset",
    ) -> None:
        self.payer = payer
        self.receiver = receiver
        self.quantity = quantity


class EosActionBuyRamBytes(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("payer", "uint64", repeated=False, required=True),
        2: protobuf.Field("receiver", "uint64", repeated=False, required=True),
        3: protobuf.Field("bytes", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        payer: "int",
        receiver: "int",
        bytes: "int",
    ) -> None:
        self.payer = payer
        self.receiver = receiver
        self.bytes = bytes


class EosActionSellRam(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "uint64", repeated=False, required=True),
        2: protobuf.Field("bytes", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        account: "int",
        bytes: "int",
    ) -> None:
        self.account = account
        self.bytes = bytes


class EosActionVoteProducer(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("voter", "uint64", repeated=False, required=True),
        2: protobuf.Field("proxy", "uint64", repeated=False, required=True),
        3: protobuf.Field("producers", "uint64", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        voter: "int",
        proxy: "int",
        producers: Optional[Sequence["int"]] = None,
    ) -> None:
        self.producers: Sequence["int"] = producers if producers is not None else []
        self.voter = voter
        self.proxy = proxy


class EosActionUpdateAuth(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "uint64", repeated=False, required=True),
        2: protobuf.Field("permission", "uint64", repeated=False, required=True),
        3: protobuf.Field("parent", "uint64", repeated=False, required=True),
        4: protobuf.Field("auth", "EosAuthorization", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        account: "int",
        permission: "int",
        parent: "int",
        auth: "EosAuthorization",
    ) -> None:
        self.account = account
        self.permission = permission
        self.parent = parent
        self.auth = auth


class EosActionDeleteAuth(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "uint64", repeated=False, required=True),
        2: protobuf.Field("permission", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        account: "int",
        permission: "int",
    ) -> None:
        self.account = account
        self.permission = permission


class EosActionLinkAuth(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "uint64", repeated=False, required=True),
        2: protobuf.Field("code", "uint64", repeated=False, required=True),
        3: protobuf.Field("type", "uint64", repeated=False, required=True),
        4: protobuf.Field("requirement", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        account: "int",
        code: "int",
        type: "int",
        requirement: "int",
    ) -> None:
        self.account = account
        self.code = code
        self.type = type
        self.requirement = requirement


class EosActionUnlinkAuth(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "uint64", repeated=False, required=True),
        2: protobuf.Field("code", "uint64", repeated=False, required=True),
        3: protobuf.Field("type", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        account: "int",
        code: "int",
        type: "int",
    ) -> None:
        self.account = account
        self.code = code
        self.type = type


class EosActionNewAccount(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("creator", "uint64", repeated=False, required=True),
        2: protobuf.Field("name", "uint64", repeated=False, required=True),
        3: protobuf.Field("owner", "EosAuthorization", repeated=False, required=True),
        4: protobuf.Field("active", "EosAuthorization", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        creator: "int",
        name: "int",
        owner: "EosAuthorization",
        active: "EosAuthorization",
    ) -> None:
        self.creator = creator
        self.name = name
        self.owner = owner
        self.active = active


class EosActionUnknown(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("data_size", "uint32", repeated=False, required=True),
        2: protobuf.Field("data_chunk", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        data_size: "int",
        data_chunk: "bytes",
    ) -> None:
        self.data_size = data_size
        self.data_chunk = data_chunk


class EthereumSignTypedData(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 464
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("primary_type", "string", repeated=False, required=True),
        3: protobuf.Field("metamask_v4_compat", "bool", repeated=False, required=False, default=True),
    }

    def __init__(
        self,
        *,
        primary_type: "str",
        address_n: Optional[Sequence["int"]] = None,
        metamask_v4_compat: Optional["bool"] = True,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.primary_type = primary_type
        self.metamask_v4_compat = metamask_v4_compat


class EthereumTypedDataStructRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 465
    FIELDS = {
        1: protobuf.Field("name", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        name: "str",
    ) -> None:
        self.name = name


class EthereumTypedDataStructAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 466
    FIELDS = {
        1: protobuf.Field("members", "EthereumStructMember", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        members: Optional[Sequence["EthereumStructMember"]] = None,
    ) -> None:
        self.members: Sequence["EthereumStructMember"] = members if members is not None else []


class EthereumTypedDataValueRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 467
    FIELDS = {
        1: protobuf.Field("member_path", "uint32", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        member_path: Optional[Sequence["int"]] = None,
    ) -> None:
        self.member_path: Sequence["int"] = member_path if member_path is not None else []


class EthereumTypedDataValueAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 468
    FIELDS = {
        1: protobuf.Field("value", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        value: "bytes",
    ) -> None:
        self.value = value


class EthereumStructMember(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("type", "EthereumFieldType", repeated=False, required=True),
        2: protobuf.Field("name", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        type: "EthereumFieldType",
        name: "str",
    ) -> None:
        self.type = type
        self.name = name


class EthereumFieldType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("data_type", "EthereumDataType", repeated=False, required=True),
        2: protobuf.Field("size", "uint32", repeated=False, required=False, default=None),
        3: protobuf.Field("entry_type", "EthereumFieldType", repeated=False, required=False, default=None),
        4: protobuf.Field("struct_name", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        data_type: "EthereumDataType",
        size: Optional["int"] = None,
        entry_type: Optional["EthereumFieldType"] = None,
        struct_name: Optional["str"] = None,
    ) -> None:
        self.data_type = data_type
        self.size = size
        self.entry_type = entry_type
        self.struct_name = struct_name


class EthereumGetPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 450
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class EthereumPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 451
    FIELDS = {
        1: protobuf.Field("node", "HDNodeType", repeated=False, required=True),
        2: protobuf.Field("xpub", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        node: "HDNodeType",
        xpub: "str",
    ) -> None:
        self.node = node
        self.xpub = xpub


class EthereumGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 56
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class EthereumAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 57
    FIELDS = {
        1: protobuf.Field("_old_address", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("address", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        _old_address: Optional["bytes"] = None,
        address: Optional["str"] = None,
    ) -> None:
        self._old_address = _old_address
        self.address = address


class EthereumSignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 58
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("nonce", "bytes", repeated=False, required=False, default=b''),
        3: protobuf.Field("gas_price", "bytes", repeated=False, required=True),
        4: protobuf.Field("gas_limit", "bytes", repeated=False, required=True),
        11: protobuf.Field("to", "string", repeated=False, required=False, default=''),
        6: protobuf.Field("value", "bytes", repeated=False, required=False, default=b''),
        7: protobuf.Field("data_initial_chunk", "bytes", repeated=False, required=False, default=b''),
        8: protobuf.Field("data_length", "uint32", repeated=False, required=False, default=0),
        9: protobuf.Field("chain_id", "uint64", repeated=False, required=True),
        10: protobuf.Field("tx_type", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        gas_price: "bytes",
        gas_limit: "bytes",
        chain_id: "int",
        address_n: Optional[Sequence["int"]] = None,
        nonce: Optional["bytes"] = b'',
        to: Optional["str"] = '',
        value: Optional["bytes"] = b'',
        data_initial_chunk: Optional["bytes"] = b'',
        data_length: Optional["int"] = 0,
        tx_type: Optional["int"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.gas_price = gas_price
        self.gas_limit = gas_limit
        self.chain_id = chain_id
        self.nonce = nonce
        self.to = to
        self.value = value
        self.data_initial_chunk = data_initial_chunk
        self.data_length = data_length
        self.tx_type = tx_type


class EthereumSignTxEIP1559(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 452
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("nonce", "bytes", repeated=False, required=True),
        3: protobuf.Field("max_gas_fee", "bytes", repeated=False, required=True),
        4: protobuf.Field("max_priority_fee", "bytes", repeated=False, required=True),
        5: protobuf.Field("gas_limit", "bytes", repeated=False, required=True),
        6: protobuf.Field("to", "string", repeated=False, required=False, default=''),
        7: protobuf.Field("value", "bytes", repeated=False, required=True),
        8: protobuf.Field("data_initial_chunk", "bytes", repeated=False, required=False, default=b''),
        9: protobuf.Field("data_length", "uint32", repeated=False, required=True),
        10: protobuf.Field("chain_id", "uint64", repeated=False, required=True),
        11: protobuf.Field("access_list", "EthereumAccessList", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        nonce: "bytes",
        max_gas_fee: "bytes",
        max_priority_fee: "bytes",
        gas_limit: "bytes",
        value: "bytes",
        data_length: "int",
        chain_id: "int",
        address_n: Optional[Sequence["int"]] = None,
        access_list: Optional[Sequence["EthereumAccessList"]] = None,
        to: Optional["str"] = '',
        data_initial_chunk: Optional["bytes"] = b'',
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.access_list: Sequence["EthereumAccessList"] = access_list if access_list is not None else []
        self.nonce = nonce
        self.max_gas_fee = max_gas_fee
        self.max_priority_fee = max_priority_fee
        self.gas_limit = gas_limit
        self.value = value
        self.data_length = data_length
        self.chain_id = chain_id
        self.to = to
        self.data_initial_chunk = data_initial_chunk


class EthereumTxRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 59
    FIELDS = {
        1: protobuf.Field("data_length", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("signature_v", "uint32", repeated=False, required=False, default=None),
        3: protobuf.Field("signature_r", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("signature_s", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        data_length: Optional["int"] = None,
        signature_v: Optional["int"] = None,
        signature_r: Optional["bytes"] = None,
        signature_s: Optional["bytes"] = None,
    ) -> None:
        self.data_length = data_length
        self.signature_v = signature_v
        self.signature_r = signature_r
        self.signature_s = signature_s


class EthereumTxAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 60
    FIELDS = {
        1: protobuf.Field("data_chunk", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        data_chunk: "bytes",
    ) -> None:
        self.data_chunk = data_chunk


class EthereumSignMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 64
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("message", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        message: "bytes",
        address_n: Optional[Sequence["int"]] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.message = message


class EthereumMessageSignature(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 66
    FIELDS = {
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
        3: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "bytes",
        address: "str",
    ) -> None:
        self.signature = signature
        self.address = address


class EthereumVerifyMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 65
    FIELDS = {
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
        3: protobuf.Field("message", "bytes", repeated=False, required=True),
        4: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "bytes",
        message: "bytes",
        address: "str",
    ) -> None:
        self.signature = signature
        self.message = message
        self.address = address


class EthereumSignTypedHash(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 470
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("domain_separator_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("message_hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        domain_separator_hash: "bytes",
        address_n: Optional[Sequence["int"]] = None,
        message_hash: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.domain_separator_hash = domain_separator_hash
        self.message_hash = message_hash


class EthereumTypedDataSignature(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 469
    FIELDS = {
        1: protobuf.Field("signature", "bytes", repeated=False, required=True),
        2: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "bytes",
        address: "str",
    ) -> None:
        self.signature = signature
        self.address = address


class EthereumAccessList(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("storage_keys", "bytes", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address: "str",
        storage_keys: Optional[Sequence["bytes"]] = None,
    ) -> None:
        self.storage_keys: Sequence["bytes"] = storage_keys if storage_keys is not None else []
        self.address = address


class MoneroTransactionSourceEntry(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("outputs", "MoneroOutputEntry", repeated=True, required=False, default=None),
        2: protobuf.Field("real_output", "uint64", repeated=False, required=False, default=None),
        3: protobuf.Field("real_out_tx_key", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("real_out_additional_tx_keys", "bytes", repeated=True, required=False, default=None),
        5: protobuf.Field("real_output_in_tx_index", "uint64", repeated=False, required=False, default=None),
        6: protobuf.Field("amount", "uint64", repeated=False, required=False, default=None),
        7: protobuf.Field("rct", "bool", repeated=False, required=False, default=None),
        8: protobuf.Field("mask", "bytes", repeated=False, required=False, default=None),
        9: protobuf.Field("multisig_kLRki", "MoneroMultisigKLRki", repeated=False, required=False, default=None),
        10: protobuf.Field("subaddr_minor", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        outputs: Optional[Sequence["MoneroOutputEntry"]] = None,
        real_out_additional_tx_keys: Optional[Sequence["bytes"]] = None,
        real_output: Optional["int"] = None,
        real_out_tx_key: Optional["bytes"] = None,
        real_output_in_tx_index: Optional["int"] = None,
        amount: Optional["int"] = None,
        rct: Optional["bool"] = None,
        mask: Optional["bytes"] = None,
        multisig_kLRki: Optional["MoneroMultisigKLRki"] = None,
        subaddr_minor: Optional["int"] = None,
    ) -> None:
        self.outputs: Sequence["MoneroOutputEntry"] = outputs if outputs is not None else []
        self.real_out_additional_tx_keys: Sequence["bytes"] = real_out_additional_tx_keys if real_out_additional_tx_keys is not None else []
        self.real_output = real_output
        self.real_out_tx_key = real_out_tx_key
        self.real_output_in_tx_index = real_output_in_tx_index
        self.amount = amount
        self.rct = rct
        self.mask = mask
        self.multisig_kLRki = multisig_kLRki
        self.subaddr_minor = subaddr_minor


class MoneroTransactionDestinationEntry(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "uint64", repeated=False, required=False, default=None),
        2: protobuf.Field("addr", "MoneroAccountPublicAddress", repeated=False, required=False, default=None),
        3: protobuf.Field("is_subaddress", "bool", repeated=False, required=False, default=None),
        4: protobuf.Field("original", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("is_integrated", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        amount: Optional["int"] = None,
        addr: Optional["MoneroAccountPublicAddress"] = None,
        is_subaddress: Optional["bool"] = None,
        original: Optional["bytes"] = None,
        is_integrated: Optional["bool"] = None,
    ) -> None:
        self.amount = amount
        self.addr = addr
        self.is_subaddress = is_subaddress
        self.original = original
        self.is_integrated = is_integrated


class MoneroTransactionRsigData(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("rsig_type", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("offload_type", "uint32", repeated=False, required=False, default=None),
        3: protobuf.Field("grouping", "uint64", repeated=True, required=False, default=None),
        4: protobuf.Field("mask", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("rsig", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("rsig_parts", "bytes", repeated=True, required=False, default=None),
        7: protobuf.Field("bp_version", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        grouping: Optional[Sequence["int"]] = None,
        rsig_parts: Optional[Sequence["bytes"]] = None,
        rsig_type: Optional["int"] = None,
        offload_type: Optional["int"] = None,
        mask: Optional["bytes"] = None,
        rsig: Optional["bytes"] = None,
        bp_version: Optional["int"] = None,
    ) -> None:
        self.grouping: Sequence["int"] = grouping if grouping is not None else []
        self.rsig_parts: Sequence["bytes"] = rsig_parts if rsig_parts is not None else []
        self.rsig_type = rsig_type
        self.offload_type = offload_type
        self.mask = mask
        self.rsig = rsig
        self.bp_version = bp_version


class MoneroGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 540
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
        3: protobuf.Field("network_type", "MoneroNetworkType", repeated=False, required=False, default=MoneroNetworkType.MAINNET),
        4: protobuf.Field("account", "uint32", repeated=False, required=False, default=None),
        5: protobuf.Field("minor", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("payment_id", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
        network_type: Optional["MoneroNetworkType"] = MoneroNetworkType.MAINNET,
        account: Optional["int"] = None,
        minor: Optional["int"] = None,
        payment_id: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display
        self.network_type = network_type
        self.account = account
        self.minor = minor
        self.payment_id = payment_id


class MoneroAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 541
    FIELDS = {
        1: protobuf.Field("address", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address: Optional["bytes"] = None,
    ) -> None:
        self.address = address


class MoneroGetWatchKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 542
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("network_type", "MoneroNetworkType", repeated=False, required=False, default=MoneroNetworkType.MAINNET),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        network_type: Optional["MoneroNetworkType"] = MoneroNetworkType.MAINNET,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.network_type = network_type


class MoneroWatchKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 543
    FIELDS = {
        1: protobuf.Field("watch_key", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("address", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        watch_key: Optional["bytes"] = None,
        address: Optional["bytes"] = None,
    ) -> None:
        self.watch_key = watch_key
        self.address = address


class MoneroTransactionInitRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 501
    FIELDS = {
        1: protobuf.Field("version", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        3: protobuf.Field("network_type", "MoneroNetworkType", repeated=False, required=False, default=MoneroNetworkType.MAINNET),
        4: protobuf.Field("tsx_data", "MoneroTransactionData", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        version: Optional["int"] = None,
        network_type: Optional["MoneroNetworkType"] = MoneroNetworkType.MAINNET,
        tsx_data: Optional["MoneroTransactionData"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.version = version
        self.network_type = network_type
        self.tsx_data = tsx_data


class MoneroTransactionInitAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 502
    FIELDS = {
        1: protobuf.Field("hmacs", "bytes", repeated=True, required=False, default=None),
        2: protobuf.Field("rsig_data", "MoneroTransactionRsigData", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        hmacs: Optional[Sequence["bytes"]] = None,
        rsig_data: Optional["MoneroTransactionRsigData"] = None,
    ) -> None:
        self.hmacs: Sequence["bytes"] = hmacs if hmacs is not None else []
        self.rsig_data = rsig_data


class MoneroTransactionSetInputRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 503
    FIELDS = {
        1: protobuf.Field("src_entr", "MoneroTransactionSourceEntry", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        src_entr: Optional["MoneroTransactionSourceEntry"] = None,
    ) -> None:
        self.src_entr = src_entr


class MoneroTransactionSetInputAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 504
    FIELDS = {
        1: protobuf.Field("vini", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("vini_hmac", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("pseudo_out", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("pseudo_out_hmac", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("pseudo_out_alpha", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("spend_key", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        vini: Optional["bytes"] = None,
        vini_hmac: Optional["bytes"] = None,
        pseudo_out: Optional["bytes"] = None,
        pseudo_out_hmac: Optional["bytes"] = None,
        pseudo_out_alpha: Optional["bytes"] = None,
        spend_key: Optional["bytes"] = None,
    ) -> None:
        self.vini = vini
        self.vini_hmac = vini_hmac
        self.pseudo_out = pseudo_out
        self.pseudo_out_hmac = pseudo_out_hmac
        self.pseudo_out_alpha = pseudo_out_alpha
        self.spend_key = spend_key


class MoneroTransactionInputViniRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 507
    FIELDS = {
        1: protobuf.Field("src_entr", "MoneroTransactionSourceEntry", repeated=False, required=False, default=None),
        2: protobuf.Field("vini", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("vini_hmac", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("pseudo_out", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("pseudo_out_hmac", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("orig_idx", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        src_entr: Optional["MoneroTransactionSourceEntry"] = None,
        vini: Optional["bytes"] = None,
        vini_hmac: Optional["bytes"] = None,
        pseudo_out: Optional["bytes"] = None,
        pseudo_out_hmac: Optional["bytes"] = None,
        orig_idx: Optional["int"] = None,
    ) -> None:
        self.src_entr = src_entr
        self.vini = vini
        self.vini_hmac = vini_hmac
        self.pseudo_out = pseudo_out
        self.pseudo_out_hmac = pseudo_out_hmac
        self.orig_idx = orig_idx


class MoneroTransactionInputViniAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 508


class MoneroTransactionAllInputsSetRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 509


class MoneroTransactionAllInputsSetAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 510
    FIELDS = {
        1: protobuf.Field("rsig_data", "MoneroTransactionRsigData", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        rsig_data: Optional["MoneroTransactionRsigData"] = None,
    ) -> None:
        self.rsig_data = rsig_data


class MoneroTransactionSetOutputRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 511
    FIELDS = {
        1: protobuf.Field("dst_entr", "MoneroTransactionDestinationEntry", repeated=False, required=False, default=None),
        2: protobuf.Field("dst_entr_hmac", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("rsig_data", "MoneroTransactionRsigData", repeated=False, required=False, default=None),
        4: protobuf.Field("is_offloaded_bp", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        dst_entr: Optional["MoneroTransactionDestinationEntry"] = None,
        dst_entr_hmac: Optional["bytes"] = None,
        rsig_data: Optional["MoneroTransactionRsigData"] = None,
        is_offloaded_bp: Optional["bool"] = None,
    ) -> None:
        self.dst_entr = dst_entr
        self.dst_entr_hmac = dst_entr_hmac
        self.rsig_data = rsig_data
        self.is_offloaded_bp = is_offloaded_bp


class MoneroTransactionSetOutputAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 512
    FIELDS = {
        1: protobuf.Field("tx_out", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("vouti_hmac", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("rsig_data", "MoneroTransactionRsigData", repeated=False, required=False, default=None),
        4: protobuf.Field("out_pk", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("ecdh_info", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        tx_out: Optional["bytes"] = None,
        vouti_hmac: Optional["bytes"] = None,
        rsig_data: Optional["MoneroTransactionRsigData"] = None,
        out_pk: Optional["bytes"] = None,
        ecdh_info: Optional["bytes"] = None,
    ) -> None:
        self.tx_out = tx_out
        self.vouti_hmac = vouti_hmac
        self.rsig_data = rsig_data
        self.out_pk = out_pk
        self.ecdh_info = ecdh_info


class MoneroTransactionAllOutSetRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 513
    FIELDS = {
        1: protobuf.Field("rsig_data", "MoneroTransactionRsigData", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        rsig_data: Optional["MoneroTransactionRsigData"] = None,
    ) -> None:
        self.rsig_data = rsig_data


class MoneroTransactionAllOutSetAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 514
    FIELDS = {
        1: protobuf.Field("extra", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("tx_prefix_hash", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("rv", "MoneroRingCtSig", repeated=False, required=False, default=None),
        5: protobuf.Field("full_message_hash", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        extra: Optional["bytes"] = None,
        tx_prefix_hash: Optional["bytes"] = None,
        rv: Optional["MoneroRingCtSig"] = None,
        full_message_hash: Optional["bytes"] = None,
    ) -> None:
        self.extra = extra
        self.tx_prefix_hash = tx_prefix_hash
        self.rv = rv
        self.full_message_hash = full_message_hash


class MoneroTransactionSignInputRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 515
    FIELDS = {
        1: protobuf.Field("src_entr", "MoneroTransactionSourceEntry", repeated=False, required=False, default=None),
        2: protobuf.Field("vini", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("vini_hmac", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("pseudo_out", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("pseudo_out_hmac", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("pseudo_out_alpha", "bytes", repeated=False, required=False, default=None),
        7: protobuf.Field("spend_key", "bytes", repeated=False, required=False, default=None),
        8: protobuf.Field("orig_idx", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        src_entr: Optional["MoneroTransactionSourceEntry"] = None,
        vini: Optional["bytes"] = None,
        vini_hmac: Optional["bytes"] = None,
        pseudo_out: Optional["bytes"] = None,
        pseudo_out_hmac: Optional["bytes"] = None,
        pseudo_out_alpha: Optional["bytes"] = None,
        spend_key: Optional["bytes"] = None,
        orig_idx: Optional["int"] = None,
    ) -> None:
        self.src_entr = src_entr
        self.vini = vini
        self.vini_hmac = vini_hmac
        self.pseudo_out = pseudo_out
        self.pseudo_out_hmac = pseudo_out_hmac
        self.pseudo_out_alpha = pseudo_out_alpha
        self.spend_key = spend_key
        self.orig_idx = orig_idx


class MoneroTransactionSignInputAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 516
    FIELDS = {
        1: protobuf.Field("signature", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("pseudo_out", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        signature: Optional["bytes"] = None,
        pseudo_out: Optional["bytes"] = None,
    ) -> None:
        self.signature = signature
        self.pseudo_out = pseudo_out


class MoneroTransactionFinalRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 517


class MoneroTransactionFinalAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 518
    FIELDS = {
        1: protobuf.Field("cout_key", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("salt", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("rand_mult", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("tx_enc_keys", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("opening_key", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        cout_key: Optional["bytes"] = None,
        salt: Optional["bytes"] = None,
        rand_mult: Optional["bytes"] = None,
        tx_enc_keys: Optional["bytes"] = None,
        opening_key: Optional["bytes"] = None,
    ) -> None:
        self.cout_key = cout_key
        self.salt = salt
        self.rand_mult = rand_mult
        self.tx_enc_keys = tx_enc_keys
        self.opening_key = opening_key


class MoneroKeyImageExportInitRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 530
    FIELDS = {
        1: protobuf.Field("num", "uint64", repeated=False, required=True),
        2: protobuf.Field("hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        4: protobuf.Field("network_type", "MoneroNetworkType", repeated=False, required=False, default=MoneroNetworkType.MAINNET),
        5: protobuf.Field("subs", "MoneroSubAddressIndicesList", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        num: "int",
        hash: "bytes",
        address_n: Optional[Sequence["int"]] = None,
        subs: Optional[Sequence["MoneroSubAddressIndicesList"]] = None,
        network_type: Optional["MoneroNetworkType"] = MoneroNetworkType.MAINNET,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.subs: Sequence["MoneroSubAddressIndicesList"] = subs if subs is not None else []
        self.num = num
        self.hash = hash
        self.network_type = network_type


class MoneroKeyImageExportInitAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 531


class MoneroKeyImageSyncStepRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 532
    FIELDS = {
        1: protobuf.Field("tdis", "MoneroTransferDetails", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        tdis: Optional[Sequence["MoneroTransferDetails"]] = None,
    ) -> None:
        self.tdis: Sequence["MoneroTransferDetails"] = tdis if tdis is not None else []


class MoneroKeyImageSyncStepAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 533
    FIELDS = {
        1: protobuf.Field("kis", "MoneroExportedKeyImage", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        kis: Optional[Sequence["MoneroExportedKeyImage"]] = None,
    ) -> None:
        self.kis: Sequence["MoneroExportedKeyImage"] = kis if kis is not None else []


class MoneroKeyImageSyncFinalRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 534


class MoneroKeyImageSyncFinalAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 535
    FIELDS = {
        1: protobuf.Field("enc_key", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        enc_key: Optional["bytes"] = None,
    ) -> None:
        self.enc_key = enc_key


class MoneroGetTxKeyRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 550
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("network_type", "MoneroNetworkType", repeated=False, required=False, default=MoneroNetworkType.MAINNET),
        3: protobuf.Field("salt1", "bytes", repeated=False, required=True),
        4: protobuf.Field("salt2", "bytes", repeated=False, required=True),
        5: protobuf.Field("tx_enc_keys", "bytes", repeated=False, required=True),
        6: protobuf.Field("tx_prefix_hash", "bytes", repeated=False, required=True),
        7: protobuf.Field("reason", "uint32", repeated=False, required=False, default=None),
        8: protobuf.Field("view_public_key", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        salt1: "bytes",
        salt2: "bytes",
        tx_enc_keys: "bytes",
        tx_prefix_hash: "bytes",
        address_n: Optional[Sequence["int"]] = None,
        network_type: Optional["MoneroNetworkType"] = MoneroNetworkType.MAINNET,
        reason: Optional["int"] = None,
        view_public_key: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.salt1 = salt1
        self.salt2 = salt2
        self.tx_enc_keys = tx_enc_keys
        self.tx_prefix_hash = tx_prefix_hash
        self.network_type = network_type
        self.reason = reason
        self.view_public_key = view_public_key


class MoneroGetTxKeyAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 551
    FIELDS = {
        1: protobuf.Field("salt", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("tx_keys", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("tx_derivations", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        salt: Optional["bytes"] = None,
        tx_keys: Optional["bytes"] = None,
        tx_derivations: Optional["bytes"] = None,
    ) -> None:
        self.salt = salt
        self.tx_keys = tx_keys
        self.tx_derivations = tx_derivations


class MoneroLiveRefreshStartRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 552
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("network_type", "MoneroNetworkType", repeated=False, required=False, default=MoneroNetworkType.MAINNET),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        network_type: Optional["MoneroNetworkType"] = MoneroNetworkType.MAINNET,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.network_type = network_type


class MoneroLiveRefreshStartAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 553


class MoneroLiveRefreshStepRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 554
    FIELDS = {
        1: protobuf.Field("out_key", "bytes", repeated=False, required=True),
        2: protobuf.Field("recv_deriv", "bytes", repeated=False, required=True),
        3: protobuf.Field("real_out_idx", "uint64", repeated=False, required=True),
        4: protobuf.Field("sub_addr_major", "uint32", repeated=False, required=True),
        5: protobuf.Field("sub_addr_minor", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        out_key: "bytes",
        recv_deriv: "bytes",
        real_out_idx: "int",
        sub_addr_major: "int",
        sub_addr_minor: "int",
    ) -> None:
        self.out_key = out_key
        self.recv_deriv = recv_deriv
        self.real_out_idx = real_out_idx
        self.sub_addr_major = sub_addr_major
        self.sub_addr_minor = sub_addr_minor


class MoneroLiveRefreshStepAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 555
    FIELDS = {
        1: protobuf.Field("salt", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("key_image", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        salt: Optional["bytes"] = None,
        key_image: Optional["bytes"] = None,
    ) -> None:
        self.salt = salt
        self.key_image = key_image


class MoneroLiveRefreshFinalRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 556


class MoneroLiveRefreshFinalAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 557


class DebugMoneroDiagRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 546
    FIELDS = {
        1: protobuf.Field("ins", "uint64", repeated=False, required=False, default=None),
        2: protobuf.Field("p1", "uint64", repeated=False, required=False, default=None),
        3: protobuf.Field("p2", "uint64", repeated=False, required=False, default=None),
        4: protobuf.Field("pd", "uint64", repeated=True, required=False, default=None),
        5: protobuf.Field("data1", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("data2", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        pd: Optional[Sequence["int"]] = None,
        ins: Optional["int"] = None,
        p1: Optional["int"] = None,
        p2: Optional["int"] = None,
        data1: Optional["bytes"] = None,
        data2: Optional["bytes"] = None,
    ) -> None:
        self.pd: Sequence["int"] = pd if pd is not None else []
        self.ins = ins
        self.p1 = p1
        self.p2 = p2
        self.data1 = data1
        self.data2 = data2


class DebugMoneroDiagAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 547
    FIELDS = {
        1: protobuf.Field("ins", "uint64", repeated=False, required=False, default=None),
        2: protobuf.Field("p1", "uint64", repeated=False, required=False, default=None),
        3: protobuf.Field("p2", "uint64", repeated=False, required=False, default=None),
        4: protobuf.Field("pd", "uint64", repeated=True, required=False, default=None),
        5: protobuf.Field("data1", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("data2", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        pd: Optional[Sequence["int"]] = None,
        ins: Optional["int"] = None,
        p1: Optional["int"] = None,
        p2: Optional["int"] = None,
        data1: Optional["bytes"] = None,
        data2: Optional["bytes"] = None,
    ) -> None:
        self.pd: Sequence["int"] = pd if pd is not None else []
        self.ins = ins
        self.p1 = p1
        self.p2 = p2
        self.data1 = data1
        self.data2 = data2


class MoneroOutputEntry(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("idx", "uint64", repeated=False, required=False, default=None),
        2: protobuf.Field("key", "MoneroRctKeyPublic", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        idx: Optional["int"] = None,
        key: Optional["MoneroRctKeyPublic"] = None,
    ) -> None:
        self.idx = idx
        self.key = key


class MoneroMultisigKLRki(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("K", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("L", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("R", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("ki", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        K: Optional["bytes"] = None,
        L: Optional["bytes"] = None,
        R: Optional["bytes"] = None,
        ki: Optional["bytes"] = None,
    ) -> None:
        self.K = K
        self.L = L
        self.R = R
        self.ki = ki


class MoneroRctKeyPublic(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("dest", "bytes", repeated=False, required=True),
        2: protobuf.Field("commitment", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        dest: "bytes",
        commitment: "bytes",
    ) -> None:
        self.dest = dest
        self.commitment = commitment


class MoneroAccountPublicAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("spend_public_key", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("view_public_key", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        spend_public_key: Optional["bytes"] = None,
        view_public_key: Optional["bytes"] = None,
    ) -> None:
        self.spend_public_key = spend_public_key
        self.view_public_key = view_public_key


class MoneroTransactionData(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("version", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("payment_id", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("unlock_time", "uint64", repeated=False, required=False, default=None),
        4: protobuf.Field("outputs", "MoneroTransactionDestinationEntry", repeated=True, required=False, default=None),
        5: protobuf.Field("change_dts", "MoneroTransactionDestinationEntry", repeated=False, required=False, default=None),
        6: protobuf.Field("num_inputs", "uint32", repeated=False, required=False, default=None),
        7: protobuf.Field("mixin", "uint32", repeated=False, required=False, default=None),
        8: protobuf.Field("fee", "uint64", repeated=False, required=False, default=None),
        9: protobuf.Field("account", "uint32", repeated=False, required=False, default=None),
        10: protobuf.Field("minor_indices", "uint32", repeated=True, required=False, default=None),
        11: protobuf.Field("rsig_data", "MoneroTransactionRsigData", repeated=False, required=False, default=None),
        12: protobuf.Field("integrated_indices", "uint32", repeated=True, required=False, default=None),
        13: protobuf.Field("client_version", "uint32", repeated=False, required=False, default=None),
        14: protobuf.Field("hard_fork", "uint32", repeated=False, required=False, default=None),
        15: protobuf.Field("monero_version", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        outputs: Optional[Sequence["MoneroTransactionDestinationEntry"]] = None,
        minor_indices: Optional[Sequence["int"]] = None,
        integrated_indices: Optional[Sequence["int"]] = None,
        version: Optional["int"] = None,
        payment_id: Optional["bytes"] = None,
        unlock_time: Optional["int"] = None,
        change_dts: Optional["MoneroTransactionDestinationEntry"] = None,
        num_inputs: Optional["int"] = None,
        mixin: Optional["int"] = None,
        fee: Optional["int"] = None,
        account: Optional["int"] = None,
        rsig_data: Optional["MoneroTransactionRsigData"] = None,
        client_version: Optional["int"] = None,
        hard_fork: Optional["int"] = None,
        monero_version: Optional["bytes"] = None,
    ) -> None:
        self.outputs: Sequence["MoneroTransactionDestinationEntry"] = outputs if outputs is not None else []
        self.minor_indices: Sequence["int"] = minor_indices if minor_indices is not None else []
        self.integrated_indices: Sequence["int"] = integrated_indices if integrated_indices is not None else []
        self.version = version
        self.payment_id = payment_id
        self.unlock_time = unlock_time
        self.change_dts = change_dts
        self.num_inputs = num_inputs
        self.mixin = mixin
        self.fee = fee
        self.account = account
        self.rsig_data = rsig_data
        self.client_version = client_version
        self.hard_fork = hard_fork
        self.monero_version = monero_version


class MoneroRingCtSig(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("txn_fee", "uint64", repeated=False, required=False, default=None),
        2: protobuf.Field("message", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("rv_type", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        txn_fee: Optional["int"] = None,
        message: Optional["bytes"] = None,
        rv_type: Optional["int"] = None,
    ) -> None:
        self.txn_fee = txn_fee
        self.message = message
        self.rv_type = rv_type


class MoneroSubAddressIndicesList(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("account", "uint32", repeated=False, required=True),
        2: protobuf.Field("minor_indices", "uint32", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        account: "int",
        minor_indices: Optional[Sequence["int"]] = None,
    ) -> None:
        self.minor_indices: Sequence["int"] = minor_indices if minor_indices is not None else []
        self.account = account


class MoneroTransferDetails(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("out_key", "bytes", repeated=False, required=True),
        2: protobuf.Field("tx_pub_key", "bytes", repeated=False, required=True),
        3: protobuf.Field("additional_tx_pub_keys", "bytes", repeated=True, required=False, default=None),
        4: protobuf.Field("internal_output_index", "uint64", repeated=False, required=True),
        5: protobuf.Field("sub_addr_major", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("sub_addr_minor", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        out_key: "bytes",
        tx_pub_key: "bytes",
        internal_output_index: "int",
        additional_tx_pub_keys: Optional[Sequence["bytes"]] = None,
        sub_addr_major: Optional["int"] = None,
        sub_addr_minor: Optional["int"] = None,
    ) -> None:
        self.additional_tx_pub_keys: Sequence["bytes"] = additional_tx_pub_keys if additional_tx_pub_keys is not None else []
        self.out_key = out_key
        self.tx_pub_key = tx_pub_key
        self.internal_output_index = internal_output_index
        self.sub_addr_major = sub_addr_major
        self.sub_addr_minor = sub_addr_minor


class MoneroExportedKeyImage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("iv", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("blob", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        iv: Optional["bytes"] = None,
        blob: Optional["bytes"] = None,
    ) -> None:
        self.iv = iv
        self.blob = blob


class NEMGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 67
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("network", "uint32", repeated=False, required=False, default=104),
        3: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        network: Optional["int"] = 104,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.network = network
        self.show_display = show_display


class NEMAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 68
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
    ) -> None:
        self.address = address


class NEMSignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 69
    FIELDS = {
        1: protobuf.Field("transaction", "NEMTransactionCommon", repeated=False, required=True),
        2: protobuf.Field("multisig", "NEMTransactionCommon", repeated=False, required=False, default=None),
        3: protobuf.Field("transfer", "NEMTransfer", repeated=False, required=False, default=None),
        4: protobuf.Field("cosigning", "bool", repeated=False, required=False, default=None),
        5: protobuf.Field("provision_namespace", "NEMProvisionNamespace", repeated=False, required=False, default=None),
        6: protobuf.Field("mosaic_creation", "NEMMosaicCreation", repeated=False, required=False, default=None),
        7: protobuf.Field("supply_change", "NEMMosaicSupplyChange", repeated=False, required=False, default=None),
        8: protobuf.Field("aggregate_modification", "NEMAggregateModification", repeated=False, required=False, default=None),
        9: protobuf.Field("importance_transfer", "NEMImportanceTransfer", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        transaction: "NEMTransactionCommon",
        multisig: Optional["NEMTransactionCommon"] = None,
        transfer: Optional["NEMTransfer"] = None,
        cosigning: Optional["bool"] = None,
        provision_namespace: Optional["NEMProvisionNamespace"] = None,
        mosaic_creation: Optional["NEMMosaicCreation"] = None,
        supply_change: Optional["NEMMosaicSupplyChange"] = None,
        aggregate_modification: Optional["NEMAggregateModification"] = None,
        importance_transfer: Optional["NEMImportanceTransfer"] = None,
    ) -> None:
        self.transaction = transaction
        self.multisig = multisig
        self.transfer = transfer
        self.cosigning = cosigning
        self.provision_namespace = provision_namespace
        self.mosaic_creation = mosaic_creation
        self.supply_change = supply_change
        self.aggregate_modification = aggregate_modification
        self.importance_transfer = importance_transfer


class NEMSignedTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 70
    FIELDS = {
        1: protobuf.Field("data", "bytes", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        data: "bytes",
        signature: "bytes",
    ) -> None:
        self.data = data
        self.signature = signature


class NEMDecryptMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 75
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("network", "uint32", repeated=False, required=False, default=None),
        3: protobuf.Field("public_key", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("payload", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        network: Optional["int"] = None,
        public_key: Optional["bytes"] = None,
        payload: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.network = network
        self.public_key = public_key
        self.payload = payload


class NEMDecryptedMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 76
    FIELDS = {
        1: protobuf.Field("payload", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        payload: "bytes",
    ) -> None:
        self.payload = payload


class NEMTransactionCommon(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("network", "uint32", repeated=False, required=False, default=104),
        3: protobuf.Field("timestamp", "uint32", repeated=False, required=True),
        4: protobuf.Field("fee", "uint64", repeated=False, required=True),
        5: protobuf.Field("deadline", "uint32", repeated=False, required=True),
        6: protobuf.Field("signer", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        timestamp: "int",
        fee: "int",
        deadline: "int",
        address_n: Optional[Sequence["int"]] = None,
        network: Optional["int"] = 104,
        signer: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.timestamp = timestamp
        self.fee = fee
        self.deadline = deadline
        self.network = network
        self.signer = signer


class NEMTransfer(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("recipient", "string", repeated=False, required=True),
        2: protobuf.Field("amount", "uint64", repeated=False, required=True),
        3: protobuf.Field("payload", "bytes", repeated=False, required=False, default=None),
        4: protobuf.Field("public_key", "bytes", repeated=False, required=False, default=None),
        5: protobuf.Field("mosaics", "NEMMosaic", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        recipient: "str",
        amount: "int",
        mosaics: Optional[Sequence["NEMMosaic"]] = None,
        payload: Optional["bytes"] = None,
        public_key: Optional["bytes"] = None,
    ) -> None:
        self.mosaics: Sequence["NEMMosaic"] = mosaics if mosaics is not None else []
        self.recipient = recipient
        self.amount = amount
        self.payload = payload
        self.public_key = public_key


class NEMProvisionNamespace(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("namespace", "string", repeated=False, required=True),
        2: protobuf.Field("parent", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("sink", "string", repeated=False, required=True),
        4: protobuf.Field("fee", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        namespace: "str",
        sink: "str",
        fee: "int",
        parent: Optional["str"] = None,
    ) -> None:
        self.namespace = namespace
        self.sink = sink
        self.fee = fee
        self.parent = parent


class NEMMosaicCreation(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("definition", "NEMMosaicDefinition", repeated=False, required=True),
        2: protobuf.Field("sink", "string", repeated=False, required=True),
        3: protobuf.Field("fee", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        definition: "NEMMosaicDefinition",
        sink: "str",
        fee: "int",
    ) -> None:
        self.definition = definition
        self.sink = sink
        self.fee = fee


class NEMMosaicSupplyChange(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("namespace", "string", repeated=False, required=True),
        2: protobuf.Field("mosaic", "string", repeated=False, required=True),
        3: protobuf.Field("type", "NEMSupplyChangeType", repeated=False, required=True),
        4: protobuf.Field("delta", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        namespace: "str",
        mosaic: "str",
        type: "NEMSupplyChangeType",
        delta: "int",
    ) -> None:
        self.namespace = namespace
        self.mosaic = mosaic
        self.type = type
        self.delta = delta


class NEMAggregateModification(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("modifications", "NEMCosignatoryModification", repeated=True, required=False, default=None),
        2: protobuf.Field("relative_change", "sint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        modifications: Optional[Sequence["NEMCosignatoryModification"]] = None,
        relative_change: Optional["int"] = None,
    ) -> None:
        self.modifications: Sequence["NEMCosignatoryModification"] = modifications if modifications is not None else []
        self.relative_change = relative_change


class NEMImportanceTransfer(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("mode", "NEMImportanceTransferMode", repeated=False, required=True),
        2: protobuf.Field("public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        mode: "NEMImportanceTransferMode",
        public_key: "bytes",
    ) -> None:
        self.mode = mode
        self.public_key = public_key


class NEMMosaic(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("namespace", "string", repeated=False, required=True),
        2: protobuf.Field("mosaic", "string", repeated=False, required=True),
        3: protobuf.Field("quantity", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        namespace: "str",
        mosaic: "str",
        quantity: "int",
    ) -> None:
        self.namespace = namespace
        self.mosaic = mosaic
        self.quantity = quantity


class NEMMosaicDefinition(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("name", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("ticker", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("namespace", "string", repeated=False, required=True),
        4: protobuf.Field("mosaic", "string", repeated=False, required=True),
        5: protobuf.Field("divisibility", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("levy", "NEMMosaicLevy", repeated=False, required=False, default=None),
        7: protobuf.Field("fee", "uint64", repeated=False, required=False, default=None),
        8: protobuf.Field("levy_address", "string", repeated=False, required=False, default=None),
        9: protobuf.Field("levy_namespace", "string", repeated=False, required=False, default=None),
        10: protobuf.Field("levy_mosaic", "string", repeated=False, required=False, default=None),
        11: protobuf.Field("supply", "uint64", repeated=False, required=False, default=None),
        12: protobuf.Field("mutable_supply", "bool", repeated=False, required=False, default=None),
        13: protobuf.Field("transferable", "bool", repeated=False, required=False, default=None),
        14: protobuf.Field("description", "string", repeated=False, required=True),
        15: protobuf.Field("networks", "uint32", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        namespace: "str",
        mosaic: "str",
        description: "str",
        networks: Optional[Sequence["int"]] = None,
        name: Optional["str"] = None,
        ticker: Optional["str"] = None,
        divisibility: Optional["int"] = None,
        levy: Optional["NEMMosaicLevy"] = None,
        fee: Optional["int"] = None,
        levy_address: Optional["str"] = None,
        levy_namespace: Optional["str"] = None,
        levy_mosaic: Optional["str"] = None,
        supply: Optional["int"] = None,
        mutable_supply: Optional["bool"] = None,
        transferable: Optional["bool"] = None,
    ) -> None:
        self.networks: Sequence["int"] = networks if networks is not None else []
        self.namespace = namespace
        self.mosaic = mosaic
        self.description = description
        self.name = name
        self.ticker = ticker
        self.divisibility = divisibility
        self.levy = levy
        self.fee = fee
        self.levy_address = levy_address
        self.levy_namespace = levy_namespace
        self.levy_mosaic = levy_mosaic
        self.supply = supply
        self.mutable_supply = mutable_supply
        self.transferable = transferable


class NEMCosignatoryModification(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("type", "NEMModificationType", repeated=False, required=True),
        2: protobuf.Field("public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        type: "NEMModificationType",
        public_key: "bytes",
    ) -> None:
        self.type = type
        self.public_key = public_key


class RippleGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 400
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class RippleAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 401
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
    ) -> None:
        self.address = address


class RippleSignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 402
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("fee", "uint64", repeated=False, required=True),
        3: protobuf.Field("flags", "uint32", repeated=False, required=False, default=0),
        4: protobuf.Field("sequence", "uint32", repeated=False, required=True),
        5: protobuf.Field("last_ledger_sequence", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("payment", "RipplePayment", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        fee: "int",
        sequence: "int",
        payment: "RipplePayment",
        address_n: Optional[Sequence["int"]] = None,
        flags: Optional["int"] = 0,
        last_ledger_sequence: Optional["int"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.fee = fee
        self.sequence = sequence
        self.payment = payment
        self.flags = flags
        self.last_ledger_sequence = last_ledger_sequence


class RippleSignedTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 403
    FIELDS = {
        1: protobuf.Field("signature", "bytes", repeated=False, required=True),
        2: protobuf.Field("serialized_tx", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "bytes",
        serialized_tx: "bytes",
    ) -> None:
        self.signature = signature
        self.serialized_tx = serialized_tx


class RipplePayment(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "uint64", repeated=False, required=True),
        2: protobuf.Field("destination", "string", repeated=False, required=True),
        3: protobuf.Field("destination_tag", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        amount: "int",
        destination: "str",
        destination_tag: Optional["int"] = None,
    ) -> None:
        self.amount = amount
        self.destination = destination
        self.destination_tag = destination_tag


class StellarAsset(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("type", "StellarAssetType", repeated=False, required=True),
        2: protobuf.Field("code", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("issuer", "string", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        type: "StellarAssetType",
        code: Optional["str"] = None,
        issuer: Optional["str"] = None,
    ) -> None:
        self.type = type
        self.code = code
        self.issuer = issuer


class StellarGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 207
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class StellarAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 208
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
    ) -> None:
        self.address = address


class StellarSignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 202
    FIELDS = {
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        3: protobuf.Field("network_passphrase", "string", repeated=False, required=True),
        4: protobuf.Field("source_account", "string", repeated=False, required=True),
        5: protobuf.Field("fee", "uint32", repeated=False, required=True),
        6: protobuf.Field("sequence_number", "uint64", repeated=False, required=True),
        8: protobuf.Field("timebounds_start", "uint32", repeated=False, required=True),
        9: protobuf.Field("timebounds_end", "uint32", repeated=False, required=True),
        10: protobuf.Field("memo_type", "StellarMemoType", repeated=False, required=True),
        11: protobuf.Field("memo_text", "string", repeated=False, required=False, default=None),
        12: protobuf.Field("memo_id", "uint64", repeated=False, required=False, default=None),
        13: protobuf.Field("memo_hash", "bytes", repeated=False, required=False, default=None),
        14: protobuf.Field("num_operations", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        network_passphrase: "str",
        source_account: "str",
        fee: "int",
        sequence_number: "int",
        timebounds_start: "int",
        timebounds_end: "int",
        memo_type: "StellarMemoType",
        num_operations: "int",
        address_n: Optional[Sequence["int"]] = None,
        memo_text: Optional["str"] = None,
        memo_id: Optional["int"] = None,
        memo_hash: Optional["bytes"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.network_passphrase = network_passphrase
        self.source_account = source_account
        self.fee = fee
        self.sequence_number = sequence_number
        self.timebounds_start = timebounds_start
        self.timebounds_end = timebounds_end
        self.memo_type = memo_type
        self.num_operations = num_operations
        self.memo_text = memo_text
        self.memo_id = memo_id
        self.memo_hash = memo_hash


class StellarTxOpRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 203


class StellarPaymentOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 211
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("destination_account", "string", repeated=False, required=True),
        3: protobuf.Field("asset", "StellarAsset", repeated=False, required=True),
        4: protobuf.Field("amount", "sint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        destination_account: "str",
        asset: "StellarAsset",
        amount: "int",
        source_account: Optional["str"] = None,
    ) -> None:
        self.destination_account = destination_account
        self.asset = asset
        self.amount = amount
        self.source_account = source_account


class StellarCreateAccountOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 210
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("new_account", "string", repeated=False, required=True),
        3: protobuf.Field("starting_balance", "sint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        new_account: "str",
        starting_balance: "int",
        source_account: Optional["str"] = None,
    ) -> None:
        self.new_account = new_account
        self.starting_balance = starting_balance
        self.source_account = source_account


class StellarPathPaymentStrictReceiveOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 212
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("send_asset", "StellarAsset", repeated=False, required=True),
        3: protobuf.Field("send_max", "sint64", repeated=False, required=True),
        4: protobuf.Field("destination_account", "string", repeated=False, required=True),
        5: protobuf.Field("destination_asset", "StellarAsset", repeated=False, required=True),
        6: protobuf.Field("destination_amount", "sint64", repeated=False, required=True),
        7: protobuf.Field("paths", "StellarAsset", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        send_asset: "StellarAsset",
        send_max: "int",
        destination_account: "str",
        destination_asset: "StellarAsset",
        destination_amount: "int",
        paths: Optional[Sequence["StellarAsset"]] = None,
        source_account: Optional["str"] = None,
    ) -> None:
        self.paths: Sequence["StellarAsset"] = paths if paths is not None else []
        self.send_asset = send_asset
        self.send_max = send_max
        self.destination_account = destination_account
        self.destination_asset = destination_asset
        self.destination_amount = destination_amount
        self.source_account = source_account


class StellarPathPaymentStrictSendOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 223
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("send_asset", "StellarAsset", repeated=False, required=True),
        3: protobuf.Field("send_amount", "sint64", repeated=False, required=True),
        4: protobuf.Field("destination_account", "string", repeated=False, required=True),
        5: protobuf.Field("destination_asset", "StellarAsset", repeated=False, required=True),
        6: protobuf.Field("destination_min", "sint64", repeated=False, required=True),
        7: protobuf.Field("paths", "StellarAsset", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        send_asset: "StellarAsset",
        send_amount: "int",
        destination_account: "str",
        destination_asset: "StellarAsset",
        destination_min: "int",
        paths: Optional[Sequence["StellarAsset"]] = None,
        source_account: Optional["str"] = None,
    ) -> None:
        self.paths: Sequence["StellarAsset"] = paths if paths is not None else []
        self.send_asset = send_asset
        self.send_amount = send_amount
        self.destination_account = destination_account
        self.destination_asset = destination_asset
        self.destination_min = destination_min
        self.source_account = source_account


class StellarManageSellOfferOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 213
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("selling_asset", "StellarAsset", repeated=False, required=True),
        3: protobuf.Field("buying_asset", "StellarAsset", repeated=False, required=True),
        4: protobuf.Field("amount", "sint64", repeated=False, required=True),
        5: protobuf.Field("price_n", "uint32", repeated=False, required=True),
        6: protobuf.Field("price_d", "uint32", repeated=False, required=True),
        7: protobuf.Field("offer_id", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        selling_asset: "StellarAsset",
        buying_asset: "StellarAsset",
        amount: "int",
        price_n: "int",
        price_d: "int",
        offer_id: "int",
        source_account: Optional["str"] = None,
    ) -> None:
        self.selling_asset = selling_asset
        self.buying_asset = buying_asset
        self.amount = amount
        self.price_n = price_n
        self.price_d = price_d
        self.offer_id = offer_id
        self.source_account = source_account


class StellarManageBuyOfferOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 222
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("selling_asset", "StellarAsset", repeated=False, required=True),
        3: protobuf.Field("buying_asset", "StellarAsset", repeated=False, required=True),
        4: protobuf.Field("amount", "sint64", repeated=False, required=True),
        5: protobuf.Field("price_n", "uint32", repeated=False, required=True),
        6: protobuf.Field("price_d", "uint32", repeated=False, required=True),
        7: protobuf.Field("offer_id", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        selling_asset: "StellarAsset",
        buying_asset: "StellarAsset",
        amount: "int",
        price_n: "int",
        price_d: "int",
        offer_id: "int",
        source_account: Optional["str"] = None,
    ) -> None:
        self.selling_asset = selling_asset
        self.buying_asset = buying_asset
        self.amount = amount
        self.price_n = price_n
        self.price_d = price_d
        self.offer_id = offer_id
        self.source_account = source_account


class StellarCreatePassiveSellOfferOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 214
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("selling_asset", "StellarAsset", repeated=False, required=True),
        3: protobuf.Field("buying_asset", "StellarAsset", repeated=False, required=True),
        4: protobuf.Field("amount", "sint64", repeated=False, required=True),
        5: protobuf.Field("price_n", "uint32", repeated=False, required=True),
        6: protobuf.Field("price_d", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        selling_asset: "StellarAsset",
        buying_asset: "StellarAsset",
        amount: "int",
        price_n: "int",
        price_d: "int",
        source_account: Optional["str"] = None,
    ) -> None:
        self.selling_asset = selling_asset
        self.buying_asset = buying_asset
        self.amount = amount
        self.price_n = price_n
        self.price_d = price_d
        self.source_account = source_account


class StellarSetOptionsOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 215
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("inflation_destination_account", "string", repeated=False, required=False, default=None),
        3: protobuf.Field("clear_flags", "uint32", repeated=False, required=False, default=None),
        4: protobuf.Field("set_flags", "uint32", repeated=False, required=False, default=None),
        5: protobuf.Field("master_weight", "uint32", repeated=False, required=False, default=None),
        6: protobuf.Field("low_threshold", "uint32", repeated=False, required=False, default=None),
        7: protobuf.Field("medium_threshold", "uint32", repeated=False, required=False, default=None),
        8: protobuf.Field("high_threshold", "uint32", repeated=False, required=False, default=None),
        9: protobuf.Field("home_domain", "string", repeated=False, required=False, default=None),
        10: protobuf.Field("signer_type", "StellarSignerType", repeated=False, required=False, default=None),
        11: protobuf.Field("signer_key", "bytes", repeated=False, required=False, default=None),
        12: protobuf.Field("signer_weight", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        source_account: Optional["str"] = None,
        inflation_destination_account: Optional["str"] = None,
        clear_flags: Optional["int"] = None,
        set_flags: Optional["int"] = None,
        master_weight: Optional["int"] = None,
        low_threshold: Optional["int"] = None,
        medium_threshold: Optional["int"] = None,
        high_threshold: Optional["int"] = None,
        home_domain: Optional["str"] = None,
        signer_type: Optional["StellarSignerType"] = None,
        signer_key: Optional["bytes"] = None,
        signer_weight: Optional["int"] = None,
    ) -> None:
        self.source_account = source_account
        self.inflation_destination_account = inflation_destination_account
        self.clear_flags = clear_flags
        self.set_flags = set_flags
        self.master_weight = master_weight
        self.low_threshold = low_threshold
        self.medium_threshold = medium_threshold
        self.high_threshold = high_threshold
        self.home_domain = home_domain
        self.signer_type = signer_type
        self.signer_key = signer_key
        self.signer_weight = signer_weight


class StellarChangeTrustOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 216
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("asset", "StellarAsset", repeated=False, required=True),
        3: protobuf.Field("limit", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        asset: "StellarAsset",
        limit: "int",
        source_account: Optional["str"] = None,
    ) -> None:
        self.asset = asset
        self.limit = limit
        self.source_account = source_account


class StellarAllowTrustOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 217
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("trusted_account", "string", repeated=False, required=True),
        3: protobuf.Field("asset_type", "StellarAssetType", repeated=False, required=True),
        4: protobuf.Field("asset_code", "string", repeated=False, required=False, default=None),
        5: protobuf.Field("is_authorized", "bool", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        trusted_account: "str",
        asset_type: "StellarAssetType",
        is_authorized: "bool",
        source_account: Optional["str"] = None,
        asset_code: Optional["str"] = None,
    ) -> None:
        self.trusted_account = trusted_account
        self.asset_type = asset_type
        self.is_authorized = is_authorized
        self.source_account = source_account
        self.asset_code = asset_code


class StellarAccountMergeOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 218
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("destination_account", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        destination_account: "str",
        source_account: Optional["str"] = None,
    ) -> None:
        self.destination_account = destination_account
        self.source_account = source_account


class StellarManageDataOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 220
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("key", "string", repeated=False, required=True),
        3: protobuf.Field("value", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        key: "str",
        source_account: Optional["str"] = None,
        value: Optional["bytes"] = None,
    ) -> None:
        self.key = key
        self.source_account = source_account
        self.value = value


class StellarBumpSequenceOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 221
    FIELDS = {
        1: protobuf.Field("source_account", "string", repeated=False, required=False, default=None),
        2: protobuf.Field("bump_to", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        bump_to: "int",
        source_account: Optional["str"] = None,
    ) -> None:
        self.bump_to = bump_to
        self.source_account = source_account


class StellarSignedTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 230
    FIELDS = {
        1: protobuf.Field("public_key", "bytes", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        public_key: "bytes",
        signature: "bytes",
    ) -> None:
        self.public_key = public_key
        self.signature = signature


class TezosGetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 150
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class TezosAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 151
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
    ) -> None:
        self.address = address


class TezosGetPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 154
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("show_display", "bool", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        address_n: Optional[Sequence["int"]] = None,
        show_display: Optional["bool"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.show_display = show_display


class TezosPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 155
    FIELDS = {
        1: protobuf.Field("public_key", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        public_key: "str",
    ) -> None:
        self.public_key = public_key


class TezosSignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 152
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False, default=None),
        2: protobuf.Field("branch", "bytes", repeated=False, required=True),
        3: protobuf.Field("reveal", "TezosRevealOp", repeated=False, required=False, default=None),
        4: protobuf.Field("transaction", "TezosTransactionOp", repeated=False, required=False, default=None),
        5: protobuf.Field("origination", "TezosOriginationOp", repeated=False, required=False, default=None),
        6: protobuf.Field("delegation", "TezosDelegationOp", repeated=False, required=False, default=None),
        7: protobuf.Field("proposal", "TezosProposalOp", repeated=False, required=False, default=None),
        8: protobuf.Field("ballot", "TezosBallotOp", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        branch: "bytes",
        address_n: Optional[Sequence["int"]] = None,
        reveal: Optional["TezosRevealOp"] = None,
        transaction: Optional["TezosTransactionOp"] = None,
        origination: Optional["TezosOriginationOp"] = None,
        delegation: Optional["TezosDelegationOp"] = None,
        proposal: Optional["TezosProposalOp"] = None,
        ballot: Optional["TezosBallotOp"] = None,
    ) -> None:
        self.address_n: Sequence["int"] = address_n if address_n is not None else []
        self.branch = branch
        self.reveal = reveal
        self.transaction = transaction
        self.origination = origination
        self.delegation = delegation
        self.proposal = proposal
        self.ballot = ballot


class TezosSignedTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 153
    FIELDS = {
        1: protobuf.Field("signature", "string", repeated=False, required=True),
        2: protobuf.Field("sig_op_contents", "bytes", repeated=False, required=True),
        3: protobuf.Field("operation_hash", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        signature: "str",
        sig_op_contents: "bytes",
        operation_hash: "str",
    ) -> None:
        self.signature = signature
        self.sig_op_contents = sig_op_contents
        self.operation_hash = operation_hash


class TezosContractID(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("tag", "TezosContractType", repeated=False, required=True),
        2: protobuf.Field("hash", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tag: "TezosContractType",
        hash: "bytes",
    ) -> None:
        self.tag = tag
        self.hash = hash


class TezosRevealOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        7: protobuf.Field("source", "bytes", repeated=False, required=True),
        2: protobuf.Field("fee", "uint64", repeated=False, required=True),
        3: protobuf.Field("counter", "uint64", repeated=False, required=True),
        4: protobuf.Field("gas_limit", "uint64", repeated=False, required=True),
        5: protobuf.Field("storage_limit", "uint64", repeated=False, required=True),
        6: protobuf.Field("public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        source: "bytes",
        fee: "int",
        counter: "int",
        gas_limit: "int",
        storage_limit: "int",
        public_key: "bytes",
    ) -> None:
        self.source = source
        self.fee = fee
        self.counter = counter
        self.gas_limit = gas_limit
        self.storage_limit = storage_limit
        self.public_key = public_key


class TezosTransactionOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        9: protobuf.Field("source", "bytes", repeated=False, required=True),
        2: protobuf.Field("fee", "uint64", repeated=False, required=True),
        3: protobuf.Field("counter", "uint64", repeated=False, required=True),
        4: protobuf.Field("gas_limit", "uint64", repeated=False, required=True),
        5: protobuf.Field("storage_limit", "uint64", repeated=False, required=True),
        6: protobuf.Field("amount", "uint64", repeated=False, required=True),
        7: protobuf.Field("destination", "TezosContractID", repeated=False, required=True),
        8: protobuf.Field("parameters", "bytes", repeated=False, required=False, default=None),
        10: protobuf.Field("parameters_manager", "TezosParametersManager", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        source: "bytes",
        fee: "int",
        counter: "int",
        gas_limit: "int",
        storage_limit: "int",
        amount: "int",
        destination: "TezosContractID",
        parameters: Optional["bytes"] = None,
        parameters_manager: Optional["TezosParametersManager"] = None,
    ) -> None:
        self.source = source
        self.fee = fee
        self.counter = counter
        self.gas_limit = gas_limit
        self.storage_limit = storage_limit
        self.amount = amount
        self.destination = destination
        self.parameters = parameters
        self.parameters_manager = parameters_manager


class TezosOriginationOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        12: protobuf.Field("source", "bytes", repeated=False, required=True),
        2: protobuf.Field("fee", "uint64", repeated=False, required=True),
        3: protobuf.Field("counter", "uint64", repeated=False, required=True),
        4: protobuf.Field("gas_limit", "uint64", repeated=False, required=True),
        5: protobuf.Field("storage_limit", "uint64", repeated=False, required=True),
        6: protobuf.Field("manager_pubkey", "bytes", repeated=False, required=False, default=None),
        7: protobuf.Field("balance", "uint64", repeated=False, required=True),
        8: protobuf.Field("spendable", "bool", repeated=False, required=False, default=None),
        9: protobuf.Field("delegatable", "bool", repeated=False, required=False, default=None),
        10: protobuf.Field("delegate", "bytes", repeated=False, required=False, default=None),
        11: protobuf.Field("script", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        source: "bytes",
        fee: "int",
        counter: "int",
        gas_limit: "int",
        storage_limit: "int",
        balance: "int",
        script: "bytes",
        manager_pubkey: Optional["bytes"] = None,
        spendable: Optional["bool"] = None,
        delegatable: Optional["bool"] = None,
        delegate: Optional["bytes"] = None,
    ) -> None:
        self.source = source
        self.fee = fee
        self.counter = counter
        self.gas_limit = gas_limit
        self.storage_limit = storage_limit
        self.balance = balance
        self.script = script
        self.manager_pubkey = manager_pubkey
        self.spendable = spendable
        self.delegatable = delegatable
        self.delegate = delegate


class TezosDelegationOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        7: protobuf.Field("source", "bytes", repeated=False, required=True),
        2: protobuf.Field("fee", "uint64", repeated=False, required=True),
        3: protobuf.Field("counter", "uint64", repeated=False, required=True),
        4: protobuf.Field("gas_limit", "uint64", repeated=False, required=True),
        5: protobuf.Field("storage_limit", "uint64", repeated=False, required=True),
        6: protobuf.Field("delegate", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        source: "bytes",
        fee: "int",
        counter: "int",
        gas_limit: "int",
        storage_limit: "int",
        delegate: "bytes",
    ) -> None:
        self.source = source
        self.fee = fee
        self.counter = counter
        self.gas_limit = gas_limit
        self.storage_limit = storage_limit
        self.delegate = delegate


class TezosProposalOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("source", "bytes", repeated=False, required=True),
        2: protobuf.Field("period", "uint64", repeated=False, required=True),
        4: protobuf.Field("proposals", "bytes", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        source: "bytes",
        period: "int",
        proposals: Optional[Sequence["bytes"]] = None,
    ) -> None:
        self.proposals: Sequence["bytes"] = proposals if proposals is not None else []
        self.source = source
        self.period = period


class TezosBallotOp(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("source", "bytes", repeated=False, required=True),
        2: protobuf.Field("period", "uint64", repeated=False, required=True),
        3: protobuf.Field("proposal", "bytes", repeated=False, required=True),
        4: protobuf.Field("ballot", "TezosBallotType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        source: "bytes",
        period: "int",
        proposal: "bytes",
        ballot: "TezosBallotType",
    ) -> None:
        self.source = source
        self.period = period
        self.proposal = proposal
        self.ballot = ballot


class TezosParametersManager(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("set_delegate", "bytes", repeated=False, required=False, default=None),
        2: protobuf.Field("cancel_delegate", "bool", repeated=False, required=False, default=None),
        3: protobuf.Field("transfer", "TezosManagerTransfer", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        set_delegate: Optional["bytes"] = None,
        cancel_delegate: Optional["bool"] = None,
        transfer: Optional["TezosManagerTransfer"] = None,
    ) -> None:
        self.set_delegate = set_delegate
        self.cancel_delegate = cancel_delegate
        self.transfer = transfer


class TezosManagerTransfer(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("destination", "TezosContractID", repeated=False, required=True),
        2: protobuf.Field("amount", "uint64", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        destination: "TezosContractID",
        amount: "int",
    ) -> None:
        self.destination = destination
        self.amount = amount


class WebAuthnListResidentCredentials(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 800


class WebAuthnAddResidentCredential(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 802
    FIELDS = {
        1: protobuf.Field("credential_id", "bytes", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        credential_id: Optional["bytes"] = None,
    ) -> None:
        self.credential_id = credential_id


class WebAuthnRemoveResidentCredential(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 803
    FIELDS = {
        1: protobuf.Field("index", "uint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        index: Optional["int"] = None,
    ) -> None:
        self.index = index


class WebAuthnCredentials(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 801
    FIELDS = {
        1: protobuf.Field("credentials", "WebAuthnCredential", repeated=True, required=False, default=None),
    }

    def __init__(
        self,
        *,
        credentials: Optional[Sequence["WebAuthnCredential"]] = None,
    ) -> None:
        self.credentials: Sequence["WebAuthnCredential"] = credentials if credentials is not None else []


class WebAuthnCredential(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("index", "uint32", repeated=False, required=False, default=None),
        2: protobuf.Field("id", "bytes", repeated=False, required=False, default=None),
        3: protobuf.Field("rp_id", "string", repeated=False, required=False, default=None),
        4: protobuf.Field("rp_name", "string", repeated=False, required=False, default=None),
        5: protobuf.Field("user_id", "bytes", repeated=False, required=False, default=None),
        6: protobuf.Field("user_name", "string", repeated=False, required=False, default=None),
        7: protobuf.Field("user_display_name", "string", repeated=False, required=False, default=None),
        8: protobuf.Field("creation_time", "uint32", repeated=False, required=False, default=None),
        9: protobuf.Field("hmac_secret", "bool", repeated=False, required=False, default=None),
        10: protobuf.Field("use_sign_count", "bool", repeated=False, required=False, default=None),
        11: protobuf.Field("algorithm", "sint32", repeated=False, required=False, default=None),
        12: protobuf.Field("curve", "sint32", repeated=False, required=False, default=None),
    }

    def __init__(
        self,
        *,
        index: Optional["int"] = None,
        id: Optional["bytes"] = None,
        rp_id: Optional["str"] = None,
        rp_name: Optional["str"] = None,
        user_id: Optional["bytes"] = None,
        user_name: Optional["str"] = None,
        user_display_name: Optional["str"] = None,
        creation_time: Optional["int"] = None,
        hmac_secret: Optional["bool"] = None,
        use_sign_count: Optional["bool"] = None,
        algorithm: Optional["int"] = None,
        curve: Optional["int"] = None,
    ) -> None:
        self.index = index
        self.id = id
        self.rp_id = rp_id
        self.rp_name = rp_name
        self.user_id = user_id
        self.user_name = user_name
        self.user_display_name = user_display_name
        self.creation_time = creation_time
        self.hmac_secret = hmac_secret
        self.use_sign_count = use_sign_count
        self.algorithm = algorithm
        self.curve = curve
