
<p align="center"><img align="center" src=docs/_static/images/magpylib_flag.png ><p>

---
<div>
<p align="center"> Builds:
<a href="https://anaconda.org/conda-forge/magpylib">
<img align='center' src="https://anaconda.org/conda-forge/magpylib/badges/platforms.svg">
  </a>
<a href="https://dev.azure.com/magpylib/magpylib/_build/latest?definitionId=1&branchName=main"> <img align='center' src="https://dev.azure.com/magpylib/magpylib/_apis/build/status/magpylib.magpylib?branchName=main"> </a>
<a href="https://circleci.com/gh/magpylib/magpylib"> <img align='center' src="https://circleci.com/gh/magpylib/magpylib.svg?style=svg"> </a>

</p>

<p align="center"> Documentation:
<a href="https://magpylib.readthedocs.io/en/latest/"> <img align='center' src="https://readthedocs.org/projects/magpylib/badge/?version=latest"> </a>
<a href="https://opensource.org/licenses/BSD-2-Clause"> <img align='center' src="https://img.shields.io/badge/License-BSD_2--Clause-orange.svg"> </a>
</p>

<p align="center"> Test Coverage:
<a href="https://codecov.io/gh/magpylib/magpylib">
  <img src="https://codecov.io/gh/magpylib/magpylib/branch/main/graph/badge.svg" />

</a>
<a href="https://lgtm.com/projects/g/magpylib/magpylib/context:python"><img alt="Language grade: Python" src="https://img.shields.io/lgtm/grade/python/g/magpylib/magpylib.svg?logo=lgtm&logoWidth=18"/></a>
</p>

<p align="center"> Downloads:
<a href="https://pypi.org/project/magpylib/">
<img src="https://badge.fury.io/py/magpylib.svg" alt="PyPI version" height="18"></a>
<a href="https://anaconda.org/conda-forge/magpylib"><img src="https://anaconda.org/conda-forge/magpylib/badges/version.svg" alt="Conda Cloud" height="18"></a>
<a href="https://anaconda.org/conda-forge/magpylib"><img src="https://anaconda.org/conda-forge/magpylib/badges/downloads.svg" alt="Conda Cloud" height="18"></a>
 <a href="https://anaconda.org/conda-forge/magpylib"><img src="https://anaconda.org/conda-forge/magpylib/badges/installer/conda.svg" alt="Conda Cloud" height="18"></a>
</p>

<p align="center"> Try it online:
<a href="https://mybinder.org/v2/gh/magpylib/magpylib/development?filepath=docs%2Fexamples">
<img src="https://mybinder.org/badge_logo.svg" alt="MyBinder link" height="18"></a>
</p>

</div>

---

### What is magpylib ?
Magpylib is a Python package for calculating **3D static magnetic fields** of magnets, line currents and other sources. The computation is based on analytical expressions and therefore **extremely fast**. A **user friendly geometry interface** enables convenient relative positioning between sources and observers.

<p align="center">
    <img align='center' src=docs/_static/images/index/source_fundamentals.png>
</p>

---

### Dependencies:
_Python3.7+_, _Numpy_, _Scipy_, _Matplotlib_, _Plotly_

---

### Documentation & Install:

**Please check out our [documentation](https://magpylib.readthedocs.io/en/latest) for installation, examples and detailed information!**

Magpylib is on PyPI and conda-forge. **Install using pip** (`pip install magpylib`) or **conda** (`conda install magpylib`) package managers.
