from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.1'
DESCRIPTION = 'Rapid base tools package'
# LONG_DESCRIPTION =  'Rapid base tools package'

# Setting up
setup(
    name="NehorayRapid1",
    version=VERSION,
    author="Nehoray melamed",
    author_email="nehoraymelamed@galeoai.com",
    description=DESCRIPTION,
    # long_description_content_type="text/markdown",
    # long_description=long_description,
    packages=find_packages(),
    install_requires=[
"absl-py==1.0.0",
"albumentations==1.1.0",
"astropy==5.0.4",
"asttokens ",
"astunparse==1.6.3",
"atomicwrites==1.4.0",
"attrs==21.4.0",
"backcall ",
"bcrypt==3.2.0",
"brotlipy==0.7.0",
"cachetools==5.0.0",
"certifi ",
"cffi ",
"charset-normalizer==2.0.12",
"cli-exit-tools==1.2.3",
"click==8.1.2",
"colorama",
"colour_demosaicing",
"cryptography ",
"csaps==1.1.0",
"cycler==0.11.0",
"Cython==0.29.28",
"decorator ",
"dill==0.3.4",
"easydict==1.9",
"einops==0.4.1",
"executing ",
"ffmpeg==1.4",
"ffmpeg-python==0.2.0",
"flatbuffers==2.0",
"fonttools==4.32.0",
"future==0.18.2",
"gast==0.5.3",
"google-auth==2.6.4",
"google-auth-oauthlib==0.4.6",
"google-pasta==0.2.0",
"grpcio==1.44.0",
"h5py==3.6.0",
"idna ",
"image-registration==0.2.5",
"imageio==2.16.2",
"imageio-ffmpeg==0.4.7",
"importlib-metadata==4.11.3",
"imutils==0.5.4",
"iniconfig==1.1.1",
"ipython ",
"jedi ",
"joblib ",
"keopscore==2.1",
"keras==2.8.0",
"Keras-Preprocessing==1.1.2",
"kiwisolver==1.4.2",
"klepto==0.2.1",
"kornia==0.6.5",
"kornia-moons==0.2.0",
"lib-detect-testenv==2.0.2",
"lib-programname==2.0.4",
"libclang==13.0.0",
"lmdb==1.3.0",
"Markdown==3.3.6",
"matplotlib==3.5.1",
"matplotlib-inline ",
"mkl-fft==1.3.1",
"mkl-random ",
"mkl-service==2.4.0",
"moviepy==1.0.3",
"natsort==8.1.0",
"networkx==2.8",
"numpngw==0.1.0",
"numpy ",
"oauthlib==3.2.0",
"opencv-python==4.5.5.64",
"opencv-python-headless==4.5.5.64",
"opt-einsum==3.3.0",
"packaging==21.3",
"pandas==1.4.3",
"paramiko==2.10.3",
"parso ",
"pickleshare ",
"Pillow==9.2.0",
"pluggy==1.0.0",
"pox==0.3.0",
"proglog==0.1.10",
"prompt-toolkit ",
"protobuf==3.20.0",
"pure-eval ",
"py==1.11.0",
"pyasn1==0.4.8",
"pyasn1-modules==0.2.8",
"pybind11==2.9.2",
"pycparser ",
"pyerfa==2.0.0.1",
"Pygments ",
"pykeops==2.1",
"PyMsgBox==1.0.9",
"PyNaCl==1.5.0",
"pyOpenSSL ",
"pyparsing==3.0.8",
"PySocks ",
"pytest==7.1.1",
"python-dateutil==2.8.2",
"pytube==12.1.0",
"pytz==2022.1",
"PyWavelets==1.3.0",
"PyYAML==6.0",
"qudida==0.0.4",
"requests ",
"requests-oauthlib==1.3.1",
"rsa==4.8",
"scikit-image==0.19.2",
"scikit-learn ",
"scipy==1.8.0",
"scp==0.14.4",
"seaborn",
"six",
"shapely",
"stack-data ",
"tensorboard==2.8.0",
"tensorboard-data-server==0.6.1",
"tensorboard-plugin-wit==1.8.1",
"tensorboardX==2.5",
"tensorflow==2.8.0",
"tensorflow-io-gcs-filesystem==0.24.0",
"termcolor==1.1.0",
"tf-estimator-nightly==2.8.0.dev2021122109",
"threadpoolctl==3.1.0",
"tifffile==2022.4.8",
"tomli==2.0.1",
"torch-interpol==0.1.1",
"tqdm==4.64.0",
"traitlets ",
"typing_extensions ",
"urllib3 ",
"wcwidth ",
"Werkzeug==2.1.1",
"win-inet-pton ",
"wincertstore==0.2",
"wrapt==1.14.0",
"zipp==3.8.0",
],
    keywords=['nehoray melamed'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)

#python3 setup.py sdist bdist_wheel
#python -m twine upload --repository pypi dist/*