# -*- coding: utf-8 -*-
# Copyright 2023 Cohesity Inc.

class CentrifySchemaEnum(object):

    """Implementation of the 'CentrifySchema' enum.
    Specifies the schema of this Centrify zone. The below list of schemas and
    their values are taken from the document Centrify Server Suite 2016 Windows
    API Programmer's Guide
    https://docs.centrify.com/en/css/suite2016/centrify-win-progguide.pdf
    'kCentrifyDynamicSchema_1_0' specifies dynamic schema, version 1.0.
    'kCentrifyDynamicSchema_2_0' specifies dynamic schema, version 2.0.
    'kCentrifyDynamicSchema_3_0' specifies dynamic schema, version 3.0.
    'kCentrifyDynamicSchema_5_0' specifies dynamic schema, version 5.0.
    'kCentrifySfu_3_0' specifies sfu schema, version 3.0. 'kCentrifySfu_3_0_V5'
    specifies sfu schema, 3.0.5. 'kCentrifySfu_4_0' specifies sfu schema,
    version 4.0. 'kCentrifyCdcRfc2307' specifies cdcrfc2307 schema.
    'kCentrifyCdcRfc2307_2' specifies cdcrfc2307, version 2.
    'kCentrifyCdcRfc2307_3' specifies cdcrfc2307, version 3.


    Attributes:
        KCENTRIFYDYNAMICSCHEMA_1_0: TODO: type description here.
        KCENTRIFYDYNAMICSCHEMA_2_0: TODO: type description here.
        KCENTRIFYSFU_3_0: TODO: type description here.
        KCENTRIFYSFU_4_0: TODO: type description here.
        KCENTRIFYCDCRFC2307: TODO: type description here.
        KCENTRIFYDYNAMICSCHEMA_3_0: TODO: type description here.
        KCENTRIFYCDCRFC2307_2: TODO: type description here.
        KCENTRIFYDYNAMICSCHEMA_5_0: TODO: type description here.
        KCENTRIFYCDCRFC2307_3: TODO: type description here.
        KCENTRIFYSFU_3_0_V5: TODO: type description here.

    """

    KCENTRIFYDYNAMICSCHEMA_1_0 = 'kCentrifyDynamicSchema_1_0'

    KCENTRIFYDYNAMICSCHEMA_2_0 = 'kCentrifyDynamicSchema_2_0'

    KCENTRIFYSFU_3_0 = 'kCentrifySfu_3_0'

    KCENTRIFYSFU_4_0 = 'kCentrifySfu_4_0'

    KCENTRIFYCDCRFC2307 = 'kCentrifyCdcRfc2307'

    KCENTRIFYDYNAMICSCHEMA_3_0 = 'kCentrifyDynamicSchema_3_0'

    KCENTRIFYCDCRFC2307_2 = 'kCentrifyCdcRfc2307_2'

    KCENTRIFYDYNAMICSCHEMA_5_0 = 'kCentrifyDynamicSchema_5_0'

    KCENTRIFYCDCRFC2307_3 = 'kCentrifyCdcRfc2307_3'

    KCENTRIFYSFU_3_0_V5 = 'kCentrifySfu_3_0_V5'
