import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as ga from '@aws-cdk/aws-globalaccelerator';
/**
 * Properties for a ApplicationLoadBalancerEndpoint.
 *
 * @stability stable
 */
export interface ApplicationLoadBalancerEndpointOptions {
    /**
     * Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @stability stable
     */
    readonly weight?: number;
    /**
     * Forward the client IP address in an `X-Forwarded-For` header.
     *
     * GlobalAccelerator will create Network Interfaces in your VPC in order
     * to preserve the client IP address.
     *
     * Client IP address preservation is supported only in specific AWS Regions.
     * See the GlobalAccelerator Developer Guide for a list.
     *
     * @default true if available
     * @stability stable
     */
    readonly preserveClientIp?: boolean;
}
/**
 * Use an Application Load Balancer as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
export declare class ApplicationLoadBalancerEndpoint implements ga.IEndpoint {
    private readonly loadBalancer;
    private readonly options;
    /**
     * The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * @stability stable
     */
    constructor(loadBalancer: elbv2.IApplicationLoadBalancer, options?: ApplicationLoadBalancerEndpointOptions);
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration(): any;
}
