import * as ec2 from '@aws-cdk/aws-ec2';
import * as ga from '@aws-cdk/aws-globalaccelerator';
/**
 * Properties for a NetworkLoadBalancerEndpoint.
 *
 * @stability stable
 */
export interface CfnEipEndpointProps {
    /**
     * Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @stability stable
     */
    readonly weight?: number;
}
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
export declare class CfnEipEndpoint implements ga.IEndpoint {
    private readonly eip;
    private readonly options;
    /**
     * The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * @stability stable
     */
    constructor(eip: ec2.CfnEIP, options?: CfnEipEndpointProps);
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration(): any;
}
