import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as ga from '@aws-cdk/aws-globalaccelerator';
/**
 * Properties for a NetworkLoadBalancerEndpoint.
 *
 * @stability stable
 */
export interface NetworkLoadBalancerEndpointProps {
    /**
     * Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @stability stable
     */
    readonly weight?: number;
}
/**
 * Use a Network Load Balancer as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
export declare class NetworkLoadBalancerEndpoint implements ga.IEndpoint {
    private readonly loadBalancer;
    private readonly options;
    /**
     * The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * @stability stable
     */
    constructor(loadBalancer: elbv2.INetworkLoadBalancer, options?: NetworkLoadBalancerEndpointProps);
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration(): any;
}
