from ...Internal.Core import Core
from ...Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Connection:
	"""Connection commands group definition. 4 total commands, 2 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("connection", core, parent)

	@property
	def cswitched(self):
		"""cswitched commands group. 1 Sub-classes, 0 commands."""
		if not hasattr(self, '_cswitched'):
			from .Connection_.Cswitched import Cswitched
			self._cswitched = Cswitched(self._core, self._base)
		return self._cswitched

	@property
	def ethroughput(self):
		"""ethroughput commands group. 0 Sub-classes, 2 commands."""
		if not hasattr(self, '_ethroughput'):
			from .Connection_.Ethroughput import Ethroughput
			self._ethroughput = Ethroughput(self._core, self._base)
		return self._ethroughput

	def clone(self) -> 'Connection':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Connection(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
