from setuptools import setup

packages = [
    "bw2analyzer>=0.10",
    "bw2calc>=2.0.dev2",
    "bw2data>=4.0.dev4",
    "bw2io>=0.9.dev3",
    "bw2parameters>=0.6.6",
    "bw_processing>=0.3.1",
    "matrix_utils>=0.1.3",
    "mrio_common_metadata>=0.2",
    "bw_migrations>=0.2",
    "numpy>=1.20",
    "scipy",
    "stats_arrays>=0.6.5",
]

setup(
    name='brightway25',
    version="1.0",
    packages=["brightway25"],
    author="Chris Mutel",
    author_email="cmutel@gmail.com",
    license="BSD 3-clause",
    install_requires=packages,
    url="https://github.com/brightway-lca/brightway25",
    description="Wrapper to document and install Brightway 2.5",
    long_description_content_type="text/markdown",
    long_description=open("README.md").read(),
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: BSD License',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3 :: Only',
        'Topic :: Scientific/Engineering :: Information Analysis',
        'Topic :: Scientific/Engineering :: Mathematics',
        'Topic :: Scientific/Engineering :: Visualization',
    ],
)
