# coding: utf-8

"""
    Yagna Activity API

     The Activity API can be perceived as controls which a Requestor-side application has to steer the execution of an Activity as specified in an Agreement which has been negotiated via the Market API/Protocol. This defines possible interactions between the Requestor application (via Activity API) and the generic components running on the Provider node, which host the Provider-side application code. The possible interactions imply a logical “execution environment” component, which is the host/container for the “payload” code. The “execution environment” is specified as an ExeUnit, with a generic interface via which a Provider node’s Activity Controller can operate the hosted code. It conforms with capability level 1 of the [Activity API specification] (https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

from ya_activity.configuration import Configuration


class RuntimeEventKindStarted(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'started': 'object'
    }

    attribute_map = {
        'started': 'started'
    }

    def __init__(self, started=None, local_vars_configuration=None):  # noqa: E501
        """RuntimeEventKindStarted - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._started = None
        self.discriminator = None

        self.started = started

    @property
    def started(self):
        """Gets the started of this RuntimeEventKindStarted.  # noqa: E501

         The specification of ExeScript commands format as per Activity API specification. Including TRANSFER command syntax extension described in [this specification](https://github.com/golemfactory/golem-architecture/blob/master/GIPS/GIP-PR0001-multifile-transfer.md). ## Implementation Notes The schemas have been defined to accept a following format of JSON command collections: ``` [ { \"deploy\": { \"net\": [{ \"id\": \"id\", \"ip\": \"10.0.0.2\", \"mask\": \"255.255.0.0\" }], \"hosts\": {\"master\": \"10.0.0.1\"}, \"nodes\": {\"10.0.0.1\": \"0xdeadbeef\"} } }, { \"start\": { \"args\": [] } }, { \"transfer\": { \"from\": \"http://34.244.4.185:8000/LICENSE\", \"to\": \"container:/input/file_in\", \"format\": \"zip\", \"depth\": 2, \"fileset\": [{\"desc\":\"all images\", \"includes\": [\"*.jpg\"], \"excludes\": [\"db*.*\"] }] } }, { \"run\": { \"entry_point\": \"rust-wasi-tutorial\", \"args\": [\"/input/file_in\", \"/output/file_cp\"] } }, { \"sign\": {} }, { \"terminate\": {} }, ... ] ``` ### Rust For Rust - this format is a default representation of Rust enum types, as serialized by `serde` library. Therefore it is recommended to use this yaml specification to manually specify Rust enum types rather than depend on automatically-generated code.   # noqa: E501

        :return: The started of this RuntimeEventKindStarted.  # noqa: E501
        :rtype: object
        """
        return self._started

    @started.setter
    def started(self, started):
        """Sets the started of this RuntimeEventKindStarted.

         The specification of ExeScript commands format as per Activity API specification. Including TRANSFER command syntax extension described in [this specification](https://github.com/golemfactory/golem-architecture/blob/master/GIPS/GIP-PR0001-multifile-transfer.md). ## Implementation Notes The schemas have been defined to accept a following format of JSON command collections: ``` [ { \"deploy\": { \"net\": [{ \"id\": \"id\", \"ip\": \"10.0.0.2\", \"mask\": \"255.255.0.0\" }], \"hosts\": {\"master\": \"10.0.0.1\"}, \"nodes\": {\"10.0.0.1\": \"0xdeadbeef\"} } }, { \"start\": { \"args\": [] } }, { \"transfer\": { \"from\": \"http://34.244.4.185:8000/LICENSE\", \"to\": \"container:/input/file_in\", \"format\": \"zip\", \"depth\": 2, \"fileset\": [{\"desc\":\"all images\", \"includes\": [\"*.jpg\"], \"excludes\": [\"db*.*\"] }] } }, { \"run\": { \"entry_point\": \"rust-wasi-tutorial\", \"args\": [\"/input/file_in\", \"/output/file_cp\"] } }, { \"sign\": {} }, { \"terminate\": {} }, ... ] ``` ### Rust For Rust - this format is a default representation of Rust enum types, as serialized by `serde` library. Therefore it is recommended to use this yaml specification to manually specify Rust enum types rather than depend on automatically-generated code.   # noqa: E501

        :param started: The started of this RuntimeEventKindStarted.  # noqa: E501
        :type: object
        """
        if self.local_vars_configuration.client_side_validation and started is None:  # noqa: E501
            raise ValueError("Invalid value for `started`, must not be `None`")  # noqa: E501

        self._started = started

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr in self.openapi_types:
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RuntimeEventKindStarted):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RuntimeEventKindStarted):
            return True

        return self.to_dict() != other.to_dict()
