# coding: utf-8

"""
    Yagna Market API

     ## Yagna Market The Yagna Market is a core component of the Yagna Network, which enables computational Offers and Demands circulation. The Market is open for all entities willing to buy computations (Demands) or monetize computational resources (Offers). ## Yagna Market API The Yagna Market API is the entry to the Yagna Market through which Requestors and Providers can publish their Demands and Offers respectively, find matching counterparty, conduct negotiations and make an agreement.  This version of Market API conforms with capability level 1 of the <a href=\"https://docs.google.com/document/d/1Zny_vfgWV-hcsKS7P-Kdr3Fb0dwfl-6T_cYKVQ9mkNg\"> Market API specification</a>.  Market API contains two roles: Requestors and Providers which are symmetrical most of the time (excluding agreement phase).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""

import re  # noqa: F401

# python 2 and python 3 compatibility library


from ya_market.api_client import ApiClient
from ya_market.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class ProviderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def approve_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """ApproveAgreement - Approves Agreement proposed by the Reqestor.  # noqa: E501

        This is a blocking operation. The call may be aborted by Provider caller code. After the call is aborted or timed out, another `approveAgreement` call can be raised on the same `agreementId`.  **Note**: It is expected from the Provider node implementation to “ring-fence” the resources required to fulfill the Agreement before the ApproveAgreement is sent. However, the resources should not be fully committed until `Approved` response is received from the `approveAgreement` call.  **Note**: Mutually exclusive with `rejectAgreement`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.approve_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.approve_agreement_with_http_info(
            agreement_id, **kwargs
        )  # noqa: E501

    def approve_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """ApproveAgreement - Approves Agreement proposed by the Reqestor.  # noqa: E501

        This is a blocking operation. The call may be aborted by Provider caller code. After the call is aborted or timed out, another `approveAgreement` call can be raised on the same `agreementId`.  **Note**: It is expected from the Provider node implementation to “ring-fence” the resources required to fulfill the Agreement before the ApproveAgreement is sent. However, the resources should not be fully committed until `Approved` response is received from the `approveAgreement` call.  **Note**: Mutually exclusive with `rejectAgreement`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.approve_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'agreement_id',
            'app_session_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method approve_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and ('agreement_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['agreement_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agreement_id` when calling `approve_agreement`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `approve_agreement`, must be a value greater than or equal to `0.0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'agreement_id' in local_var_params:
            path_params['agreementId'] = local_var_params['agreement_id']  # noqa: E501

        query_params = []
        if 'app_session_id' in local_var_params and local_var_params['app_session_id'] is not None:  # noqa: E501
            query_params.append(('appSessionId', local_var_params['app_session_id']))  # noqa: E501
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/agreements/{agreementId}/approve",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def collect_agreement_events(self, **kwargs):  # noqa: E501
        """CollectAgreementEvents - Collects events related to an Agreement.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. All events are appearing on both sides equally.  Returns Agreement related events: * `AgreementApprovedEvent` - Indicates that the Agreement has been approved   by the Provider.   - The Provider is now ready to accept a request to start an Activity     as described in the negotiated agreement.   - The Providers’s corresponding `approveAgreement` call returns `Approved`     after this event is emitted.  * `AgreementRejectedEvent` - Indicates that the Provider has called   `rejectAgreement`, which effectively stops the Agreement handshake.   The Requestor may attempt to return to the Negotiation phase by sending   a new Proposal.  * `AgreementCancelledEvent` - Indicates that the Requestor has called   `cancelAgreement`, which effectively stops the Agreement handshake.  * `AgreementTerminatedEvent` - Indicates that the Agreement has been   terminated by specified party (contains signature).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_agreement_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AgreementEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.collect_agreement_events_with_http_info(**kwargs)  # noqa: E501

    def collect_agreement_events_with_http_info(self, **kwargs):  # noqa: E501
        """CollectAgreementEvents - Collects events related to an Agreement.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. All events are appearing on both sides equally.  Returns Agreement related events: * `AgreementApprovedEvent` - Indicates that the Agreement has been approved   by the Provider.   - The Provider is now ready to accept a request to start an Activity     as described in the negotiated agreement.   - The Providers’s corresponding `approveAgreement` call returns `Approved`     after this event is emitted.  * `AgreementRejectedEvent` - Indicates that the Provider has called   `rejectAgreement`, which effectively stops the Agreement handshake.   The Requestor may attempt to return to the Negotiation phase by sending   a new Proposal.  * `AgreementCancelledEvent` - Indicates that the Requestor has called   `cancelAgreement`, which effectively stops the Agreement handshake.  * `AgreementTerminatedEvent` - Indicates that the Agreement has been   terminated by specified party (contains signature).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_agreement_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AgreementEvent], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'after_timestamp',
            'max_events',
            'app_session_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_agreement_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `collect_agreement_events`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_agreement_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_agreement_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501
        if 'app_session_id' in local_var_params and local_var_params['app_session_id'] is not None:  # noqa: E501
            query_params.append(('appSessionId', local_var_params['app_session_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/agreementEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AgreementEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def collect_demands(self, subscription_id, **kwargs):  # noqa: E501
        """CollectDemands - Reads Market responses to published Offer.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. Returns Proposal related events: * `ProposalEvent` - Indicates that there is new Demand Proposal for this Offer. * `ProposalRejectedEvent` - Indicates that the Requestor has rejected   our previous Proposal related to this Offer. This effectively ends a   Negotiation chain - it explicitly indicates that the sender will not   create another counter-Proposal.  * `AgreementEvent` - Indicates that the Requestor is accepting our   previous Proposal and ask for our approval of the Agreement.  * `PropertyQueryEvent` - not supported yet.  **Note**: When `collectDemands` is waiting, simultaneous call to `unsubscribeOffer` on the same `subscriptionId` should result in \"Subscription does not exist\" error returned from `collectDemands`.  **Note**: Specification requires this endpoint to support list of specific Proposal Ids to listen for messages related only to specific Proposals. This is not covered yet.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_demands(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param int max_events: Maximum number of events that server should return at once. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Event]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.collect_demands_with_http_info(
            subscription_id, **kwargs
        )  # noqa: E501

    def collect_demands_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """CollectDemands - Reads Market responses to published Offer.  # noqa: E501

        This is a blocking operation. It will not return until there is at least one new event. Returns Proposal related events: * `ProposalEvent` - Indicates that there is new Demand Proposal for this Offer. * `ProposalRejectedEvent` - Indicates that the Requestor has rejected   our previous Proposal related to this Offer. This effectively ends a   Negotiation chain - it explicitly indicates that the sender will not   create another counter-Proposal.  * `AgreementEvent` - Indicates that the Requestor is accepting our   previous Proposal and ask for our approval of the Agreement.  * `PropertyQueryEvent` - not supported yet.  **Note**: When `collectDemands` is waiting, simultaneous call to `unsubscribeOffer` on the same `subscriptionId` should result in \"Subscription does not exist\" error returned from `collectDemands`.  **Note**: Specification requires this endpoint to support list of specific Proposal Ids to listen for messages related only to specific Proposals. This is not covered yet.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_demands_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param int max_events: Maximum number of events that server should return at once. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Event], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'timeout',
            'max_events'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_demands" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `collect_demands`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `collect_demands`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_demands`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `collect_demands`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/offers/{subscriptionId}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Event]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def counter_proposal_offer(self, subscription_id, proposal_id, demand_offer_base, **kwargs):  # noqa: E501
        """CounterProposalOffer - Responds with a bespoke Offer to received Demand.  # noqa: E501

        Creates and sends a modified version of original Offer (a counter-proposal) adjusted to previously received Proposal (ie. Demand). Changes Proposal state to `Draft`. Returns created Proposal id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.counter_proposal_offer(subscription_id, proposal_id, demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param DemandOfferBase demand_offer_base: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.counter_proposal_offer_with_http_info(subscription_id, proposal_id, demand_offer_base, **kwargs)  # noqa: E501

    def counter_proposal_offer_with_http_info(self, subscription_id, proposal_id, demand_offer_base, **kwargs):  # noqa: E501
        """CounterProposalOffer - Responds with a bespoke Offer to received Demand.  # noqa: E501

        Creates and sends a modified version of original Offer (a counter-proposal) adjusted to previously received Proposal (ie. Demand). Changes Proposal state to `Draft`. Returns created Proposal id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.counter_proposal_offer_with_http_info(subscription_id, proposal_id, demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param DemandOfferBase demand_offer_base: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'proposal_id',
            'demand_offer_base'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method counter_proposal_offer" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `counter_proposal_offer`")  # noqa: E501
        # verify the required parameter 'proposal_id' is set
        if self.api_client.client_side_validation and ('proposal_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['proposal_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proposal_id` when calling `counter_proposal_offer`")  # noqa: E501
        # verify the required parameter 'demand_offer_base' is set
        if self.api_client.client_side_validation and ('demand_offer_base' not in local_var_params or  # noqa: E501
                                                        local_var_params['demand_offer_base'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `demand_offer_base` when calling `counter_proposal_offer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501
        if 'proposal_id' in local_var_params:
            path_params['proposalId'] = local_var_params['proposal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'demand_offer_base' in local_var_params:
            body_params = local_var_params['demand_offer_base']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/offers/{subscriptionId}/proposals/{proposalId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """GetAgreement - Fetches agreement with given agreement id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Agreement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_agreement_with_http_info(agreement_id, **kwargs)  # noqa: E501

    def get_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """GetAgreement - Fetches agreement with given agreement id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Agreement, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["agreement_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and (
            "agreement_id" not in local_var_params
            or local_var_params["agreement_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `agreement_id` when calling `get_agreement`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agreement_id" in local_var_params:
            path_params["agreementId"] = local_var_params["agreement_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/agreements/{agreementId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Agreement",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_offers(self, **kwargs):  # noqa: E501
        """GetOffers - Fetches all active Offers which have been published by the Provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_offers(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Offer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_offers_with_http_info(**kwargs)  # noqa: E501

    def get_offers_with_http_info(self, **kwargs):  # noqa: E501
        """GetOffers - Fetches all active Offers which have been published by the Provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_offers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Offer], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_offers" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/offers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Offer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_proposal_demand(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """GetProposalDemand - Fetches Proposal (Demand) with given id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proposal_demand(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Proposal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_proposal_demand_with_http_info(subscription_id, proposal_id, **kwargs)  # noqa: E501

    def get_proposal_demand_with_http_info(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """GetProposalDemand - Fetches Proposal (Demand) with given id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proposal_demand_with_http_info(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Proposal, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["subscription_id", "proposal_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_proposal_demand" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and (
            "subscription_id" not in local_var_params
            or local_var_params["subscription_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `subscription_id` when calling `get_proposal_demand`"
            )  # noqa: E501
        # verify the required parameter 'proposal_id' is set
        if self.api_client.client_side_validation and (
            "proposal_id" not in local_var_params
            or local_var_params["proposal_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `proposal_id` when calling `get_proposal_demand`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "subscription_id" in local_var_params:
            path_params["subscriptionId"] = local_var_params[
                "subscription_id"
            ]  # noqa: E501
        if "proposal_id" in local_var_params:
            path_params["proposalId"] = local_var_params["proposal_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/offers/{subscriptionId}/proposals/{proposalId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Proposal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_reply_offers(self, subscription_id, query_id, body, **kwargs):  # noqa: E501
        """QueryReplyOffers - Handles dynamic property query.  # noqa: E501

        Sends a response to a received property value query.  The Market Matching Mechanism, when resolving the match relation for the specific Demand-Offer pair, is to detect the “dynamic” properties required (via constraints) by the other side. At this point, it is able to query the issuing node for those properties and submit the other side’s requested properties as the context of the query.  **Note**: The property query responses may be submitted in “chunks”, ie. the responder may choose to resolve ‘quick’/lightweight’ properties faster and provide response sooner, while still working on more time-consuming properties in the background. Therefore the response contains both the resolved properties, as well as list of properties which responder knows still require resolution.  **Note**: This method must be implemented for Market API Capability Level 2.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_reply_offers(subscription_id, query_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str query_id: (required)
        :param object body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_reply_offers_with_http_info(subscription_id, query_id, body, **kwargs)  # noqa: E501

    def query_reply_offers_with_http_info(self, subscription_id, query_id, body, **kwargs):  # noqa: E501
        """QueryReplyOffers - Handles dynamic property query.  # noqa: E501

        Sends a response to a received property value query.  The Market Matching Mechanism, when resolving the match relation for the specific Demand-Offer pair, is to detect the “dynamic” properties required (via constraints) by the other side. At this point, it is able to query the issuing node for those properties and submit the other side’s requested properties as the context of the query.  **Note**: The property query responses may be submitted in “chunks”, ie. the responder may choose to resolve ‘quick’/lightweight’ properties faster and provide response sooner, while still working on more time-consuming properties in the background. Therefore the response contains both the resolved properties, as well as list of properties which responder knows still require resolution.  **Note**: This method must be implemented for Market API Capability Level 2.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_reply_offers_with_http_info(subscription_id, query_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str query_id: (required)
        :param object body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'query_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_reply_offers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `query_reply_offers`")  # noqa: E501
        # verify the required parameter 'query_id' is set
        if self.api_client.client_side_validation and ('query_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['query_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `query_id` when calling `query_reply_offers`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `query_reply_offers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501
        if 'query_id' in local_var_params:
            path_params['queryId'] = local_var_params['query_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/offers/{subscriptionId}/propertyQuery/{queryId}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def reject_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """RejectAgreement - Rejects Agreement proposed by the Requestor.  # noqa: E501

        The Requestor side is notified about the Provider’s decision to reject a negotiated agreement. This effectively stops the Agreement handshake.  **Note**: Mutually exclusive with `approveAgreement`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.reject_agreement_with_http_info(
            agreement_id, **kwargs
        )  # noqa: E501

    def reject_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """RejectAgreement - Rejects Agreement proposed by the Requestor.  # noqa: E501

        The Requestor side is notified about the Provider’s decision to reject a negotiated agreement. This effectively stops the Agreement handshake.  **Note**: Mutually exclusive with `approveAgreement`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'agreement_id',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and ('agreement_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['agreement_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agreement_id` when calling `reject_agreement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agreement_id' in local_var_params:
            path_params['agreementId'] = local_var_params['agreement_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/agreements/{agreementId}/reject', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reject_proposal_demand(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """RejectProposalDemand - Rejects Proposal (Demand).  # noqa: E501

        Effectively ends a Negotiation chain - it explicitly indicates that the sender will not create another counter-Proposal.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_proposal_demand(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param dict(str, object) request_body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reject_proposal_demand_with_http_info(subscription_id, proposal_id, **kwargs)  # noqa: E501

    def reject_proposal_demand_with_http_info(self, subscription_id, proposal_id, **kwargs):  # noqa: E501
        """RejectProposalDemand - Rejects Proposal (Demand).  # noqa: E501

        Effectively ends a Negotiation chain - it explicitly indicates that the sender will not create another counter-Proposal.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_proposal_demand_with_http_info(subscription_id, proposal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param str proposal_id: (required)
        :param dict(str, object) request_body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'subscription_id',
            'proposal_id',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_proposal_demand" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and ('subscription_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['subscription_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscription_id` when calling `reject_proposal_demand`")  # noqa: E501
        # verify the required parameter 'proposal_id' is set
        if self.api_client.client_side_validation and ('proposal_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['proposal_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proposal_id` when calling `reject_proposal_demand`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in local_var_params:
            path_params['subscriptionId'] = local_var_params['subscription_id']  # noqa: E501
        if 'proposal_id' in local_var_params:
            path_params['proposalId'] = local_var_params['proposal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/offers/{subscriptionId}/proposals/{proposalId}/reject', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def subscribe_offer(self, demand_offer_base, **kwargs):  # noqa: E501
        """SubscribeOffer - Publishes Provider capabilities via Offer.  # noqa: E501

        Offer object can be considered an \"open\" or public Offer, as it is not directed at a specific Requestor, but rather is sent to the market so that the matching mechanism implementation can associate relevant Demands.  **Note**: it is an \"atomic\" operation, ie. as soon as Subscription is placed, the Offer is published on the market.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_offer(demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DemandOfferBase demand_offer_base: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.subscribe_offer_with_http_info(demand_offer_base, **kwargs)  # noqa: E501

    def subscribe_offer_with_http_info(self, demand_offer_base, **kwargs):  # noqa: E501
        """SubscribeOffer - Publishes Provider capabilities via Offer.  # noqa: E501

        Offer object can be considered an \"open\" or public Offer, as it is not directed at a specific Requestor, but rather is sent to the market so that the matching mechanism implementation can associate relevant Demands.  **Note**: it is an \"atomic\" operation, ie. as soon as Subscription is placed, the Offer is published on the market.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_offer_with_http_info(demand_offer_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DemandOfferBase demand_offer_base: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'demand_offer_base'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_offer" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'demand_offer_base' is set
        if self.api_client.client_side_validation and ('demand_offer_base' not in local_var_params or  # noqa: E501
                                                        local_var_params['demand_offer_base'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `demand_offer_base` when calling `subscribe_offer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'demand_offer_base' in local_var_params:
            body_params = local_var_params['demand_offer_base']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/offers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def terminate_agreement(self, agreement_id, **kwargs):  # noqa: E501
        """TerminateAgreement - Terminates approved Agreement.  # noqa: E501

        Method to finish/close the Agreement while in `Approved` state.  The other party gets notified about calling party decision to terminate a \"running\" agreement.  **Note**: Can be invoked at any time after Agreement was approved by both sides.  **Note**: Financial and reputational consequences are not defined by this specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.terminate_agreement(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.terminate_agreement_with_http_info(
            agreement_id, **kwargs
        )  # noqa: E501

    def terminate_agreement_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """TerminateAgreement - Terminates approved Agreement.  # noqa: E501

        Method to finish/close the Agreement while in `Approved` state.  The other party gets notified about calling party decision to terminate a \"running\" agreement.  **Note**: Can be invoked at any time after Agreement was approved by both sides.  **Note**: Financial and reputational consequences are not defined by this specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.terminate_agreement_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str agreement_id: (required)
        :param dict(str, object) request_body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'agreement_id',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method terminate_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and ('agreement_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['agreement_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agreement_id` when calling `terminate_agreement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agreement_id' in local_var_params:
            path_params['agreementId'] = local_var_params['agreement_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/agreements/{agreementId}/terminate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def unsubscribe_offer(self, subscription_id, **kwargs):  # noqa: E501
        """UnsubscribeOffer - Stop subscription for previously published Offer.  # noqa: E501

        Stop receiving Proposals.  **Note**: this will terminate all pending `collectDemands` calls on this subscription. This implies, that client code should not `unsubscribeOffer` before it has received all expected/useful inputs from `collectDemands`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unsubscribe_offer(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.unsubscribe_offer_with_http_info(
            subscription_id, **kwargs
        )  # noqa: E501

    def unsubscribe_offer_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """UnsubscribeOffer - Stop subscription for previously published Offer.  # noqa: E501

        Stop receiving Proposals.  **Note**: this will terminate all pending `collectDemands` calls on this subscription. This implies, that client code should not `unsubscribeOffer` before it has received all expected/useful inputs from `collectDemands`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unsubscribe_offer_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str subscription_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["subscription_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unsubscribe_offer" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'subscription_id' is set
        if self.api_client.client_side_validation and (
            "subscription_id" not in local_var_params
            or local_var_params["subscription_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `subscription_id` when calling `unsubscribe_offer`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "subscription_id" in local_var_params:
            path_params["subscriptionId"] = local_var_params[
                "subscription_id"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/offers/{subscriptionId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
