## _Fasta Sequences File Splitter_ (fasta-splitter)

> Command line tool to split one multiple sequences fasta file into individual sequences fasta files.

### Supported Operating Systems

---
<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/d/dd/Linux_logo.jpg/640px-Linux_logo.jpg" alt="drawing" title="Linux" height="48" width="42"/> <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/c9/Finder_Icon_macOS_Big_Sur.png/640px-Finder_Icon_macOS_Big_Sur.png" alt="drawing" title="macOS" height="52" width="52"/> <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/8/87/Windows_logo_-_2021.svg/800px-Windows_logo_-_2021.svg.png" alt="drawing" title="Windows" height="40" width="40"/>

### Documentation

---
Official Documentation on **[ReadTheDocs](https://fasta-splitter.readthedocs.io "fasta-splitter")**.

### Project Info

---
|  |  |
| ------ | ------ |
| `Continuous Integration (GitHub Actions)` | [![Linux CI](https://github.com/alan-lira/fasta-splitter/actions/workflows/linux_ci.yml/badge.svg)](https://github.com/alan-lira/fasta-splitter/actions/workflows/linux_ci.yml) <br> [![macOS CI](https://github.com/alan-lira/fasta-splitter/actions/workflows/macos_ci.yml/badge.svg)](https://github.com/alan-lira/fasta-splitter/actions/workflows/macos_ci.yml) <br> [![Windows CI](https://github.com/alan-lira/fasta-splitter/actions/workflows/windows_ci.yml/badge.svg)](https://github.com/alan-lira/fasta-splitter/actions/workflows/windows_ci.yml) |
| `Code Coverage (Codecov)` | [![codecov](https://codecov.io/gh/alan-lira/fasta-splitter/branch/main/graph/badge.svg)](https://codecov.io/gh/alan-lira/fasta-splitter) |
| `Vulnerabilities (Snyk)` | [![Known Vulnerabilities](https://snyk.io/test/github/alan-lira/fasta-splitter/badge.svg)](https://snyk.io/test/github/alan-lira/fasta-splitter) |
| `Maintainability (Code Climate)` | [![Maintainability](https://api.codeclimate.com/v1/badges/93ea9bc426ee119d0660/maintainability)](https://codeclimate.com/github/alan-lira/fasta-splitter/maintainability) |
| `Documentation (Read the Docs)` | [![Documentation Status](https://readthedocs.org/projects/fasta-splitter/badge/?version=latest)](https://fasta-splitter.readthedocs.io/en/latest/?badge=latest) |
| `Issues` | ![GitHub issues](https://img.shields.io/github/issues/alan-lira/fasta-splitter) |
| `Languages` | ![GitHub language count](https://img.shields.io/github/languages/count/alan-lira/fasta-splitter) <br> ![GitHub top language](https://img.shields.io/github/languages/top/alan-lira/fasta-splitter)|
| `Lines of Code` | ![Lines of code](https://img.shields.io/tokei/lines/github/alan-lira/fasta-splitter?label=lines%20of%20code) |
| `Code Size` | ![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/alan-lira/fasta-splitter) |
| `Repository Size` | ![GitHub repo size](https://img.shields.io/github/repo-size/alan-lira/fasta-splitter) |
| `Contributors Count` | ![GitHub contributors](https://img.shields.io/github/contributors/alan-lira/fasta-splitter) |
| `Last Commit Date` | ![GitHub last commit](https://img.shields.io/github/last-commit/alan-lira/fasta-splitter) |
| `Latest Tag` | ![GitHub tag (latest SemVer pre-release)](https://img.shields.io/github/v/tag/alan-lira/fasta-splitter?include_prereleases&sort=semver) |

### GitHub Releases Info

---
|  |  |
| ------ | ------ |
| `Total Downloads (All Releases)` | ![GitHub all releases](https://img.shields.io/github/downloads/alan-lira/fasta-splitter/total) |
| `Release Date` | ![GitHub Release Date](https://img.shields.io/github/release-date/alan-lira/fasta-splitter) |
| `Latest Release` | ![GitHub release (latest SemVer including pre-releases)](https://img.shields.io/github/v/release/alan-lira/fasta-splitter?include_prereleases&sort=semver) |
| `Latest Release Total Downloads` | ![GitHub release (latest by SemVer including pre-releases)](https://img.shields.io/github/downloads-pre/alan-lira/fasta-splitter/latest/total?sort=semver) |
| `Commits Since Latest Release` | ![GitHub commits since latest release (by SemVer including pre-releases)](https://img.shields.io/github/commits-since/alan-lira/fasta-splitter/latest?include_prereleases&sort=semver) |

### PyPI Releases Info

---
|  |  |
| ------ | ------ |
| `Total Downloads` | ![PyPI - Downloads](https://img.shields.io/pypi/dm/fasta-splitter) |
| `Latest Release` | ![PyPI](https://img.shields.io/pypi/v/fasta-splitter) |
| `Status` | ![PyPI - Status](https://img.shields.io/pypi/status/fasta-splitter) |
| `Python Versions` | ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/fasta-splitter) |

### License Info

---
|  |  |
| ------ | ------ |
| `License Type` | ![GitHub](https://img.shields.io/github/license/alan-lira/fasta-splitter?color=blue) |
| `License Scan (FOSSA)` | [![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Falan-lira%2Ffasta-splitter.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%2Falan-lira%2Ffasta-splitter?ref=badge_shield) |
