"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3 = require("@aws-cdk/aws-s3");
/**
 * @stability stable
 */
class PrivateBucket extends s3.Bucket {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        let encryption = s3.BucketEncryption.S3_MANAGED;
        if (props.encryption && props.encryption !== "NONE") {
            encryption = props.encryption;
        }
        super(scope, id, {
            ...props,
            encryption: encryption,
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
        });
    }
}
exports.PrivateBucket = PrivateBucket;
_a = JSII_RTTI_SYMBOL_1;
PrivateBucket[_a] = { fqn: "@pepperize/cdk-private-bucket.PrivateBucket", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxzQ0FBc0M7Ozs7QUFNdEMsTUFBYSxhQUFjLFNBQVEsRUFBRSxDQUFDLE1BQU07Ozs7SUFDMUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE0QixFQUFFO1FBQ3RFLElBQUksVUFBVSxHQUF3QixFQUFFLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxDQUFDO1FBQ3JFLElBQUksS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLE1BQU0sRUFBRTtZQUNuRCxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztTQUMvQjtRQUNELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsR0FBRyxLQUFLO1lBQ1IsVUFBVSxFQUFFLFVBQVU7WUFDdEIsaUJBQWlCLEVBQUUsRUFBRSxDQUFDLGlCQUFpQixDQUFDLFNBQVM7WUFDakQsVUFBVSxFQUFFLElBQUk7U0FDakIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFaSCxzQ0FhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHMzIGZyb20gXCJAYXdzLWNkay9hd3MtczNcIjtcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcIkBhd3MtY2RrL2NvcmVcIjtcblxuZXhwb3J0IGludGVyZmFjZSBQcml2YXRlQnVja2V0UHJvcHMgZXh0ZW5kcyBzMy5CdWNrZXRQcm9wcyB7fVxuXG5leHBvcnQgY2xhc3MgUHJpdmF0ZUJ1Y2tldCBleHRlbmRzIHMzLkJ1Y2tldCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBQcml2YXRlQnVja2V0UHJvcHMgPSB7fSkge1xuICAgIGxldCBlbmNyeXB0aW9uOiBzMy5CdWNrZXRFbmNyeXB0aW9uID0gczMuQnVja2V0RW5jcnlwdGlvbi5TM19NQU5BR0VEO1xuICAgIGlmIChwcm9wcy5lbmNyeXB0aW9uICYmIHByb3BzLmVuY3J5cHRpb24gIT09IFwiTk9ORVwiKSB7XG4gICAgICBlbmNyeXB0aW9uID0gcHJvcHMuZW5jcnlwdGlvbjtcbiAgICB9XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGVuY3J5cHRpb246IGVuY3J5cHRpb24sXG4gICAgICBibG9ja1B1YmxpY0FjY2VzczogczMuQmxvY2tQdWJsaWNBY2Nlc3MuQkxPQ0tfQUxMLFxuICAgICAgZW5mb3JjZVNTTDogdHJ1ZSxcbiAgICB9KTtcbiAgfVxufVxuIl19