# Generated by Django 4.2.23 on 2025-07-11 09:10

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('securegroups', '0017_filterexpression'),
        ('eveonline', '0017_alliance_and_corp_names_are_not_unique'),
        ('auth', '0012_alter_user_first_name_max_length'),
        ('corptools', '0121_charassetcoordiante'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='General',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('hr_access', 'Can access HR Centre'),),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='CharacterAuditLoginData',
            fields=[
                ('characteraudit', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='login_data', serialize=False, to='corptools.characteraudit')),
                ('last_login', models.DateTimeField(blank=True, null=True)),
                ('last_update', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Label',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True)),
                ('color', models.CharField(choices=[('blue', 'Blue'), ('red', 'Red'), ('green', 'Green'), ('yellow', 'Yellow')], default='blue', max_length=16)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='LabelGrouping',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True)),
                ('description', models.TextField(blank=True, default='')),
                ('can_self_assign', models.BooleanField(default=False)),
                ('multiple_selection', models.BooleanField(default=False)),
                ('allow_empty', models.BooleanField(default=True)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='UsersCheck',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, default='', max_length=255)),
                ('filters', models.ManyToManyField(related_name='+', to='securegroups.smartfilter')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='UserNotes',
            fields=[
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='hr_notes', serialize=False, to=settings.AUTH_USER_MODEL)),
                ('notes', models.TextField(blank=True, default='')),
                ('added_on', models.DateTimeField(auto_now_add=True)),
                ('last_updated_on', models.DateTimeField(auto_now=True)),
                ('added_by', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('last_updated_by', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='UserLabel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('added_on', models.DateTimeField(auto_now_add=True)),
                ('added_by', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_labels', to='hrcentre.label')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='hr_labels', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.AddField(
            model_name='label',
            name='grouping',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='options', to='hrcentre.labelgrouping'),
        ),
        migrations.CreateModel(
            name='CorporationSetup',
            fields=[
                ('corporation', models.OneToOneField(on_delete=django.db.models.deletion.RESTRICT, primary_key=True, related_name='hrcentre_setup', serialize=False, to='eveonline.evecorporationinfo')),
                ('access_list', models.ManyToManyField(blank=True, related_name='+', to='auth.group')),
                ('checks', models.ManyToManyField(blank=True, to='hrcentre.userscheck')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='AllianceSetup',
            fields=[
                ('alliance', models.OneToOneField(on_delete=django.db.models.deletion.RESTRICT, primary_key=True, related_name='hrcentre_setup', serialize=False, to='eveonline.eveallianceinfo')),
                ('access_list', models.ManyToManyField(blank=True, related_name='+', to='auth.group')),
                ('checks', models.ManyToManyField(blank=True, to='hrcentre.userscheck')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.AddConstraint(
            model_name='userlabel',
            constraint=models.UniqueConstraint(fields=('user', 'label'), name='unique_user_label'),
        ),
    ]
