# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fRAT', 'fRAT.utils']

package_data = \
{'': ['*'],
 'fRAT': ['configuration_profiles/*',
          'configuration_profiles/maps/*',
          'configuration_profiles/roi_analysis/*',
          'images/*']}

install_requires = \
['altgraph==0.17.2',
 'bootstrapped==0.0.2',
 'brotli==1.0.9',
 'certifi==2022.12.7',
 'chardet==3.0.4',
 'charset-normalizer==2.0.12',
 'ci-info==0.2.0',
 'click==7.1.1',
 'contourpy==1.0.7',
 'cycler==0.10.0',
 'cython==0.29.21',
 'dash-core-components==1.15.0',
 'dash-html-components==1.1.2',
 'dash-renderer==1.9.0',
 'dash-table==4.11.2',
 'dash==1.19.0',
 'dataclasses==0.6',
 'decorator==4.4.2',
 'descartes==1.1.0',
 'dill==0.3.6',
 'dominate==2.6.0',
 'etelemetry==0.2.2',
 'filelock==3.0.12',
 'flask-compress==1.8.0',
 'flask==1.1.2',
 'fonttools==4.38.0',
 'fslpy==3.4.0',
 'funcsigs==1.0.2',
 'future==0.18.2',
 'gevent==22.10.2',
 'greenlet==2.0.2',
 'h5py==3.8.0',
 'idna==2.9',
 'imageio==2.9.0',
 'isodate==0.6.0',
 'itsdangerous==1.1.0',
 'jinja2==2.11.3',
 'joblib==1.2.0',
 'kiwisolver==1.4.4',
 'looseversion==1.0.1',
 'lxml==4.9.2',
 'macholib==1.15.2',
 'markupsafe==1.1.1',
 'matplotlib==3.6.3',
 'mizani==0.8.1',
 'multiprocess==0.70.14',
 'networkx==2.4',
 'neurdflib==5.0.1',
 'nibabel==3.2.1',
 'nilearn==0.9.0',
 'nipype==1.8.4',
 'numpy==1.22.3',
 'packaging==23.0',
 'palettable==3.3.0',
 'pandas==1.5.3',
 'pathos==0.2.6',
 'patsy==0.5.3',
 'pillow==9.3.0',
 'pip-autoremove==0.10.0',
 'plotly==4.14.3',
 'plotnine==0.10.1',
 'pox==0.2.8',
 'ppft==1.6.6.2',
 'prov==1.5.3',
 'pydot==1.4.1',
 'pydotplus==2.0.2',
 'pyinstaller-hooks-contrib==2022.2',
 'pyinstaller==4.9',
 'pyparsing==2.4.6',
 'python-dateutil==2.8.1',
 'pytz==2022.7.1',
 'pywavelets==1.4.1',
 'rdflib==5.0.0',
 'requests==2.27.1',
 'retrying==1.3.3',
 'scikit-image==0.19.3',
 'scikit-learn==1.2.1',
 'scipy==1.10.0',
 'simplejson==3.17.0',
 'six==1.14.0',
 'sklearn==0.0',
 'statsmodels==0.13.5',
 'tabulate==0.8.9',
 'tenacity==8.2.0',
 'threadpoolctl==2.1.0',
 'tifffile==2021.7.30',
 'toml==0.10.2',
 'traits==6.3.2',
 'urllib3==1.26.5',
 'werkzeug==1.0.1',
 'xlrd==1.2.0',
 'xmltodict==0.12.0',
 'zope-event==4.5.0',
 'zope-interface==5.2.0']

entry_points = \
{'console_scripts': ['fRAT = fRAT.__main__:start_gui']}

setup_kwargs = {
    'name': 'frat-brain',
    'version': '1.2.0',
    'description': 'Application for ROI fMRI data analysis.',
    'long_description': '<img src="https://github.com/elliohow/fMRI_ROI_Analysis_Tool/blob/master/docs/images/fRAT.gif?raw=true" width=500>\n\n# fRAT - fMRI ROI Analysis Tool\n[![status](https://joss.theoj.org/papers/cc9c0cb3b12abaf30c8381728d3229d7/status.svg)](https://joss.theoj.org/papers/cc9c0cb3b12abaf30c8381728d3229d7)\n[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com) \n[![GitHub license](https://img.shields.io/hexpm/l/plug?style=flat-square)](https://github.com/elliohow/fMRI_ROI_Analysis_Tool/blob/master/LICENSE)\n[![Github release (latest by date)](https://img.shields.io/github/v/release/elliohow/fmri_roi_analysis_tool?style=flat-square)](https://github.com/elliohow/fmri_roi_analysis_tool/releases/latest)\n[![Github issues](https://img.shields.io/github/issues/elliohow/fmri_roi_analysis_tool?style=flat-square)](https://github.com/elliohow/fmri_roi_analysis_tool/issues)\n[![Documentation](https://img.shields.io/readthedocs/fmri-roi-analysis-tool)](https://fmri-roi-analysis-tool.readthedocs.io/en/latest/)\n\nfRAT is an open-source python-based GUI application used to simplify the processing and analysis of fMRI data by\nconverting voxelwise maps into ROI-wise maps. An installation of FSL is required in order to use fRAT.\n\n> fRAT is written using **Python** for **MacOS, Linux and WSL2**.\n\nDocumentation:\n\n[Home page](https://fmri-roi-analysis-tool.readthedocs.io)\n\n[Installation instructions](https://fmri-roi-analysis-tool.readthedocs.io/en/latest/installation.html)\n\n[ROI analysis tutorial](https://fmri-roi-analysis-tool.readthedocs.io/en/latest/tutorials/Basic-ROI-analysis.html)\n\n## Reporting bugs\n\nTo report a bug, please go to [fRAT\'s Issues](https://github.com/elliohow/fMRI_ROI_Analysis_Tool/issues/new).\n\nFor other questions, issues or discussion please go to [fRAT\'s Discussions](https://github.com/elliohow/fMRI_ROI_Analysis_Tool/discussions).\n\n## Contributing with development\n\nThe [Fork & Pull Request Workflow](https://docs.github.com/en/get-started/quickstart/contributing-to-projects) is used for contributing. Below is a summary of the necessary steps for this workflow:\n\n1. Fork this repository.\n2. Clone the repository at your machine.\n3. Add your changes in a branch named after the feature (`lower-case-with-hyphens`).\n4. Make a pull request to `fRAT`, targeting the `master` branch.\n\n## Images\n<img src="https://github.com/elliohow/fMRI_ROI_Analysis_Tool/blob/master/docs/images/GUI.png?raw=true" title="Example of the fRAT GUI" width=700>\n\n<img src="https://github.com/elliohow/fMRI_ROI_Analysis_Tool/blob/master/docs/images/ROI_example.png?raw=true" \n  title="A region of interest map created using fRAT, showing the mean temporal Signal-to-Noise for each region. Data is displayed in MNI152 standard space and combines data from multiple subjects." \nwidth=700>\n\n<img src="https://github.com/elliohow/fMRI_ROI_Analysis_Tool/blob/master/docs/images/HTML_report.png?raw=true" title="Example of a HTML report output by fRAT" width=600>\n\n## Versioning\nWe use [Semantic versioning](http://semver.org/) for versioning. For the versions available, see the\n[tag list](https://github.com/elliohow/fMRI_ROI_Analysis_Tool/tags) for this project.\n\n## Licensing\nThis project uses the Apache 2.0 license. For the text version of the license see\n[here](https://github.com/elliohow/fMRI_ROI_Analysis_Tool/blob/master/LICENSE). \nPrior to version 1.0.0, this project used an MIT license.\n',
    'author': 'Elliot Howley',
    'author_email': 'elliohow@hotmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://fmri-roi-analysis-tool.readthedocs.io/en/latest/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<3.11',
}


setup(**setup_kwargs)
