# AUTOGENERATED! DO NOT EDIT! File to edit: source/50_gui.ipynb (unless otherwise specified).

__all__ = ['instance', 'example_lib']

# Internal Cell
import pya
import flayout as fl
import numpy as np

# Cell
@fl.pcell
def instance(
    name="instance",
    width: float = 1.0,
    height: float = 1.0,
    num_inputs: int = 3,
    num_outputs: int = 1,
    port_size=0.1,
):
    if (width < 2 * port_size) or (height < 2 * port_size):
        raise ValueError(f"width/height should be bigger than port size. Got: {width:.2f} < {port_size:.2f}")

    rect = np.array([(-width/2, -height/2), (width/2, -height/2), (width/2, height/2), (-width/2, height/2)])
    port = np.array([(-port_size/2, -port_size/2), (port_size/2, -port_size/2), (port_size/2, port_size/2), (-port_size/2, port_size/2)])
    input_ports = np.array([port + np.array([-width/2, y]) for i, y in enumerate(np.linspace(-width/2, width/2, num_inputs + 2)[1:-1])])
    output_ports = np.array([port + np.array([width/2, y]) for i, y in enumerate(np.linspace(-width/2, width/2, num_inputs + 2)[1:-1])])


    cell = fl.cell(
        name,
        shapes={
            (1, 0): [rect],
            (1, 1): [*input_ports, *output_ports],
        }
    )
    return cell

# Cell
example_lib = fl.library(
    "F. E. L.",
    pcells=[instance],
    cells=[],
    description="FLayout Example Library",
)