# AUTOGENERATED! DO NOT EDIT! File to edit: source/92_notebook.ipynb (unless otherwise specified).

__all__ = ['html_repr', 'auto_expand']

# Internal Cell
from functools import wraps

import bokeh.plotting as bp
import flayout.bokeh as flbk
import pya
from bokeh.embed import file_html
from bokeh.io import output_notebook
from bokeh.resources import CDN

try:
    IPYTHON = get_ipython()  # type: ignore
    output_notebook(hide_banner=True)
except NameError:
    IPYTHON = None

# Cell
def html_repr(func, types):
    for cls in types:

        def registered(obj):
            plot = func(None, obj)
            html = file_html(plot, CDN)
            return html

        if IPYTHON is not None:
            fmtr = IPYTHON.display_formatter.formatters["text/html"]
            fmtr.for_type(cls, registered)

# Cell
def _expand_fig(fig):
    try:
        w = (fig.x_range.end - fig.x_range.start)
        h = (fig.y_range.end - fig.y_range.start)
        fig.x_range.start -= w/10
        fig.x_range.end += w/10
        fig.y_range.start -= h/10
        fig.y_range.end += h/10
    except Exception as e:
        pass
    return fig

def auto_expand(func):
    @wraps(func)
    def new_func(*args, **kwargs):
        fig = func(*args, **kwargs)
        if isinstance(fig, bp.Column):
            fig = bp.Column(*[_expand_fig(f) for f in fig.children])
        else:
            fig = _expand_fig(fig)
        return fig
    return new_func

# Cell
html_repr(auto_expand(flbk.draw_point), [pya.DPoint, pya.Point])
html_repr(auto_expand(flbk.draw_vector), [pya.DVector, pya.Vector])
html_repr(auto_expand(flbk.draw_path), [pya.Path, pya.DPath])
html_repr(auto_expand(flbk.draw_poly), [pya.DSimplePolygon, pya.SimplePolygon, pya.DPolygon, pya.Polygon])
html_repr(auto_expand(flbk.draw_box), [pya.Box, pya.DBox])
html_repr(auto_expand(flbk.draw_cell), [pya.Cell])
html_repr(auto_expand(flbk.draw_inst), [pya.Instance])
html_repr(auto_expand(flbk.draw_layout), [pya.Layout])