# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-06-21 12:50
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def set_cancelation_requested(apps, schema_editor):
    SubjectRegistration = apps.get_model('leprikon', 'SubjectRegistration')
    SubjectRegistration.objects.filter(cancel_request=True).update(cancelation_requested='1970-01-01 00:00')


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('leprikon', '0052_payment_notification_sent'),
    ]

    operations = [
        migrations.AddField(
            model_name='subjectregistration',
            name='approved_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='approved by'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='cancelation_requested',
            field=models.DateTimeField(editable=False, null=True, verbose_name='time of cancellation request'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='cancelation_requested_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='cancelation requested by'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='canceled_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='canceled by'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='created_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='created by'),
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='payment_requested_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='payment requested by'),
        ),
        migrations.RunPython(set_cancelation_requested),
    ]
