#!/usr/bin/env python3
#
# GlobalChem - Common R Group Replacements
#
# -----------------------------------

class CommonRGroupReplacements(object):

    def __init__(self):

        pass

    @staticmethod
    def get_smiles():

        smiles = {
            'water': 'O',
            'methanol': 'OC',
            'ammonia': 'N',
            'hydrogen chloride': 'Cl',
            'hydrogen fluoride': 'F',
            'ethane': 'CC',
            'hydrogen cyanide': 'C#N',
            'formic acid': 'C(=O)O',
            'hydrogen bromide': 'Br',
            'fluroform': 'C(F)(F)F',
            'propane': 'C(C)C',
            'toulene': 'Cc1ccccc1',
            'pyridine': 'c1cccnc1',
            'dimethylamine': 'N(C)C',
            'ethanol': 'OCC',
            'formamide': 'C(N)=O',
            'morpholine': 'N1CCOCC1',
            'nitro': '[N+](=O)[O-]',
            'isobutane': 'C(C)(C)C',
            'anisole': 'c1ccc(OC)cc1',
            'flurobenzene': 'c1ccc(F)cc1',
            'cyclohexane': 'C1CCCCC1',
            'acetic acid': 'CC(=O)O',
            'methyl formate': 'C(=O)OC',
            'butane': 'CCCC',
            'acetamide': 'NC(C)=O',
            'methanamine': 'NC',
            'acetaldehyde': 'C(C)=O',
            'chlorobenzene': 'c1ccc(Cl)cc1',
            '1-methylpiperazine': 'N1CCN(C)CC1',
            'phenylmethanol': 'OCc1ccccc1',
            'ethylbenzene': 'CCc1ccccc1',
            'piperidine': 'N1CCCCC1',
            'thiophene': 'c1cccs1',
            'cyclopropane': 'C1CC1',
            'phenol': 'Oc1ccccc1',
            'aniline': 'Nc1ccccc1',
            'hydrosulfonylmethane': 'S(C)(=O)=O',
            'piperazine': 'N1CCNCC1',
            'pyrrolidine': 'N1CCCC1',
            '4-methylmorpholine': 'CN1CCOCC1',
            'hydrogen iodide': 'I',
            'ethyl formate': 'C(=O)OCC',
            'sulfonic amide': 'S(N)(=O)=O',
            'phenylmethanamine': 'NCc1ccccc1',
            'N-methylformamide': 'C(=O)NC',
            'trimethylamine': 'CN(C)C',
            'N,N-dimethylformamide': 'C(=O)N(C)C',
            'thiol': 'SC',
            'benzaldehyde': 'C(=O)c1ccccc1',
            '1-methylpiperidine': 'CN1CCCCC1',
            'cyclopentane': 'C1CCCC1',
            'N-hydroxyformamide': 'C(=O)NO',
            'pyrimidine': 'c1cncnc1',
            'furan': 'c1ccco1',
            'ethanamine': 'CCN',
            'benzonitrile': 'c1ccc(C#N)cc1',
            'propionic acid': 'CCC(=O)O',
            'propan-2-ol': 'OC(C)C',
            'methanesulfonamide': 'NS(C)(=O)=O',
            'pentane': 'CCCCC',
            'morpholine-4-carbaldehyde': 'C(=O)N1CCOCC1',
            'trifluoromethanol': 'OC(F)(F)F',
            'methoxymethane': 'COC',
            'cyclohexanamine': 'NC1CCCCC1',
            'formaldehyde': 'C=O',
            'N-phenylformamide': 'C(=O)Nc1ccccc1',
            'butan-1-ol': 'OCCCC',
            'pyrazine': 'c1cnccn1',
            'naphthalene': 'c1ccc2ccccc2c1',
            'propan-1-ol': 'OCCC',
            'benzamide': 'NC(=O)c1ccccc1',
            '1-methyl-1H-pyrazole': 'c1cnn(C)c1',
            'N-benzylformamide': 'C(=O)NCc1ccccc1',
            '1﻿H-imidazole': 'n1ccnc1',
            'propan-2-amine': 'NC(C)C',
            '1,3-Benzodioxole': 'c1ccc2c(c1)OCO2',
            '1-methylpyrrolidine': 'CN1CCCC1',
            'methylcyclohexane': 'CC1CCCCC1',
            'ethyne': 'C#C',
            '2-methoxypyridine': 'c1ccc(OC)nc1',
            'N,N-dimethylethanamine': 'CCN(C)C',
            'thiazole': 'c1nccs1',
            'bromobenzene': 'c1ccc(Br)cc1',
            '4-methylpyridine': 'Cc1ccncc1',
            '2-methoxyethan-1-ol': 'OCCOC',
            'hexane': 'CCCCCC',
            'Tetrahydropyran': 'C1CCOCC1',
            '1H-pyrazole': 'c1cn[nH]c1',
            '1-methyl-1H-imidazole': 'Cn1ccnc1',
            'benzoic acid': 'c1ccc(C(=O)O)cc1',
            'boronic acid': 'B(O)O',
            '2-hydroxyacetic acid': 'OCC(=O)O',
            'ethene': 'C=C',
            'piperidine-1-carbaldehyde': 'C(=O)N1CCCCC1',
            'styrene': 'C=Cc1ccccc1',
            '1-fluoro-4-methylbenzene': 'Cc1ccc(F)cc1',
            'ethylene glycol': 'OCCO',
            '2-(dimethylamino)ethan-1-ol': 'OCCN(C)C',
            '(trifluoromethyl)benzene': 'c1ccc(C(F)(F)F)cc1',
            'diethylamine': 'N(CC)CC',
            'N-cyclohexylformamide': 'C(=O)NC1CCCCC1',
            'benzothiazole': 'c1nc2ccccc2s1',
            'methylcyclopropane': 'CC1CC1',
            'N-ethyl-N-methylethanamine': 'CN(CC)CC',
            '1H-benzoimidazole': 'c1nc2ccccc2[nH]1',
            'N-isopropylformamide': 'C(=O)NC(C)C',
            '2-aminoethan-1-ol': 'NCCO',
            'N-(2-hydroxyethyl)formamide': 'C(=O)NCCO',
            '2,3-dihydrobenzo[b][1,4]dioxine': 'c1ccc2c(c1)OCCO2',
            'benzothiophene': 'c1cc2ccccc2s1',
            'propylbenzene': 'CCCc1ccccc1',
            'pyrrolidine-1-carbaldehyde': 'C(=O)N1CCCC1',
            '1,4-dimethylpiperazine': 'CN1CCN(C)CC1',
            'N-ethylformamide': 'C(=O)NCC',
            '2-morpholinoethan-1-ol': 'OCCN1CCOCC1',
            '4-ethylmorpholine': 'CCN1CCOCC1',
            'indole': 'c1c[nH]c2ccccc12',
            'quinoline': 'c1cnc2ccccc2c1',
            '3-(dimethylamino)propan-1-ol': 'OCCCN(C)C',
            '3-methylpyridine': 'Cc1cccnc1',
            'cyclobutane': 'C1CCC1',
            'formimidamide': 'C(=N)N',
            'benzofuran': 'c1cc2ccccc2o1',
            '1-methoxy-4-methylbenzene': 'Cc1ccc(OC)cc1',
            '2-methylpyridine': 'Cc1ccccn1',
            'acetonitrile': 'CC#N',
            '1,2-dichlorobenzene': 'c1ccc(Cl)c(Cl)c1',
            'N,N-dimethylaniline': 'c1ccc(N(C)C)cc1',
            'hydrosulfonylbenzene': 'S(=O)(=O)c1ccccc1',
            'N-methylacetamide': 'CNC(C)=O',
            'hydrogen sulfide': 'S',
            '2-phenylethan-1-amine': 'NCCc1ccccc1',
            '2-(pyrrolidin-1-yl)ethan-1-ol': 'OCCN1CCCC1',
            'methoxyethane': 'CCOC',
            '1,2-dimethoxybenzene': 'c1ccc(OC)c(OC)c1',
            'nitrobenzene': 'c1ccc([N+](=O)[O-])cc1',
            'ethynylbenzene': 'C#Cc1ccccc1',
            'N-(pyridin-3-yl)formamide': 'C(=O)Nc1cccnc1',
            '2-(piperidin-1-yl)ethan-1-ol': 'OCCN1CCCCC1',
            'benzenesulfonamide': 'c1ccc(S(N)(=O)=O)cc1',
            '1-ethylpyrrolidine': 'CCN1CCCC1',
            'pyrazole': 'c1cc[nH]n1',
            '3-(piperidin-1-yl)propan-1-ol': 'OCCCN1CCCCC1',
            'N,N-diethylformamide': 'C(=O)N(CC)CC',
            'acetophenone': 'c1ccc(C(C)=O)cc1',
            'benzooxazole': 'c1nc2ccccc2o1',
            '4-methylpiperazine-1-carbaldehyde': 'C(=O)N1CCN(C)CC1',
            'benzenethiol': 'Sc1ccccc1',
            'sulfuric diamide': 'NS(N)(=O)=O',
            '4-methoxyaniline': 'Nc1ccc(OC)cc1',
            '1-chloro-4-methylbenzene': 'Cc1ccc(Cl)cc1',
            'propan-1-amine': 'CCCN',
            'ethoxybenzene': 'c1ccc(OCC)cc1',
            '5-methylene-2-thioxothiazolidin-4-one': 'C=C1SC(=S)NC1=O',
            '1,3-difluorobenzene': 'c1ccc(F)cc1F',
            '(trifluoromethoxy)benzene': 'c1ccc(OC(F)(F)F)cc1',
            'heptane': 'CCCCCCC',
            'pyridin-2-amine': 'c1ccc(N)nc1',
            '1-ethylpiperidine': 'CCN1CCCCC1',
            'formohydrazide': 'C(=O)NN',
            '2-chlorothiophene': 'c1ccc(Cl)s1',
            'piperidin-4-ol': 'N1CCC(O)CC1',
            '2-methylthiazole': 'c1csc(C)n1',
            'N-cyclopropylformamide': 'C(=O)NC1CC1',
            'prop-2-en-1-ol': 'OCC=C',
            'cyclopentanamine': 'NC1CCCC1',
            'urea': 'NC(N)=O',
            'prop-1-ene': 'CC=C',
            '(methylsulfonyl)benzene': 'c1ccc(S(C)(=O)=O)cc1',
            'difluoromethanol': 'OC(F)F',
            '2-phenylacetamide': 'NC(=O)Cc1ccccc1',
            '4-fluorobenzaldehyde': 'C(=O)c1ccc(F)cc1',
            'N-propylformamide': 'C(=O)NCCC',
            'N-tert-butylformamide': 'C(=O)NC(C)(C)C',
            'tetrazole': 'c1nnn[nH]1',
            'pyrrolidin-3-ol': 'N1CCC(O)C1',
            'biphenyl': 'c1ccc(-c2ccccc2)cc1',
            'cyclopropanamine': 'NC1CC1',
            'formaldehyde oxime': 'C=NO',
            'furan-2-carboxamide': 'NC(=O)c1ccco1',
            '3-morpholinopropan-1-ol': 'OCCCN1CCOCC1',
            'propionamide': 'NC(=O)CC',
            '2-(piperazin-1-yl)ethan-1-ol': 'N1CCN(CCO)CC1',
            'pyridin-3-ylmethanamine': 'NCc1cccnc1',
            'N-hydroxyacrylamide': 'C=CC(=O)NO',
            'N-(2-methoxyethyl)formamide': 'C(=O)NCCOC',
            '2-methylthiophene': 'Cc1cccs1',
            'tert-butylbenzene': 'c1ccc(C(C)(C)C)cc1',
            'cyclohexanecarboxamide': 'NC(=O)C1CCCCC1',
            '4-fluorophenol': 'Oc1ccc(F)cc1',
            '2-ethynylpyridine': 'C#Cc1ccccn1',
            '(4-methoxyphenyl)methanamine': 'NCc1ccc(OC)cc1',
            'butyric acid': 'CCCC(=O)O',
            '1-Acetylpiperazine': 'N1CCN(C(C)=O)CC1',
            '3,5-dimethylisoxazole': 'c1c(C)noc1C',
            '2-methyl-1H-imidazole': 'n1ccnc1C',
            '1-ethylpiperazine': 'N1CCN(CC)CC1',
            'adamantane': 'C12CC3CC(CC(C3)C1)C2',
            '1-chloro-3-methylbenzene': 'Cc1cccc(Cl)c1',
            '1,2-difluorobenzene': 'c1ccc(F)c(F)c1',
            '1-phenylurea': 'NC(=O)Nc1ccccc1',
            '2-methylpropan-2-ol': 'OC(C)(C)C',
            '1-chloro-2-methylbenzene': 'Cc1ccccc1Cl',
            'N-phenethylformamide': 'C(=O)NCCc1ccccc1',
            'isonicotinamide': 'NC(=O)c1ccncc1',
            'N-methylcyclopentanamine': 'CNC1CCCC1',
            '2-methoxyethan-1-amine': 'NCCOC',
            'propionaldehyde': 'C(=O)CC',
            'N-(4-chlorophenyl)formamide': 'C(=O)Nc1ccc(Cl)cc1',
            '2-chloropyridine': 'c1ccc(Cl)nc1',
            'N,N-dimethylpropan-1-amine': 'CCCN(C)C',
            '5-methylenethiazolidine-2,4-dione': 'C=C1SC(=O)NC1=O',
            '3-methoxypyridine': 'c1cncc(OC)c1',
            '3-(trifluoromethyl)pyridine': 'c1ncccc1C(F)(F)F',
            '4-methylbenzenesulfonamide': 'NS(=O)(=O)c1ccc(C)cc1',
            '2-phenylethan-1-ol': 'OCCc1ccccc1',
            'N-cyclopentylformamide': 'C(=O)NC1CCCC1',
            'indazole': 'c1ccc2[nH]ncc2c1',
            'cyclopentanol': 'OC1CCCC1',
            'nicotinamide': 'NC(=O)c1cccnc1',
            'isopentane': 'CCC(C)C',
            'hydrosulfonylethane': 'S(=O)(=O)CC',
            'tert-butyl carbamate': 'NC(=O)OC(C)(C)C',
            '(tetrahydrofuran-2-yl)methanol': 'OCC1CCCO1',
            'N,N-dimethylacetamide': 'CC(=O)N(C)C',
            '1-phenylpiperazine': 'N1CCN(c2ccccc2)CC1',
            '2-methylpropan-1-ol': 'C(C)(C)CO',
            'N-methylethanamine': 'CCNC',
            '1,3-dichlorobenzene': 'c1ccc(Cl)cc1Cl',
            'tert-butyl formate': 'C(=O)OC(C)(C)C',
            'thiophene-2-carbaldehyde': 'C(=O)c1cccs1',
            '1-methyl-1,4-diazepane': 'N1CCCN(C)CC1',
            'N-phenylacetamide': 'c1ccc(NC(C)=O)cc1',
            'octane': 'CCCCCCCC',
            '1-methoxy-2-methylbenzene': 'Cc1ccccc1OC',
            '1H-pyrrole-2,5-dione': 'N1C(=O)C=CC1=O',
            'sulfamic acid': 'OS(N)(=O)=O',
            '2-methylisoindoline-1,3-dione': 'CN1C(=O)c2ccccc2C1=O',
            '(difluoromethyl)phosphonic acid': 'C(F)(F)P(=O)(O)O',
            'pyrimidin-2-amine': 'c1ccnc(N)n1',
            '1H-benzo[d]imidazole-5-carboxamide': 'c1nc2cc(C(N)=O)ccc2[nH]1',
            '2-methylpropan-2-amine': 'NC(C)(C)C',
            'N-(4-fluorophenyl)formamide': 'C(=O)Nc1ccc(F)cc1',
            'oxazole': 'c1cnco1',
            'pyridin-3-ylmethanol': 'OCc1cccnc1',
            'pyridin-3-ol': 'Oc1cccnc1',
            'picolinamide': 'NC(=O)c1ccccn1',
            'cyclopropylmethanol': 'OCC1CC1',
            'ethyl carbamate': 'NC(=O)OCC',
            '2-(diethylamino)ethan-1-ol': 'OCCN(CC)CC',
            'pyrocatechol': 'c1ccc(O)c(O)c1',
            'acrylamide': 'NC(=O)C=C',
            'azetidine': 'N1CCC1',
            'p-xylene': 'Cc1ccc(C)cc1',
            '1-methylpiperidin-4-ol': 'OC1CCN(C)CC1',
            '4-hydrosulfonylmorpholine': 'S(=O)(=O)N1CCOCC1',
            '4-methyl-1H-imidazole': 'Cc1c[nH]cn1',
            'N-(pyridin-4-yl)formamide': 'C(=O)Nc1ccncc1',
            '4-methoxyphenol': 'Oc1ccc(OC)cc1',
            'fluoromethane': 'CF',
            'N-methylbenzamide': 'CNC(=O)c1ccccc1',
            'pyridin-3-amine': 'Nc1cccnc1',
            'pyridin-4-ylmethanamine': 'NCc1ccncc1',
            'imidazole': 'c1ncc[nH]1',
            '3-chlorophenol': 'Oc1cccc(Cl)c1',
            '1-ethylurea': 'NC(=O)NCC',
            'methyl benzoate': 'c1ccc(C(=O)OC)cc1',
            '(aminomethylene)bis(phosphonic acid)': 'NC(P(=O)(O)O)P(=O)(O)O',
            'pyridin-4-amine': 'Nc1ccncc1',
            'pyrrole': 'n1cccc1',
            'N-methyl-2-phenylcyclopropan-1-amine': 'CNC1CC1c1ccccc1',
            '5-methoxy-3-methyl-1,3,4-oxadiazol-2(3H)-one': 'Cn1nc(OC)oc1=O',
            '(methylsulfonyl)methane': 'CS(C)(=O)=O',
            '1-(piperidin-1-yl)ethan-1-one': 'C1CCN(C(C)=O)CC1',
            'methyl acetate': 'CC(=O)OC',
            '4-chlorophenol': 'Oc1ccc(Cl)cc1',
            'ethane-1,2-diamine': 'NCCN',
            '4-methylpiperidine': 'N1CCC(C)CC1',
            'benzyl formate': 'C(=O)OCc1ccccc1',
            'N,N-dimethylsulfonic amide': 'S(=O)(=O)N(C)C',
            '4-methoxybenzaldehyde': 'C(=O)c1ccc(OC)cc1',
            'N-hydroxyacetamide': 'CC(=O)NO',
            '1H-1,2,4-triazole': 'n1cncn1',
            '2-fluoroethan-1-ol': 'OCCF',
            '2-aminobenzamide': 'Nc1ccccc1C(N)=O',
            'N-hydroxypropionamide': 'CCC(=O)NO',
            '2H-tetrazole': 'c1nn[nH]n1',
            'prop-2-yn-1-ol': 'OCC#C',
            'piperidin-4-ylmethanol': 'N1CCC(CO)CC1',
            '3-ethynylpyridine': 'C#Cc1cccnc1',
            '4-chlorobenzaldehyde': 'C(=O)c1ccc(Cl)cc1',
            'methylphosphonic acid': 'CP(=O)(O)O',
            'isobutyramide': 'NC(=O)C(C)C',
            'cyclopropylmethanamine': 'NCC1CC1',
            'N,N-dimethylpyrrolidin-3-amine': 'N1CCC(N(C)C)C1',
            '4,5-dihydrooxazol-2-amine': 'C1COC(N)=N1',
            '1,2,3,4-tetrahydroisoquinoline': 'N1CCc2ccccc2C1',
            '4-phenylmorpholine': 'c1ccc(N2CCOCC2)cc1',
            '4,5-dihydro-1H-imidazole': 'C1=NCCN1',
            '3-aminopropan-1-ol': 'NCCCO',
            '2,2,2-trifluoroacetaldehyde': 'C(=O)C(F)(F)F',
            'trifluoromethanethiol': 'SC(F)(F)F',
            'N-ethylacetamide': 'CCNC(C)=O',
            'N-methylaniline': 'N(C)c1ccccc1',
            'phenylmethanethiol': 'SCc1ccccc1',
            '4-(pyrrolidin-1-yl)piperidine': 'N1CCC(N2CCCC2)CC1',
            '4-(trifluoromethyl)pyrimidine': 'c1nccc(C(F)(F)F)n1',
            '1-methoxy-3-methylbenzene': 'Cc1cccc(OC)c1',
            'N-butylformamide': 'C(=O)NCCCC',
            '2,2,2-trifluoroethan-1-ol': 'OCC(F)(F)F',
            'p-toluidine': 'Nc1ccc(C)cc1',
            '1,3-dimethoxybenzene': 'c1cc(OC)cc(OC)c1',
            'N,N-dimethyl-1-phenylmethanamine': 'CN(C)Cc1ccccc1',
            '2-methylnaphthalene': 'Cc1ccc2ccccc2c1',
            'tetrahydrofuran': 'C1CCCO1',
            'acrylic acid': 'C=CC(=O)O',
            '2-(methylamino)ethan-1-ol': 'CNCCO',
            '4-methylbenzaldehyde': 'C(=O)c1ccc(C)cc1',
            '3,4-dimethyl-1H-pyrazole-5-carboxylic acid': 'Cc1c(C)n[nH]c1C(=O)O',
            'chloromethane': 'CCl',
            'butyramide': 'NC(=O)CCC',
            '1-chloro-4-hydrosulfonylbenzene': 'S(=O)(=O)c1ccc(Cl)cc1',
            'difluoromethane': 'C(F)F',
            '3-(pyrrolidin-1-yl)propan-1-ol': 'OCCCN1CCCC1',
            'cyclopropylbenzene': 'C1CC1c1ccccc1',
            'cumene': 'c1ccc(C(C)C)cc1',
            '2-methyltetrahydrofuran': 'CC1CCCO1',
            'N-methylpropan-2-amine': 'CNC(C)C',
            'alanine': 'CC(N)C(=O)O',
            '1,2,3,6-tetrahydropyridine': 'C1=CCNCC1',
            '2-(trifluoromethyl)pyridine': 'c1ccc(C(F)(F)F)nc1',
            'hydroquinone': 'Oc1ccc(O)cc1',
            '4-fluoroaniline': 'Nc1ccc(F)cc1',
            '1-fluoro-2-methoxybenzene': 'c1ccc(OC)c(F)c1',
            '2-ethylidenehydrazine-1-carbothioamide': 'C(C)=NNC(N)=S',
            'furan-2-carbaldehyde': 'C(=O)c1ccco1',
            'butan-1-amine': 'NCCCC',
            'triaza-1,2-dien-2-ium': 'N=[N+]=N',
            'pyridin-2-ylmethanol': 'OCc1ccccn1',
            'resorcinol': 'c1cc(O)cc(O)c1',
            'piperidin-3-ol': 'N1CCCC(O)C1',
            'cyclopropanecarboxamide': 'NC(=O)C1CC1',
            '1-methyl-1H-1,2,4-triazole': 'Cn1cncn1',
            '4-chlorobenzene-1,2-diol': 'Oc1ccc(Cl)cc1O',
            'N-methyl-1-phenylmethanamine': 'N(C)Cc1ccccc1',
            'pyrazin-2-amine': 'c1cnc(N)cn1',
            'thiophen-2-ylmethanamine': 'NCc1cccs1',
            '2-morpholinoethan-1-amine': 'NCCN1CCOCC1',
            'thiomorpholine 1,1-dioxide': 'N1CCS(=O)(=O)CC1',
            '2-isopropoxypyridine': 'c1ccc(OC(C)C)nc1',
            'pyridazine': 'c1ccnnc1',
            '3-fluoropyridine': 'c1ccc(F)cn1',
            'isoquinoline': 'c1cncc2ccccc12',
            '4-chloroaniline': 'Nc1ccc(Cl)cc1',
            'pyrrolidin-2-one': 'N1CCCC1=O',
            '5-methyloctahydropyrrolo[3,4-b]pyrrole': 'N1CCC2CN(C)CC21',
            '4-methoxybenzamide': 'NC(=O)c1ccc(OC)cc1',
            'm-cresol': 'Oc1cccc(C)c1',
            '4,4,5,5-tetramethyl-1,3,2-dioxaborolane': 'B1OC(C)(C)C(C)(C)O1',
            'N1,N1-dimethylethane-1,2-diamine': 'NCCN(C)C',
            '1-phenylthiourea': 'NC(=S)Nc1ccccc1',
            '1-methyl-4-(trifluoromethyl)benzene': 'Cc1ccc(C(F)(F)F)cc1',
            'isopropoxybenzene': 'c1ccc(OC(C)C)cc1',
            '4-methoxypiperidine': 'N1CCC(OC)CC1',
            '1,2-dichloro-4-methylbenzene': 'Cc1ccc(Cl)c(Cl)c1',
            '1-(4-chlorophenyl)urea': 'NC(=O)Nc1ccc(Cl)cc1',
            'thiazol-2-amine': 'Nc1nccs1',
            'o-xylene': 'c1ccc(C)c(C)c1',
            '2-methyl-1,3,4-oxadiazole': 'c1nnc(C)o1',
            '1-fluoro-3-methylbenzene': 'Cc1cccc(F)c1',
            '(methoxymethyl)benzene': 'COCc1ccccc1',
            'hydrazine': 'NN',
            '1-cyclohexylurea': 'NC(=O)NC1CCCCC1',
            'ethanethiol': 'SCC',
            'N-hydroxypentanamide': 'CCCCC(=O)NO',
            'thiophene-2-carboxamide': 'NC(=O)c1cccs1',
            'N-(cyclopropylmethyl)formamide': 'C(=O)NCC1CC1',
            '1-ethyl-2-methylpyrrolidine': 'CCN1CCCC1C',
            'pyridin-4-ylmethanol': 'OCc1ccncc1',
            'triethylamine': 'CCN(CC)CC',
            '4-hydroxy-2-oxobut-3-enoic acid': 'C(O)=CC(=O)C(=O)O',
            'isonicotinaldehyde': 'C(=O)c1ccncc1',
            '1,1,1-trifluoroethane': 'CC(F)(F)F',
            'isothiocyanic acid': 'N=C=S',
            'phosphonic acid': 'P(=O)(O)O',
            '2-hydroxy-4-oxobut-2-enoic acid': 'C(=O)C=C(O)C(=O)O',
            'N,N-dimethylpiperidin-4-amine': 'CN(C)C1CCNCC1',
            '1-(pyridin-2-yl)piperazine': 'N1CCN(c2ccccn2)CC1',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'water': '[#8]',
            'methanol': '[#8]-[#6]',
            'ammonia': '[#7]',
            'hydrogen chloride': '[#17]',
            'hydrogen fluoride': '[#9]',
            'ethane': '[#6]-[#6]',
            'hydrogen cyanide': '[#6]#[#7]',
            'formic acid': '[#6](=[#8])-[#8]',
            'hydrogen bromide': '[#35]',
            'fluroform': '[#6](-[#9])(-[#9])-[#9]',
            'propane': '[#6](-[#6])-[#6]',
            'toulene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pyridine': '[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            'dimethylamine': '[#7](-[#6])-[#6]',
            'ethanol': '[#8]-[#6]-[#6]',
            'formamide': '[#6](-[#7])=[#8]',
            'morpholine': '[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'nitro': '[#7+](=[#8])-[#8-]',
            'isobutane': '[#6](-[#6])(-[#6])-[#6]',
            'anisole': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'flurobenzene': '[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1',
            'cyclohexane': '[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'acetic acid': '[#6]-[#6](=[#8])-[#8]',
            'methyl formate': '[#6](=[#8])-[#8]-[#6]',
            'butane': '[#6]-[#6]-[#6]-[#6]',
            'acetamide': '[#7]-[#6](-[#6])=[#8]',
            'methanamine': '[#7]-[#6]',
            'acetaldehyde': '[#6](-[#6])=[#8]',
            'chlorobenzene': '[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            '1-methylpiperazine': '[#7]1-[#6]-[#6]-[#7](-[#6])-[#6]-[#6]-1',
            'phenylmethanol': '[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'ethylbenzene': '[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'piperidine': '[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'thiophene': '[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'cyclopropane': '[#6]1-[#6]-[#6]-1',
            'phenol': '[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'aniline': '[#7]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'hydrosulfonylmethane': '[#16](-[#6])(=[#8])=[#8]',
            'piperazine': '[#7]1-[#6]-[#6]-[#7]-[#6]-[#6]-1',
            'pyrrolidine': '[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            '4-methylmorpholine': '[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'hydrogen iodide': '[#53]',
            'ethyl formate': '[#6](=[#8])-[#8]-[#6]-[#6]',
            'sulfonic amide': '[#16](-[#7])(=[#8])=[#8]',
            'phenylmethanamine': '[#7]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'N-methylformamide': '[#6](=[#8])-[#7]-[#6]',
            'trimethylamine': '[#6]-[#7](-[#6])-[#6]',
            'N,N-dimethylformamide': '[#6](=[#8])-[#7](-[#6])-[#6]',
            'thiol': '[#16]-[#6]',
            'benzaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '1-methylpiperidine': '[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'cyclopentane': '[#6]1-[#6]-[#6]-[#6]-[#6]-1',
            'N-hydroxyformamide': '[#6](=[#8])-[#7]-[#8]',
            'pyrimidine': '[#6]1:[#6]:[#7]:[#6]:[#7]:[#6]:1',
            'furan': '[#6]1:[#6]:[#6]:[#6]:[#8]:1',
            'ethanamine': '[#6]-[#6]-[#7]',
            'benzonitrile': '[#6]1:[#6]:[#6]:[#6](-[#6]#[#7]):[#6]:[#6]:1',
            'propionic acid': '[#6]-[#6]-[#6](=[#8])-[#8]',
            'propan-2-ol': '[#8]-[#6](-[#6])-[#6]',
            'methanesulfonamide': '[#7]-[#16](-[#6])(=[#8])=[#8]',
            'pentane': '[#6]-[#6]-[#6]-[#6]-[#6]',
            'morpholine-4-carbaldehyde': '[#6](=[#8])-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'trifluoromethanol': '[#8]-[#6](-[#9])(-[#9])-[#9]',
            'methoxymethane': '[#6]-[#8]-[#6]',
            'cyclohexanamine': '[#7]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'formaldehyde': '[#6]=[#8]',
            'N-phenylformamide': '[#6](=[#8])-[#7]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'butan-1-ol': '[#8]-[#6]-[#6]-[#6]-[#6]',
            'pyrazine': '[#6]1:[#6]:[#7]:[#6]:[#6]:[#7]:1',
            'naphthalene': '[#6]1:[#6]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]:1',
            'propan-1-ol': '[#8]-[#6]-[#6]-[#6]',
            'benzamide': '[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '1-methyl-1H-pyrazole': '[#6]1:[#6]:[#7]:[#7](-[#6]):[#6]:1',
            'N-benzylformamide': '[#6](=[#8])-[#7]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'propan-2-amine': '[#7]-[#6](-[#6])-[#6]',
            '1,3-Benzodioxole': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1)-[#8]-[#6]-[#8]-2',
            '1-methylpyrrolidine': '[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'methylcyclohexane': '[#6]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'ethyne': '[#6]#[#6]',
            '2-methoxypyridine': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#7]:[#6]:1',
            'N,N-dimethylethanamine': '[#6]-[#6]-[#7](-[#6])-[#6]',
            'thiazole': '[#6]1:[#7]:[#6]:[#6]:[#16]:1',
            'bromobenzene': '[#6]1:[#6]:[#6]:[#6](-[#35]):[#6]:[#6]:1',
            '4-methylpyridine': '[#6]-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            '2-methoxyethan-1-ol': '[#8]-[#6]-[#6]-[#8]-[#6]',
            'hexane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'Tetrahydropyran': '[#6]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            '1H-pyrazole': '[#6]1:[#6]:[#7]:[#7H]:[#6]:1',
            '1-methyl-1H-imidazole': '[#6]-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'benzoic acid': '[#6]1:[#6]:[#6]:[#6](-[#6](=[#8])-[#8]):[#6]:[#6]:1',
            'boronic acid': '[#5](-[#8])-[#8]',
            '2-hydroxyacetic acid': '[#8]-[#6]-[#6](=[#8])-[#8]',
            'ethene': '[#6]=[#6]',
            'piperidine-1-carbaldehyde': '[#6](=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'styrene': '[#6]=[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '1-fluoro-4-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1',
            'ethylene glycol': '[#8]-[#6]-[#6]-[#8]',
            '2-(dimethylamino)ethan-1-ol': '[#8]-[#6]-[#6]-[#7](-[#6])-[#6]',
            '(trifluoromethyl)benzene': '[#6]1:[#6]:[#6]:[#6](-[#6](-[#9])(-[#9])-[#9]):[#6]:[#6]:1',
            'diethylamine': '[#7](-[#6]-[#6])-[#6]-[#6]',
            'N-cyclohexylformamide': '[#6](=[#8])-[#7]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'benzothiazole': '[#6]1:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#16]:1',
            'methylcyclopropane': '[#6]-[#6]1-[#6]-[#6]-1',
            'N-ethyl-N-methylethanamine': '[#6]-[#7](-[#6]-[#6])-[#6]-[#6]',
            '1H-benzoimidazole': '[#6]1:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#7H]:1',
            'N-isopropylformamide': '[#6](=[#8])-[#7]-[#6](-[#6])-[#6]',
            '2-aminoethan-1-ol': '[#7]-[#6]-[#6]-[#8]',
            'N-(2-hydroxyethyl)formamide': '[#6](=[#8])-[#7]-[#6]-[#6]-[#8]',
            '2,3-dihydrobenzo[b][1,4]dioxine': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1)-[#8]-[#6]-[#6]-[#8]-2',
            'benzothiophene': '[#6]1:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#16]:1',
            'propylbenzene': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pyrrolidine-1-carbaldehyde': '[#6](=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            '1,4-dimethylpiperazine': '[#6]-[#7]1-[#6]-[#6]-[#7](-[#6])-[#6]-[#6]-1',
            'N-ethylformamide': '[#6](=[#8])-[#7]-[#6]-[#6]',
            '2-morpholinoethan-1-ol': '[#8]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            '4-ethylmorpholine': '[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'indole': '[#6]1:[#6]:[#7H]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            'quinoline': '[#6]1:[#6]:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]:1',
            '3-(dimethylamino)propan-1-ol': '[#8]-[#6]-[#6]-[#6]-[#7](-[#6])-[#6]',
            '3-methylpyridine': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            'cyclobutane': '[#6]1-[#6]-[#6]-[#6]-1',
            'formimidamide': '[#6](=[#7])-[#7]',
            'benzofuran': '[#6]1:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#8]:1',
            '1-methoxy-4-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            '2-methylpyridine': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1',
            'acetonitrile': '[#6]-[#6]#[#7]',
            '1,2-dichlorobenzene': '[#6]1:[#6]:[#6]:[#6](-[#17]):[#6](-[#17]):[#6]:1',
            'N,N-dimethylaniline': '[#6]1:[#6]:[#6]:[#6](-[#7](-[#6])-[#6]):[#6]:[#6]:1',
            'hydrosulfonylbenzene': '[#16](=[#8])(=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'N-methylacetamide': '[#6]-[#7]-[#6](-[#6])=[#8]',
            'hydrogen sulfide': '[#16]',
            '2-phenylethan-1-amine': '[#7]-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '2-(pyrrolidin-1-yl)ethan-1-ol': '[#8]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'methoxyethane': '[#6]-[#6]-[#8]-[#6]',
            '1,2-dimethoxybenzene': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6](-[#8]-[#6]):[#6]:1',
            'nitrobenzene': '[#6]1:[#6]:[#6]:[#6](-[#7+](=[#8])-[#8-]):[#6]:[#6]:1',
            'ethynylbenzene': '[#6]#[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'N-(pyridin-3-yl)formamide': '[#6](=[#8])-[#7]-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            '2-(piperidin-1-yl)ethan-1-ol': '[#8]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'benzenesulfonamide': '[#6]1:[#6]:[#6]:[#6](-[#16](-[#7])(=[#8])=[#8]):[#6]:[#6]:1',
            '1-ethylpyrrolidine': '[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'pyrazole': '[#6]1:[#6]:[#6]:[#7H]:[#7]:1',
            '3-(piperidin-1-yl)propan-1-ol': '[#8]-[#6]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'N,N-diethylformamide': '[#6](=[#8])-[#7](-[#6]-[#6])-[#6]-[#6]',
            'acetophenone': '[#6]1:[#6]:[#6]:[#6](-[#6](-[#6])=[#8]):[#6]:[#6]:1',
            'benzooxazole': '[#6]1:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#8]:1',
            '4-methylpiperazine-1-carbaldehyde': '[#6](=[#8])-[#7]1-[#6]-[#6]-[#7](-[#6])-[#6]-[#6]-1',
            'benzenethiol': '[#16]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'sulfuric diamide': '[#7]-[#16](-[#7])(=[#8])=[#8]',
            '4-methoxyaniline': '[#7]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            '1-chloro-4-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            'propan-1-amine': '[#6]-[#6]-[#6]-[#7]',
            'ethoxybenzene': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]-[#6]):[#6]:[#6]:1',
            '5-methylene-2-thioxothiazolidin-4-one': '[#6]=[#6]1-[#16]-[#6](=[#16])-[#7]-[#6]-1=[#8]',
            '1,3-difluorobenzene': '[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1-[#9]',
            '(trifluoromethoxy)benzene': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6](-[#9])(-[#9])-[#9]):[#6]:[#6]:1',
            'heptane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            'pyridin-2-amine': '[#6]1:[#6]:[#6]:[#6](-[#7]):[#7]:[#6]:1',
            '1-ethylpiperidine': '[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'formohydrazide': '[#6](=[#8])-[#7]-[#7]',
            '2-chlorothiophene': '[#6]1:[#6]:[#6]:[#6](-[#17]):[#16]:1',
            'piperidin-4-ol': '[#7]1-[#6]-[#6]-[#6](-[#8])-[#6]-[#6]-1',
            '2-methylthiazole': '[#6]1:[#6]:[#16]:[#6](-[#6]):[#7]:1',
            'N-cyclopropylformamide': '[#6](=[#8])-[#7]-[#6]1-[#6]-[#6]-1',
            'prop-2-en-1-ol': '[#8]-[#6]-[#6]=[#6]',
            'cyclopentanamine': '[#7]-[#6]1-[#6]-[#6]-[#6]-[#6]-1',
            'urea': '[#7]-[#6](-[#7])=[#8]',
            'prop-1-ene': '[#6]-[#6]=[#6]',
            '(methylsulfonyl)benzene': '[#6]1:[#6]:[#6]:[#6](-[#16](-[#6])(=[#8])=[#8]):[#6]:[#6]:1',
            'difluoromethanol': '[#8]-[#6](-[#9])-[#9]',
            '2-phenylacetamide': '[#7]-[#6](=[#8])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '4-fluorobenzaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1',
            'N-propylformamide': '[#6](=[#8])-[#7]-[#6]-[#6]-[#6]',
            'N-tert-butylformamide': '[#6](=[#8])-[#7]-[#6](-[#6])(-[#6])-[#6]',
            'tetrazole': '[#6]1:[#7]:[#7]:[#7]:[#7H]:1',
            'pyrrolidin-3-ol': '[#7]1-[#6]-[#6]-[#6](-[#8])-[#6]-1',
            'biphenyl': '[#6]1:[#6]:[#6]:[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#6]:1',
            'cyclopropanamine': '[#7]-[#6]1-[#6]-[#6]-1',
            'formaldehyde oxime': '[#6]=[#7]-[#8]',
            'furan-2-carboxamide': '[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#8]:1',
            '3-morpholinopropan-1-ol': '[#8]-[#6]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'propionamide': '[#7]-[#6](=[#8])-[#6]-[#6]',
            '2-(piperazin-1-yl)ethan-1-ol': '[#7]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#8])-[#6]-[#6]-1',
            'pyridin-3-ylmethanamine': '[#7]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            'N-hydroxyacrylamide': '[#6]=[#6]-[#6](=[#8])-[#7]-[#8]',
            'N-(2-methoxyethyl)formamide': '[#6](=[#8])-[#7]-[#6]-[#6]-[#8]-[#6]',
            '2-methylthiophene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'tert-butylbenzene': '[#6]1:[#6]:[#6]:[#6](-[#6](-[#6])(-[#6])-[#6]):[#6]:[#6]:1',
            'cyclohexanecarboxamide': '[#7]-[#6](=[#8])-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            '4-fluorophenol': '[#8]-[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1',
            '2-ethynylpyridine': '[#6]#[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1',
            '(4-methoxyphenyl)methanamine': '[#7]-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'butyric acid': '[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            '1-Acetylpiperazine': '[#7]1-[#6]-[#6]-[#7](-[#6](-[#6])=[#8])-[#6]-[#6]-1',
            '3,5-dimethylisoxazole': '[#6]1:[#6](-[#6]):[#7]:[#8]:[#6]:1-[#6]',
            '1-ethylpiperazine': '[#7]1-[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]-1',
            'adamantane': '[#6]12-[#6]-[#6]3-[#6]-[#6](-[#6]-[#6](-[#6]-3)-[#6]-1)-[#6]-2',
            '1-chloro-3-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6](-[#17]):[#6]:1',
            '1,2-difluorobenzene': '[#6]1:[#6]:[#6]:[#6](-[#9]):[#6](-[#9]):[#6]:1',
            '1-phenylurea': '[#7]-[#6](=[#8])-[#7]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '2-methylpropan-2-ol': '[#8]-[#6](-[#6])(-[#6])-[#6]',
            '1-chloro-2-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#17]',
            'N-phenethylformamide': '[#6](=[#8])-[#7]-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'isonicotinamide': '[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            'N-methylcyclopentanamine': '[#6]-[#7]-[#6]1-[#6]-[#6]-[#6]-[#6]-1',
            '2-methoxyethan-1-amine': '[#7]-[#6]-[#6]-[#8]-[#6]',
            'propionaldehyde': '[#6](=[#8])-[#6]-[#6]',
            'N-(4-chlorophenyl)formamide': '[#6](=[#8])-[#7]-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            '2-chloropyridine': '[#6]1:[#6]:[#6]:[#6](-[#17]):[#7]:[#6]:1',
            'N,N-dimethylpropan-1-amine': '[#6]-[#6]-[#6]-[#7](-[#6])-[#6]',
            '5-methylenethiazolidine-2,4-dione': '[#6]=[#6]1-[#16]-[#6](=[#8])-[#7]-[#6]-1=[#8]',
            '3-methoxypyridine': '[#6]1:[#6]:[#7]:[#6]:[#6](-[#8]-[#6]):[#6]:1',
            '3-(trifluoromethyl)pyridine': '[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1-[#6](-[#9])(-[#9])-[#9]',
            '4-methylbenzenesulfonamide': '[#7]-[#16](=[#8])(=[#8])-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            '2-phenylethan-1-ol': '[#8]-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'N-cyclopentylformamide': '[#6](=[#8])-[#7]-[#6]1-[#6]-[#6]-[#6]-[#6]-1',
            'indazole': '[#6]1:[#6]:[#6]:[#6]2:[#7H]:[#7]:[#6]:[#6]:2:[#6]:1',
            'cyclopentanol': '[#8]-[#6]1-[#6]-[#6]-[#6]-[#6]-1',
            'nicotinamide': '[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            'isopentane': '[#6]-[#6]-[#6](-[#6])-[#6]',
            'hydrosulfonylethane': '[#16](=[#8])(=[#8])-[#6]-[#6]',
            'tert-butyl carbamate': '[#7]-[#6](=[#8])-[#8]-[#6](-[#6])(-[#6])-[#6]',
            '(tetrahydrofuran-2-yl)methanol': '[#8]-[#6]-[#6]1-[#6]-[#6]-[#6]-[#8]-1',
            'N,N-dimethylacetamide': '[#6]-[#6](=[#8])-[#7](-[#6])-[#6]',
            '1-phenylpiperazine': '[#7]1-[#6]-[#6]-[#7](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1',
            '2-methylpropan-1-ol': '[#6](-[#6])(-[#6])-[#6]-[#8]',
            'N-methylethanamine': '[#6]-[#6]-[#7]-[#6]',
            '1,3-dichlorobenzene': '[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1-[#17]',
            'tert-butyl formate': '[#6](=[#8])-[#8]-[#6](-[#6])(-[#6])-[#6]',
            'thiophene-2-carbaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            '1-methyl-1,4-diazepane': '[#7]1-[#6]-[#6]-[#6]-[#7](-[#6])-[#6]-[#6]-1',
            'N-phenylacetamide': '[#6]1:[#6]:[#6]:[#6](-[#7]-[#6](-[#6])=[#8]):[#6]:[#6]:1',
            'octane': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]',
            '1-methoxy-2-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]-[#6]',
            '1H-pyrrole-2,5-dione': '[#7]1-[#6](=[#8])-[#6]=[#6]-[#6]-1=[#8]',
            'sulfamic acid': '[#8]-[#16](-[#7])(=[#8])=[#8]',
            '2-methylisoindoline-1,3-dione': '[#6]-[#7]1-[#6](=[#8])-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#6]-1=[#8]',
            '(difluoromethyl)phosphonic acid': '[#6](-[#9])(-[#9])-[#15](=[#8])(-[#8])-[#8]',
            'pyrimidin-2-amine': '[#6]1:[#6]:[#6]:[#7]:[#6](-[#7]):[#7]:1',
            '1H-benzo[d]imidazole-5-carboxamide': '[#6]1:[#7]:[#6]2:[#6]:[#6](-[#6](-[#7])=[#8]):[#6]:[#6]:[#6]:2:[#7H]:1',
            '2-methylpropan-2-amine': '[#7]-[#6](-[#6])(-[#6])-[#6]',
            'N-(4-fluorophenyl)formamide': '[#6](=[#8])-[#7]-[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1',
            'oxazole': '[#6]1:[#6]:[#7]:[#6]:[#8]:1',
            'pyridin-3-ylmethanol': '[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            'pyridin-3-ol': '[#8]-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            'picolinamide': '[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1',
            'cyclopropylmethanol': '[#8]-[#6]-[#6]1-[#6]-[#6]-1',
            'ethyl carbamate': '[#7]-[#6](=[#8])-[#8]-[#6]-[#6]',
            '2-(diethylamino)ethan-1-ol': '[#8]-[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]',
            'pyrocatechol': '[#6]1:[#6]:[#6]:[#6](-[#8]):[#6](-[#8]):[#6]:1',
            'acrylamide': '[#7]-[#6](=[#8])-[#6]=[#6]',
            'azetidine': '[#7]1-[#6]-[#6]-[#6]-1',
            'p-xylene': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            '1-methylpiperidin-4-ol': '[#8]-[#6]1-[#6]-[#6]-[#7](-[#6])-[#6]-[#6]-1',
            '4-hydrosulfonylmorpholine': '[#16](=[#8])(=[#8])-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            '4-methyl-1H-imidazole': '[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1',
            'N-(pyridin-4-yl)formamide': '[#6](=[#8])-[#7]-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            '4-methoxyphenol': '[#8]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'fluoromethane': '[#6]-[#9]',
            'N-methylbenzamide': '[#6]-[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pyridin-3-amine': '[#7]-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            'pyridin-4-ylmethanamine': '[#7]-[#6]-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            'imidazole': '[#6]1:[#7]:[#6]:[#6]:[#7H]:1',
            '3-chlorophenol': '[#8]-[#6]1:[#6]:[#6]:[#6]:[#6](-[#17]):[#6]:1',
            '1-ethylurea': '[#7]-[#6](=[#8])-[#7]-[#6]-[#6]',
            'methyl benzoate': '[#6]1:[#6]:[#6]:[#6](-[#6](=[#8])-[#8]-[#6]):[#6]:[#6]:1',
            '(aminomethylene)bis(phosphonic acid)': '[#7]-[#6](-[#15](=[#8])(-[#8])-[#8])-[#15](=[#8])(-[#8])-[#8]',
            'pyridin-4-amine': '[#7]-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            'N-methyl-2-phenylcyclopropan-1-amine': '[#6]-[#7]-[#6]1-[#6]-[#6]-1-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '5-methoxy-3-methyl-1,3,4-oxadiazol-2(3H)-one': '[#6]-[#7]1:[#7]:[#6](-[#8]-[#6]):[#8]:[#6]:1=[#8]',
            '(methylsulfonyl)methane': '[#6]-[#16](-[#6])(=[#8])=[#8]',
            '1-(piperidin-1-yl)ethan-1-one': '[#6]1-[#6]-[#6]-[#7](-[#6](-[#6])=[#8])-[#6]-[#6]-1',
            'methyl acetate': '[#6]-[#6](=[#8])-[#8]-[#6]',
            '4-chlorophenol': '[#8]-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            'ethane-1,2-diamine': '[#7]-[#6]-[#6]-[#7]',
            '4-methylpiperidine': '[#7]1-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-1',
            'benzyl formate': '[#6](=[#8])-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'N,N-dimethylsulfonic amide': '[#16](=[#8])(=[#8])-[#7](-[#6])-[#6]',
            '4-methoxybenzaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'N-hydroxyacetamide': '[#6]-[#6](=[#8])-[#7]-[#8]',
            '2-fluoroethan-1-ol': '[#8]-[#6]-[#6]-[#9]',
            '2-aminobenzamide': '[#7]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6](-[#7])=[#8]',
            'N-hydroxypropionamide': '[#6]-[#6]-[#6](=[#8])-[#7]-[#8]',
            '2H-tetrazole': '[#6]1:[#7]:[#7]:[#7H]:[#7]:1',
            'prop-2-yn-1-ol': '[#8]-[#6]-[#6]#[#6]',
            'piperidin-4-ylmethanol': '[#7]1-[#6]-[#6]-[#6](-[#6]-[#8])-[#6]-[#6]-1',
            '3-ethynylpyridine': '[#6]#[#6]-[#6]1:[#6]:[#6]:[#6]:[#7]:[#6]:1',
            '4-chlorobenzaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            'methylphosphonic acid': '[#6]-[#15](=[#8])(-[#8])-[#8]',
            'isobutyramide': '[#7]-[#6](=[#8])-[#6](-[#6])-[#6]',
            'cyclopropylmethanamine': '[#7]-[#6]-[#6]1-[#6]-[#6]-1',
            'N,N-dimethylpyrrolidin-3-amine': '[#7]1-[#6]-[#6]-[#6](-[#7](-[#6])-[#6])-[#6]-1',
            '4,5-dihydrooxazol-2-amine': '[#6]1-[#6]-[#8]-[#6](-[#7])=[#7]-1',
            '1,2,3,4-tetrahydroisoquinoline': '[#7]1-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#6]-1',
            '4-phenylmorpholine': '[#6]1:[#6]:[#6]:[#6](-[#7]2-[#6]-[#6]-[#8]-[#6]-[#6]-2):[#6]:[#6]:1',
            '4,5-dihydro-1H-imidazole': '[#6]1=[#7]-[#6]-[#6]-[#7]-1',
            '3-aminopropan-1-ol': '[#7]-[#6]-[#6]-[#6]-[#8]',
            '2,2,2-trifluoroacetaldehyde': '[#6](=[#8])-[#6](-[#9])(-[#9])-[#9]',
            'trifluoromethanethiol': '[#16]-[#6](-[#9])(-[#9])-[#9]',
            'N-ethylacetamide': '[#6]-[#6]-[#7]-[#6](-[#6])=[#8]',
            'N-methylaniline': '[#7](-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'phenylmethanethiol': '[#16]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '4-(pyrrolidin-1-yl)piperidine': '[#7]1-[#6]-[#6]-[#6](-[#7]2-[#6]-[#6]-[#6]-[#6]-2)-[#6]-[#6]-1',
            '4-(trifluoromethyl)pyrimidine': '[#6]1:[#7]:[#6]:[#6]:[#6](-[#6](-[#9])(-[#9])-[#9]):[#7]:1',
            '1-methoxy-3-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:1',
            'N-butylformamide': '[#6](=[#8])-[#7]-[#6]-[#6]-[#6]-[#6]',
            '2,2,2-trifluoroethan-1-ol': '[#8]-[#6]-[#6](-[#9])(-[#9])-[#9]',
            'p-toluidine': '[#7]-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            '1,3-dimethoxybenzene': '[#6]1:[#6]:[#6](-[#8]-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:1',
            'N,N-dimethyl-1-phenylmethanamine': '[#6]-[#7](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '2-methylnaphthalene': '[#6]-[#6]1:[#6]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]:1',
            'tetrahydrofuran': '[#6]1-[#6]-[#6]-[#6]-[#8]-1',
            'acrylic acid': '[#6]=[#6]-[#6](=[#8])-[#8]',
            '2-(methylamino)ethan-1-ol': '[#6]-[#7]-[#6]-[#6]-[#8]',
            '4-methylbenzaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            '3,4-dimethyl-1H-pyrazole-5-carboxylic acid': '[#6]-[#6]1:[#6](-[#6]):[#7]:[#7H]:[#6]:1-[#6](=[#8])-[#8]',
            'chloromethane': '[#6]-[#17]',
            'butyramide': '[#7]-[#6](=[#8])-[#6]-[#6]-[#6]',
            '1-chloro-4-hydrosulfonylbenzene': '[#16](=[#8])(=[#8])-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            'difluoromethane': '[#6](-[#9])-[#9]',
            '3-(pyrrolidin-1-yl)propan-1-ol': '[#8]-[#6]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'cyclopropylbenzene': '[#6]1-[#6]-[#6]-1-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'cumene': '[#6]1:[#6]:[#6]:[#6](-[#6](-[#6])-[#6]):[#6]:[#6]:1',
            '2-methyltetrahydrofuran': '[#6]-[#6]1-[#6]-[#6]-[#6]-[#8]-1',
            'N-methylpropan-2-amine': '[#6]-[#7]-[#6](-[#6])-[#6]',
            'alanine': '[#6]-[#6](-[#7])-[#6](=[#8])-[#8]',
            '1,2,3,6-tetrahydropyridine': '[#6]1=[#6]-[#6]-[#7]-[#6]-[#6]-1',
            '2-(trifluoromethyl)pyridine': '[#6]1:[#6]:[#6]:[#6](-[#6](-[#9])(-[#9])-[#9]):[#7]:[#6]:1',
            'hydroquinone': '[#8]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1',
            '4-fluoroaniline': '[#7]-[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1',
            '1-fluoro-2-methoxybenzene': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6](-[#9]):[#6]:1',
            '2-ethylidenehydrazine-1-carbothioamide': '[#6](-[#6])=[#7]-[#7]-[#6](-[#7])=[#16]',
            'furan-2-carbaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#8]:1',
            'butan-1-amine': '[#7]-[#6]-[#6]-[#6]-[#6]',
            'triaza-1,2-dien-2-ium': '[#7]=[#7+]=[#7]',
            'pyridin-2-ylmethanol': '[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1',
            'resorcinol': '[#6]1:[#6]:[#6](-[#8]):[#6]:[#6](-[#8]):[#6]:1',
            'piperidin-3-ol': '[#7]1-[#6]-[#6]-[#6]-[#6](-[#8])-[#6]-1',
            'cyclopropanecarboxamide': '[#7]-[#6](=[#8])-[#6]1-[#6]-[#6]-1',
            '1-methyl-1H-1,2,4-triazole': '[#6]-[#7]1:[#6]:[#7]:[#6]:[#7]:1',
            '4-chlorobenzene-1,2-diol': '[#8]-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1-[#8]',
            'N-methyl-1-phenylmethanamine': '[#7](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pyrazin-2-amine': '[#6]1:[#6]:[#7]:[#6](-[#7]):[#6]:[#7]:1',
            'thiophen-2-ylmethanamine': '[#7]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            '2-morpholinoethan-1-amine': '[#7]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'thiomorpholine 1,1-dioxide': '[#7]1-[#6]-[#6]-[#16](=[#8])(=[#8])-[#6]-[#6]-1',
            '2-isopropoxypyridine': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6](-[#6])-[#6]):[#7]:[#6]:1',
            'pyridazine': '[#6]1:[#6]:[#6]:[#7]:[#7]:[#6]:1',
            '3-fluoropyridine': '[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#7]:1',
            'isoquinoline': '[#6]1:[#6]:[#7]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            '4-chloroaniline': '[#7]-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            'pyrrolidin-2-one': '[#7]1-[#6]-[#6]-[#6]-[#6]-1=[#8]',
            '5-methyloctahydropyrrolo[3,4-b]pyrrole': '[#7]1-[#6]-[#6]-[#6]2-[#6]-[#7](-[#6])-[#6]-[#6]-1-2',
            '4-methoxybenzamide': '[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'm-cresol': '[#8]-[#6]1:[#6]:[#6]:[#6]:[#6](-[#6]):[#6]:1',
            '4,4,5,5-tetramethyl-1,3,2-dioxaborolane': '[#5]1-[#8]-[#6](-[#6])(-[#6])-[#6](-[#6])(-[#6])-[#8]-1',
            'N1,N1-dimethylethane-1,2-diamine': '[#7]-[#6]-[#6]-[#7](-[#6])-[#6]',
            '1-phenylthiourea': '[#7]-[#6](=[#16])-[#7]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '1-methyl-4-(trifluoromethyl)benzene': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#9])(-[#9])-[#9]):[#6]:[#6]:1',
            'isopropoxybenzene': '[#6]1:[#6]:[#6]:[#6](-[#8]-[#6](-[#6])-[#6]):[#6]:[#6]:1',
            '4-methoxypiperidine': '[#7]1-[#6]-[#6]-[#6](-[#8]-[#6])-[#6]-[#6]-1',
            '1,2-dichloro-4-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6](-[#17]):[#6]:1',
            '1-(4-chlorophenyl)urea': '[#7]-[#6](=[#8])-[#7]-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            'thiazol-2-amine': '[#7]-[#6]1:[#7]:[#6]:[#6]:[#16]:1',
            'o-xylene': '[#6]1:[#6]:[#6]:[#6](-[#6]):[#6](-[#6]):[#6]:1',
            '2-methyl-1,3,4-oxadiazole': '[#6]1:[#7]:[#7]:[#6](-[#6]):[#8]:1',
            '1-fluoro-3-methylbenzene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6](-[#9]):[#6]:1',
            '(methoxymethyl)benzene': '[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'hydrazine': '[#7]-[#7]',
            '1-cyclohexylurea': '[#7]-[#6](=[#8])-[#7]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'ethanethiol': '[#16]-[#6]-[#6]',
            'N-hydroxypentanamide': '[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#7]-[#8]',
            'thiophene-2-carboxamide': '[#7]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'N-(cyclopropylmethyl)formamide': '[#6](=[#8])-[#7]-[#6]-[#6]1-[#6]-[#6]-1',
            '1-ethyl-2-methylpyrrolidine': '[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-1-[#6]',
            'pyridin-4-ylmethanol': '[#8]-[#6]-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            'triethylamine': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]',
            '4-hydroxy-2-oxobut-3-enoic acid': '[#6](-[#8])=[#6]-[#6](=[#8])-[#6](=[#8])-[#8]',
            'isonicotinaldehyde': '[#6](=[#8])-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            '1,1,1-trifluoroethane': '[#6]-[#6](-[#9])(-[#9])-[#9]',
            'isothiocyanic acid': '[#7]=[#6]=[#16]',
            'phosphonic acid': '[#15](=[#8])(-[#8])-[#8]',
            '2-hydroxy-4-oxobut-2-enoic acid': '[#6](=[#8])-[#6]=[#6](-[#8])-[#6](=[#8])-[#8]',
            'N,N-dimethylpiperidin-4-amine': '[#6]-[#7](-[#6])-[#6]1-[#6]-[#6]-[#7]-[#6]-[#6]-1',
            '1-(pyridin-2-yl)piperazine': '[#7]1-[#6]-[#6]-[#7](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#7]:2)-[#6]-[#6]-1',

        }

        return smarts
