#!/usr/bin/env python3
#
# GlobalChem - Schedule One
#
# -----------------------------------

class ScheduleOne(object):

    def __init__(self):

        pass

    @staticmethod
    def get_smiles():

        smiles = {
            'acetyl-alpha-methylfentanyl': 'CC(CC1=CC=CC=C1)N2CCC(CC2)N(C3=CC=CC=C3)C(=O)C',
            'acetylmethadol': 'CCC(C(CC(C)N(C)C)(C1=CC=CC=C1)C2=CC=CC=C2)OC(=O)C',
            'acetylfentanyl': 'CC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3',
            'acrylfentanyl': 'C=CC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3',
            'ah-7921': 'ClC1=CC=C(C(NCC2(CCCCC2)N(C)C)=O)C=C1Cl',
            'allylprodine': 'CCC(=O)OC1(CCN(CC1CC=C)C)C2=CC=CC=C2',
            'alphaacetylmethadol': 'CCC(C(CC(C)N(C)C)(C1=CC=CC=C1)C2=CC=CC=C2)OC(=O)C',
            'alphameprodine': 'CCC1CN(CCC1(C2=CC=CC=C2)OC(=O)CC)C',
            'alphamethadol': 'CCC(C(CC(C)N(C)C)(C1=CC=CC=C1)C2=CC=CC=C2)O',
            'alpha-methylfentanyl': 'O=C(N(c1ccccc1)C3CCN(C(Cc2ccccc2)C)CC3)CC',
            'alpha-methylthiofentanyl': 'CCC(=O)N(C1CCN(CC1)C(C)CC2=CC=CS2)C3=CC=CC=C3',
            'benzethidine': 'CCOC(=O)C1(CCN(CC1)CCOCC2=CC=CC=C2)C3=CC=CC=C3',
            'betacetylmethadol': 'CCC(C(CC(C)N(C)C)(C1=CC=CC=C1)C2=CC=CC=C2)OC(=O)C',
            'beta-hydroxyfentanyl': 'CCC(=O)N(C1CCN(CC1)CC(C2=CC=CC=C2)O)C3=CC=CC=C3',
            'beta-hydroxy-3-methylfentanyl': 'CCC(=O)N(C1CCN(CC1C)CC(C2=CC=CC=C2)O)C3=CC=CC=C3',
            'beta-hydroxythiofentanyl': 'CCC(=O)N(C1CCN(CC1)CC(C2=CC=CS2)O)C3=CC=CC=C3',
            'betameprodine': 'CCC1CN(CCC1(C2=CC=CC=C2)OC(=O)CC)C',
            'betamethadol': 'CCC(C(CC(C)N(C)C)(C1=CC=CC=C1)C2=CC=CC=C2)O',
            'beta-methylfentanyl': 'CCC(=O)N(C1CCN(CC1)CC(C)C2=CC=CC=C2)C3=CC=CC=C3',
            'beta′-phenylfentanyl': 'O=C(CCC1=CC=CC=C1)N(C2CCN(CCC3=CC=CC=C3)CC2)C4=CC=CC=C4',
            'betaprodine': 'CCC(=O)OC1(CCN(CC1C)C)C2=CC=CC=C2',
            'butyrylfentanyl': 'CCCC(=O)N(C2CCN(CCc1ccccc1)CC2)c3ccccc3',
            'clonitazene': 'CCN(CC)CCN1C2=C(C=C(C=C2)[N+](=O)[O-])N=C1CC3=CC=C(C=C3)Cl',
            'crotonylfentanyl': 'CC=CC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3',
            'cyclopentylfentanyl': 'C1CCC(C1)C(=O)N(C2CCN(CC2)CCC3=CC=CC=C3)C4=CC=CC=C4',
            'cyclopropylfentanyl': 'C1CC1C(=O)N(C2CCN(CC2)CCC3=CC=CC=C3)C4=CC=CC=C4',
            'dextromoramide': 'CC(CN1CCOCC1)C(C2=CC=CC=C2)(C3=CC=CC=C3)C(=O)N4CCCC4',
            'diampromide': 'CCC(=O)N(CC(C)N(C)CCC1=CC=CC=C1)C2=CC=CC=C2',
            'diethylthiambutene': 'CCN(CC)C(C)C=C(C1=CC=CS1)C2=CC=CS2',
            'difenoxin': 'C1CN(CCC1(C2=CC=CC=C2)C(=O)O)CCC(C#N)(C3=CC=CC=C3)C4=CC=CC=C4',
            'dimenoxadol': 'CCOC(C1=CC=CC=C1)(C2=CC=CC=C2)C(=O)OCCN(C)C',
            'dimepheptanol': 'CCC(C(CC(C)N(C)C)(C1=CC=CC=C1)C2=CC=CC=C2)O',
            'dimethylthiambutene': 'CC(C=C(C1=CC=CS1)C2=CC=CS2)N(C)C',
            'dioxaphetylbutyrate': 'CCOC(=O)C(CCN1CCOCC1)(c1ccccc1)c1ccccc1',
            'dipipanone': 'CCC(=O)C(CC(C)N1CCCCC1)(C2=CC=CC=C2)C3=CC=CC=C3',
            'ethylmethylthiambutene': 'CCN(C)C(C)C=C(C1=CC=CS1)C2=CC=CS2',
            'etonitazene': 'CCN(CC)CCN1C2=C(C=C(C=C2)[N+](=O)[O-])N=C1CC3=CC=C(C=C3)OCC',
            'etoxeridine': 'CCOC(=O)C1(CCN(CC1)CCOCCO)C2=CC=CC=C2',
            'fentanylcarbamate': 'O=C(N(C1=CC=CC=C1)C2CCN(CCC3=CC=CC=C3)CC2)OCC',
            '4-fluoroisobutyrylfentanyl': 'CC(C)C(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=C(C=C3)F',
            '2′-fluoroortho-fluorofentanyl': 'O=C(CC)N(C1CCN(CCC2=CC=CC=C2F)CC1)C3=C(F)C=CC=C3',
            'furanylfentanyl': 'C1CN(CCC1N(C2=CC=CC=C2)C(=O)C3=CC=CO3)CCC4=CC=CC=C4',
            'furethidine': 'CCOC(=O)C1(CCN(CC1)CCOCC2CCCO2)C3=CC=CC=C3',
            'hydroxypethidine': 'CCOC(=O)C1(CCN(CC1)C)C2=CC(=CC=C2)O',
            'isobutyrylfentanyl': 'CC(C)C(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3',
            'isotonitazene': 'CCN(CC)CCN1C(CC2=CC=C(OC(C)C)C=C2)=NC3=CC([N+]([O-])=O)=CC=C31',
            'ketobemidone': 'CCC(=O)C1(CCN(CC1)C)C2=CC(=CC=C2)O',
            'levomoramide': 'C[C@@H](CN1CCOCC1)C(c1ccccc1)(c1ccccc1)C(=O)N1CCCC1',
            'levophenacylmorphan': 'C1CCC23CCN(C(C2C1)CC4=C3C=C(C=C4)O)CC(=O)C5=CC=CC=C5',
            'methoxyacetylfentanyl': 'c3ccccc3N(C(=O)COC)C1CCN(CC1)CCc2ccccc2',
            '4′-methylacetylfentanyl': 'CC(N(C1CCN(CCC2=CC=C(C)C=C2)CC1)C3=CC=CC=C3)=O',
            '3-methylfentanyl': 'CCC(=O)N(C1CCN(CC1C)CCC2=CC=CC=C2)C3=CC=CC=C3',
            '3-methylthiofentanyl': 'CCC(=O)N(C1CCN(CC1C)CCC2=CC=CS2)C3=CC=CC=C3',
            'morpheridine': 'CCOC(=O)C1(CCN(CC1)CCN2CCOCC2)C3=CC=CC=C3',
            'mppp': 'O=C(CC3=CC=CC=C3)N(C(C2=CC=CC=C2)CN1CCCC1)C',
            'mt-45': 'c3ccccc3CC(c2ccccc2)N(CC1)CCN1C4CCCCC4',
            'noracymethadol': 'CCC(C(CC(C)NC)(C1=CC=CC=C1)C2=CC=CC=C2)OC(=O)C',
            'norlevorphanol': 'C1CCC23CCNC(C2C1)CC4=C3C=C(C=C4)O',
            'normethadone': 'CCC(=O)C(CCN(C)C)(C1=CC=CC=C1)C2=CC=CC=C2',
            'norpipanone': 'CCC(=O)C(CCN1CCCCC1)(C2=CC=CC=C2)C3=CC=CC=C3',
            'ocfentanil': 'COCC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3F',
            'ortho-fluoroacrylfentanyl': 'O=C(N(C1=CC=CC=C1F)C2CCN(CCC3=CC=CC=C3)CC2)C=C',
            'ortho-fluorobutyrylfentanyl': 'CCCC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=C(C=C3)F',
            'ortho-fluorofentanyl': 'CCC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3F',
            'ortho-fluoroisobutyrylfentanyl': 'CC(C)C(=O)N(C1CCN(CCC2=CC=CC=C2)CC1)C3=C(F)C=CC=C3',
            'ortho-methylacetylfentanyl': 'CC(N(C1CCN(CCC2=CC=CC=C2)CC1)C3=C(C)C=CC=C3)=O',
            'ortho-methylmethoxyacetylfentanyl': 'O=C(COC)N(C1CCN(CCC2=CC=CC=C2)CC1)C3=C(C)C=CC=C3',
            'para-chloroisobutyrylfentanyl': 'O=C(C(C)C)N(C1CCN(CCC2=CC=CC=C2)CC1)C3=CC=C(Cl)C=C3',
            'para-fluorobutyrylfentanyl': 'C1C(CCN(C1)CCc1ccccc1)N(c1ccc(cc1)F)C(=O)CCC',
            'para-fluorofentanyl': 'CCC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=C(C=C3)F',
            'para-fluorofuranylfentanyl': 'O=C(C1=CC=CO1)N(C2CCN(CCC3=CC=CC=C3)CC2)C4=CC=C(F)C=C4',
            'para-methoxybutyrylfentanyl': 'O=C(CCC)N(C1CCN(CCC2=CC=CC=C2)CC1)C3=CC=C(OC)C=C3',
            'para-methylfentanyl': 'O=C(CC)N(C1CCN(CCC2=CC=CC=C2)CC1)C3=CC=C(C)C=C3',
            'pepap': 'O=C(C)OC1(CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3',
            'phenadoxone': 'CCC(=O)C(CC(C)N1CCOCC1)(C2=CC=CC=C2)C3=CC=CC=C3',
            'phenampromide': 'CCC(=O)N(C1=CC=CC=C1)C(C)CN2CCCCC2',
            'phenomorphan': 'C1CCC23CCN(C(C2C1)CC4=C3C=C(C=C4)O)CCC5=CC=CC=C5',
            'phenoperidine': 'CCOC(=O)C1(CCN(CC1)CCC(C2=CC=CC=C2)O)C3=CC=CC=C3',
            'phenylfentanyl': 'O=C(C1=CC=CC=C1)N(C2CCN(CCC3=CC=CC=C3)CC2)C4=CC=CC=C4',
            'piritramide': 'C1CCN(CC1)C2(CCN(CC2)CCC(C#N)(C3=CC=CC=C3)C4=CC=CC=C4)C(=O)N',
            'proheptazine': 'CCC(=O)OC1(CCCN(CC1C)C)C2=CC=CC=C2',
            'properidine': 'CC(C)OC(=O)C1(CCN(CC1)C)C2=CC=CC=C2',
            'propiram': 'CCC(=O)N(C1=CC=CC=N1)C(C)CN2CCCCC2',
            'racemoramide': 'CC(CN1CCOCC1)C(C2=CC=CC=C2)(C3=CC=CC=C3)C(=O)N4CCCC4',
            'tetrahydrofuranylfentanyl': 'C1CC(OC1)C(=O)N(C2CCN(CC2)CCC3=CC=CC=C3)C4=CC=CC=C4',
            'thiofentanyl': 'CCC(=O)N(C1CCN(CC1)CCC2=CC=CS2)C3=CC=CC=C3',
            'thiofuranylfentanyl': 'O=C(N(C1CCN(CCC2=CC=CC=C2)CC1)C3=CC=CC=C3)C4=CC=CS4',
            'tilidine': 'CCOC(=O)C1(CCC=CC1N(C)C)C2=CC=CC=C2',
            'trimeperidine': 'CCC(=O)OC1(CC(N(CC1C)C)C)C2=CC=CC=C2',
            'pinky': 'CN(C)C1CCCCC1N(C)C(=O)C2=CC(=C(C=C2)Cl)Cl',
            'valerylfentanyl': 'CCCCC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3',
            'acetorphine': 'CCCC(C)(C1CC23C=CC1(C4C25CCN(C3CC6=C5C(=C(C=C6)OC(=O)C)O4)C)OC)O',
            'acetyldihydrocodeine': 'CC(=O)OC1CCC2C3CC4=C5C2(C1OC5=C(C=C4)OC)CCN3C',
            'benzylmorphine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OCC6=CC=CC=C6)OC3C(C=C4)O',
            'codeinemethylbromide': 'C[N+]1(CCC23C4C1CC5=C2C(=C(C=C5)OC)OC3C(C=C4)O)C.[Br-]',
            'codeine-n-oxide': 'C[N+]1(CCC23C4C1CC5=C2C(=C(C=C5)OC)OC3C(C=C4)O)[O-]',
            'cyprenorphine': 'CC(C)(C1CC23C=CC1(C4C25CCN(C3CC6=C5C(=C(C=C6)O)O4)CC7CC7)OC)O',
            'desomorphine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)O)OC3CCC4',
            'dihydromorphine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)O)OC3C(CC4)O',
            'drotebanol': 'CN1CCC23CC(CCC2(C1CC4=C3C(=C(C=C4)OC)OC)O)O',
            'etorphine': 'CCCC(C)(C1CC23C=CC1(C4C25CCN(C3CC6=C5C(=C(C=C6)O)O4)C)OC)O',
            'heroin': 'CC(=O)OC1C=CC2C3CC4=C5C2(C1OC5=C(C=C4)OC(=O)C)CCN3C',
            'hydromorphinol': 'CN1CCC23C4C(CCC2(C1CC5=C3C(=C(C=C5)O)O4)O)O',
            'methyldesorphine': 'CC1=CCC2C3CC4=C5C2(C1OC5=C(C=C4)O)CCN3C',
            'methyldihydromorphine': 'CC1(CCC2C3CC4=C5C2(C1OC5=C(C=C4)O)CCN3C)O',
            'morphinemethylbromide': 'C[N+]1(CCC23C4C1CC5=C2C(=C(C=C5)O)OC3C(C=C4)O)C.[Br-]',
            'morphinemethylsulfonate': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OS(=O)(=O)C)OC3C(C=C4)O',
            'morphine-n-oxide': 'C[N+]1(CCC23C4C1CC5=C2C(=C(C=C5)O)OC3C(C=C4)O)[O-]',
            'myrophine': 'CCCCCCCCCCCCCC(=O)OC1C=CC2C3CC4=C5C2(C1OC5=C(C=C4)OCC6=CC=CC=C6)CCN3C',
            'nicocodeine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OC)OC3C(C=C4)OC(=O)C6=CN=CC=C6',
            'nicomorphine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OC(=O)C6=CN=CC=C6)OC3C(C=C4)OC(=O)C7=CN=CC=C7',
            'normorphine': 'C1CNC2CC3=C4C15C2C=CC(C5OC4=C(C=C3)O)O',
            'pholcodine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OCCN6CCOCC6)OC3C(C=C4)O',
            'thebacon': 'CC(=O)OC1=CCC2C3CC4=C5C2(C1OC5=C(C=C4)OC)CCN3C',
            'alpha-ethyltryptamine': 'CCC(CC1=CNC2=CC=CC=C21)N',
            '4-bromo-2,5-dimethoxy-amphetamine': 'CC(CC1=CC(=C(C=C1OC)Br)OC)N',
            '4-bromo-2,5-dimethoxyphenethylamine': 'COC1=CC(=C(C=C1CCN)OC)Br',
            '2,5-dimethoxyamphetamine': 'CC(CC1=C(C=CC(=C1)OC)OC)N',
            '2,5-dimethoxy-4-ethylamphet-amine': 'CCC1=CC(=C(C=C1OC)CC(C)N)OC',
            '2,5-dimethoxy-4-(n)-propylthiophenethylamine': 'CCCSC1=C(C=C(C(=C1)OC)CCN)OC',
            '4-methoxyamphetamine': 'CC(CC1=CC=C(C=C1)OC)N',
            '5-methoxy-3,4-methylenedioxy-amphetamine': 'CC(CC1=CC2=C(C(=C1)OC)OCO2)N',
            '4-methyl-2,5-dimethoxy-amphetamine': 'CC(CC1=CC(=C(C=C1OC)SC)OC)N',
            '3,4-methylenedioxyamphetamine': 'CC(CC1=CC2=C(C=C1)OCO2)N',
            '3,4-methylenedioxymethamphetamine': 'CC(CC1=CC2=C(C=C1)OCO2)NC',
            '3,4-methylenedioxy-n-ethylamphetamine': 'CCNC(C)CC1=CC2=C(C=C1)OCO2',
            'n-hydroxy-3,4-methylenedioxyamphetamine': 'CC(CC1=CC2=C(C=C1)OCO2)NO',
            '3,4,5-trimethoxyamphetamine': 'CC(CC1=CC(=C(C(=C1)OC)OC)OC)N',
            '5-methoxy-n,n-dimethyltryptamine': 'CN(C)CCC1=CNC2=C1C=C(C=C2)OC',
            'alpha-methyltryptamine': 'CC(CC1=CNC2=CC=CC=C21)N',
            'bufotenine': 'CN(C)CCC1=CNC2=C1C=C(C=C2)O',
            'diethyltryptamine': 'CCN(CC)CCC1=CNC2=CC=CC=C21',
            'dimethyltryptamine': 'CN(C)CCC1=CNC2=CC=CC=C21',
            '5-methoxy-n,n-diisopropyltryptamine': 'CC(C)N(CCC1=CNC2=C1C=C(C=C2)OC)C(C)C',
            'ibogaine': 'CCC1CC2CC3C1N(C2)CCC4=C3NC5=C4C=C(C=C5)OC',
            'lysergicaciddiethylamide': 'CCN(CC)C(=O)C1CN(C2CC3=CNC4=CC=CC(=C34)C2=C1)C',
            'marihuana': 'CCCCCC1=CC(=C2C3C=C(CCC3C(OC2=C1)(C)C)C)O',
            'mescaline': 'COC1=CC(=CC(=C1OC)OC)CCN',
            'parahexyl': 'CCCCCCC1=CC(=C2C3=C(CCC(C3)C)C(OC2=C1)(C)C)O',
            'peyote': 'COC1=CC(=CC(=C1OC)OC)CCN',
            'n-ethyl-3-piperidylbenzilate': 'O=C(OC1CCCN(CC)C1)C(O)(c2ccccc2)c3ccccc3',
            'n-methyl-3-piperidylbenzilate': 'CN1CCCC(C1)OC(=O)C(C2=CC=CC=C2)(C3=CC=CC=C3)O',
            'psilocybin': 'CN(C)CCC1=CNC2=C1C(=CC=C2)OP(=O)(O)O',
            'psilocyn': 'CN(C)CCC1=CNC2=C1C(=CC=C2)O',
            'tetrahydrocannabinols': 'CCCCCC1=CC(=C2C3C=C(CCC3C(OC2=C1)(C)C)C)O',
            'n-ethyl-1-phenylcyclohexylamine': 'ClC(Cl)=C(Cl)Cl',
            'pyrrolidine-phencyclidine': 'c1ccccc1C3(N2CCCC2)CCCCC3',
            'thiophene-phencyclidine': 'C1CCC(CC1)(C2=CC=CS2)N3CCCCC3',
            '1-[1-(2-thienyl)cyclohexyl]pyrrolidine': 'C1CCC(CC1)(C2=CC=CS2)N3CCCC3',
            'mephedrone': 'CC1=CC=C(C=C1)C(=O)C(C)NC',
            'mdpv': 'CCCC(C(=O)C1=CC2=C(C=C1)OCO2)N3CCCC3',
            '2c-e': 'COc1cc(CC)c(cc1CCN)OC',
            '2c-d': 'O(c1cc(c(OC)cc1CCN)C)C',
            '2c-c': 'COc1cc(CCN)c(cc1Cl)OC',
            '2c-i': 'Ic1cc(OC)c(cc1OC)CCN',
            '2c-t-2': 'CCSc1cc(OC)c(cc1OC)CCN',
            '2c-t-4': 'CC(C)Sc1cc(OC)c(cc1OC)CCN',
            '2c-h': 'O(c1ccc(OC)cc1CCN)C',
            '2c-n': '[O-][N+](=O)c1cc(OC)c(cc1OC)CCN',
            '2c-p': 'COC1=C(CCN)C=C(OC)C(CCC)=C1',
            'methylone': 'CC(C(=O)C1=CC2=C(C=C1)OCO2)NC',
            'ur-144': 'CCCCCN1C=C(C2=CC=CC=C21)C(=O)C3C(C3(C)C)(C)C',
            '5-fluoro-ur-144': 'FCCCCCN1C=C(C(C2C(C)(C)C2(C)C)=O)C3=C1C=CC=C3',
            'apinaca': 'C3C4CC2CC3CC(C4)(C2)NC(=O)c(nn1CCCCC)c5c1cccc5',
            'quinolin-8-yl 5-fluoro-1-pentylindole-3-carboxylate': 'CCCCCN1C=C(C2=C1C=CC(=C2)F)C(=O)OC3=CC=CC4=C3N=CC=C4',
            'quinolin-8-yl1-(5-fluoropentyl)-1h-indole-3-carboxylate': 'C1=CC=C2C(=C1)C(=CN2CCCCCF)C(=O)OC3=CC=CC4=C3N=CC=C4',
            'n-(1-amino-3-methyl-1-oxobutan-2-yl)-1-(4-fluorobenzyl)-1h-indazole-3-carboxamide': 'CC(C)C(C(=O)N)NC(=O)C1=NN(C2=CC=CC=C21)CC3=CC=C(C=C3)F',
            'n-(1-amino-3,3-dimethyl-1-oxobutan-2-yl)-1-pentyl-1h-indazole-3-carboxamide': 'O=C(C1=NN(CCCCC)C2=C1C=CC=C2)NC(C(C)(C)C)C(N)=O',
            '2c-i-nbome': 'COC1=CC=CC=C1CNCCC2=CC(=C(C=C2OC)I)OC',
            '2c-c-nbome': 'COc2ccccc2CNCCc(cc1OC)c(OC)cc1Cl',
            '2c-b-nbome': 'COC1=CC=CC=C1CNCCC2=CC(=C(C=C2OC)Br)OC',
            '4-mec': 'CCNC(C)C(=O)C1=CC=C(C=C1)C',
            '4-meppp': 'CC1=CC=C(C=C1)C(=O)C(C)N2CCCC2',
            'alpha-pvp': 'CCCC(C(C1=CC=CC=C1)=O)N2CCCC2',
            'butylone': 'CCC(C(=O)C1=CC2=C(C=C1)OCO2)NC',
            'pentedrone': 'CCCC(C(=O)C1=CC=CC=C1)NC',
            'pentylone': 'CCCC(C(=O)C1=CC2=C(C=C1)OCO2)NC',
            'flephedrone': 'CC(C(=O)C1=CC=C(C=C1)F)NC',
            '3-fmc': 'FC1=CC=CC(=C1)C(C(C)NC)=O',
            'naphyrone': 'CCCC(C(C1=CC2=C(C=C1)C=CC=C2)=O)N3CCCC3',
            'alpha-pbp': 'C2CCCN2C(CC)C(=O)c1ccccc1',
            'ab-chminaca': 'CC(C)C(C(=O)N)NC(=O)C1=NN(C2=CC=CC=C21)CC3CCCCC3',
            'ab-pinaca': 'CCCCCN1C2=CC=CC=C2C(=N1)C(=O)NC(C(C)C)C(=O)N',
            'thj-2201': 'O=C(C1=CC=CC2=C1C=CC=C2)C3=NN(CCCCCF)C4=C3C=CC=C4',
            'mab-chminaca': 'O=C(NC(C(N)=O)C(C)(C)C)C1=NN(CC2CCCCC2)C3=C1C=CC=C3',
            '5f-mdmb-pinaca': 'COC(=O)C(NC(=O)c1nn(CCCCCF)c2ccccc12)C(C)(C)C',
            '5f-amb': 'CC(C)C(C(=O)OC)NC(=O)C1=NN(C2=CC=CC=C21)CCCCCF',
            '5f-apinaca': 'O=C(C1=NN(C2=C1C=CC=C2)CCCCCF)NC34CC5CC(C4)CC(C5)C3',
            'adb-fubinaca': 'CC(C)(C)C(C(=O)N)NC(=O)C1=NN(C2=CC=CC=C21)CC3=CC=C(C=C3)F',
            'mdmb-chmica': 'COC(=O)[C@@H](NC(=O)c1cn(CC2CCCCC2)c3ccccc13)C(C)(C)C',
            'mdmb-fubinaca': 'CC(C)(C)C(C(=O)OC)NC(=O)C1=NN(C2=CC=CC=C21)CC3=CC=C(C=C3)F',
            'mmb-fubinaca': 'FC(C=C1)=CC=C1CN2N=C(C(N[C@H](C(OC)=O)C(C)C)=O)C3=CC=CC=C32',
            'ethylone': 'CCNC(C)C(=O)C1=CC2=C(C=C1)OCO2',
            'nm2201': 'FCCCCCN1C=C(C(OC2=C(C=CC=C3)C3=CC=C2)=O)C4=CC=CC=C41',
            '5f-ab-pinaca': 'CC(C)C(C(=O)N)NC(=O)C1=NN(C2=CC=CC=C21)CCCCCF',
            '4-cn-cumyl-butinaca': 'O=C(NC(C)(C)C1=CC=CC=C1)C2=NN(CCCCC#N)C3=C2C=CC=C3',
            'mmb-chmica': 'CC(C)C(C(=O)OC)NC(=O)C1=CN(C2=CC=CC=C21)CC3CCCCC3',
            '5f-cumyl-p7aica': 'CC(C)(C1=CC=CC=C1)NC(=O)C2=CN(C3=C2C=CC=N3)CCCCCF',
            'n-ethylpentylone': 'CCCC(C(=O)C1=CC2=C(C=C1)OCO2)NCC',
            '4f-mdmb-binaca': 'O=C(N[C@H](C(OC)=O)C(C)(C)C)C1=NN(CCCCF)C2=C1C=CC=C2',
            'para-methoxymethamphetamine': 'CC(CC1=CC=C(C=C1)OC)NC',
            'gamma-hydroxybutyricacid': 'C(CC(=O)O)CO',
            'mecloqualone': 'CC1=NC2=CC=CC=C2C(=O)N1C3=CC=CC=C3Cl',
            'methaqualone': 'CC1=CC=CC=C1N2C(=NC3=CC=CC=C3C2=O)C',
            'aminorex': 'C1C(OC(=N1)N)C2=CC=CC=C2',
            'n-benzylpiperazine': 'C1CN(CCN1)CC2=CC=CC=C2',
            'cathinone': 'CC(C(=O)C1=CC=CC=C1)N',
            '4,4′-dimethylaminorex': 'CC(N=C(N)O1)C1C2=CC=C(C)C=C2',
            'fenethylline': 'CC(CC1=CC=CC=C1)NCCN2C=NC3=C2C(=O)N(C(=O)N3C)C',
            'methcathinone': 'CC(C(=O)C1=CC=CC=C1)NC',
            '(±)cis-4-methylaminorex': 'CC1C(OC(=N1)N)C2=CC=CC=C2',
            'n-ethylamphetamine': 'CC(NCC)CC1=CC=CC=C1',
            'n,n-dimethylamphetamine': 'CC(CC1=CC=CC=C1)N(C)C',
            'cp-47,479': 'CCCCCCC(C)(C)c1ccc(c(c1)O)[C@H]2CCC[C@H](C2)O',
            'cannabicyclohexanol': 'CCCCCCCC(C)(C)C1=CC(=C(C=C1)C2CCCC(C2)O)O',
            'jwh-018': 'CCCCCN1C=C(C(C2=CC=CC3=CC=CC=C32)=O)C4=CC=CC=C41',
            'jwh-073': 'CCCCN1C=C(C2=CC=CC=C21)C(=O)C3=CC=CC4=CC=CC=C43',
            'jwh-019': 'c3cccc2c3cccc2C(=O)c1cn(CCCCCC)c4c1cccc4',
            'jwh-200': 'O=C(C1=CC=CC2=C1C=CC=C2)C3=CN(C4=C3C=CC=C4)CCN5CCOCC5',
            'jwh-250': 'COc2ccccc2CC(=O)c(c3ccccc13)cn1CCCCC',
            'jwh-081': 'CCCCCn3c1ccccc1c(c3)C(=O)c4c2ccccc2c(OC)cc4',
            'jwh-122': 'CCCCCn1cc(c2c1cccc2)C(=O)c3ccc(c4c3cccc4)C',
            'jwh-398': 'c14ccccc1n(CCCCC)cc4C(=O)c(cc3)c2ccccc2c3Cl',
            'am-2201': 'O=C(C1=CN(CCCCCF)C2=C1C=CC=C2)C3=CC=CC4=C3C=CC=C4',
            'am-694': 'Ic2ccccc2C(=O)c1cn(CCCCCF)c3ccccc13',
            'rcs-4': 'CCCCCn1cc(c2c1cccc2)C(=O)c3ccc(cc3)OC',
            'rcs-8': 'COc1ccccc1CC(=O)c2cn(c3c2cccc3)CCC4CCCCC4',
            'jwh-203': 'Clc2ccccc2CC(=O)c1cn(CCCCC)c3ccccc13',
            '5f-edmb-pinaca': 'CC(C)(C)C(NC(C1=NN(CCCCCF)C2=C1C=CC=C2)=O)C(OCC)=O',
            '5f-mdmb-pica': 'O=C(N[C@H](C(OC)=O)C(C)(C)C)C1=CN(CCCCCF)C2=C1C=CC=C2',
            'fub-apinaca': 'C1C2CC3CC1CC(C2)(C3)NC(=O)C4=NN(C5=CC=CC=C54)CC6=CC=C(C=C6)F',
            '5f-cumyl-pinaca': 'CC(C)(C1=CC=CC=C1)NC(=O)C2=NN(C3=CC=CC=C32)CCCCCF',
            'fub-144': 'Fc1ccc(cc1)Cn1cc(c2c1cccc2)C(=O)C1C(C1(C)C)(C)C',
            '2-(ethylamino)-1-phenylhexan-1-one': 'CCCCC(C(=O)C1=CC=CC=C1)NCC',
            'alpha-pyrrolidinohexiophenone': 'C1(=CC=CC=C1)C(C(CCCC)N2CCCC2)=O',
            '4-meap': 'CC1=CC=C(C(C(CCC)NCC)=O)C=C1',
            '4′-methyl-alpha-pyrrolidinohexanophenone': 'CC1=CC=C(C(C(CCCC)N2CCCC2)=O)C=C1',
            '1-phenyl-2-(pyrrolidin-1-yl)heptan-1-one': 'CCCCCC(C(=O)C1=CC=CC=C1)N2CCCC2',
            '4′-chloro-alpha-pvp': 'CCCC(C(=O)C1=CC=C(C=C1)Cl)N2CCCC2',
            'brorphine': 'CC(C1=CC=C(Br)C=C1)N2CCC(N3C(NC4=C3C=CC=C4)=O)CC2',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'acetyl-alpha-methylfentanyl': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#6]',
            'acetylmethadol': '[#6]-[#6]-[#6](-[#6](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]',
            'acetylfentanyl': '[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'acrylfentanyl': '[#6]=[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'ah-7921': '[#17]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#7]-[#6]-[#6]2(-[#6]-[#6]-[#6]-[#6]-[#6]-2)-[#7](-[#6])-[#6])=[#8]):[#6]:[#6]:1-[#17]',
            'allylprodine': '[#6]-[#6]-[#6](=[#8])-[#8]-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1-[#6]-[#6]=[#6])-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'alphaacetylmethadol': '[#6]-[#6]-[#6](-[#6](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]',
            'alphameprodine': '[#6]-[#6]-[#6]1-[#6]-[#7](-[#6]-[#6]-[#6]-1(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]-[#6])-[#6]',
            'alphamethadol': '[#6]-[#6]-[#6](-[#6](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]',
            'alpha-methylfentanyl': '[#8]=[#6](-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1-[#6]-[#6]-[#7](-[#6](-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6])-[#6]-[#6]-1)-[#6]-[#6]',
            'alpha-methylthiofentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'benzethidine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'betacetylmethadol': '[#6]-[#6]-[#6](-[#6](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]',
            'beta-hydroxyfentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'beta-hydroxy-3-methylfentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1-[#6])-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'beta-hydroxythiofentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'betameprodine': '[#6]-[#6]-[#6]1-[#6]-[#7](-[#6]-[#6]-[#6]-1(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]-[#6])-[#6]',
            'betamethadol': '[#6]-[#6]-[#6](-[#6](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]',
            'beta-methylfentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6](-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'beta′-phenylfentanyl': '[#8]=[#6](-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'betaprodine': '[#6]-[#6]-[#6](=[#8])-[#8]-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1-[#6])-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'butyrylfentanyl': '[#6]-[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'clonitazene': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]-[#7]1:[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2)-[#7+](=[#8])-[#8-]):[#7]:[#6]:1-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#17]',
            'crotonylfentanyl': '[#6]-[#6]=[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'cyclopentylfentanyl': '[#6]1-[#6]-[#6]-[#6](-[#6]-1)-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'cyclopropylfentanyl': '[#6]1-[#6]-[#6]-1-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'dextromoramide': '[#6]-[#6](-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1)-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'diampromide': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'diethylthiambutene': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6](-[#6])-[#6]=[#6](-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'difenoxin': '[#6]1-[#6]-[#7](-[#6]-[#6]-[#6]-1(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#8])-[#6]-[#6]-[#6](-[#6]#[#7])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'dimenoxadol': '[#6]-[#6]-[#8]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#8]-[#6]-[#6]-[#7](-[#6])-[#6]',
            'dimepheptanol': '[#6]-[#6]-[#6](-[#6](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]',
            'dimethylthiambutene': '[#6]-[#6](-[#6]=[#6](-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#7](-[#6])-[#6]',
            'dioxaphetylbutyrate': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6](-[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'dipipanone': '[#6]-[#6]-[#6](=[#8])-[#6](-[#6]-[#6](-[#6])-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'ethylmethylthiambutene': '[#6]-[#6]-[#7](-[#6])-[#6](-[#6])-[#6]=[#6](-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'etonitazene': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]-[#7]1:[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2)-[#7+](=[#8])-[#8-]):[#7]:[#6]:1-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#6]',
            'etoxeridine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#8]-[#6]-[#6]-[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'fentanylcarbamate': '[#8]=[#6](-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#8]-[#6]-[#6]',
            '4-fluoroisobutyrylfentanyl': '[#6]-[#6](-[#6])-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9]',
            '2′-fluoroortho-fluorofentanyl': '[#8]=[#6](-[#6]-[#6])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#9])-[#6]-[#6]-1)-[#6]1:[#6](-[#9]):[#6]:[#6]:[#6]:[#6]:1',
            'furanylfentanyl': '[#6]1-[#6]-[#7](-[#6]-[#6]-[#6]-1-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#8]:1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'furethidine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#8]-[#6]-[#6]1-[#6]-[#6]-[#6]-[#8]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'hydroxypethidine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6])-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#8]',
            'isobutyrylfentanyl': '[#6]-[#6](-[#6])-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'isotonitazene': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]-[#7]1:[#6](-[#6]-[#6]2:[#6]:[#6]:[#6](-[#8]-[#6](-[#6])-[#6]):[#6]:[#6]:2):[#7]:[#6]2:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:[#6]:1:2',
            'ketobemidone': '[#6]-[#6]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6])-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#8]',
            'levomoramide': '[#6]-[#6@@H](-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1)-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'levophenacylmorphan': '[#6]1-[#6]-[#6]-[#6]23-[#6]-[#6]-[#7](-[#6](-[#6]-2-[#6]-1)-[#6]-[#6]1:[#6]-3:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#6]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'methoxyacetylfentanyl': '[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7](-[#6](=[#8])-[#6]-[#8]-[#6])-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '4′-methylacetylfentanyl': '[#6]-[#6](-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8]',
            '3-methylfentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1-[#6])-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '3-methylthiofentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1-[#6])-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'morpheridine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'mppp': '[#8]=[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7](-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-1)-[#6]',
            'mt-45': '[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'noracymethadol': '[#6]-[#6]-[#6](-[#6](-[#6]-[#6](-[#6])-[#7]-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]',
            'norlevorphanol': '[#6]1-[#6]-[#6]-[#6]23-[#6]-[#6]-[#7]-[#6](-[#6]-2-[#6]-1)-[#6]-[#6]1:[#6]-3:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'normethadone': '[#6]-[#6]-[#6](=[#8])-[#6](-[#6]-[#6]-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'norpipanone': '[#6]-[#6]-[#6](=[#8])-[#6](-[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'ocfentanil': '[#6]-[#8]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#9]',
            'ortho-fluoroacrylfentanyl': '[#8]=[#6](-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#9])-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]=[#6]',
            'ortho-fluorobutyrylfentanyl': '[#6]-[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9]',
            'ortho-fluorofentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#9]',
            'ortho-fluoroisobutyrylfentanyl': '[#6]-[#6](-[#6])-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6](-[#9]):[#6]:[#6]:[#6]:[#6]:1',
            'ortho-methylacetylfentanyl': '[#6]-[#6](-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6](-[#6]):[#6]:[#6]:[#6]:[#6]:1)=[#8]',
            'ortho-methylmethoxyacetylfentanyl': '[#8]=[#6](-[#6]-[#8]-[#6])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6](-[#6]):[#6]:[#6]:[#6]:[#6]:1',
            'para-chloroisobutyrylfentanyl': '[#8]=[#6](-[#6](-[#6])-[#6])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6](-[#17]):[#6]:[#6]:1',
            'para-fluorobutyrylfentanyl': '[#6]1-[#6](-[#6]-[#6]-[#7](-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7](-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9])-[#6](=[#8])-[#6]-[#6]-[#6]',
            'para-fluorofentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9]',
            'para-fluorofuranylfentanyl': '[#8]=[#6](-[#6]1:[#6]:[#6]:[#6]:[#8]:1)-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6](-[#9]):[#6]:[#6]:1',
            'para-methoxybutyrylfentanyl': '[#8]=[#6](-[#6]-[#6]-[#6])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'para-methylfentanyl': '[#8]=[#6](-[#6]-[#6])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            'pepap': '[#8]=[#6](-[#6])-[#8]-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'phenadoxone': '[#6]-[#6]-[#6](=[#8])-[#6](-[#6]-[#6](-[#6])-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'phenampromide': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#6])-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'phenomorphan': '[#6]1-[#6]-[#6]-[#6]23-[#6]-[#6]-[#7](-[#6](-[#6]-2-[#6]-1)-[#6]-[#6]1:[#6]-3:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'phenoperidine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'phenylfentanyl': '[#8]=[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'piritramide': '[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6](-[#6]#[#7])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#7]',
            'proheptazine': '[#6]-[#6]-[#6](=[#8])-[#8]-[#6]1(-[#6]-[#6]-[#6]-[#7](-[#6]-[#6]-1-[#6])-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'properidine': '[#6]-[#6](-[#6])-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'propiram': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1)-[#6](-[#6])-[#6]-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'racemoramide': '[#6]-[#6](-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1)-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'tetrahydrofuranylfentanyl': '[#6]1-[#6]-[#6](-[#8]-[#6]-1)-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'thiofentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'thiofuranylfentanyl': '[#8]=[#6](-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'tilidine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#6]=[#6]-[#6]-1-[#7](-[#6])-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'trimeperidine': '[#6]-[#6]-[#6](=[#8])-[#8]-[#6]1(-[#6]-[#6](-[#7](-[#6]-[#6]-1-[#6])-[#6])-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pinky': '[#6]-[#7](-[#6])-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1-[#7](-[#6])-[#6](=[#8])-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#17])-[#17]',
            'valerylfentanyl': '[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'acetorphine': '[#6]-[#6]-[#6]-[#6](-[#6])(-[#6]1-[#6]-[#6]23-[#6]=[#6]-[#6]-1(-[#6]1-[#6]-24-[#6]-[#6]-[#7](-[#6]-3-[#6]-[#6]2:[#6]-4:[#6](:[#6](:[#6]:[#6]:2)-[#8]-[#6](=[#8])-[#6])-[#8]-1)-[#6])-[#8]-[#6])-[#8]',
            'acetyldihydrocodeine': '[#6]-[#6](=[#8])-[#8]-[#6]1-[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]4:[#6]5-[#6]-2(-[#6]-1-[#8]-[#6]:5:[#6](:[#6]:[#6]:4)-[#8]-[#6])-[#6]-[#6]-[#7]-3-[#6]',
            'benzylmorphine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]',
            'codeinemethylbromide': '[#6]-[#7+]1(-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8])-[#6].[#35-]',
            'codeine-n-oxide': '[#6]-[#7+]1(-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8])-[#8-]',
            'cyprenorphine': '[#6]-[#6](-[#6])(-[#6]1-[#6]-[#6]23-[#6]=[#6]-[#6]-1(-[#6]1-[#6]-24-[#6]-[#6]-[#7](-[#6]-3-[#6]-[#6]2:[#6]-4:[#6](:[#6](:[#6]:[#6]:2)-[#8])-[#8]-1)-[#6]-[#6]1-[#6]-[#6]-1)-[#8]-[#6])-[#8]',
            'desomorphine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6]-[#6]-[#6]-4',
            'dihydromorphine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6](-[#6]-[#6]-4)-[#8]',
            'drotebanol': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]-[#6](-[#6]-[#6]-[#6]-2(-[#6]-1-[#6]-[#6]1:[#6]-3:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-[#6])-[#8])-[#8]',
            'etorphine': '[#6]-[#6]-[#6]-[#6](-[#6])(-[#6]1-[#6]-[#6]23-[#6]=[#6]-[#6]-1(-[#6]1-[#6]-24-[#6]-[#6]-[#7](-[#6]-3-[#6]-[#6]2:[#6]-4:[#6](:[#6](:[#6]:[#6]:2)-[#8])-[#8]-1)-[#6])-[#8]-[#6])-[#8]',
            'heroin': '[#6]-[#6](=[#8])-[#8]-[#6]1-[#6]=[#6]-[#6]2-[#6]3-[#6]-[#6]4:[#6]5-[#6]-2(-[#6]-1-[#8]-[#6]:5:[#6](:[#6]:[#6]:4)-[#8]-[#6](=[#8])-[#6])-[#6]-[#6]-[#7]-3-[#6]',
            'hydromorphinol': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6](-[#6]-[#6]-[#6]-2(-[#6]-1-[#6]-[#6]1:[#6]-3:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-4)-[#8])-[#8]',
            'methyldesorphine': '[#6]-[#6]1=[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]4:[#6]5-[#6]-2(-[#6]-1-[#8]-[#6]:5:[#6](:[#6]:[#6]:4)-[#8])-[#6]-[#6]-[#7]-3-[#6]',
            'methyldihydromorphine': '[#6]-[#6]1(-[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]4:[#6]5-[#6]-2(-[#6]-1-[#8]-[#6]:5:[#6](:[#6]:[#6]:4)-[#8])-[#6]-[#6]-[#7]-3-[#6])-[#8]',
            'morphinemethylbromide': '[#6]-[#7+]1(-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8])-[#6].[#35-]',
            'morphinemethylsulfonate': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#16](=[#8])(=[#8])-[#6])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]',
            'morphine-n-oxide': '[#6]-[#7+]1(-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8])-[#8-]',
            'myrophine': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]1-[#6]=[#6]-[#6]2-[#6]3-[#6]-[#6]4:[#6]5-[#6]-2(-[#6]-1-[#8]-[#6]:5:[#6](:[#6]:[#6]:4)-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]-[#6]-[#7]-3-[#6]',
            'nicocodeine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]-[#6](=[#8])-[#6]1:[#6]:[#7]:[#6]:[#6]:[#6]:1',
            'nicomorphine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]1:[#6]:[#7]:[#6]:[#6]:[#6]:1)-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]-[#6](=[#8])-[#6]1:[#6]:[#7]:[#6]:[#6]:[#6]:1',
            'normorphine': '[#6]1-[#6]-[#7]-[#6]2-[#6]-[#6]3:[#6]4-[#6]-15-[#6]-2-[#6]=[#6]-[#6](-[#6]-5-[#8]-[#6]:4:[#6](:[#6]:[#6]:3)-[#8])-[#8]',
            'pholcodine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1)-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]',
            'thebacon': '[#6]-[#6](=[#8])-[#8]-[#6]1=[#6]-[#6]-[#6]2-[#6]3-[#6]-[#6]4:[#6]5-[#6]-2(-[#6]-1-[#8]-[#6]:5:[#6](:[#6]:[#6]:4)-[#8]-[#6])-[#6]-[#6]-[#7]-3-[#6]',
            'alpha-ethyltryptamine': '[#6]-[#6]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#7]',
            '4-bromo-2,5-dimethoxy-amphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#8]-[#6])-[#35])-[#8]-[#6])-[#7]',
            '4-bromo-2,5-dimethoxyphenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#6]-[#6]-[#7])-[#8]-[#6])-[#35]',
            '2,5-dimethoxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1)-[#8]-[#6])-[#8]-[#6])-[#7]',
            '2,5-dimethoxy-4-ethylamphet-amine': '[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#8]-[#6])-[#6]-[#6](-[#6])-[#7])-[#8]-[#6]',
            '2,5-dimethoxy-4-(n)-propylthiophenethylamine': '[#6]-[#6]-[#6]-[#16]-[#6]1:[#6](:[#6]:[#6](:[#6](:[#6]:1)-[#8]-[#6])-[#6]-[#6]-[#7])-[#8]-[#6]',
            '4-methoxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#7]',
            '5-methoxy-3,4-methylenedioxy-amphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6](:[#6]:1)-[#8]-[#6])-[#8]-[#6]-[#8]-2)-[#7]',
            '4-methyl-2,5-dimethoxy-amphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#8]-[#6])-[#16]-[#6])-[#8]-[#6])-[#7]',
            '3,4-methylenedioxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]',
            '3,4-methylenedioxymethamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]-[#6]',
            '3,4-methylenedioxy-n-ethylamphetamine': '[#6]-[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2',
            'n-hydroxy-3,4-methylenedioxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]-[#8]',
            '3,4,5-trimethoxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8]-[#6])-[#8]-[#6])-[#8]-[#6])-[#7]',
            '5-methoxy-n,n-dimethyltryptamine': '[#6]-[#7](-[#6])-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6](:[#6]:[#6]:2)-[#8]-[#6]',
            'alpha-methyltryptamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#7]',
            'bufotenine': '[#6]-[#7](-[#6])-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6](:[#6]:[#6]:2)-[#8]',
            'diethyltryptamine': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            'dimethyltryptamine': '[#6]-[#7](-[#6])-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            '5-methoxy-n,n-diisopropyltryptamine': '[#6]-[#6](-[#6])-[#7](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6](:[#6]:[#6]:2)-[#8]-[#6])-[#6](-[#6])-[#6]',
            'ibogaine': '[#6]-[#6]-[#6]1-[#6]-[#6]2-[#6]-[#6]3-[#6]-1-[#7](-[#6]-2)-[#6]-[#6]-[#6]1:[#6]-3:[#7H]:[#6]2:[#6]:1:[#6]:[#6](:[#6]:[#6]:2)-[#8]-[#6]',
            'lysergicaciddiethylamide': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6](=[#8])-[#6]1-[#6]-[#7](-[#6]2-[#6]-[#6]3:[#6]:[#7H]:[#6]4:[#6]:[#6]:[#6]:[#6](:[#6]:3:4)-[#6]-2=[#6]-1)-[#6]',
            'marihuana': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'mescaline': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            'parahexyl': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3=[#6](-[#6]-[#6]-[#6](-[#6]-3)-[#6])-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#8]',
            'peyote': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            'n-ethyl-3-piperidylbenzilate': '[#8]=[#6](-[#8]-[#6]1-[#6]-[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-1)-[#6](-[#8])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'n-methyl-3-piperidylbenzilate': '[#6]-[#7]1-[#6]-[#6]-[#6]-[#6](-[#6]-1)-[#8]-[#6](=[#8])-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]',
            'psilocybin': '[#6]-[#7](-[#6])-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6](:[#6]:[#6]:[#6]:2)-[#8]-[#15](=[#8])(-[#8])-[#8]',
            'psilocyn': '[#6]-[#7](-[#6])-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6](:[#6]:[#6]:[#6]:2)-[#8]',
            'tetrahydrocannabinols': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'n-ethyl-1-phenylcyclohexylamine': '[#17]-[#6](-[#17])=[#6](-[#17])-[#17]',
            'pyrrolidine-phencyclidine': '[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]1(-[#7]2-[#6]-[#6]-[#6]-[#6]-2)-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'thiophene-phencyclidine': '[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            '1-[1-(2-thienyl)cyclohexyl]pyrrolidine': '[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'mephedrone': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#8])-[#6](-[#6])-[#7]-[#6]',
            'mdpv': '[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            '2c-e': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#6]-[#6]):[#6](:[#6]:[#6]:1-[#6]-[#6]-[#7])-[#8]-[#6]',
            '2c-d': '[#8](-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6]-[#6]-[#7])-[#6])-[#6]',
            '2c-c': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#6]-[#6]-[#7]):[#6](:[#6]:[#6]:1-[#17])-[#8]-[#6]',
            '2c-i': '[#53]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:[#6]:1-[#8]-[#6])-[#6]-[#6]-[#7]',
            '2c-t-2': '[#6]-[#6]-[#16]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:[#6]:1-[#8]-[#6])-[#6]-[#6]-[#7]',
            '2c-t-4': '[#6]-[#6](-[#6])-[#16]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:[#6]:1-[#8]-[#6])-[#6]-[#6]-[#7]',
            '2c-h': '[#8](-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6]-[#6]-[#7])-[#6]',
            '2c-n': '[#8-]-[#7+](=[#8])-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:[#6]:1-[#8]-[#6])-[#6]-[#6]-[#7]',
            '2c-p': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](-[#6]-[#6]-[#6]):[#6]:1',
            'methylone': '[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]-[#6]',
            'ur-144': '[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6](=[#8])-[#6]1-[#6](-[#6]-1(-[#6])-[#6])(-[#6])-[#6]',
            '5-fluoro-ur-144': '[#9]-[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](-[#6](-[#6]2-[#6](-[#6])(-[#6])-[#6]-2(-[#6])-[#6])=[#8]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'apinaca': '[#6]1-[#6]2-[#6]-[#6]3-[#6]-[#6]-1-[#6]-[#6](-[#6]-2)(-[#6]-3)-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'quinolin-8-yl 5-fluoro-1-pentylindole-3-carboxylate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6](:[#6]:2)-[#9])-[#6](=[#8])-[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]2:[#6]:1:[#7]:[#6]:[#6]:[#6]:2',
            'quinolin-8-yl1-(5-fluoropentyl)-1h-indole-3-carboxylate': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1):[#6](:[#6]:[#7]:2-[#6]-[#6]-[#6]-[#6]-[#6]-[#9])-[#6](=[#8])-[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]2:[#6]:1:[#7]:[#6]:[#6]:[#6]:2',
            'n-(1-amino-3-methyl-1-oxobutan-2-yl)-1-(4-fluorobenzyl)-1h-indazole-3-carboxamide': '[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#7])-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9]',
            'n-(1-amino-3,3-dimethyl-1-oxobutan-2-yl)-1-pentyl-1h-indazole-3-carboxamide': '[#8]=[#6](-[#6]1:[#7]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#7]-[#6](-[#6](-[#6])(-[#6])-[#6])-[#6](-[#7])=[#8]',
            '2c-i-nbome': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#7]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#8]-[#6])-[#53])-[#8]-[#6]',
            '2c-c-nbome': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#7]-[#6]-[#6]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:[#6]:1-[#8]-[#6])-[#17]',
            '2c-b-nbome': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#7]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#8]-[#6])-[#35])-[#8]-[#6]',
            '4-mec': '[#6]-[#6]-[#7]-[#6](-[#6])-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]',
            '4-meppp': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#8])-[#6](-[#6])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'alpha-pvp': '[#6]-[#6]-[#6]-[#6](-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'butylone': '[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]-[#6]',
            'pentedrone': '[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6]',
            'pentylone': '[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]-[#6]',
            'flephedrone': '[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9])-[#7]-[#6]',
            '3-fmc': '[#9]-[#6]1:[#6]:[#6]:[#6]:[#6](:[#6]:1)-[#6](-[#6](-[#6])-[#7]-[#6])=[#8]',
            'naphyrone': '[#6]-[#6]-[#6]-[#6](-[#6](-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1):[#6]:[#6]:[#6]:[#6]:2)=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'alpha-pbp': '[#6]1-[#6]-[#6]-[#6]-[#7]-1-[#6](-[#6]-[#6])-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'ab-chminaca': '[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#7])-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'ab-pinaca': '[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6](:[#7]:1)-[#6](=[#8])-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](=[#8])-[#7]',
            'thj-2201': '[#8]=[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]1:[#7]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'mab-chminaca': '[#8]=[#6](-[#7]-[#6](-[#6](-[#7])=[#8])-[#6](-[#6])(-[#6])-[#6])-[#6]1:[#7]:[#7](-[#6]-[#6]2-[#6]-[#6]-[#6]-[#6]-[#6]-2):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            '5f-mdmb-pinaca': '[#6]-[#8]-[#6](=[#8])-[#6](-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]):[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6](-[#6])(-[#6])-[#6]',
            '5f-amb': '[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8]-[#6])-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]',
            '5f-apinaca': '[#8]=[#6](-[#6]1:[#7]:[#7](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-[#6]-[#6]-[#6]-[#9])-[#7]-[#6]12-[#6]-[#6]3-[#6]-[#6](-[#6]-1)-[#6]-[#6](-[#6]-3)-[#6]-2',
            'adb-fubinaca': '[#6]-[#6](-[#6])(-[#6])-[#6](-[#6](=[#8])-[#7])-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9]',
            'mdmb-chmica': '[#6]-[#8]-[#6](=[#8])-[#6@@H](-[#7]-[#6](=[#8])-[#6]1:[#6]:[#7](-[#6]-[#6]2-[#6]-[#6]-[#6]-[#6]-[#6]-2):[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6](-[#6])(-[#6])-[#6]',
            'mdmb-fubinaca': '[#6]-[#6](-[#6])(-[#6])-[#6](-[#6](=[#8])-[#8]-[#6])-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9]',
            'mmb-fubinaca': '[#9]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#7]1:[#7]:[#6](-[#6](-[#7]-[#6@H](-[#6](-[#8]-[#6])=[#8])-[#6](-[#6])-[#6])=[#8]):[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            'ethylone': '[#6]-[#6]-[#7]-[#6](-[#6])-[#6](=[#8])-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2',
            'nm2201': '[#9]-[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](-[#6](-[#8]-[#6]2:[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3:[#6]:[#6]:[#6]:2)=[#8]):[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            '5f-ab-pinaca': '[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#7])-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]',
            '4-cn-cumyl-butinaca': '[#8]=[#6](-[#7]-[#6](-[#6])(-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#7]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]#[#7]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'mmb-chmica': '[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8]-[#6])-[#7]-[#6](=[#8])-[#6]1:[#6]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            '5f-cumyl-p7aica': '[#6]-[#6](-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6](=[#8])-[#6]1:[#6]:[#7](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#7]:2)-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]',
            'n-ethylpentylone': '[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#8]-2)-[#7]-[#6]-[#6]',
            '4f-mdmb-binaca': '[#8]=[#6](-[#7]-[#6@H](-[#6](-[#8]-[#6])=[#8])-[#6](-[#6])(-[#6])-[#6])-[#6]1:[#7]:[#7](-[#6]-[#6]-[#6]-[#6]-[#9]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'para-methoxymethamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#7]-[#6]',
            'gamma-hydroxybutyricacid': '[#6](-[#6]-[#6](=[#8])-[#8])-[#6]-[#8]',
            'mecloqualone': '[#6]-[#6]1:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6](=[#8]):[#7]:1-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#17]',
            'methaqualone': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7]1:[#6](:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]:1=[#8])-[#6]',
            'aminorex': '[#6]1-[#6](-[#8]-[#6](=[#7]-1)-[#7])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'n-benzylpiperazine': '[#6]1-[#6]-[#7](-[#6]-[#6]-[#7]-1)-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'cathinone': '[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]',
            '4,4′-dimethylaminorex': '[#6]-[#6]1-[#7]=[#6](-[#7])-[#8]-[#6]-1-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            'fenethylline': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6]-[#6]-[#7]1:[#6]:[#7]:[#6]2:[#6]:1:[#6](=[#8]):[#7](:[#6](=[#8]):[#7]:2-[#6])-[#6]',
            'methcathinone': '[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6]',
            '(±)cis-4-methylaminorex': '[#6]-[#6]1-[#6](-[#8]-[#6](=[#7]-1)-[#7])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'n-ethylamphetamine': '[#6]-[#6](-[#7]-[#6]-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'n,n-dimethylamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7](-[#6])-[#6]',
            'cp-47,479': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])(-[#6])-[#6]1:[#6]:[#6]:[#6](:[#6](:[#6]:1)-[#8])-[#6@H]1-[#6]-[#6]-[#6]-[#6@H](-[#6]-1)-[#8]',
            'cannabicyclohexanol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])(-[#6])-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#6]1-[#6]-[#6]-[#6]-[#6](-[#6]-1)-[#8])-[#8]',
            'jwh-018': '[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:2:3)=[#8]):[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            'jwh-073': '[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            'jwh-019': '[#6]1:[#6]:[#6]:[#6]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2-[#6](=[#8])-[#6]1:[#6]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'jwh-200': '[#8]=[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]1:[#6]:[#7](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'jwh-250': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6](=[#8])-[#6]1:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#7](:[#6]:1)-[#6]-[#6]-[#6]-[#6]-[#6]',
            'jwh-081': '[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6](:[#6]:1)-[#6](=[#8])-[#6]1:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'jwh-122': '[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]',
            'jwh-398': '[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]):[#6]:[#6]:2-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#17]',
            'am-2201': '[#8]=[#6](-[#6]1:[#6]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]1:[#6]:[#6]:[#6]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'am-694': '[#53]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6](=[#8])-[#6]1:[#6]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]):[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            'rcs-4': '[#6]-[#6]-[#6]-[#6]-[#6]-[#7]1:[#6]:[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]',
            'rcs-8': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6](=[#8])-[#6]1:[#6]:[#7](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'jwh-203': '[#17]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6](=[#8])-[#6]1:[#6]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]):[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            '5f-edmb-pinaca': '[#6]-[#6](-[#6])(-[#6])-[#6](-[#7]-[#6](-[#6]1:[#7]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)=[#8])-[#6](-[#8]-[#6]-[#6])=[#8]',
            '5f-mdmb-pica': '[#8]=[#6](-[#7]-[#6@H](-[#6](-[#8]-[#6])=[#8])-[#6](-[#6])(-[#6])-[#6])-[#6]1:[#6]:[#7](-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'fub-apinaca': '[#6]1-[#6]2-[#6]-[#6]3-[#6]-[#6]-1-[#6]-[#6](-[#6]-2)(-[#6]-3)-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9]',
            '5f-cumyl-pinaca': '[#6]-[#6](-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6](=[#8])-[#6]1:[#7]:[#7](:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6]-[#6]-[#6]-[#6]-[#9]',
            'fub-144': '[#9]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#7]1:[#6]:[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](=[#8])-[#6]1-[#6](-[#6]-1(-[#6])-[#6])(-[#6])-[#6]',
            '2-(ethylamino)-1-phenylhexan-1-one': '[#6]-[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6]-[#6]',
            'alpha-pyrrolidinohexiophenone': '[#6]1(:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#6](-[#6]-[#6]-[#6]-[#6])-[#7]1-[#6]-[#6]-[#6]-[#6]-1)=[#8]',
            '4-meap': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#6](-[#6]-[#6]-[#6])-[#7]-[#6]-[#6])=[#8]):[#6]:[#6]:1',
            '4′-methyl-alpha-pyrrolidinohexanophenone': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#6](-[#6]-[#6]-[#6]-[#6])-[#7]2-[#6]-[#6]-[#6]-[#6]-2)=[#8]):[#6]:[#6]:1',
            '1-phenyl-2-(pyrrolidin-1-yl)heptan-1-one': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            '4′-chloro-alpha-pvp': '[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#17])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'brorphine': '[#6]-[#6](-[#6]1:[#6]:[#6]:[#6](-[#35]):[#6]:[#6]:1)-[#7]1-[#6]-[#6]-[#6](-[#7]2:[#6](:[#7H]:[#6]3:[#6]:2:[#6]:[#6]:[#6]:[#6]:3)=[#8])-[#6]-[#6]-1',
        }

        return smarts