#!/usr/bin/env python3
#
# GlobalChem - Amino Acid Protecting Groups
#
# -----------------------------------------

class AminoAcidProtectingGroups(object):

    def __init__(self):

        pass

    @staticmethod
    def get_smiles(self):

        smiles = {
            'tert-butyloxycarbonyl': 'O=COC(C)(C)C',
            'trityl': 'C(C1=CC=CC=C1)(C2=CC=CC=C2)C3=CC=CC=C3',
            '3,5-dimethoxyphenylisoproxycarbonyl': 'COC1=CC(C(C)(OC=O)C)=CC(OC)=C1',
            '2-(4-biphenyl)isopropoxycarbonyl': 'CC(C)(OC=O)C(C=C1)=CC=C1C2=CC=CC=C2',
            '2-nitrophenylsulfenyl': 'SC1=CC=CC=C1[N+]([O-])=O',
            'boc': 'O=COC(C)(C)C',
            'trt': 'C(C1=CC=CC=C1)(C2=CC=CC=C2)C3=CC=CC=C3',
            'ddz': 'COC1=CC(C(C)(OC=O)C)=CC(OC)=C1',
            'bpoc': 'CC(C)(OC=O)C(C=C1)=CC=C1C2=CC=CC=C2',
            'nps': 'SC1=CC=CC=C1[N+]([O-])=O',
            '9-fluorenylmethoxycarbonyl': 'O=COCC1C2=C(C3=C1C=CC=C3)C=CC=C2',
            '2-(4-nitrophenylsulfonyl)ethoxycarbonyl': 'O=COCCS(=O)(C1=CC=C([N+]([O-])=O)C=C1)=O',
            '(1,1-dioxobenzo[b]thiophene-2-yl)methyloxycarbonyl': 'O=COCC1=CC2=CC=CC=C2S1(=O)=O',
            '(1,1-dioxonaptho[1,2-b]thiophene-2-yl)methyloxycarbonyl': 'O=COCC1=CC2=CC=C3C=CC=CC3=C2S1(=O)=O',
            '1-(4,4-dimethyl-2,6-dioxocyclohex-1-ylidene)-3-methylbutyl': r'CC(C)C/C=C1C(CC(C)(C)CC\1=O)=O',
            '2,7-di-tert-butyl-fmoc': 'CC1=CC(C2COC=O)=C(C=C1)C3=C2C=C(C(C)(C)C)C=C3',
            '2-fluoro-fmoc': 'FC1=CC2=C(C(C=CC=C3)=C3C2COC=O)C=C1',
            '2-monoisooctyl-fmoc': 'O=COCC1C2=C(C=CC=C2)C3=C1C=C(C(CCCCCCC)=O)C=C3',
            '2,7-diisooctyl-fmoc': 'O=COCC1C2=C(C=CC(C(CCCCCCC)=O)=C2)C3=C1C=C(C(CCCCCCC)=O)C=C3',
            'tetrachlorophthaloyl': 'O=CC1=C(Cl)C(Cl)=C(Cl)C(Cl)=C1C=O',
            '2-[phenyl(methyl)sulfonio])ethyloxycarbonyltetrafluoroborate': 'C[S+](CCOC=O)C1=CC=CC=C1',
            'ethanesulfonylethoxycarbonyl': 'O=COC(S(=O)(CC)=O)C',
            '2-(4-sulfophenylsulfonyl)ethoxycarbonyl': 'O=COCCS(=O)(C1=CC=C(S(=O)(O)=O)C=C1)=O',
            'fmoc': 'O=COCC1C2=C(C3=C1C=CC=C3)C=CC=C2',
            'nsc': 'O=COCCS(=O)(C1=CC=C([N+]([O-])=O)C=C1)=O',
            'bsmoc': 'O=COCC1=CC2=CC=CC=C2S1(=O)=O',
            'alpha-nsmoc': 'O=COCC1=CC2=CC=C3C=CC=CC3=C2S1(=O)=O',
            'ivdde':  r'CC(C)C/C=C1C(CC(C)(C)CC\1=O)=O',
            'fmoc*': 'CC1=CC(C2COC=O)=C(C=C1)C3=C2C=C(C(C)(C)C)C=C3',
            'fmoc(fmoc(2f))': 'FC1=CC2=C(C(C=CC=C3)=C3C2COC=O)C=C1',
            'mio-fmoc': 'O=COCC1C2=C(C=CC=C2)C3=C1C=C(C(CCCCCCC)=O)C=C3',
            'dio-fmoc': 'O=COCC1C2=C(C=CC(C(CCCCCCC)=O)=C2)C3=C1C=C(C(CCCCCCC)=O)C=C3',
            'tcp': 'O=CC1=C(Cl)C(Cl)=C(Cl)C(Cl)=C1C=O',
            'pms': 'C[S+](CCOC=O)C1=CC=CC=C1',
            'esc': 'O=COC(S(=O)(CC)=O)C',
            'sps': 'O=COCCS(=O)(C1=CC=C(S(=O)(O)=O)C=C1)=O',
            'benzyloxycarbonyl': 'O=COCC1=CC=CC=C1',
            'allyloxycarbonyl': 'O=COCC=C',
            'o-nitrobenzenesulfonyl': 'O=S(C1=CC=CC=C1[N+]([O-])=O)=O',
            '2,4-dinitrobenzenesulfonyl': 'O=S(C1=CC=C([N+]([O-])=O)C=C1[N+]([O-])=O)=O',
            'benzothiazole-2-sulfonyl': 'O=S(C1=NC2=CC=CC=C2S1)=O',
            '2,2,2-trichloroethyloxycarbonyl': 'O=COCC(Cl)(Cl)Cl',
            'dithiasuccinoyl': 'O=CSS[C]=O',
            'p-nitrobenzyloxycarbonyl': 'O=COCC1=CC=C([N+]([O-])=O)C=C1',
            'alpha-azidoacids': '[N-]=[N+]=NCC(O)=O',
            'proparglyoxycarbonyl': 'C#COC(C)=O',
            'o-nitrobenzylcarbonyl': 'O=CCC1=CC=CC=C1[N+]([O-])=O',
            '4-nitroveratryloxycarbonyl': 'O=COCC1=C([N+]([O-])=O)C=C(OC)C(OC)=C1',
            '2-(2-nitrophenyl)propyloxycarbonyl': 'O=COCC(C1=CC=CC=C1[N+]([O-])=O)C',
            '2-(3,4-methylenedioxy-6-nitrophenyl)propyloxycarbonyl': 'O=COCC(C1=CC(OCO2)=C2C=C1[N+]([O-])=O)C',
            '9-(4-bromophenyl)-9-fluorenyl': 'BrC1=CC=C(C2C3=C(C4=C2C=CC=C4)C=CC=C3)C=C1',
            'azidomethoxycarbonyl': 'O=COCN=[N+]=[N-]',
            'hexafluoroacetone': 'O=C1OC(C(C(F)(F)F)C(F)(F)F)NC1',
            'Z': 'O=COCC1=CC=CC=C1',
            'alloc': 'O=COCC=C',
            'o-nbs': 'O=S(C1=CC=CC=C1[N+]([O-])=O)=O',
            'd-nbs': 'O=S(C1=CC=C([N+]([O-])=O)C=C1[N+]([O-])=O)=O',
            'bts': 'O=S(C1=NC2=CC=CC=C2S1)=O',
            'troc': 'O=COCC(Cl)(Cl)Cl',
            'dts': 'O=CSS[C]=O',
            'pnz': 'O=COCC1=CC=C([N+]([O-])=O)C=C1',
            'poc': 'C#COC(C)=O',
            'onz': 'O=CCC1=CC=CC=C1[N+]([O-])=O',
            'nvoc': 'O=COCC1=C([N+]([O-])=O)C=C(OC)C(OC)=C1',
            'nppoc': 'O=COCC(C1=CC=CC=C1[N+]([O-])=O)C',
            'mnppoc': 'O=COCC(C1=CC(OCO2)=C2C=C1[N+]([O-])=O)C',
            'brphf': 'BrC1=CC=C(C2C3=C(C4=C2C=CC=C4)C=CC=C3)C=C1',
            'azoc': 'O=COCN=[N+]=[N-]',
            'hfa': 'O=C1OC(C(C(F)(F)F)C(F)(F)F)NC1',
            '2-chlorobenzyloxycarbonyl': 'O=COCC1=CC=CC=C1Cl',
            '4-methyltrityl': 'CC1=CC=C(C(C2=CC=CC=C2)C3=CC=CC=C3)C=C1',
            'cl-z': 'O=COCC1=CC=CC=C1Cl',
            'mtt': 'CC1=CC=C(C(C2=CC=CC=C2)C3=CC=CC=C3)C=C1',
            '1-(4,4-dimethyl-2,6-dioxocylohex-1-ylidene)-3-methylbutyl': r'O=C1/C(C(CC(C)C1)=O)=C\CC(C)C',
            'trifluoroacetyl': 'O=CC(F)(F)F',
            '2-(methylsulfonyl)ethoxycarbonyl': 'O=COCCS(=O)(C)=O',
            'tfa': 'O=CC(F)(F)F',
            'msc': 'O=COCCS(=O)(C)=O',
            'phenyldisulphanylethyloxycarbonyl': 'O=COC(SSC1=CC=CC=C1)C',
            '2-pyridyldisulphanylethyloxycarbonyl': 'O=COC(SSC1=NC=CC=C1)C',
            'phdec': 'O=COC(SSC1=CC=CC=C1)C',
            'pydec': 'O=COC(SSC1=NC=CC=C1)C',
            'tert-butyl': 'CC(C)C',
            '2-chlorotrityl': 'ClC1=CC=CC=C1C(C2=CC=CC=C2)C3=CC=CC=C3',
            '2-4-dimethyoxybenzyl': 'CC1=CC(OC)=CC(OC)=C1',
            '2-phenylisopropyl': 'CC(C)C1=CC=CC=C1',
            '5-phenyl-3,4-ethylenedioxythenyl': 'CC1=C(OCCO2)C2=C(S1)C3=CC=CC=C3',
            'bu': 'CC(C)C',
            '2-cl-trt': 'ClC1=CC=CC=C1C(C2=CC=CC=C2)C3=CC=CC=C3',
            'dmb': 'CC1=CC(OC)=CC(OC)=C1',
            '2-ph-pr': 'CC(C)C1=CC=CC=C1',
            'phenyl-edotn': 'CC1=C(OCCO2)C2=C(S1)C3=CC=CC=C3',
            '9-fluorenylmethyl': 'CC1C2=C(C3=C1C=CC=C3)C=CC=C2',
            '4-(N-[1-(4,4-dimethyl-2,6-dioxocylocheylidene)-3-methylbutyl]-amino)benzyl': r'CC(CC(/C1=C(NC2=CC=C(C)C=C2)/CC(C)C)=O)(C)CC1=O',
            'methyl': 'C',
            'ethyl': 'CC',
            'carbamoylmethyl': 'CC(N)=O',
            'fm': 'CC1C2=C(C3=C1C=CC=C3)C=CC=C2',
            'dmab': r'CC(CC(/C1=C(NC2=CC=C(C)C=C2)/CC(C)C)=O)(C)CC1=O',
            'me': 'C',
            'et': 'CC',
            'cam': 'CC(N)=O',
            'allyl': 'CC=C',
            'benzyl': 'CC1=CC=CC=C1',
            'phenacyl': 'CC(C1=CC=CC=C1)=O',
            'p-nitrobenzyl': 'CC1=CC=C([N+]([O-])=O)C=C1',
            '2-trimethylsilyethyl': 'CCC[Si](C)(C)C',
            '(2-phenyl-2-trimethylsilyl)ethyl': 'CC(C1=CC=CC=C1)[Si](C)(C)C',
            '2-(trimethylsilyl)isopropyl': 'CC(C)([Si](C)(C)C)C',
            '2,2,2-trichloroethyl': 'CC(Cl)(Cl)Cl',
            'p-hydroxyphenacyl': 'CC(C1=CC=C(O)C=C1)=O',
            '4,5-dimethyoxy-2-nitrobenzyl': 'CC1=CC(OC)=C(OC)C=C1[N+]([O-])=O',
            '1,1-dimethylallyl': 'C=CC(C)C',
            'pentaaminecobalt_III': 'N[Co](N)(N)(N)(Cl)(Cl)N',
            'al': 'CC=C',
            'bn': 'CC1=CC=CC=C1',
            'pac': 'CC(C1=CC=CC=C1)=O',
            'pnb': 'CC1=CC=C([N+]([O-])=O)C=C1',
            'tmse': 'CCC[Si](C)(C)C',
            'ptmse': 'CC(C1=CC=CC=C1)[Si](C)(C)C',
            'tmsi': 'CC(C)([Si](C)(C)C)C',
            'tce': 'CC(Cl)(Cl)Cl',
            'php': 'CC(C1=CC=C(O)C=C1)=O',
            'dmnb': 'CC1=CC(OC)=C(OC)C=C1[N+]([O-])=O',
            'dma': 'C=CC(C)C',
            'cyclohexyl': 'C1CCCCC1',
            'b-menthyl': 'C[C@H]1[C@H](C(C)C)CC[C@@H](C)C1',
            'b-3-methylpent-3-yl': 'CCC(C)CC',
            '4-(3,6,9-trioxadecyl)oxybenzyl': 'CC1=CC=C(OCCOCCOCCOC)C=C1',
            'chx': 'C1CCCCC1',
            'men': 'C[CH]1[CH](C(C)C)CC[CH](C)C1',
            'mpe': 'CCC(C)CC',
            'tegbz': 'CC1=CC=C(OCCOCCOCCOC)C=C1',
            '9-fluoroenylmethyl': 'CC1C2=C(C3=C1C=CC=C3)C=CC=C2',
            '4-(N-[1-(4,4-dimethyl-2,6-dioxocyclohexylidene)-3-methyl-butyl]-amino)benzyl': r'CC(CC(/C1=C(NC2=CC=C(C)C=C2)/CC(C)C)=O)(C)CC1=O',
            'trimethylsilylethyl': 'CCC[Si](C)(C)C',
            '4,5-dimethoxy-2-nitrobenzyloxycarbonyl': 'CC1=CC(OC)=C(OC)C=C1[N+]([O-])=O',
            'pseudoprolines': 'CC1(C)NC(C(O)=O)CO1',
            '2-hydroxy-4-methoxybenzyl': 'CC1=CC=C(OC)C=C1O',
            '2,4-dimethoxybenzyl': 'CC1=CC=C(OC)C=C1OC',
            '2,4,6-trimethoxybenzyl': 'CC1=C(OC)C=C(OC)C=C1OC',
            '1-methyl-3-indolylmethyl': 'CCC1=CNC2=C1C=CC=C2',
            '3,4-ethylene-dioxy-2-thenyl': 'CC1=C(OCCO2)C2=CS1',
            'hmb': 'CC1=CC=C(OC)C=C1O',
            'tmob': 'CC1=C(OC)C=C(OC)C=C1OC',
            'mim': 'CCC1=CNC2=C1C=CC=C2',
            'edot': 'CC1=C(OCCO2)C2=CS1',
            '4-methoxy-2-nitro-benzyl': 'CC1=CC=C(OC)C=C1[N+]([O-])=O',
            '(6-hydroxy-3-oxido-1,3-benz[d]oxathiol-5-yl)methyl': 'O=S1COC2=C1C=C(C)C(O)=C2',
            '2-hydroxy-4-methoxy-5-(methylsulfinyl)benzyl': 'CC1=CC(S(C)=O)=C(OC)C=C1O',
            'n-boc-n-methyl[2-(methylamino)ethyl]carbamoyl-hmb': 'CC(C)(OC(N(CCN(C(OC1=CC(OC)=CC=C1)=O)C)C)=O)C',
            '9-xanthenyl': 'C1(CC2=C(C=CC=C2)O3)=C3C=CC=C1',
            'cyclopropyldimethylcarbinyl': 'CC(C1CC1)C',
            '4,4-dimethoxybenzhydryl': 'COC1=CC=C(C=C1)CC2=CC=C(OC)C=C2',
            'xan': 'C1(CC2=C(C=CC=C2)O3)=C3C=CC=C1',
            'cpd': 'CC(C1CC1)C',
            'mbh': 'COC1=CC=C(C=C1)CC2=CC=C(OC)C=C2',
            'p-toluenesulfonyl': 'O=S(C1=CC=C(C)C=C1)=O',
            '2,2,5,7,8-pentamethylchroman-6-sulfonyl': 'O=S(C1=C(C)C(CCC(C)(C)O2)=C2C(C)=C1C)=O',
            '2,2,4,6,7-pentamethyl-2,3-dihydrobenzofuran-5-sulfonyl': 'O=S(C1=C(C)C(C)=C(OC(C)(C)C2)C2=C1C)=O',
            'mesityl-2-sulfonyl': 'CC1=C(S(=O)(NC(N)=N)=O)C(C)=CC(C)=C1',
            '4-methoxy-2,3,6-trimethylphenylsulfonyl': 'O=S(C1=C(C)C=C(OC)C(C)=C1C)=O',
            '1,2-dimethylindole-3-sulfonyl': 'O=S(C1=C(C)N(C)C2=C1C=CC=C2)=O',
            'w,w-bis-tert-butyloxycarbonyl': r'CC(C)(OC(/N=C(NC(OC(C)(C)C)=O)\N)=O)C',
            '5-dibenzosuberenyl': 'C12=CC=CC=C1CCC3C=CC=CC3=C2',
            '5-dibenzosuberyl': 'C12=CC=CC=C1CCC3=C(C=CC=C3)C2',
            '2-methoxy-5-dibenzosuberyl': 'COC(C=C1CC2)=CC=C1CC3=C2C=CC=C3',
            'nitro': 'O=[N+][O-]',
            'tos': 'O=S(C1=CC=C(C)C=C1)=O',
            'pmc': 'O=S(C1=C(C)C(CCC(C)(C)O2)=C2C(C)=C1C)=O',
            'pbf': 'O=S(C1=C(C)C(C)=C(OC(C)(C)C2)C2=C1C)=O',
            'mts': 'CC1=C(S(=O)(NC(N)=N)=O)C(C)=CC(C)=C1',
            'mtr': 'O=S(C1=C(C)C=C(OC)C(C)=C1C)=O',
            'mis': 'O=S(C1=C(C)N(C)C2=C1C=CC=C2)=O',
            'bis-boc': r'CC(C)(OC(/N=C(NC(OC(C)(C)C)=O)\N)=O)C',
            'suben': 'C12=CC=CC=C1CCC3C=CC=CC3=C2',
            'sub': 'C12=CC=CC=C1CCC3=C(C=CC=C3)C2',
            'mesub': 'COC(C=C1CC2)=CC=C1CC3=C2C=CC=C3',
            'no2': 'O=[N+][O-]',
            'w,w-bis-benzyloxycarbonyl': r'O=C(/N=C(NC(OCC1=CC=CC=C1)=O)\N)OCC2=CC=CC=C2',
            'w,w-bis-allyloxycarbonyl': r'O=C(/N=C(NC(OCC=C)=O)\N)OCC=C',
            'z': r'O=C(/N=C(NC(OCC1=CC=CC=C1)=O)\N)OCC2=CC=CC=C2',
            'p-methylbenzyl': 'CC1=CC=C(C)C=C1',
            'p-methoxybenzyl': 'CC1=CC=C(OC)C=C1',
            'monomethoxytrityl': 'COC1=CC=C(C(C2=CC=CC=C2)C3=CC=CC=C3)C=C1',
            'trimethoxybenzyl': 'CC1=C(OC)C=C(OC)C=C1OC',
            '2,2,4,6,7-pentamethyl-5-dihydrobenzofuranylmethyl': 'CC1=C(C)C(C)=C(OC(C)(C)C2)C2=C1C',
            '1-adamantyl': 'C12CC3CC(C2)CC(C3)C1',
            'meb': 'CC1=CC=C(C)C=C1',
            'mob': 'CC1=CC=C(OC)C=C1',
            'mmt': 'COC1=CC=C(C(C2=CC=CC=C2)C3=CC=CC=C3)C=C1',
            'pmbf': 'CC1=C(C)C(C)=C(OC(C)(C)C2)C2=C1C',
            '1-ada': 'C12CC3CC(C2)CC(C3)C1',
            '2-(2,4-dinitrophenyl)ethyl': 'CCC1=CC=C([N+]([O-])=O)C=C1[N+]([O-])=O',
            '9-fluororenylmethoxycarbonyl': 'O=COCC1C2=C(C3=C1C=CC=C3)C=CC=C2',
            'dnpe': 'CCC1=CC=C([N+]([O-])=O)C=C1[N+]([O-])=O',
            'acetamidomethyl': 'CNC(C)=O',
            'phenylacetamidomethyl': 'CNC(CC1=CC=CC=C1)=O',
            '5-tert-butylmercapto': 'CC(C)(S)C',
            '3-nitro-2-pyridinesulfenyl': 'SC1=NC=CC=C1[N+]([O-])=O',
            '2-pyridinesulfenyl': 'SC1=NC=CC=C1',
            'N-allyloxycarbonyl-N-[2,3,5,6-tetrafluoro-4-(phenylthio)phenyl]]aminomethyl': 'FC1=C(F)C(SC2=CC=CC=C2)=C(F)C(F)=C1N(C(OCC=C)=O)C',
            'o-nitrobenzyl': 'CC1=CC=CC=C1[N+]([O-])=O',
            '4-picolyl': 'CC1=CC=NC=C1',
            'ninhydrin': 'O=C1C2(SCC(C(O)=O)N2)C(C3=C1C=CC=C3)=O',
            'acm': 'CNC(C)=O',
            'phacm': 'CNC(CC1=CC=CC=C1)=O',
            'sbu': 'CC(C)(S)C',
            'npys': 'SC1=NC=CC=C1[N+]([O-])=O',
            's-pyr': 'SC1=NC=CC=C1',
            'fsam': 'FC1=C(F)C(SC2=CC=CC=C2)=C(F)C(F)=C1N(C(OCC=C)=O)C',
            'onb': 'CC1=CC=CC=C1[N+]([O-])=O',
            'nin': 'O=C1C2(SCC(C(O)=O)N2)C(C3=C1C=CC=C3)=O',
            'n-tosyl': 'O=S(N1C=CN=C1)(C2=CC=C(C)C=C2)=O',
            'n-trityl': 'N1(C(C2=CC=CC=C2)(C3=CC=CC=C3)C4=CC=CC=C4)C=CN=C1',
            'n-monomethoxytrityl': 'COC(C=C1)=CC=C1C(C2=CC=CC=C2)(C3=CC=CC=C3)N4C=CN=C4',
            'n-methyltrityl': 'CC(C=C1)=CC=C1C(C2=CC=CC=C2)(C3=CC=CC=C3)N4C=CN=C4',
            'n-tert-butyloxycarbonyl': 'O=C(OC(C)(C)C)N1C=CN=C1',
            'n-2,4-dimethylpent-3-yloxycarbonyl': 'O=C(OC(C(C)C)C(C)C)N1C=CN=C1',
            'n-benzyloxymethyl': '[N+]1(COCC2=CC=CC=C2)=CNC=C1',
            'n-tert-butoxymethyl': 'CC(C)(C)OC[N+]1=CNC=C1',
            'ntos': 'O=S(N1C=CN=C1)(C2=CC=C(C)C=C2)=O',
            'ntrt': 'N1(C(C2=CC=CC=C2)(C3=CC=CC=C3)C4=CC=CC=C4)C=CN=C1',
            'nmtt': 'COC(C=C1)=CC=C1C(C2=CC=CC=C2)(C3=CC=CC=C3)N4C=CN=C4',
            'nmmt': 'CC(C=C1)=CC=C1C(C2=CC=CC=C2)(C3=CC=CC=C3)N4C=CN=C4',
            'nboc': 'O=C(OC(C)(C)C)N1C=CN=C1',
            'ndoc': 'O=C(OC(C(C)C)C(C)C)N1C=CN=C1',
            'nbom': '[N+]1(COCC2=CC=CC=C2)=CNC=C1',
            'nbum': 'CC(C)(C)OC[N+]1=CNC=C1',
            'N-9-fluorenylmethoxycarbonyl': 'O=C(OC1C(C=CC=C2)=C2C3=C1C=CC=C3)N4C=CN=C4',
            '2,6-dimethoxybenzoyl': 'O=C(C1=C(OC)C=CC=C1OC)N2C=CN=C2',
            'dmbz': 'O=C(C1=C(OC)C=CC=C1OC)N2C=CN=C2',
            'N-2,4-dinitrophenyl': 'O=C(C1=C([N+]([O-])=O)C=C([N+]([O-])=O)C=C1)N2C=CN=C2',
            'dnp': 'O=C(C1=C([N+]([O-])=O)C=C([N+]([O-])=O)C=C1)N2C=CN=C2',
            'cyclohexyl;': 'C1CCCCC1',
            'tert-butyldimethylsilyl': 'CSi(C(C)(C)C)C',
            'tbdms': 'C[Si](C(C)(C)C)C',
            'tert-butyldiphenylsilyl': 'CC(Si(C1=CC=CC=C1)C2=CC=CC=C2)(C)C',
            'propargyloxycarbonyl': 'C#COC(C)=O',
            'tbdps': 'CC([Si](C1=CC=CC=C1)C2=CC=CC=C2)(C)C',
            'dcb': 'CC1=C(Cl)C=CC=C1Cl',
            'brbn': 'CC1=CC=CC=C1Br',
            'brz': 'O=COCC1=CC=CC=C1Br',
            'pen': 'CCCCC',
            'tegb': 'CC1=CC=C(OCCOCCOCCOC)C=C1',
            'boc-n-methyl-n-[2-(methylamino)ethyl]carbamoyl': 'O=C(C(OC(C)(C)C)=O)N(C)CCNC',
            'boc-nmec': 'O=C(C(OC(C)(C)C)=O)N(C)CCNC',
            'formyl': 'C=O',
            'cyclohexyloxycarbonyl': 'O=COC1CCCCC1',
            'for': 'C=O',
            'hoc': 'O=COC1CCCCC1',

        }
        
        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'tert-butyloxycarbonyl': '[#8]=[#6]-[#8]-[#6](-[#6])(-[#6])-[#6]',
            'trityl': '[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '3,5-dimethoxyphenylisoproxycarbonyl': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#6](-[#6])(-[#8]-[#6]=[#8])-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:1',
            '2-(4-biphenyl)isopropoxycarbonyl': '[#6]-[#6](-[#6])(-[#8]-[#6]=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '2-nitrophenylsulfenyl': '[#16]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            'boc': '[#8]=[#6]-[#8]-[#6](-[#6])(-[#6])-[#6]',
            'trt': '[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'ddz': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#6](-[#6])(-[#8]-[#6]=[#8])-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:1',
            'bpoc': '[#6]-[#6](-[#6])(-[#8]-[#6]=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'nps': '[#16]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            '9-fluorenylmethoxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1-[#6]2:[#6](-[#6]3:[#6]-1:[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:[#6]:[#6]:2',
            '2-(4-nitrophenylsulfonyl)ethoxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]-[#16](=[#8])(-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1)=[#8]',
            '(1,1-dioxobenzo[b]thiophene-2-yl)methyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1=[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#16]-1(=[#8])=[#8]',
            '(1,1-dioxonaptho[1,2-b]thiophene-2-yl)methyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1=[#6]-[#6]2:[#6]:[#6]:[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3:[#6]:2-[#16]-1(=[#8])=[#8]',
            '1-(4,4-dimethyl-2,6-dioxocyclohex-1-ylidene)-3-methylbutyl': '[#6]-[#6](-[#6])-[#6]-[#6]=[#6]1-[#6](-[#6]-[#6](-[#6])(-[#6])-[#6]-[#6]-1=[#8])=[#8]',
            '2,7-di-tert-butyl-fmoc': '[#6]-[#6]1:[#6]:[#6]2-[#6](-[#6]-[#8]-[#6]=[#8])-[#6]3:[#6](-[#6]:2:[#6]:[#6]:1):[#6]:[#6]:[#6](:[#6]:3)-[#6](-[#6])(-[#6])-[#6]',
            '2-fluoro-fmoc': '[#9]-[#6]1:[#6]:[#6]2:[#6](-[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3-[#6]-2-[#6]-[#8]-[#6]=[#8]):[#6]:[#6]:1',
            '2-monoisooctyl-fmoc': '[#8]=[#6]-[#8]-[#6]-[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]-1:[#6]:[#6](-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])=[#8]):[#6]:[#6]:2',
            '2,7-diisooctyl-fmoc': '[#8]=[#6]-[#8]-[#6]-[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6](-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])=[#8]):[#6]:2)-[#6]2:[#6]-1:[#6]:[#6](-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])=[#8]):[#6]:[#6]:2',
            'tetrachlorophthaloyl': '[#8]=[#6]-[#6]1:[#6](-[#17]):[#6](-[#17]):[#6](-[#17]):[#6](-[#17]):[#6]:1-[#6]=[#8]',
            '2-[phenyl(methyl)sulfonio])ethyloxycarbonyltetrafluoroborate': '[#6]-[#16+](-[#6]-[#6]-[#8]-[#6]=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'ethanesulfonylethoxycarbonyl': '[#8]=[#6]-[#8]-[#6](-[#16](=[#8])(-[#6]-[#6])=[#8])-[#6]',
            '2-(4-sulfophenylsulfonyl)ethoxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]-[#16](=[#8])(-[#6]1:[#6]:[#6]:[#6](-[#16](=[#8])(-[#8])=[#8]):[#6]:[#6]:1)=[#8]',
            'fmoc': '[#8]=[#6]-[#8]-[#6]-[#6]1-[#6]2:[#6](-[#6]3:[#6]-1:[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:[#6]:[#6]:2',
            'nsc': '[#8]=[#6]-[#8]-[#6]-[#6]-[#16](=[#8])(-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1)=[#8]',
            'bsmoc': '[#8]=[#6]-[#8]-[#6]-[#6]1=[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#16]-1(=[#8])=[#8]',
            'alpha-nsmoc': '[#8]=[#6]-[#8]-[#6]-[#6]1=[#6]-[#6]2:[#6]:[#6]:[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3:[#6]:2-[#16]-1(=[#8])=[#8]',
            'ivdde': '[#6]-[#6](-[#6])-[#6]-[#6]=[#6]1-[#6](-[#6]-[#6](-[#6])(-[#6])-[#6]-[#6]-1=[#8])=[#8]',
            'fmoc*': '[#6]-[#6]1:[#6]:[#6]2-[#6](-[#6]-[#8]-[#6]=[#8])-[#6]3:[#6](-[#6]:2:[#6]:[#6]:1):[#6]:[#6]:[#6](:[#6]:3)-[#6](-[#6])(-[#6])-[#6]',
            'fmoc(fmoc(2f))': '[#9]-[#6]1:[#6]:[#6]2:[#6](-[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3-[#6]-2-[#6]-[#8]-[#6]=[#8]):[#6]:[#6]:1',
            'mio-fmoc': '[#8]=[#6]-[#8]-[#6]-[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]-1:[#6]:[#6](-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])=[#8]):[#6]:[#6]:2',
            'dio-fmoc': '[#8]=[#6]-[#8]-[#6]-[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6](-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])=[#8]):[#6]:2)-[#6]2:[#6]-1:[#6]:[#6](-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])=[#8]):[#6]:[#6]:2',
            'tcp': '[#8]=[#6]-[#6]1:[#6](-[#17]):[#6](-[#17]):[#6](-[#17]):[#6](-[#17]):[#6]:1-[#6]=[#8]',
            'pms': '[#6]-[#16+](-[#6]-[#6]-[#8]-[#6]=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'esc': '[#8]=[#6]-[#8]-[#6](-[#16](=[#8])(-[#6]-[#6])=[#8])-[#6]',
            'sps': '[#8]=[#6]-[#8]-[#6]-[#6]-[#16](=[#8])(-[#6]1:[#6]:[#6]:[#6](-[#16](=[#8])(-[#8])=[#8]):[#6]:[#6]:1)=[#8]',
            'benzyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'allyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]=[#6]',
            'o-nitrobenzenesulfonyl': '[#8]=[#16](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8])=[#8]',
            '2,4-dinitrobenzenesulfonyl': '[#8]=[#16](-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1-[#7+](-[#8-])=[#8])=[#8]',
            'benzothiazole-2-sulfonyl': '[#8]=[#16](-[#6]1:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#16]:1)=[#8]',
            '2,2,2-trichloroethyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6](-[#17])(-[#17])-[#17]',
            'dithiasuccinoyl': '[#8]=[#6]-[#16]-[#16]-[#6]=[#8]',
            'p-nitrobenzyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1',
            'alpha-azidoacids': '[#7-]=[#7+]=[#7]-[#6]-[#6](-[#8])=[#8]',
            'proparglyoxycarbonyl': '[#6]#[#6]-[#8]-[#6](-[#6])=[#8]',
            'o-nitrobenzylcarbonyl': '[#8]=[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            '4-nitroveratryloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6](-[#8]-[#6]):[#6](-[#8]-[#6]):[#6]:1',
            '2-(2-nitrophenyl)propyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8])-[#6]',
            '2-(3,4-methylenedioxy-6-nitrophenyl)propyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6](-[#6]1:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:[#6]:1-[#7+](-[#8-])=[#8])-[#6]',
            '9-(4-bromophenyl)-9-fluorenyl': '[#35]-[#6]1:[#6]:[#6]:[#6](-[#6]2-[#6]3:[#6](-[#6]4:[#6]-2:[#6]:[#6]:[#6]:[#6]:4):[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:1',
            'azidomethoxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#7]=[#7+]=[#7-]',
            'hexafluoroacetone': '[#8]=[#6]1-[#8]-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])-[#6](-[#9])(-[#9])-[#9])-[#7]-[#6]-1',
            'Z': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'alloc': '[#8]=[#6]-[#8]-[#6]-[#6]=[#6]',
            'o-nbs': '[#8]=[#16](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8])=[#8]',
            'd-nbs': '[#8]=[#16](-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1-[#7+](-[#8-])=[#8])=[#8]',
            'bts': '[#8]=[#16](-[#6]1:[#7]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#16]:1)=[#8]',
            'troc': '[#8]=[#6]-[#8]-[#6]-[#6](-[#17])(-[#17])-[#17]',
            'dts': '[#8]=[#6]-[#16]-[#16]-[#6]=[#8]',
            'pnz': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1',
            'poc': '[#6]#[#6]-[#8]-[#6](-[#6])=[#8]',
            'onz': '[#8]=[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            'nvoc': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6](-[#8]-[#6]):[#6](-[#8]-[#6]):[#6]:1',
            'nppoc': '[#8]=[#6]-[#8]-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8])-[#6]',
            'mnppoc': '[#8]=[#6]-[#8]-[#6]-[#6](-[#6]1:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:[#6]:1-[#7+](-[#8-])=[#8])-[#6]',
            'brphf': '[#35]-[#6]1:[#6]:[#6]:[#6](-[#6]2-[#6]3:[#6](-[#6]4:[#6]-2:[#6]:[#6]:[#6]:[#6]:4):[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:1',
            'azoc': '[#8]=[#6]-[#8]-[#6]-[#7]=[#7+]=[#7-]',
            'hfa': '[#8]=[#6]1-[#8]-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])-[#6](-[#9])(-[#9])-[#9])-[#7]-[#6]-1',
            '2-chlorobenzyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#17]',
            '4-methyltrityl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#6]:1',
            'cl-z': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#17]',
            'mtt': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#6]:1',
            '1-(4,4-dimethyl-2,6-dioxocylohex-1-ylidene)-3-methylbutyl': '[#8]=[#6]1-[#6](-[#6](-[#6]-[#6](-[#6])-[#6]-1)=[#8])=[#6]-[#6]-[#6](-[#6])-[#6]',
            'trifluoroacetyl': '[#8]=[#6]-[#6](-[#9])(-[#9])-[#9]',
            '2-(methylsulfonyl)ethoxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]-[#16](=[#8])(-[#6])=[#8]',
            'tfa': '[#8]=[#6]-[#6](-[#9])(-[#9])-[#9]',
            'msc': '[#8]=[#6]-[#8]-[#6]-[#6]-[#16](=[#8])(-[#6])=[#8]',
            'phenyldisulphanylethyloxycarbonyl': '[#8]=[#6]-[#8]-[#6](-[#16]-[#16]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]',
            '2-pyridyldisulphanylethyloxycarbonyl': '[#8]=[#6]-[#8]-[#6](-[#16]-[#16]-[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1)-[#6]',
            'phdec': '[#8]=[#6]-[#8]-[#6](-[#16]-[#16]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]',
            'pydec': '[#8]=[#6]-[#8]-[#6](-[#16]-[#16]-[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1)-[#6]',
            'tert-butyl': '[#6]-[#6](-[#6])-[#6]',
            '2-chlorotrityl': '[#17]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '2-4-dimethyoxybenzyl': '[#6]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:1',
            '2-phenylisopropyl': '[#6]-[#6](-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '5-phenyl-3,4-ethylenedioxythenyl': '[#6]-[#6]1:[#6]2-[#8]-[#6]-[#6]-[#8]-[#6]:2:[#6](:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'bu': '[#6]-[#6](-[#6])-[#6]',
            '2-cl-trt': '[#17]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'dmb': '[#6]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:1',
            '2-ph-pr': '[#6]-[#6](-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'phenyl-edotn': '[#6]-[#6]1:[#6]2-[#8]-[#6]-[#6]-[#8]-[#6]:2:[#6](:[#16]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '9-fluorenylmethyl': '[#6]-[#6]1-[#6]2:[#6](-[#6]3:[#6]-1:[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:[#6]:[#6]:2',
            '4-(N-[1-(4,4-dimethyl-2,6-dioxocylocheylidene)-3-methylbutyl]-amino)benzyl': '[#6]-[#6]1(-[#6]-[#6](-[#6](=[#6](-[#7]-[#6]2:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:2)-[#6]-[#6](-[#6])-[#6])-[#6](-[#6]-1)=[#8])=[#8])-[#6]',
            'methyl': '[#6]',
            'ethyl': '[#6]-[#6]',
            'carbamoylmethyl': '[#6]-[#6](-[#7])=[#8]',
            'fm': '[#6]-[#6]1-[#6]2:[#6](-[#6]3:[#6]-1:[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:[#6]:[#6]:2',
            'dmab': '[#6]-[#6]1(-[#6]-[#6](-[#6](=[#6](-[#7]-[#6]2:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:2)-[#6]-[#6](-[#6])-[#6])-[#6](-[#6]-1)=[#8])=[#8])-[#6]',
            'me': '[#6]',
            'et': '[#6]-[#6]',
            'cam': '[#6]-[#6](-[#7])=[#8]',
            'allyl': '[#6]-[#6]=[#6]',
            'benzyl': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'phenacyl': '[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8]',
            'p-nitrobenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1',
            '2-trimethylsilyethyl': '[#6]-[#6]-[#6]-[Si](-[#6])(-[#6])-[#6]',
            '(2-phenyl-2-trimethylsilyl)ethyl': '[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[Si](-[#6])(-[#6])-[#6]',
            '2-(trimethylsilyl)isopropyl': '[#6]-[#6](-[#6])(-[Si](-[#6])(-[#6])-[#6])-[#6]',
            '2,2,2-trichloroethyl': '[#6]-[#6](-[#17])(-[#17])-[#17]',
            'p-hydroxyphenacyl': '[#6]-[#6](-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)=[#8]',
            '4,5-dimethyoxy-2-nitrobenzyl': '[#6]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](-[#8]-[#6]):[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            '1,1-dimethylallyl': '[#6]=[#6]-[#6](-[#6])-[#6]',
            'pentaaminecobalt_III': '[#7]-[Co](-[#7])(-[#7])(-[#7])(-[#17])(-[#17])-[#7]',
            'al': '[#6]-[#6]=[#6]',
            'bn': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pac': '[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8]',
            'pnb': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1',
            'tmse': '[#6]-[#6]-[#6]-[Si](-[#6])(-[#6])-[#6]',
            'ptmse': '[#6]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[Si](-[#6])(-[#6])-[#6]',
            'tmsi': '[#6]-[#6](-[#6])(-[Si](-[#6])(-[#6])-[#6])-[#6]',
            'tce': '[#6]-[#6](-[#17])(-[#17])-[#17]',
            'php': '[#6]-[#6](-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)=[#8]',
            'dmnb': '[#6]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](-[#8]-[#6]):[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            'dma': '[#6]=[#6]-[#6](-[#6])-[#6]',
            'cyclohexyl': '[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'b-menthyl': '[#6]-[#6@H]1-[#6@H](-[#6](-[#6])-[#6])-[#6]-[#6]-[#6@@H](-[#6])-[#6]-1',
            'b-3-methylpent-3-yl': '[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            '4-(3,6,9-trioxadecyl)oxybenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]-[#6]-[#8]-[#6]-[#6]-[#8]-[#6]-[#6]-[#8]-[#6]):[#6]:[#6]:1',
            'chx': '[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'men': '[#6]-[#6H]1-[#6H](-[#6](-[#6])-[#6])-[#6]-[#6]-[#6H](-[#6])-[#6]-1',
            'mpe': '[#6]-[#6]-[#6](-[#6])-[#6]-[#6]',
            'tegbz': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]-[#6]-[#8]-[#6]-[#6]-[#8]-[#6]-[#6]-[#8]-[#6]):[#6]:[#6]:1',
            '9-fluoroenylmethyl': '[#6]-[#6]1-[#6]2:[#6](-[#6]3:[#6]-1:[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:[#6]:[#6]:2',
            '4-(N-[1-(4,4-dimethyl-2,6-dioxocyclohexylidene)-3-methyl-butyl]-amino)benzyl': '[#6]-[#6]1(-[#6]-[#6](-[#6](=[#6](-[#7]-[#6]2:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:2)-[#6]-[#6](-[#6])-[#6])-[#6](-[#6]-1)=[#8])=[#8])-[#6]',
            'trimethylsilylethyl': '[#6]-[#6]-[#6]-[Si](-[#6])(-[#6])-[#6]',
            '4,5-dimethoxy-2-nitrobenzyloxycarbonyl': '[#6]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](-[#8]-[#6]):[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            'pseudoprolines': '[#6]-[#6]1(-[#6])-[#7]-[#6](-[#6](-[#8])=[#8])-[#6]-[#8]-1',
            '2-hydroxy-4-methoxybenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]',
            '2,4-dimethoxybenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]-[#6]',
            '2,4,6-trimethoxybenzyl': '[#6]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]-[#6]',
            '1-methyl-3-indolylmethyl': '[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            '3,4-ethylene-dioxy-2-thenyl': '[#6]-[#6]1:[#6]2-[#8]-[#6]-[#6]-[#8]-[#6]:2:[#6]:[#16]:1',
            'hmb': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]',
            'tmob': '[#6]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]-[#6]',
            'mim': '[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'edot': '[#6]-[#6]1:[#6]2-[#8]-[#6]-[#6]-[#8]-[#6]:2:[#6]:[#16]:1',
            '4-methoxy-2-nitro-benzyl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            '(6-hydroxy-3-oxido-1,3-benz[d]oxathiol-5-yl)methyl': '[#8]=[#16]1-[#6]-[#8]-[#6]2:[#6]-1:[#6]:[#6](-[#6]):[#6](-[#8]):[#6]:2',
            '2-hydroxy-4-methoxy-5-(methylsulfinyl)benzyl': '[#6]-[#6]1:[#6]:[#6](-[#16](-[#6])=[#8]):[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]',
            'n-boc-n-methyl[2-(methylamino)ethyl]carbamoyl-hmb': '[#6]-[#6](-[#6])(-[#8]-[#6](-[#7](-[#6]-[#6]-[#7](-[#6](-[#8]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:[#6]:1)=[#8])-[#6])-[#6])=[#8])-[#6]',
            '9-xanthenyl': '[#6]12-[#6]-[#6]3:[#6](:[#6]:[#6]:[#6]:[#6]:3)-[#8]-[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'cyclopropyldimethylcarbinyl': '[#6]-[#6](-[#6]1-[#6]-[#6]-1)-[#6]',
            '4,4-dimethoxybenzhydryl': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'xan': '[#6]12-[#6]-[#6]3:[#6](:[#6]:[#6]:[#6]:[#6]:3)-[#8]-[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'cpd': '[#6]-[#6](-[#6]1-[#6]-[#6]-1)-[#6]',
            'mbh': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'p-toluenesulfonyl': '[#8]=[#16](-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1)=[#8]',
            '2,2,5,7,8-pentamethylchroman-6-sulfonyl': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#6]2-[#6]-[#6]-[#6](-[#6])(-[#6])-[#8]-[#6]:2:[#6](-[#6]):[#6]:1-[#6])=[#8]',
            '2,2,4,6,7-pentamethyl-2,3-dihydrobenzofuran-5-sulfonyl': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#6](-[#6]):[#6]2-[#8]-[#6](-[#6])(-[#6])-[#6]-[#6]:2:[#6]:1-[#6])=[#8]',
            'mesityl-2-sulfonyl': '[#6]-[#6]1:[#6](-[#16](=[#8])(-[#7]-[#6](-[#7])=[#7])=[#8]):[#6](-[#6]):[#6]:[#6](-[#6]):[#6]:1',
            '4-methoxy-2,3,6-trimethylphenylsulfonyl': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#6]:[#6](-[#8]-[#6]):[#6](-[#6]):[#6]:1-[#6])=[#8]',
            '1,2-dimethylindole-3-sulfonyl': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#7](-[#6]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)=[#8]',
            'w,w-bis-tert-butyloxycarbonyl': '[#6]-[#6](-[#6])(-[#8]-[#6](/[#7]=[#6](/[#7]-[#6](-[#8]-[#6](-[#6])(-[#6])-[#6])=[#8])-[#7])=[#8])-[#6]',
            '5-dibenzosuberenyl': '[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6]-[#6]1-[#6]=[#6]-[#6]=[#6]-[#6]-1=[#6]-2',
            '5-dibenzosuberyl': '[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6]-[#6]1:[#6](:[#6]:[#6]:[#6]:[#6]:1)-[#6]-2',
            '2-methoxy-5-dibenzosuberyl': '[#6]-[#8]-[#6]1:[#6]:[#6]2-[#6]-[#6]-[#6]3:[#6](-[#6]-[#6]:2:[#6]:[#6]:1):[#6]:[#6]:[#6]:[#6]:3',
            'nitro': '[#8]=[#7+]-[#8-]',
            'tos': '[#8]=[#16](-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1)=[#8]',
            'pmc': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#6]2-[#6]-[#6]-[#6](-[#6])(-[#6])-[#8]-[#6]:2:[#6](-[#6]):[#6]:1-[#6])=[#8]',
            'pbf': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#6](-[#6]):[#6]2-[#8]-[#6](-[#6])(-[#6])-[#6]-[#6]:2:[#6]:1-[#6])=[#8]',
            'mts': '[#6]-[#6]1:[#6](-[#16](=[#8])(-[#7]-[#6](-[#7])=[#7])=[#8]):[#6](-[#6]):[#6]:[#6](-[#6]):[#6]:1',
            'mtr': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#6]:[#6](-[#8]-[#6]):[#6](-[#6]):[#6]:1-[#6])=[#8]',
            'mis': '[#8]=[#16](-[#6]1:[#6](-[#6]):[#7](-[#6]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)=[#8]',
            'bis-boc': '[#6]-[#6](-[#6])(-[#8]-[#6](/[#7]=[#6](/[#7]-[#6](-[#8]-[#6](-[#6])(-[#6])-[#6])=[#8])-[#7])=[#8])-[#6]',
            'suben': '[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6]-[#6]1-[#6]=[#6]-[#6]=[#6]-[#6]-1=[#6]-2',
            'sub': '[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#6]-[#6]1:[#6](:[#6]:[#6]:[#6]:[#6]:1)-[#6]-2',
            'mesub': '[#6]-[#8]-[#6]1:[#6]:[#6]2-[#6]-[#6]-[#6]3:[#6](-[#6]-[#6]:2:[#6]:[#6]:1):[#6]:[#6]:[#6]:[#6]:3',
            'no2': '[#8]=[#7+]-[#8-]',
            'w,w-bis-benzyloxycarbonyl': '[#8]=[#6](/[#7]=[#6](/[#7]-[#6](-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8])-[#7])-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'w,w-bis-allyloxycarbonyl': '[#8]=[#6](/[#7]=[#6](/[#7]-[#6](-[#8]-[#6]-[#6]=[#6])=[#8])-[#7])-[#8]-[#6]-[#6]=[#6]',
            'z': '[#8]=[#6](/[#7]=[#6](/[#7]-[#6](-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8])-[#7])-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'p-methylbenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            'p-methoxybenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'monomethoxytrityl': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#6]:1',
            'trimethoxybenzyl': '[#6]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]-[#6]',
            '2,2,4,6,7-pentamethyl-5-dihydrobenzofuranylmethyl': '[#6]-[#6]1:[#6](-[#6]):[#6](-[#6]):[#6]2-[#8]-[#6](-[#6])(-[#6])-[#6]-[#6]:2:[#6]:1-[#6]',
            '1-adamantyl': '[#6]12-[#6]-[#6]3-[#6]-[#6](-[#6]-1)-[#6]-[#6](-[#6]-3)-[#6]-2',
            'meb': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1',
            'mob': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            'mmt': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#6]:1',
            'pmbf': '[#6]-[#6]1:[#6](-[#6]):[#6](-[#6]):[#6]2-[#8]-[#6](-[#6])(-[#6])-[#6]-[#6]:2:[#6]:1-[#6]',
            '1-ada': '[#6]12-[#6]-[#6]3-[#6]-[#6](-[#6]-1)-[#6]-[#6](-[#6]-3)-[#6]-2',
            '2-(2,4-dinitrophenyl)ethyl': '[#6]-[#6]-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            '9-fluororenylmethoxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1-[#6]2:[#6](-[#6]3:[#6]-1:[#6]:[#6]:[#6]:[#6]:3):[#6]:[#6]:[#6]:[#6]:2',
            'dnpe': '[#6]-[#6]-[#6]1:[#6]:[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            'acetamidomethyl': '[#6]-[#7]-[#6](-[#6])=[#8]',
            'phenylacetamidomethyl': '[#6]-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8]',
            '5-tert-butylmercapto': '[#6]-[#6](-[#6])(-[#16])-[#6]',
            '3-nitro-2-pyridinesulfenyl': '[#16]-[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            '2-pyridinesulfenyl': '[#16]-[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1',
            'N-allyloxycarbonyl-N-[2,3,5,6-tetrafluoro-4-(phenylthio)phenyl]]aminomethyl': '[#9]-[#6]1:[#6](-[#9]):[#6](-[#16]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6](-[#9]):[#6](-[#9]):[#6]:1-[#7](-[#6](-[#8]-[#6]-[#6]=[#6])=[#8])-[#6]',
            'o-nitrobenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            '4-picolyl': '[#6]-[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            'ninhydrin': '[#8]=[#6]1-[#6]2(-[#16]-[#6]-[#6](-[#6](-[#8])=[#8])-[#7]-2)-[#6](-[#6]2:[#6]-1:[#6]:[#6]:[#6]:[#6]:2)=[#8]',
            'acm': '[#6]-[#7]-[#6](-[#6])=[#8]',
            'phacm': '[#6]-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8]',
            'sbu': '[#6]-[#6](-[#6])(-[#16])-[#6]',
            'npys': '[#16]-[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            's-pyr': '[#16]-[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1',
            'fsam': '[#9]-[#6]1:[#6](-[#9]):[#6](-[#16]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6](-[#9]):[#6](-[#9]):[#6]:1-[#7](-[#6](-[#8]-[#6]-[#6]=[#6])=[#8])-[#6]',
            'onb': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7+](-[#8-])=[#8]',
            'nin': '[#8]=[#6]1-[#6]2(-[#16]-[#6]-[#6](-[#6](-[#8])=[#8])-[#7]-2)-[#6](-[#6]2:[#6]-1:[#6]:[#6]:[#6]:[#6]:2)=[#8]',
            'n-tosyl': '[#8]=[#16](-[#7]1:[#6]:[#6]:[#7]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1)=[#8]',
            'n-trityl': '[#7]1(-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)(-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#6]:[#7]:[#6]:1',
            'n-monomethoxytrityl': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'n-methyltrityl': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'n-tert-butyloxycarbonyl': '[#8]=[#6](-[#8]-[#6](-[#6])(-[#6])-[#6])-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'n-2,4-dimethylpent-3-yloxycarbonyl': '[#8]=[#6](-[#8]-[#6](-[#6](-[#6])-[#6])-[#6](-[#6])-[#6])-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'n-benzyloxymethyl': '[#7+]1(-[#6]-[#8]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#7H]:[#6]:[#6]:1',
            'n-tert-butoxymethyl': '[#6]-[#6](-[#6])(-[#6])-[#8]-[#6]-[#7+]1:[#6]:[#7H]:[#6]:[#6]:1',
            'ntos': '[#8]=[#16](-[#7]1:[#6]:[#6]:[#7]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1)=[#8]',
            'ntrt': '[#7]1(-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)(-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#6]:[#7]:[#6]:1',
            'nmtt': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'nmmt': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'nboc': '[#8]=[#6](-[#8]-[#6](-[#6])(-[#6])-[#6])-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'ndoc': '[#8]=[#6](-[#8]-[#6](-[#6](-[#6])-[#6])-[#6](-[#6])-[#6])-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'nbom': '[#7+]1(-[#6]-[#8]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6]:[#7H]:[#6]:[#6]:1',
            'nbum': '[#6]-[#6](-[#6])(-[#6])-[#8]-[#6]-[#7+]1:[#6]:[#7H]:[#6]:[#6]:1',
            'N-9-fluorenylmethoxycarbonyl': '[#8]=[#6](-[#8]-[#6]1-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#6]2:[#6]-1:[#6]:[#6]:[#6]:[#6]:2)-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'N-2,6-dimethoxybenzoyl': '[#8]=[#6](-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6]:[#6]:[#6]:1-[#8]-[#6])-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'dmbz': '[#8]=[#6](-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6]:[#6]:[#6]:1-[#8]-[#6])-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'N-2,4-dinitrophenyl': '[#8]=[#6](-[#6]1:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1)-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'dnp': '[#8]=[#6](-[#6]1:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6](-[#7+](-[#8-])=[#8]):[#6]:[#6]:1)-[#7]1:[#6]:[#6]:[#7]:[#6]:1',
            'cyclohexyl;': '[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'tert-butyldimethylsilyl': '[#6]-[Si](-[#6](-[#6])(-[#6])-[#6])-[#6]',
            'tbdms': '[#6]-[Si](-[#6](-[#6])(-[#6])-[#6])-[#6]',
            'tert-butyldiphenylsilyl': '[#6]-[#6](-[Si](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6])-[#6]',
            'propargyloxycarbonyl': '[#6]#[#6]-[#8]-[#6](-[#6])=[#8]',
            'tbdps': '[#6]-[#6](-[Si](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6])-[#6]',
            '2,6-dichlorobenzyl': '[#6]-[#6]1:[#6](-[#17]):[#6]:[#6]:[#6]:[#6]:1-[#17]',
            '2-bromobenzyl': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#35]',
            '2-bromobenzyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#35]',
            '3-pentyl': '[#6]-[#6]-[#6]-[#6]-[#6]',
            'dcb': '[#6]-[#6]1:[#6](-[#17]):[#6]:[#6]:[#6]:[#6]:1-[#17]',
            'brbn': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#35]',
            'brz': '[#8]=[#6]-[#8]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#35]',
            'pen': '[#6]-[#6]-[#6]-[#6]-[#6]',
            'tegb': '[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]-[#6]-[#8]-[#6]-[#6]-[#8]-[#6]-[#6]-[#8]-[#6]):[#6]:[#6]:1',
            'boc-n-methyl-n-[2-(methylamino)ethyl]carbamoyl': '[#8]=[#6](-[#6](-[#8]-[#6](-[#6])(-[#6])-[#6])=[#8])-[#7](-[#6])-[#6]-[#6]-[#7]-[#6]',
            'boc-nmec': '[#8]=[#6](-[#6](-[#8]-[#6](-[#6])(-[#6])-[#6])=[#8])-[#7](-[#6])-[#6]-[#6]-[#7]-[#6]',
            'formyl': '[#6]=[#8]',
            'cyclohexyloxycarbonyl': '[#8]=[#6]-[#8]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'for': '[#6]=[#8]',
            'hoc': '[#8]=[#6]-[#8]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
        }
        
        return smarts
    
