# autogenerated
# mypy: ignore-errors
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from rime_sdk.protos.image_registry import image_registry_pb2 as image__registry_dot_image__registry__pb2


class ImageRegistryStub(object):
    """Service for managing custom images in RIME.
    ***********************************************************
    Public: external RPCs that should be available to to clients.
    **********************************************************
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CreateImage = channel.unary_unary(
                '/rime.ImageRegistry/CreateImage',
                request_serializer=image__registry_dot_image__registry__pb2.CreateImageRequest.SerializeToString,
                response_deserializer=image__registry_dot_image__registry__pb2.CreateImageResponse.FromString,
                )
        self.GetImage = channel.unary_unary(
                '/rime.ImageRegistry/GetImage',
                request_serializer=image__registry_dot_image__registry__pb2.GetImageRequest.SerializeToString,
                response_deserializer=image__registry_dot_image__registry__pb2.GetImageResponse.FromString,
                )
        self.ListImages = channel.unary_unary(
                '/rime.ImageRegistry/ListImages',
                request_serializer=image__registry_dot_image__registry__pb2.ListImagesRequest.SerializeToString,
                response_deserializer=image__registry_dot_image__registry__pb2.ListImagesResponse.FromString,
                )
        self.DeleteImage = channel.unary_unary(
                '/rime.ImageRegistry/DeleteImage',
                request_serializer=image__registry_dot_image__registry__pb2.DeleteImageRequest.SerializeToString,
                response_deserializer=image__registry_dot_image__registry__pb2.DeleteImageResponse.FromString,
                )
        self.EnsureImageExistence = channel.unary_unary(
                '/rime.ImageRegistry/EnsureImageExistence',
                request_serializer=image__registry_dot_image__registry__pb2.EnsureImageExistenceRequest.SerializeToString,
                response_deserializer=image__registry_dot_image__registry__pb2.EnsureImageExistenceResponse.FromString,
                )
        self.SyncImageTag = channel.unary_unary(
                '/rime.ImageRegistry/SyncImageTag',
                request_serializer=image__registry_dot_image__registry__pb2.SyncImageTagRequest.SerializeToString,
                response_deserializer=image__registry_dot_image__registry__pb2.SyncImageTagResponse.FromString,
                )
        self.UpdateBuildInfo = channel.unary_unary(
                '/rime.ImageRegistry/UpdateBuildInfo',
                request_serializer=image__registry_dot_image__registry__pb2.UpdateBuildInfoRequest.SerializeToString,
                response_deserializer=image__registry_dot_image__registry__pb2.UpdateBuildInfoResponse.FromString,
                )


class ImageRegistryServicer(object):
    """Service for managing custom images in RIME.
    ***********************************************************
    Public: external RPCs that should be available to to clients.
    **********************************************************
    """

    def CreateImage(self, request, context):
        """CreateImage

        Creates a new ManagedImage with a unique `name` (see the naming rules below for
        for `ManagedImage.name`).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetImage(self, request, context):
        """GetImage

        Gets the definition of the ManagedImage for `name`.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListImages(self, request, context):
        """ListImages

        List all images matching the constrains specified in the request.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteImage(self, request, context):
        """DeleteImage

        Deletes the definition of the ManagedImage given by `name`.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EnsureImageExistence(self, request, context):
        """****************************************************************
        Private: internal only RPCs that should not be exposed to clients.
        ***************************************************************

        EnsureImageExistence ensures that the every RIME managed image exists in
        the backend registry. For any image that does not exist in the registry,
        the RPC will create that image in the registry then update the managed
        image metadata to indicate the image's new repository name and to mark
        the image as OUTDATED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SyncImageTag(self, request, context):
        """Ensures image given by `name` is synced to the tag of the registry's version.
        If necessary, this will start a job to build a new tag of the managed image
        based on the current version of the registry. However, if an image is already
        synced to the current version of the registry, this RPC will do nothing.
        For instance, if we had the following images:

        Name | Tag
        -----|--------
        Foo  | 0.11.2
        Bar  | 0.11.2
        Baz  | 0.11.1

        and upgraded the RIME backend to 0.12.1, then calling `SyncImageTag('Foo')`
        will start a job to create the 'Foo' image at tag 0.12.1 (but will not change
        any other images).

        SyncImageTag only builds a new tag of the managed image if
        * the image has status as OUTDATED
        * the image has status READY but the backend registry does not contain
        a tag on that image for the registry's version (ie. inconsistency).
        * the SyncImageTag is *forced* and the image has any other state other
        than READY or OUTDATED (see cases for those states above).
        unless another job is simultaneously rebuilding the same image.

        Note: this does not change the definition of the ManagedImage, only its tag.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateBuildInfo(self, request, context):
        """UpdateBuildInfo updates the information about an image after an image build
        for it has completed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ImageRegistryServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'CreateImage': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateImage,
                    request_deserializer=image__registry_dot_image__registry__pb2.CreateImageRequest.FromString,
                    response_serializer=image__registry_dot_image__registry__pb2.CreateImageResponse.SerializeToString,
            ),
            'GetImage': grpc.unary_unary_rpc_method_handler(
                    servicer.GetImage,
                    request_deserializer=image__registry_dot_image__registry__pb2.GetImageRequest.FromString,
                    response_serializer=image__registry_dot_image__registry__pb2.GetImageResponse.SerializeToString,
            ),
            'ListImages': grpc.unary_unary_rpc_method_handler(
                    servicer.ListImages,
                    request_deserializer=image__registry_dot_image__registry__pb2.ListImagesRequest.FromString,
                    response_serializer=image__registry_dot_image__registry__pb2.ListImagesResponse.SerializeToString,
            ),
            'DeleteImage': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteImage,
                    request_deserializer=image__registry_dot_image__registry__pb2.DeleteImageRequest.FromString,
                    response_serializer=image__registry_dot_image__registry__pb2.DeleteImageResponse.SerializeToString,
            ),
            'EnsureImageExistence': grpc.unary_unary_rpc_method_handler(
                    servicer.EnsureImageExistence,
                    request_deserializer=image__registry_dot_image__registry__pb2.EnsureImageExistenceRequest.FromString,
                    response_serializer=image__registry_dot_image__registry__pb2.EnsureImageExistenceResponse.SerializeToString,
            ),
            'SyncImageTag': grpc.unary_unary_rpc_method_handler(
                    servicer.SyncImageTag,
                    request_deserializer=image__registry_dot_image__registry__pb2.SyncImageTagRequest.FromString,
                    response_serializer=image__registry_dot_image__registry__pb2.SyncImageTagResponse.SerializeToString,
            ),
            'UpdateBuildInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateBuildInfo,
                    request_deserializer=image__registry_dot_image__registry__pb2.UpdateBuildInfoRequest.FromString,
                    response_serializer=image__registry_dot_image__registry__pb2.UpdateBuildInfoResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'rime.ImageRegistry', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ImageRegistry(object):
    """Service for managing custom images in RIME.
    ***********************************************************
    Public: external RPCs that should be available to to clients.
    **********************************************************
    """

    @staticmethod
    def CreateImage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ImageRegistry/CreateImage',
            image__registry_dot_image__registry__pb2.CreateImageRequest.SerializeToString,
            image__registry_dot_image__registry__pb2.CreateImageResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetImage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ImageRegistry/GetImage',
            image__registry_dot_image__registry__pb2.GetImageRequest.SerializeToString,
            image__registry_dot_image__registry__pb2.GetImageResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListImages(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ImageRegistry/ListImages',
            image__registry_dot_image__registry__pb2.ListImagesRequest.SerializeToString,
            image__registry_dot_image__registry__pb2.ListImagesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteImage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ImageRegistry/DeleteImage',
            image__registry_dot_image__registry__pb2.DeleteImageRequest.SerializeToString,
            image__registry_dot_image__registry__pb2.DeleteImageResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EnsureImageExistence(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ImageRegistry/EnsureImageExistence',
            image__registry_dot_image__registry__pb2.EnsureImageExistenceRequest.SerializeToString,
            image__registry_dot_image__registry__pb2.EnsureImageExistenceResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SyncImageTag(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ImageRegistry/SyncImageTag',
            image__registry_dot_image__registry__pb2.SyncImageTagRequest.SerializeToString,
            image__registry_dot_image__registry__pb2.SyncImageTagResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateBuildInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ImageRegistry/UpdateBuildInfo',
            image__registry_dot_image__registry__pb2.UpdateBuildInfoRequest.SerializeToString,
            image__registry_dot_image__registry__pb2.UpdateBuildInfoResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
