# -*- coding: utf-8 -*-
"""Create the example Database

Revision ID: e90a32e90839
Revises:
Create Date: 2022-03-22 20:56:29.497521

"""
import sqlalchemy as sa
import sqlalchemy_utc
import sqlalchemy_utils
from alembic import op

# revision identifiers, used by Alembic.
revision = "e90a32e90839"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "aliases",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("alias", sa.String(), nullable=True),
        sa.Column(
            "created",
            sqlalchemy_utc.sqltypes.UtcDateTime(timezone=True),
            nullable=False,
        ),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column("value_id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("alias", "version"),
    )
    op.create_index(op.f("ix_aliases_alias"), "aliases", ["alias"], unique=False)
    op.create_table(
        "data_types",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("type_config_hash", sa.Integer(), nullable=False),
        sa.Column("type_name", sa.String(), nullable=False),
        sa.Column("type_config", sa.JSON(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("type_config_hash", "type_name"),
    )
    op.create_index(
        op.f("ix_data_types_type_config_hash"),
        "data_types",
        ["type_config_hash"],
        unique=False,
    )
    op.create_index(
        op.f("ix_data_types_type_name"), "data_types", ["type_name"], unique=False
    )
    op.create_table(
        "manifests",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("module_type", sa.String(), nullable=False),
        sa.Column("module_config", sa.JSON(), nullable=False),
        sa.Column("manifest_hash", sa.Integer(), nullable=False),
        sa.Column("is_idempotent", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("module_type", "manifest_hash"),
    )
    op.create_index(
        op.f("ix_manifests_manifest_hash"), "manifests", ["manifest_hash"], unique=False
    )
    op.create_index(
        op.f("ix_manifests_module_type"), "manifests", ["module_type"], unique=False
    )
    op.create_table(
        "metadata_schema_lookup",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("metadata_schema_hash", sa.Integer(), nullable=True),
        sa.Column("metadata_type", sa.String(), nullable=False),
        sa.Column("metadata_schema", sa.JSON(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("metadata_schema_hash"),
    )
    op.create_index(
        op.f("ix_metadata_schema_lookup_metadata_schema_hash"),
        "metadata_schema_lookup",
        ["metadata_schema_hash"],
        unique=False,
    )
    op.create_table(
        "environments",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("metadata_hash", sa.Integer(), nullable=False),
        sa.Column("metadata_schema_id", sa.Integer(), nullable=False),
        sa.Column("metadata_payload", sa.JSON(), nullable=False),
        sa.ForeignKeyConstraint(
            ["metadata_schema_id"],
            ["metadata_schema_lookup.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("metadata_hash"),
    )
    op.create_index(
        op.f("ix_environments_metadata_hash"),
        "environments",
        ["metadata_hash"],
        unique=False,
    )
    op.create_table(
        "jobs",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("manifest_id", sa.Integer(), nullable=False),
        sa.Column("inputs", sa.JSON(), nullable=False),
        sa.Column("input_hash", sa.String(), nullable=False),
        sa.Column("is_idempotent", sa.Boolean(), nullable=False),
        sa.Column(
            "created",
            sqlalchemy_utc.sqltypes.UtcDateTime(timezone=True),
            nullable=False,
        ),
        sa.Column(
            "started", sqlalchemy_utc.sqltypes.UtcDateTime(timezone=True), nullable=True
        ),
        sa.Column("duration_ms", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["manifest_id"],
            ["manifests.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "pedigrees",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("manifest_id", sa.Integer(), nullable=False),
        sa.Column("inputs", sa.JSON(), nullable=False),
        sa.ForeignKeyConstraint(
            ["manifest_id"],
            ["manifests.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "values",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("global_id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=True),
        sa.Column("data_type_id", sa.Integer(), nullable=True),
        sa.Column("data_type_name", sa.Integer(), nullable=False),
        sa.Column("value_size", sa.Integer(), nullable=False),
        sa.Column("value_hash", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["data_type_id"],
            ["data_types.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("value_hash", "value_size", "data_type_id"),
    )
    op.create_index(
        op.f("ix_values_data_type_name"), "values", ["data_type_name"], unique=False
    )
    op.create_index(
        op.f("ix_values_value_hash"), "values", ["value_hash"], unique=False
    )
    op.create_index(
        op.f("ix_values_value_size"), "values", ["value_size"], unique=False
    )
    op.create_table(
        "destinies",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("value_id", sa.Integer(), nullable=True),
        sa.Column("category", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("manifest_id", sa.Integer(), nullable=True),
        sa.Column("inputs", sa.JSON(), nullable=False),
        sa.Column("output_name", sa.String(), nullable=False),
        sa.Column("destiny_value", sa.Integer(), nullable=True),
        sa.Column("description", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["destiny_value"],
            ["values.id"],
        ),
        sa.ForeignKeyConstraint(
            ["manifest_id"],
            ["manifests.id"],
        ),
        sa.ForeignKeyConstraint(
            ["value_id"],
            ["values.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("value_id", "category", "key"),
    )
    op.create_table(
        "job_environments",
        sa.Column("jobs_id", sa.Integer(), nullable=False),
        sa.Column("environment_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["environment_id"],
            ["environments.id"],
        ),
        sa.ForeignKeyConstraint(
            ["jobs_id"],
            ["jobs.id"],
        ),
        sa.PrimaryKeyConstraint("jobs_id", "environment_id"),
    )
    op.create_table(
        "value_environments",
        sa.Column("value_id", sa.Integer(), nullable=False),
        sa.Column("environment_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["environment_id"],
            ["environments.id"],
        ),
        sa.ForeignKeyConstraint(
            ["value_id"],
            ["values.id"],
        ),
        sa.PrimaryKeyConstraint("value_id", "environment_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("value_environments")
    op.drop_table("job_environments")
    op.drop_table("destinies")
    op.drop_index(op.f("ix_values_value_size"), table_name="values")
    op.drop_index(op.f("ix_values_value_hash"), table_name="values")
    op.drop_index(op.f("ix_values_data_type_name"), table_name="values")
    op.drop_table("values")
    op.drop_table("pedigrees")
    op.drop_table("jobs")
    op.drop_index(op.f("ix_environments_metadata_hash"), table_name="environments")
    op.drop_table("environments")
    op.drop_index(
        op.f("ix_metadata_schema_lookup_metadata_schema_hash"),
        table_name="metadata_schema_lookup",
    )
    op.drop_table("metadata_schema_lookup")
    op.drop_index(op.f("ix_manifests_module_type"), table_name="manifests")
    op.drop_index(op.f("ix_manifests_manifest_hash"), table_name="manifests")
    op.drop_table("manifests")
    op.drop_index(op.f("ix_data_types_type_name"), table_name="data_types")
    op.drop_index(op.f("ix_data_types_type_config_hash"), table_name="data_types")
    op.drop_table("data_types")
    op.drop_index(op.f("ix_aliases_alias"), table_name="aliases")
    op.drop_table("aliases")
    # ### end Alembic commands ###
