"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Disk = exports.DiskProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ens_generated_1 = require("./ens.generated");
Object.defineProperty(exports, "DiskProperty", { enumerable: true, get: function () { return ens_generated_1.RosDisk; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ENS::Disk`, which is used to create a pay-as-you-go or subscription data disk.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDisk`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ens-disk
 */
class Disk extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDisk = new ens_generated_1.RosDisk(this, id, {
            snapshotId: props.snapshotId,
            category: props.category,
            kmsKeyId: props.kmsKeyId,
            encrypted: props.encrypted,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'PostPaid' : props.instanceChargeType,
            size: props.size,
            diskName: props.diskName,
            ensRegionId: props.ensRegionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDisk;
        this.attrDiskId = rosDisk.attrDiskId;
    }
}
exports.Disk = Disk;
//# sourceMappingURL=data:application/json;base64,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