"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskInstanceAttachment = exports.DiskInstanceAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ens_generated_1 = require("./ens.generated");
Object.defineProperty(exports, "DiskInstanceAttachmentProperty", { enumerable: true, get: function () { return ens_generated_1.RosDiskInstanceAttachment; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ENS::DiskInstanceAttachment`, which is used to attach a data disk to an Edge Node Service (ENS) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskInstanceAttachment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ens-diskinstanceattachment
 */
class DiskInstanceAttachment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskInstanceAttachment = new ens_generated_1.RosDiskInstanceAttachment(this, id, {
            instanceId: props.instanceId,
            deleteWithInstance: props.deleteWithInstance,
            diskId: props.diskId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskInstanceAttachment;
        this.attrDiskId = rosDiskInstanceAttachment.attrDiskId;
        this.attrInstanceId = rosDiskInstanceAttachment.attrInstanceId;
    }
}
exports.DiskInstanceAttachment = DiskInstanceAttachment;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGlza2luc3RhbmNlYXR0YWNobWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRpc2tpbnN0YW5jZWF0dGFjaG1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUE0RDtBQUV0QiwrR0FGN0IseUNBQXlCLE9BRWtDO0FBNEJwRTs7OztHQUlHO0FBQ0gsTUFBYSxzQkFBdUIsU0FBUSxHQUFHLENBQUMsUUFBUTtJQWdCcEQ7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBa0MsRUFBRSxtQ0FBMkMsSUFBSTtRQUM3SCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDO1FBQ2IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBRXpFLE1BQU0seUJBQXlCLEdBQUcsSUFBSSx5Q0FBeUIsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ3ZFLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtTQUN2QixFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLHlCQUF5QixDQUFDO1FBQzFDLElBQUksQ0FBQyxVQUFVLEdBQUcseUJBQXlCLENBQUMsVUFBVSxDQUFDO1FBQ3ZELElBQUksQ0FBQyxjQUFjLEdBQUcseUJBQXlCLENBQUMsY0FBYyxDQUFDO0lBQ25FLENBQUM7Q0FDSjtBQXJDRCx3REFxQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NEaXNrSW5zdGFuY2VBdHRhY2htZW50IH0gZnJvbSAnLi9lbnMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zRGlza0luc3RhbmNlQXR0YWNobWVudCBhcyBEaXNrSW5zdGFuY2VBdHRhY2htZW50UHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBEaXNrSW5zdGFuY2VBdHRhY2htZW50YC5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLWVucy1kaXNraW5zdGFuY2VhdHRhY2htZW50XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRGlza0luc3RhbmNlQXR0YWNobWVudFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRpc2tJZDogVGhlIElEIG9mIHRoZSBjbG91ZCBkaXNrIHRvIGJlIG1vdW50ZWQuIFRoZSBDbG91ZCBEaXNrIChEaXNrSWQpIGFuZCB0aGUgaW5zdGFuY2UgKEluc3RhbmNlSWQpIG11c3QgYmUgb24gdGhlIHNhbWUgbm9kZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBkaXNrSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGluc3RhbmNlSWQ6IEluc3RhbmNlIElELlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlbGV0ZVdpdGhJbnN0YW5jZTogV2hldGhlciB0aGUgY2xvdWQgZGlzayB0byBiZSBtb3VudGVkIGlzIHJlbGVhc2VkIHdpdGggdGhlIGluc3RhbmNlXG4gICAgICogVmFsdWU6XG4gICAgICogdHJ1ZTogV2hlbiB0aGUgaW5zdGFuY2UgaXMgcmVsZWFzZWQsIHRoZSBjbG91ZCBkaXNrIGlzIHJlbGVhc2VkIHRvZ2V0aGVyIHdpdGggdGhlIGluc3RhbmNlLlxuICAgICAqIGZhbHNlOiBXaGVuIHRoZSBpbnN0YW5jZSBpcyByZWxlYXNlZCwgdGhlIGNsb3VkIGRpc2sgaXMgcmV0YWluZWQgYW5kIGlzIG5vdCByZWxlYXNlZCB0b2dldGhlciB3aXRoIHRoZSBpbnN0YW5jZS5cbiAgICAgKiAgRW1wdHkgbWVhbnMgZmFsc2UgYnkgZGVmYXVsdC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZWxldGVXaXRoSW5zdGFuY2U/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogVGhpcyBjbGFzcyBlbmNhcHN1bGF0ZXMgYW5kIGV4dGVuZHMgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OkVOUzo6RGlza0luc3RhbmNlQXR0YWNobWVudGAsIHdoaWNoIGlzIHVzZWQgdG8gYXR0YWNoIGEgZGF0YSBkaXNrIHRvIGFuIEVkZ2UgTm9kZSBTZXJ2aWNlIChFTlMpIGluc3RhbmNlLlxuICogQE5vdGUgVGhpcyBjbGFzcyBtYXkgaGF2ZSBzb21lIG5ldyBmdW5jdGlvbnMgdG8gZmFjaWxpdGF0ZSBkZXZlbG9wbWVudCwgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoaXMgY2xhc3MgaW5zdGVhZCBvZiBgUm9zRGlza0luc3RhbmNlQXR0YWNobWVudGBmb3IgYSBtb3JlIGNvbnZlbmllbnQgZGV2ZWxvcG1lbnQgZXhwZXJpZW5jZS5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLWVucy1kaXNraW5zdGFuY2VhdHRhY2htZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBEaXNrSW5zdGFuY2VBdHRhY2htZW50IGV4dGVuZHMgcm9zLlJlc291cmNlIHtcbiAgICBwcm90ZWN0ZWQgc2NvcGU6IHJvcy5Db25zdHJ1Y3Q7XG4gICAgcHJvdGVjdGVkIGlkOiBzdHJpbmc7XG4gICAgcHJvdGVjdGVkIHByb3BzOiBEaXNrSW5zdGFuY2VBdHRhY2htZW50UHJvcHM7XG4gICAgcHJvdGVjdGVkIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIERpc2tJZDogVGhlIElEIG9mIHRoZSBjbG91ZCBkaXNrIHRvIGJlIG1vdW50ZWQuIFRoZSBDbG91ZCBEaXNrIChEaXNrSWQpIGFuZCB0aGUgaW5zdGFuY2UgKEluc3RhbmNlSWQpIG11c3QgYmUgb24gdGhlIHNhbWUgbm9kZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckRpc2tJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEluc3RhbmNlSWQ6IEluc3RhbmNlIElELlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySW5zdGFuY2VJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERpc2tJbnN0YW5jZUF0dGFjaG1lbnRQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgdGhpcy5zY29wZSA9IHNjb3BlO1xuICAgICAgICB0aGlzLmlkID0gaWQ7XG4gICAgICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuXG4gICAgICAgIGNvbnN0IHJvc0Rpc2tJbnN0YW5jZUF0dGFjaG1lbnQgPSBuZXcgUm9zRGlza0luc3RhbmNlQXR0YWNobWVudCh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIGluc3RhbmNlSWQ6IHByb3BzLmluc3RhbmNlSWQsXG4gICAgICAgICAgICBkZWxldGVXaXRoSW5zdGFuY2U6IHByb3BzLmRlbGV0ZVdpdGhJbnN0YW5jZSxcbiAgICAgICAgICAgIGRpc2tJZDogcHJvcHMuZGlza0lkLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0Rpc2tJbnN0YW5jZUF0dGFjaG1lbnQ7XG4gICAgICAgIHRoaXMuYXR0ckRpc2tJZCA9IHJvc0Rpc2tJbnN0YW5jZUF0dGFjaG1lbnQuYXR0ckRpc2tJZDtcbiAgICAgICAgdGhpcy5hdHRySW5zdGFuY2VJZCA9IHJvc0Rpc2tJbnN0YW5jZUF0dGFjaG1lbnQuYXR0ckluc3RhbmNlSWQ7XG4gICAgfVxufVxuIl19