"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Image = exports.ImageProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ens_generated_1 = require("./ens.generated");
Object.defineProperty(exports, "ImageProperty", { enumerable: true, get: function () { return ens_generated_1.RosImage; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ENS::Image`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosImage`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ens-image
 */
class Image extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosImage = new ens_generated_1.RosImage(this, id, {
            imageName: props.imageName,
            instanceId: props.instanceId,
            deleteAfterImageUpload: props.deleteAfterImageUpload,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosImage;
        this.attrArchitecture = rosImage.attrArchitecture;
        this.attrComputeType = rosImage.attrComputeType;
        this.attrCreateTime = rosImage.attrCreateTime;
        this.attrImageId = rosImage.attrImageId;
        this.attrImageName = rosImage.attrImageName;
        this.attrImageOwnerAlias = rosImage.attrImageOwnerAlias;
        this.attrImageSize = rosImage.attrImageSize;
        this.attrInstanceId = rosImage.attrInstanceId;
        this.attrOsVersion = rosImage.attrOsVersion;
        this.attrPlatform = rosImage.attrPlatform;
        this.attrSnapshotId = rosImage.attrSnapshotId;
    }
}
exports.Image = Image;
//# sourceMappingURL=data:application/json;base64,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