"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ens_generated_1 = require("./ens.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return ens_generated_1.RosInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ENS::Instance`, which is used to create an Edge Node Service (ENS) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ens-instance
 */
class Instance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInstance = new ens_generated_1.RosInstance(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            keyPairName: props.keyPairName,
            privateIpAddress: props.privateIpAddress,
            userData: props.userData,
            ipType: props.ipType,
            systemDiskSize: props.systemDiskSize,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            quantity: props.quantity,
            internetChargeType: props.internetChargeType,
            instanceName: props.instanceName,
            uniqueSuffix: props.uniqueSuffix,
            imageId: props.imageId,
            paymentType: props.paymentType,
            dataDiskSize: props.dataDiskSize,
            instanceType: props.instanceType,
            ensRegionId: props.ensRegionId,
            hostName: props.hostName,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrAutoRenew = rosInstance.attrAutoRenew;
        this.attrAutoRenewPeriod = rosInstance.attrAutoRenewPeriod;
        this.attrDataDiskSize = rosInstance.attrDataDiskSize;
        this.attrEnsRegionId = rosInstance.attrEnsRegionId;
        this.attrHostName = rosInstance.attrHostName;
        this.attrImageId = rosInstance.attrImageId;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceName = rosInstance.attrInstanceName;
        this.attrInstanceType = rosInstance.attrInstanceType;
        this.attrInternetChargeType = rosInstance.attrInternetChargeType;
        this.attrIpType = rosInstance.attrIpType;
        this.attrKeyPairName = rosInstance.attrKeyPairName;
        this.attrPaymentType = rosInstance.attrPaymentType;
        this.attrPeriod = rosInstance.attrPeriod;
        this.attrPrivateIpAddress = rosInstance.attrPrivateIpAddress;
        this.attrPrivateIps = rosInstance.attrPrivateIps;
        this.attrPublicIps = rosInstance.attrPublicIps;
        this.attrQuantity = rosInstance.attrQuantity;
        this.attrSystemDiskSize = rosInstance.attrSystemDiskSize;
        this.attrUniqueSuffix = rosInstance.attrUniqueSuffix;
        this.attrUserData = rosInstance.attrUserData;
        this.attrVSwitchId = rosInstance.attrVSwitchId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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