"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScaling = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
class AutoScaling {
    static metrics(name, max_capacity) {
        let header = new aws_cloudwatch_1.TextWidget({
            width: 24,
            height: 1,
            markdown: `# ${name} - Auto Scaling Group`,
        });
        let groupInServiceInstancesMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/AutoScaling',
            metricName: 'GroupInServiceInstances',
            dimensions: {
                AutoScalingGroupName: name,
            },
        });
        let leftAnnotations = null;
        if (typeof (max_capacity) == 'number') {
            leftAnnotations = [
                {
                    label: 'Max Instances in ASG',
                    value: max_capacity,
                },
            ];
        }
        let GroupInServiceInstancesProps = {
            height: 6,
            width: 12,
            leftYAxis: {
                min: 0,
                label: 'Instances',
                showUnits: false,
            },
            leftAnnotations: leftAnnotations,
        };
        let GroupInServiceInstances = new aws_cloudwatch_1.GraphWidget(GroupInServiceInstancesProps);
        GroupInServiceInstances.addRightMetric(groupInServiceInstancesMetric);
        GroupInServiceInstances.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'GroupInServiceInstances (expected)',
            color: '#666666',
            usingMetrics: {
                m1: groupInServiceInstancesMetric,
            },
        }));
        let cpuUtilizationAverageMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'CPUUtilization',
            dimensions: {
                AutoScalingGroupName: name,
            },
            statistic: 'Average',
        });
        let cpuUtilizationAverage = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        cpuUtilizationAverage.addRightMetric(cpuUtilizationAverageMetric);
        cpuUtilizationAverage.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'Average CPUUtilization (expected)',
            color: '#666666',
            usingMetrics: {
                m1: cpuUtilizationAverageMetric,
            },
        }));
        let cpuUtilizationMaximumMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'CPUUtilization',
            dimensions: {
                AutoScalingGroupName: name,
            },
            statistic: 'Maximum',
        });
        let cpuUtilizationMaximum = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        cpuUtilizationMaximum.addRightMetric(cpuUtilizationMaximumMetric);
        cpuUtilizationMaximum.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'Maximum CPUUtilization (expected)',
            color: '#666666',
            usingMetrics: {
                m1: cpuUtilizationMaximumMetric,
            },
        }));
        let networkInMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'NetworkIn',
            dimensions: {
                AutoScalingGroupName: name,
            },
            statistic: 'Average',
        });
        let networkIn = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        networkIn.addRightMetric(networkInMetric);
        networkIn.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'NetworkIn (expected)',
            color: '#666666',
            usingMetrics: {
                m1: networkInMetric,
            },
        }));
        let networkOutMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'NetworkOut',
            dimensions: {
                AutoScalingGroupName: name,
            },
            statistic: 'Average',
        });
        let networkOut = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        networkOut.addRightMetric(networkOutMetric);
        networkOut.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'NetworkOut (expected)',
            color: '#666666',
            usingMetrics: {
                m1: networkOutMetric,
            },
        }));
        return [header, GroupInServiceInstances, cpuUtilizationAverage, cpuUtilizationMaximum, networkIn, networkOut];
    }
}
exports.AutoScaling = AutoScaling;
//# sourceMappingURL=data:application/json;base64,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