import { AutoScalingGroup, CfnAutoScalingGroup } from '@aws-cdk/aws-autoscaling';
import { DashboardProps } from '@aws-cdk/aws-cloudwatch';
import { CfnReplicationGroup } from '@aws-cdk/aws-elasticache';
import { BaseLoadBalancer, CfnLoadBalancer } from '@aws-cdk/aws-elasticloadbalancingv2';
import { CfnDBCluster } from '@aws-cdk/aws-rds';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface HalloumiDashboard extends DashboardProps {
    /**
     * List of LoadBalancers.
     *
     * If set, must only contain a list of LoadBalancer
     *
     * @default - None
     * @stability stable
     */
    readonly loadBalancer?: (BaseLoadBalancer | CfnLoadBalancer)[];
    /**
     * List of AutoScaling.
     *
     * If set, must only contain a list of AutoScaling
     *
     * @default - None
     * @stability stable
     */
    readonly autoScaling?: (AutoScalingGroup | CfnAutoScalingGroup)[];
    /**
     * List of RDS.
     *
     * If set, must only contain a list of RDS
     *
     * @default - None
     * @stability stable
     */
    readonly rds?: (CfnDBCluster)[];
    /**
     * List of Elasticache.
     *
     * If set, must only contain a list of Elasticache
     *
     * @default - None
     * @stability stable
     */
    readonly elasticache?: (CfnReplicationGroup)[];
}
/**
 * An AWS CloudWatch Dashboard.
 *
 * @stability stable
 * @example
 *
 * // create a dashboard for AutoScaling
 * new Dashboard(this, 'dashboard', {
 *    autoScalingName: 'my-auto-scaling',
 *    autoScalingMaxCapacity: 10
 * });
 */
export declare class Dashboard extends Construct {
    /**
     * Creates a Dashboard based on the Halloumi best practices.
     *
     * @param scope the scope into which to import this dashboard.
     * @param id the logical ID of the returned dashboard construct.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: HalloumiDashboard);
}
