"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
class LoadBalancer {
    static metrics(name, full_name) {
        let header = new aws_cloudwatch_1.TextWidget({
            width: 24,
            height: 1,
            markdown: `# ${name} - Application Load Balancer`,
        });
        let requestCountMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/ApplicationELB',
            metricName: 'RequestCount',
            dimensions: {
                LoadBalancer: full_name,
            },
            period: core_1.Duration.seconds(300),
            statistic: 'Sum',
        });
        let responseTimeMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/ApplicationELB',
            metricName: 'TargetResponseTime',
            dimensions: {
                LoadBalancer: full_name,
            },
            period: core_1.Duration.seconds(300),
        });
        let requestCount = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        requestCount.addRightMetric(requestCountMetric);
        requestCount.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'RequestCount (expected)',
            period: core_1.Duration.seconds(300),
            color: '#666666',
            usingMetrics: {
                m1: requestCountMetric,
            },
        }));
        let responseTime = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        responseTime.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'TargetResponseTime (expected)',
            period: core_1.Duration.seconds(300),
            color: '#666666',
            usingMetrics: {
                m1: responseTimeMetric,
            },
        }));
        responseTime.addRightMetric(responseTimeMetric);
        return [header, requestCount, responseTime];
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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