"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redis = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
class Redis {
    static metrics(name) {
        let header = new aws_cloudwatch_1.TextWidget({
            width: 24,
            height: 1,
            markdown: `# ${name} - Redis`,
        });
        let metrics = [
            'CPUUtilization',
            'FreeableMemory',
            'SwapUsage',
            'NetworkBytesIn',
            'NetworkBytesOut',
            'CurrConnections',
            'Evictions',
            'Reclaimed',
            'CacheHits',
            'CacheMisses',
            'ReplicationBytes',
            'ReplicationLag',
            'BytesUsedForCache',
        ];
        let graph = Array();
        graph.push(header);
        metrics.forEach(metric => {
            graph.push(Redis.metricGraph(metric, name));
        });
        return graph;
    }
    static metricGraph(metric, name) {
        let cloudwatchMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/ElastiCache',
            metricName: metric,
            dimensions: {
                CacheClusterId: name,
            },
        });
        let graphWidget = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        graphWidget.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: `${metric} (expected)`,
            color: '#666666',
            usingMetrics: {
                m1: cloudwatchMetric,
            },
        }));
        graphWidget.addRightMetric(cloudwatchMetric);
        return graphWidget;
    }
}
exports.Redis = Redis;
//# sourceMappingURL=data:application/json;base64,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