<p align="center">
<img src="logo.png" alt="Logo"><br>
</p>

<div align="center">
<a href="https://www.python.org/downloads/release/python-370/"><img src="https://img.shields.io/badge/python-3.7-blue" alt="Python"></a>
<a href="https://zenodo.org/badge/latestdoi/304602979"><img src="https://zenodo.org/badge/304602979.svg" alt="DOI"></a>
<a href="https://pypi.org/project/yupi/"><img src="https://img.shields.io/pypi/v/yupi" alt="PyPI"></a>
<a href="https://yupi.readthedocs.io/en/latest/"><img src="https://img.shields.io/readthedocs/yupi" alt="ReadTheDocs"></a>
</div>

Standing for *Yet Underused Path Instruments*, **yupi** is a set of tools designed
for collecting, generating and processing trajectory data.

## **Main features**

- **Convert raw data to trajectories** ... *different input manners*
- **I/O operations with trajectories** ... *json and csv serializers*
- **Trajectory extraction from video inputs** ... *even with moving camera*
- **Artificial trajectory generation** ... *several models implemented*
- **Trajectory basic operations** ... *rotation, shift, scaling, ...*
- **Trajectory transformations** ... *filters, resamplers, ...*
- **Statistical analysis rom trajectories ensembles** ... *turning angles histogram, velocity autocorrelation function, power spectral density, and much more ...*
- **Results visualization** ... *each statistical observable has a related plot function*
- **Spacial projection of trajectories** ... *for 2D and 3D trajectories*

## Installation

Current recommended installation method is via PyPI:

```cmd
pip install yupi
```

## Compatibility

- Python 3.7 or later
- Ubuntu 18.04 or later
- Windows 7 or later
- macOS 10.12.6 (Sierra) or later.

## Getting Started

In the [official documentation](https://yupi.readthedocs.io/en/latest/) there
are some resources to start using the library: Tutorials, Examples  and a
detailed description of the API.

## Examples

Code examples (with additional multimedia resources) can be found in
[this repository](https://github.com/yupidevs/yupi_examples). Additionally, in
the [Examples section](https://yupi.readthedocs.io/en/latest/examples/examples.html)
of the documentation, you can find the same examples with additional comments
and expected execution results in order to inspect the examples without actually
executing them.
