"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.dynamodb.create_table
hub.exec.boto3.client.dynamodb.delete_table
hub.exec.boto3.client.dynamodb.describe_table
hub.exec.boto3.client.dynamodb.list_tables
hub.exec.boto3.client.dynamodb.update_table
resource = hub.tool.boto3.resource.create(ctx, "dynamodb", "Table", name)
hub.tool.boto3.resource.exec(resource, delete, *args, **kwargs)
hub.tool.boto3.resource.exec(resource, delete_item, *args, **kwargs)
hub.tool.boto3.resource.exec(resource, get_item, *args, **kwargs)
hub.tool.boto3.resource.exec(resource, put_item, *args, **kwargs)
hub.tool.boto3.resource.exec(resource, query, *args, **kwargs)
hub.tool.boto3.resource.exec(resource, scan, *args, **kwargs)
hub.tool.boto3.resource.exec(resource, update, *args, **kwargs)
hub.tool.boto3.resource.exec(resource, update_item, *args, **kwargs)
"""
from collections import OrderedDict
from typing import Any
from typing import Dict
from typing import List


async def present(
    hub,
    ctx,
    name: str,
    attribute_definitions: List,
    key_schema: List,
    billing_mode: str = None,
    sse_specification: dict = None,
    stream_specification: dict = None,
    provisioned_throughput: dict = None,
    local_secondary_indexes: List = None,
    global_secondary_indexes: List = None,
    replica_updates: List = None,
    tags: List = None,
    table_class: str = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    The CreateTable operation adds a new table to your account. In an Amazon Web Services account, table names must
    be unique within each Region. That is, you can have two tables with same name if you create the tables in
    different Regions.  CreateTable is an asynchronous operation. Upon receiving a CreateTable request, DynamoDB
    immediately returns a response with a TableStatus of CREATING. After the table is created, DynamoDB sets the
    TableStatus to ACTIVE. You can perform read and write operations only on an ACTIVE table.  You can optionally
    define secondary indexes on the new table, as part of the CreateTable operation. If you want to create multiple
    tables with secondary indexes on them, you must create the tables sequentially. Only one table with secondary
    indexes can be in the CREATING state at any given time. You can use the DescribeTable action to check the table
    status.

    Args:
        replica_updates: A list of replica update actions (create, delete, or update) for the table.
        table_class(Text, optional): The table class of the new table. Valid values are STANDARD and
                STANDARD_INFREQUENT_ACCESS.
        billing_mode(Text, optional): Controls how users are charged for read and write throughput and how they manage
            capacity.
                PROVISIONED - AWS recommends using PROVISIONED for predictable workloads. PROVISIONED sets the billing
                            mode to Provisioned Mode.
                PAY_PER_REQUEST - AWS recommends using PAY_PER_REQUEST for unpredictable workloads. PAY_PER_REQUEST
                            sets the billing mode to On-Demand Mode .
        global_secondary_indexes(list, optional): One or more global secondary indexes (the maximum is 20) to be created
                on the table.
                Each global secondary index in the array includes the following:
                    IndexName - The name of the global secondary index. Must be unique only for this table.
                    KeySchema - Specifies the key schema for the global secondary index.
                    Projection - Specifies attributes that are copied (projected) from the table into the index. Each
                        attribute specification is composed of:
                            ProjectionType - One of the following:
                                    KEYS_ONLY - Only the index and primary keys are projected into the index.
                                    INCLUDE - Only the specified table attributes are projected into the index.
                                    ALL - All the table attributes are projected into the index.
                            NonKeyAttributes - A list of one or more non-key attribute names that are projected into the
                                secondary index.
                ProvisionedThroughput - The provisioned throughput settings for the global secondary index, consisting
                        of read and write capacity units.
        local_secondary_indexes(list, optional): One or more local secondary indexes (the maximum is 5) to be created on
                the table. Each index is scoped to a given partition key value.

                Each local secondary index in the array includes the following:
                    IndexName - The name of the local secondary index. Must be unique only for this table.
                    KeySchema - Specifies the key schema for the local secondary index. The key schema must begin with
                        the same partition key as the table.
                    Projection - Specifies attributes that are copied (projected) from the table into the index. Each
                        attribute specification is composed of:
                            ProjectionType - One of the following:
                                KEYS_ONLY - Only the index and primary keys are projected into the index.
                                INCLUDE - Only the specified table attributes are projected into the index. The list of
                                    projected attributes is in NonKeyAttributes.
                                ALL - All the table attributes are projected into the index.
                            NonKeyAttributes - A list of one or more non-key attribute names that are projected into
                                the secondary index.
        provisioned_throughput(dict, optional): Represents the provisioned throughput settings for a specified table or
            index. If user sets BillingMode as PROVISIONED, you must specify this property. If user sets BillingMode as
            PAY_PER_REQUEST, you cannot specify this property.
        stream_specification(dict, optional): The settings for DynamoDB Streams on the table. These settings consist of:
            StreamEnabled - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
            StreamViewType - When an item in the table is modified, StreamViewType determines what information is
                written to the table's stream. Valid values for StreamViewType are:
                    KEYS_ONLY - Only the key attributes of the modified item are written to the stream.
                    NEW_IMAGE - The entire item, as it appears after it was modified, is written to the stream.
                    OLD_IMAGE - The entire item, as it appeared before it was modified, is written to the stream.
                    NEW_AND_OLD_IMAGES - Both the new and the old item images of the item are written to the stream.
        sse_specification(dict, optional): Represents the settings used to enable server-side encryption.
        tags(List, optional): The tags to assign to the route_table. Defaults to None.
            * Key (string) -- The key of the tag. Tag keys are case-sensitive and accept a maximum of 127 Unicode
                    characters. May not begin with aws: .
            * Value (string) -- The value of the tag. Tag values are case-sensitive and accept a maximum of 255 Unicode
                characters.
        key_schema(list): Specifies the attributes that make up the primary key for a table or an index. The attributes
            in KeySchema must also be defined in the AttributeDefinitions array.

            Each KeySchemaElement in the array is composed of:
                AttributeName - The name of this key attribute.
                KeyType - The role that the key attribute will assume:
                    HASH - partition key
                    RANGE - sort key
        attribute_definitions(List): An array of attributes that describe the key schema for the table and indexes.
        name(Text): The name of the table to create.

    Request Syntax:
        [dynamodb_table-id]:
          aws.dynamodb.table.present:
          - name: 'string'
          - attribute_definitions: 'list'
          - key_schema: 'list'
          - billing_mode: 'string'
          - sse_specification: 'dict'
          - stream_specification: 'dict'
          - provisioned_throughput: 'dict'
          - local_secondary_indexes: 'list'
          - global_secondary_indexes: 'list'
          - tags:
            - Key: 'string'
              Value: 'string'
          - table_class: 'str'

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            dyanmodb_table-1e8965drf2c56902g:
              aws.dynamodb.table.present:
                - name: dyanmodb_table-1e8965drf2c56902g
                - attribute_definitions: [
                            {"AttributeName": "Artist", "AttributeType": "S", },
                            { "AttributeName": "SongTitle", "AttributeType": "S",},
                        ]
                - key_schema = [
                            { "AttributeName": "Artist", "KeyType": "HASH", },
                            { "AttributeName": "SongTitle", "KeyType": "RANGE", },
                        ]
                - provisioned_throughput = { "ReadCapacityUnits": 123, "WriteCapacityUnits": 123, }
                - tags:
                  - Key: Name
                    Value: test-nat-gateway
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    created_table_id = name
    update_table = False
    update_tags = False
    existing_tags = None
    before = await hub.exec.boto3.client.dynamodb.describe_table(ctx, TableName=name)

    if before and before["result"] and before["ret"].get("Table"):
        table_resource = before["ret"].get("Table")
        update_ret = await hub.exec.boto3.client.dynamodb.update_table(
            ctx=ctx,
            AttributeDefinitions=attribute_definitions,
            TableName=name,
            BillingMode=billing_mode,
            ProvisionedThroughput=provisioned_throughput,
            GlobalSecondaryIndexes=global_secondary_indexes,
            SSESpecification=sse_specification,
            StreamSpecification=stream_specification,
            ReplicaUpdates=replica_updates,
            TableClass=table_class,
        )
        result["result"] = update_ret["result"]
        if not update_ret["result"]:
            result["comment"] = update_ret["comment"]
            result["result"] = False
            return result

        await hub.tool.boto3.client.wait(
            ctx, "dynamodb", "table_exists", TableName=name
        )
        update_comment = f"Updated aws.dynamodb.table {name}."
        update_tags_comment = ""
        update_table = True
        if result["result"]:
            # get existing tags
            old_tags = await hub.exec.boto3.client.dynamodb.list_tags_of_resource(
                ctx, ResourceArn=table_resource.get("TableArn")
            )
            if old_tags.get("result") and old_tags.get("ret"):
                existing_tags = old_tags.get("ret").get("Tags")
            if tags is not None:
                # Update tags
                update_tags_result = await hub.exec.aws.dynamodb.table_tag.update_tags(
                    ctx=ctx,
                    resource_arn=table_resource.get("TableArn"),
                    old_tags=existing_tags,
                    new_tags=tags,
                )
                update_tags = update_tags_result["result"]
                update_tags_comment = update_tags_result["comment"]
                if not update_tags_result["result"]:
                    result["result"] = False
            else:
                update_tags = False
        result[
            "comment"
        ] = f"{name} is already present. {update_comment}. {update_tags_comment}"
    else:
        try:
            ret = await hub.exec.boto3.client.dynamodb.create_table(
                ctx,
                AttributeDefinitions=attribute_definitions,
                KeySchema=key_schema,
                TableName=name,
                BillingMode=billing_mode,
                GlobalSecondaryIndexes=global_secondary_indexes,
                LocalSecondaryIndexes=local_secondary_indexes,
                ProvisionedThroughput=provisioned_throughput,
                SSESpecification=sse_specification,
                StreamSpecification=stream_specification,
                Tags=tags if tags is not None else None,
                TableClass=table_class,
            )
            result["result"] = ret["result"]
            if not ret["result"]:
                result["comment"] = ret["comment"]
                return result

            await hub.tool.boto3.client.wait(
                ctx, "dynamodb", "table_exists", TableName=name
            )
            update_tags = True
            created_table_id = ret["ret"]["TableDescription"]["TableName"]
            ret["comment"] = f"Created aws.dynamodb.table '{created_table_id}'"
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
            result["result"] = False

    after = None

    if update_table or created_table_id is not None:
        after = await hub.exec.boto3.client.dynamodb.describe_table(
            ctx, TableName=created_table_id
        )
    if before["result"] and before["ret"].get("Table"):
        before["ret"].get("Table")["Tags"] = existing_tags
        result["old_state"] = before["ret"].get("Table")
    if after["result"] and after["ret"].get("Table"):
        if not update_tags:
            after["ret"].get("Table")["Tags"] = existing_tags
        else:
            new_tags = await hub.exec.boto3.client.dynamodb.list_tags_of_resource(
                ctx, ResourceArn=after["ret"].get("Table").get("TableArn")
            )
            if new_tags.get("result") and new_tags.get("ret"):
                after["ret"].get("Table")["Tags"] = new_tags.get("ret").get("Tags")
        result["new_state"] = after["ret"].get("Table")
    return result


async def absent(hub, ctx, name: str) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    The DeleteTable operation deletes a table and all of its items. After a DeleteTable request, the specified table
    is in the DELETING state until DynamoDB completes the deletion. If the table is in the ACTIVE state, you can
    delete it. If a table is in CREATING or UPDATING states, then DynamoDB returns a ResourceInUseException. If the
    specified table does not exist, DynamoDB returns a ResourceNotFoundException. If table is already in the
    DELETING state, no error is returned.   DynamoDB might continue to accept data read and write operations, such
    as GetItem and PutItem, on a table in the DELETING state until the table deletion is complete.  When you delete
    a table, any indexes on that table are also deleted. If you have DynamoDB Streams enabled on the table, then the
    corresponding stream on that table goes into the DISABLED state, and the stream is automatically deleted after
    24 hours. Use the DescribeTable action to check the status of the table.

    Args:
        name(Text): A name, ID, or JMES search path to identify the resource.

    Request Syntax:
        [dynamodb_table-id]:
          aws.dynamodb.table.absent:
          - name: 'string'

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            dyanmodb_table-1e8965drf2c56902g:
              aws.dynamodb.table.present:
                - name: dyanmodb_table-1e8965drf2c56902g
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    before = await hub.exec.boto3.client.dynamodb.describe_table(ctx, TableName=name)
    if before["result"] and before["ret"].get("Table"):
        result["old_state"] = before["ret"].get("Table")

    if not before:
        result["comment"] = f"'{name}' already absent"
    elif ctx.get("test", False):
        result["comment"] = f"Would delete aws.dynamodb.table {name}"
        return result
    else:
        try:
            ret = await hub.exec.boto3.client.dynamodb.delete_table(ctx, TableName=name)
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                result["result"] = False
                return result
            f"Deleted aws.dynamodb.table '{name}'"
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Returns an array of table names associated with the current account and endpoint. The output from ListTables is
    paginated, with each page returning a maximum of 100 table names.


    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: bash

            $ idem describe aws.dynamodb.table
    """

    global new_table_resource, table_name
    result = {}

    ret = await hub.exec.boto3.client.dynamodb.list_tables(ctx)
    if not ret["result"]:
        hub.log.debug(f"Could not describe table {ret['comment']}")
        return result
    describe_parameters = OrderedDict(
        {
            "AttributeDefinitions": "attribute_definitions",
            "KeySchema": "key_schema",
            "TableName": "table_name",
            "StreamSpecification": "stream_specification",
            "TableArn": "table_arn",
        }
    )
    if ret and ret["ret"] and ret["ret"].get("TableNames"):
        for table_name in ret["ret"].get("TableNames"):
            resource = await hub.exec.boto3.client.dynamodb.describe_table(
                ctx, TableName=table_name
            )
            new_table_resource = []

            if (
                resource.get("result")
                and resource.get("ret") is not None
                and resource.get("ret").get("Table")
            ):
                table_resource = resource.get("ret").get("Table")
            else:
                continue
            for parameter_old_key, parameter_new_key in describe_parameters.items():
                if table_resource.get(parameter_old_key) is not None:
                    new_table_resource.append(
                        {parameter_new_key: table_resource.get(parameter_old_key)}
                    )
            if table_resource.get("BillingModeSummary"):
                new_table_resource.append(
                    {
                        "billing_mode": table_resource.get("BillingModeSummary").get(
                            "BillingMode"
                        )
                    }
                )
            if table_resource.get("TableClassSummary"):
                new_table_resource.append(
                    {
                        "table_class": table_resource.get("TableClassSummary").get(
                            "TableClass"
                        )
                    }
                )
            if table_resource.get("LocalSecondaryIndexes"):
                local_secondary_indexes = []
                for local_index in table_resource.get("LocalSecondaryIndexes"):
                    new_local_index = {
                        "IndexName": local_index["IndexName"],
                        "KeySchema": local_index["KeySchema"],
                        "Projection": local_index["Projection"],
                    }
                    local_secondary_indexes.append(new_local_index)
                new_table_resource.append(
                    {"local_secondary_indexes": local_secondary_indexes}
                )

            if table_resource.get("GlobalSecondaryIndexes"):
                global_secondary_indexes = []
                for global_index in table_resource.get("GlobalSecondaryIndexes"):
                    new_global_index = {
                        "IndexName": global_index["IndexName"],
                        "KeySchema": global_index["KeySchema"],
                        "Projection": global_index["Projection"],
                    }
                    if global_index.get("ProvisionedThroughput"):
                        provisioned_throughput = global_index.get(
                            "ProvisionedThroughput"
                        )
                        new_provisioned = {
                            "ReadCapacityUnits": provisioned_throughput[
                                "ReadCapacityUnits"
                            ],
                            "WriteCapacityUnits": provisioned_throughput[
                                "WriteCapacityUnits"
                            ],
                        }
                        new_global_index["ProvisionedThroughput"] = new_provisioned
                    global_secondary_indexes.append(new_global_index)
                new_table_resource.append(
                    {"global_secondary_indexes": global_secondary_indexes}
                )

            if table_resource.get("ProvisionedThroughput"):
                provisioned_throughput = table_resource.get("ProvisionedThroughput")
                new_provisioned = {
                    "ReadCapacityUnits": provisioned_throughput["ReadCapacityUnits"],
                    "WriteCapacityUnits": provisioned_throughput["WriteCapacityUnits"],
                }
                new_table_resource.append({"provisioned_throughput": new_provisioned})

            if table_resource.get("SSEDescription"):
                sse_specification = table_resource.get("SSEDescription")
                new_sse_specification = {
                    "KMSMasterKeyArn": sse_specification["KMSMasterKeyArn"],
                    "SSEType": sse_specification["SSEType"],
                }
                if (
                    sse_specification.get("Status") == "ENABLED"
                    or sse_specification.get("Status") == "ENABLING"
                ):
                    new_sse_specification["Enabled"] = True
                else:
                    new_sse_specification["Enabled"] = False
                new_table_resource.append({"sse_specification": new_sse_specification})
            tags = await hub.exec.boto3.client.dynamodb.list_tags_of_resource(
                ctx, ResourceArn=table_resource.get("TableArn")
            )
            if tags and tags.get("result") and tags.get("ret"):
                new_table_resource.append({"tags": tags.get("ret").get("Tags")})
            result[table_name] = {"aws.dynamodb.table.present": new_table_resource}
    return result
