"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.ec2.associate_dhcp_options
hub.exec.boto3.client.ec2.create_dhcp_options
hub.exec.boto3.client.ec2.delete_dhcp_options
hub.exec.boto3.client.ec2.describe_dhcp_options
"""
import copy
from typing import Any
from typing import Dict
from typing import List
from typing import OrderedDict

__contracts__ = ["resource"]


async def present(
    hub,
    ctx,
    name: str,
    dhcp_configurations: List,
    tags: List = None,
    vpc_id: str = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing
    all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the
    individual DHCP options you can specify. For more information about the options, see RFC 2132.    domain-name-
    servers - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The default DHCP option set
    specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the IP addresses in a
    single parameter, separated by commas. To have your instance receive a custom DNS hostname as specified in
    domain-name, you must set domain-name-servers to a custom DNS server.    domain-name - If you're using
    AmazonProvidedDNS in us-east-1, specify ec2.internal. If you're using AmazonProvidedDNS in another Region,
    specify region.compute.internal (for example, ap-northeast-1.compute.internal). Otherwise, specify a domain name
    (for example, ExampleCompany.com). This value is used to complete unqualified DNS hostnames. Important: Some
    Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux
    operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP options
    set is associated with a VPC that has instances with multiple operating systems, specify only one domain name.
    ntp-servers - The IP addresses of up to four Network Time Protocol (NTP) servers.    netbios-name-servers - The
    IP addresses of up to four NetBIOS name servers.    netbios-node-type - The NetBIOS node type (1, 2, 4, or 8).
    We recommend that you specify 2 (broadcast and multicast are not currently supported). For more information
    about these node types, see RFC 2132.   Your VPC automatically starts out with a set of DHCP options that
    includes only a DNS server that we provide (AmazonProvidedDNS). If you create a set of options, and if your VPC
    has an internet gateway, make sure to set the domain-name-servers option either to AmazonProvidedDNS or to a
    domain name server of your choice. For more information, see DHCP options sets in the Amazon Virtual Private
    Cloud User Guide.

    Args:
        name(Text): A name, ID to identify the resource.
        dhcp_configurations (List): A DHCP configuration option.
            * Key (string) : The name of a DHCP option. Options are domain-name-servers|domain-name|ntp-servers|netbios-name-servers|netbios-node-type
            * Values (List) : One or more values for the DHCP option.
                * Value (string): The attribute value. The value is case-sensitive.
        tags(List, optional): The tags to assign to the subnet. Defaults to None.
            * Key (string) --  The key of the tag. Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with aws: .
            * Value (string) -- The value of the tag. Tag values are case-sensitive and accept a maximum of 255 Unicode characters.
        vpc_id (Text, optional): The ID of the VPC.

    Request Syntax:
        [dhcp_option-id]:
          aws.ec2.dhcp_option.present:
          - dhcp_configurations:
              - Key: 'string'
                Values: List
                    - Value: 'string'
          - vpc_id: 'string'
          - tags:
              - Key: 'string'
                Value: 'string'

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            dop-adhkjghjghjg:
              aws.ec2.dhcp_option.present:
                - dhcp_configurations:
                    - Key: domain-name-servers
                      Values:
                            - Value : 10.2.5.1
                            - Value : 10.2.5.2
                - vpc_id: vpc-76db75b8
                - tags:
                    - Key: test_name
                      Value: test-dhcp
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    update_new_state = True
    before = await hub.exec.boto3.client.ec2.describe_dhcp_options(
        ctx, DhcpOptionsIds=[name]
    )
    if ctx.get("test", False):
        if before:
            result["comment"] = f"Would update aws.ec2.dhcp_option {name}"
            result["result"] = True
        else:
            result["comment"] = f"Would create aws.ec2.dhcp_option {name}"
            result["result"] = True
        return result

    try:
        if before["result"]:
            result["old_state"] = before["ret"]["DhcpOptions"][0]
            update_new_state = False
            result["comment"] = f"'{name}' already exists"
            if vpc_id is not None:
                vpc_ret = await hub.exec.boto3.client.ec2.describe_vpcs(
                    ctx, VpcIds=[vpc_id]
                )
                if (
                    vpc_ret["result"]
                    and vpc_ret["ret"]["Vpcs"][0]["DhcpOptionsId"] != name
                ):
                    ret_associate = (
                        await hub.exec.boto3.client.ec2.associate_dhcp_options(
                            ctx,
                            DhcpOptionsId=name,
                            VpcId=vpc_id,
                        )
                    )
                    if ret_associate["result"]:
                        result["comment"] = f"'{name}' attached to vpc '{vpc_id}'"
                    else:
                        result["result"] = False
            # check if tags need to be updated
            if tags is not None:
                update_ret = await hub.exec.aws.ec2.tag.update_tags(
                    ctx=ctx,
                    resource_id=before["ret"]["DhcpOptions"][0]["DhcpOptionsId"],
                    old_tags=before["ret"]["DhcpOptions"][0]["Tags"],
                    new_tags=tags,
                )
                result["comment"] = f"'{name}' already present. Updating tags"
                if not update_ret["result"]:
                    result["comment"] = update_ret["comment"]
                    result["result"] = False
        else:
            dhcp_config_values_list = []
            dhcp_config = []
            for dhcp in dhcp_configurations[0].get("Values"):
                if "Value" in dhcp:
                    dhcp_config_values_list.append(dhcp.get("Value"))
            dhcp_config.append(
                {
                    "Key": dhcp_configurations[0].get("Key"),
                    "Values": dhcp_config_values_list,
                }
            )
            ret = await hub.exec.boto3.client.ec2.create_dhcp_options(
                ctx,
                DhcpConfigurations=dhcp_config,
                TagSpecifications=[{"ResourceType": "dhcp-options", "Tags": tags}]
                if tags is not None
                else None,
            )
            result["comment"] = f"Created '{name}'"
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result
            if result["result"] and vpc_id is not None:
                ret_associate = await hub.exec.boto3.client.ec2.associate_dhcp_options(
                    ctx,
                    DhcpOptionsId=ret["ret"]["DhcpOptions"]["DhcpOptionsId"],
                    VpcId=vpc_id,
                )
                result[
                    "comment"
                ] = f"Created '{name}' and also associated with vpc '{vpc_id}'"
                result["result"] = ret_associate["result"]
                if not result["result"]:
                    result["comment"] = ret_associate["comment"]
                    return result
    except hub.tool.boto3.exception.ClientError as e:
        result["result"] = False
        result["comment"] = f"{e.__class__.__name__}: {e}"
    try:
        if update_new_state:
            after = await hub.exec.boto3.client.ec2.describe_dhcp_options(
                ctx, DhcpOptionsIds=[ret["ret"]["DhcpOptions"]["DhcpOptionsId"]]
            )
            result["new_state"] = after["ret"]["DhcpOptions"][0]
        else:
            result["new_state"] = copy.deepcopy(result["old_state"])
    except Exception as e:
        result["comment"] = str(e)
        result["result"] = False
    return result


async def absent(hub, ctx, name: str) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
    it. You can disassociate the set of DHCP options by associating either a new set of options or the default set
    of options with the VPC.

    Args:
        name(Text): A name, ID to identify the resource.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            resource_is_absent:
              aws.ec2.dhcp_option.absent:
                - name: value
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)

    before = await hub.exec.boto3.client.ec2.describe_dhcp_options(
        ctx, DhcpOptionsIds=[name]
    )
    if not before["result"]:
        result["comment"] = f"'{name}' already absent"
    elif ctx.get("test", False):
        result["comment"] = f"Would delete aws.ec2.dhcp_option {name}"
        return result
    else:
        result["old_state"] = before["ret"]["DhcpOptions"][0]
        try:
            ret = await hub.exec.boto3.client.ec2.delete_dhcp_options(
                ctx, DhcpOptionsId=name
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result
            result["comment"] = f"Deleted '{name}'"
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
            result["result"] = False
    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Describes one or more of your DHCP options sets. For more information, see DHCP options sets in the Amazon
    Virtual Private Cloud User Guide.


    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: bash

            $ idem describe aws.ec2.dhcp_option
    """

    result = {}
    ret = await hub.exec.boto3.client.ec2.describe_dhcp_options(ctx)

    if not ret["result"]:
        hub.log.debug(f"Could not describe dhcp_options {ret['comment']}")
        return result

    describe_parameters = OrderedDict(
        {
            "DhcpConfigurations": "dhcp_configurations",
            "Tags": "tags",
        }
    )

    for dhcp_option in ret["ret"]["DhcpOptions"]:
        # Including fields to match the 'present' function parameters
        dhcp_options_id = dhcp_option.get("DhcpOptionsId")
        resource_translated = []

        for parameter_old_key, parameter_new_key in describe_parameters.items():
            if dhcp_option.get(parameter_old_key) is not None:
                resource_translated.append(
                    {parameter_new_key: dhcp_option.get(parameter_old_key)}
                )

        result[dhcp_options_id] = {"aws.ec2.dhcp_option.present": resource_translated}

    return result
