"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
hub.exec.boto3.client.ec2.create_flow_logs
hub.exec.boto3.client.ec2.delete_flow_logs
hub.exec.boto3.client.ec2.describe_flow_logs
"""
from collections import OrderedDict
from typing import Any
from typing import Dict
from typing import List

__contracts__ = ["resource"]
TREQ = {
    "present": {
        "require": ["aws.ec2.vpc.present"],
        "require": ["aws.ec2.subnet.present"],
    },
}


async def present(
    hub,
    ctx,
    name: str,
    resource_type: str,
    traffic_type: str,
    log_format: str,
    max_aggregation_interval: int,
    log_destination: str = None,
    log_destination_type: str = None,
    log_group_name: str = None,
    iam_role: str = None,
    destination_options: Dict = None,
    resource_ids: List = None,
    tags: Dict[str, str] = None,
) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Creates a flow log to capture information about IP traffic for a specific network interface, subnet,
    or VPC.  Flow log data for a monitored network interface is recorded as flow log records, which are log events
    consisting of fields that describe the traffic flow. For more information, see Flow log records in the Amazon
    Virtual Private Cloud User Guide. When publishing to CloudWatch Logs, flow log records are published to a log
    group, and each network interface has a unique log stream in the log group. When publishing to Amazon S3, flow
    log records for all of the monitored network interfaces are published to a single log file object that is stored
    in the specified bucket. For more information, see VPC Flow Logs in the Amazon Virtual Private Cloud User Guide.
    Args:
        hub:
        ctx:
        name(str): A name, ID, or JMES search path to identify the resource.
        log_group_name(str, Optional): log_group_name if the log_destination_type is cloudwatch
        resource_type(str): Type of resource flow-log is attached to (Subnet, VPC, NetworkInterface)
        traffic_type(str): Type of traffic to be recorded (REJECT, ALL, ACCEPT)
        log_destination_type(str, Optional): S3 bucket or Default: cloud-watch-logs
        log_destination(str, Optional): S3 bucket ARN
        log_format(str): Syntax to be used to print log statements
        max_aggregation_interval(int): Max interval during which packets are aggregated and then stored in log record
        iam_role(str, Optional): ARN of IAM role to be used to post in cloud-watch-logs
        destination_options(Dict, Optional): The destination options.
                a) FileFormat(str) : The format for the flow log. The default is plain-text.
                b) HiveCompatiblePartitions (bool) : Indicates whether to use Hive-compatible prefixes for flow logs
                    stored in Amazon S3. The default is false .
                c) PerHourPartition (bool) : Indicates whether to partition the flow log per hour. This reduces the cost
                    and response time for queries. The default is false .
        resource_ids([str]): list of resource_ids flow-log is attached to
        tags(Dict, Optional): List of Name, Value pair to tag flow-logs

    Request Syntax:
        [flow-log-id]:
          aws.ec2.flow_log.present:
          - name: 'string'
          - log_group_name: 'string'
          - resource_type: 'integer'
          - traffic_type: 'string'
          - tags:
            - Key: 'string'
              Value: 'string'

    Returns:
        Dict[str, Any]

    Examples:
        .. code-block:: sls
            fl-09c0787e693332a0a:
                aws.ec2.flow_log.present:
                - traffic_type: REJECT
                - log_destination_type: s3
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    created_flow_log_id = name
    before = await hub.exec.boto3.client.ec2.describe_flow_logs(
        ctx, **{"FlowLogIds": [name]}
    )
    after = None
    if before["result"] and before["ret"].get("FlowLogs"):
        old_tags = before["ret"].get("FlowLogs")[0].get("Tags")
        if tags is not None:
            if tags == old_tags:
                result["comment"] = "Nothing to update"
                result["old_state"] = before["ret"]["FlowLogs"][0]
                result["new_state"] = result["old_state"]
                result["result"] = True
                return result
            result["comment"] = f"'{name}' already exists. Updating tags"
            update_ret = await hub.exec.aws.ec2.tag.update_tags(
                ctx,
                resource_id=name,
                old_tags=old_tags,
                new_tags=tags,
            )
            if not update_ret["result"]:
                result["comment"] = update_ret["comment"]
                result["result"] = False
            after = await hub.exec.boto3.client.ec2.describe_flow_logs(
                ctx, FlowLogIds=[created_flow_log_id]
            )
    else:
        try:
            ret = await hub.exec.boto3.client.ec2.create_flow_logs(
                ctx,
                DeliverLogsPermissionArn=iam_role,
                TagSpecifications=[{"ResourceType": "vpc-flow-log", "Tags": tags}]
                if tags is not None
                else None,
                DestinationOptions=destination_options,
                LogDestination=log_destination,
                LogDestinationType=log_destination_type,
                LogFormat=log_format,
                LogGroupName=log_group_name,
                MaxAggregationInterval=max_aggregation_interval,
                ResourceIds=resource_ids,
                ResourceType=resource_type,
                TrafficType=traffic_type,
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result
            result["comment"] = f"Created '{name}'"
            created_flow_log_id = ret["ret"]["FlowLogIds"][0]
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
        after = await hub.exec.boto3.client.ec2.describe_flow_logs(
            ctx, FlowLogIds=[created_flow_log_id]
        )
    if before["result"] and before["ret"].get("FlowLogs"):
        result["old_state"] = before["ret"]["FlowLogs"][0]
    if after and after["result"] and after["ret"].get("FlowLogs"):
        result["new_state"] = after["ret"]["FlowLogs"][0]
    return result


async def absent(hub, ctx, name: str) -> Dict[str, Any]:
    r"""
    **Autogenerated function**

    Deletes one or more flow logs.
    Args:
        hub:
        ctx:
        name(Text): A name, ID, or JMES search path to identify the resource.
    Returns:
        Dict[str, Any]
    Examples:
        .. code-block:: sls
            resource_is_absent:
              aws_auto.ec2.flow_log.absent:
                - name: value
    """

    result = dict(comment="", old_state=None, new_state=None, name=name, result=True)
    flow_log_id_list = [name]
    before = await hub.exec.boto3.client.ec2.describe_flow_logs(
        ctx, FlowLogIds=flow_log_id_list
    )

    if not before:
        result["comment"] = f"'{name}' already absent"
        return result
    else:
        try:
            ret = await hub.exec.boto3.client.ec2.delete_flow_logs(
                ctx, FlowLogIds=flow_log_id_list
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = f"'{name}' is already in deleted state."
                return result
            result["comment"] = f"Deleted '{name}'"
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = f"{e.__class__.__name__}: {e}"
        after = await hub.exec.boto3.client.ec2.describe_flow_logs(
            ctx, FlowLogIds=flow_log_id_list
        )
    if before["result"] and before["ret"].get("FlowLogs"):
        result["old_state"] = before["ret"]["FlowLogs"][0]
    if after and after["result"]:
        result["new_state"] = after["ret"]["FlowLogs"]
    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r"""
    **Autogenerated function**
    Describe the resource in a way that can be recreated/managed with the corresponding "present" function

    Describes one or more flow logs. To view the information in your flow logs (the log streams for the network
    interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs API.
    Returns:
        Dict[str, Any]
    Examples:
        .. code-block:: bash
            $ idem describe aws_auto.ec2.flow_log
    """

    result = {}
    ret = await hub.exec.boto3.client.ec2.describe_flow_logs(ctx)
    if not ret["result"]:
        hub.log.debug(f"Could not describe flow_log {ret['comment']}")
        return result
    for flow_log in ret["ret"]["FlowLogs"]:
        flow_log_id = flow_log.get("FlowLogId")
        describe_parameters = OrderedDict(
            {
                "DeliverLogsPermissionArn": "iam_role",
                "LogGroupName": "log_group_name",
                "TrafficType": "traffic_type",
                "LogDestinationType": "log_destination_type",
                "LogDestination": "log_destination",
                "LogFormat": "log_format",
                "MaxAggregationInterval": "max_aggregation_interval",
                "Tags": "tags",
            }
        )
        resource_translated = []
        for parameter_old_key, parameter_new_key in describe_parameters.items():
            if flow_log.get(parameter_old_key) is not None:
                resource_translated.append(
                    {parameter_new_key: flow_log.get(parameter_old_key)}
                )
        resource_id = flow_log.get("ResourceId")
        resource_ids = [resource_id]
        resource_type = resource_id.split("-")[0]
        resource_translated.append({"resource_ids": resource_ids})
        if resource_type == "vpc":
            resource_type = "VPC"
        elif resource_type == "subnet":
            resource_type = "Subnet"
        else:
            resource_type = "NetworkInterface"
        resource_translated.append({"resource_type": resource_type})
        resource_translated.append({"flow_log_id": flow_log_id})
        result[flow_log_id] = {"aws.ec2.flow_log.present": resource_translated}
    return result
