# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AzurePrivatelinkArgs', 'AzurePrivatelink']

@pulumi.input_type
class AzurePrivatelinkArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 user_subscription_ids: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a AzurePrivatelink resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_subscription_ids: A List of allowed Subscription IDs Maximum Length: `16`.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "user_subscription_ids", user_subscription_ids)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="userSubscriptionIds")
    def user_subscription_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A List of allowed Subscription IDs Maximum Length: `16`.
        """
        return pulumi.get(self, "user_subscription_ids")

    @user_subscription_ids.setter
    def user_subscription_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "user_subscription_ids", value)


@pulumi.input_type
class _AzurePrivatelinkState:
    def __init__(__self__, *,
                 azure_service_alias: Optional[pulumi.Input[str]] = None,
                 azure_service_id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 user_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AzurePrivatelink resources.
        :param pulumi.Input[str] azure_service_alias: Azure Privatelink service alias
        :param pulumi.Input[str] azure_service_id: Azure Privatelink service ID
        :param pulumi.Input[str] message: Printable result of the Azure Privatelink request
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: Privatelink resource state
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_subscription_ids: A List of allowed Subscription IDs Maximum Length: `16`.
        """
        if azure_service_alias is not None:
            pulumi.set(__self__, "azure_service_alias", azure_service_alias)
        if azure_service_id is not None:
            pulumi.set(__self__, "azure_service_id", azure_service_id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if user_subscription_ids is not None:
            pulumi.set(__self__, "user_subscription_ids", user_subscription_ids)

    @property
    @pulumi.getter(name="azureServiceAlias")
    def azure_service_alias(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Privatelink service alias
        """
        return pulumi.get(self, "azure_service_alias")

    @azure_service_alias.setter
    def azure_service_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_service_alias", value)

    @property
    @pulumi.getter(name="azureServiceId")
    def azure_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Privatelink service ID
        """
        return pulumi.get(self, "azure_service_id")

    @azure_service_id.setter
    def azure_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_service_id", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Printable result of the Azure Privatelink request
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Privatelink resource state
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="userSubscriptionIds")
    def user_subscription_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A List of allowed Subscription IDs Maximum Length: `16`.
        """
        return pulumi.get(self, "user_subscription_ids")

    @user_subscription_ids.setter
    def user_subscription_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_subscription_ids", value)


class AzurePrivatelink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 user_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The Azure Privatelink resource allows the creation and management of Aiven Azure Privatelink for a services.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.AzurePrivatelink("foo",
            project=data["aiven_project"]["foo"]["project"],
            service_name=aiven_kafka["bar"]["service_name"],
            user_subscription_ids=["xxxxxx-xxxx-xxxx-xxxx-xxxxxxxx"])
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/azurePrivatelink:AzurePrivatelink foo project/service_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_subscription_ids: A List of allowed Subscription IDs Maximum Length: `16`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzurePrivatelinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Azure Privatelink resource allows the creation and management of Aiven Azure Privatelink for a services.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.AzurePrivatelink("foo",
            project=data["aiven_project"]["foo"]["project"],
            service_name=aiven_kafka["bar"]["service_name"],
            user_subscription_ids=["xxxxxx-xxxx-xxxx-xxxx-xxxxxxxx"])
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/azurePrivatelink:AzurePrivatelink foo project/service_name
        ```

        :param str resource_name: The name of the resource.
        :param AzurePrivatelinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzurePrivatelinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 user_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzurePrivatelinkArgs.__new__(AzurePrivatelinkArgs)

            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if user_subscription_ids is None and not opts.urn:
                raise TypeError("Missing required property 'user_subscription_ids'")
            __props__.__dict__["user_subscription_ids"] = user_subscription_ids
            __props__.__dict__["azure_service_alias"] = None
            __props__.__dict__["azure_service_id"] = None
            __props__.__dict__["message"] = None
            __props__.__dict__["state"] = None
        super(AzurePrivatelink, __self__).__init__(
            'aiven:index/azurePrivatelink:AzurePrivatelink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_service_alias: Optional[pulumi.Input[str]] = None,
            azure_service_id: Optional[pulumi.Input[str]] = None,
            message: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            user_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AzurePrivatelink':
        """
        Get an existing AzurePrivatelink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_service_alias: Azure Privatelink service alias
        :param pulumi.Input[str] azure_service_id: Azure Privatelink service ID
        :param pulumi.Input[str] message: Printable result of the Azure Privatelink request
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: Privatelink resource state
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_subscription_ids: A List of allowed Subscription IDs Maximum Length: `16`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzurePrivatelinkState.__new__(_AzurePrivatelinkState)

        __props__.__dict__["azure_service_alias"] = azure_service_alias
        __props__.__dict__["azure_service_id"] = azure_service_id
        __props__.__dict__["message"] = message
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        __props__.__dict__["user_subscription_ids"] = user_subscription_ids
        return AzurePrivatelink(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureServiceAlias")
    def azure_service_alias(self) -> pulumi.Output[str]:
        """
        Azure Privatelink service alias
        """
        return pulumi.get(self, "azure_service_alias")

    @property
    @pulumi.getter(name="azureServiceId")
    def azure_service_id(self) -> pulumi.Output[str]:
        """
        Azure Privatelink service ID
        """
        return pulumi.get(self, "azure_service_id")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[str]:
        """
        Printable result of the Azure Privatelink request
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Privatelink resource state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="userSubscriptionIds")
    def user_subscription_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A List of allowed Subscription IDs Maximum Length: `16`.
        """
        return pulumi.get(self, "user_subscription_ids")

