# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClickhouseGrantArgs', 'ClickhouseGrant']

@pulumi.input_type
class ClickhouseGrantArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 privilege_grants: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_grants: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ClickhouseGrant resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]] privilege_grants: Configuration to grant a privilege. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] role: The role to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]] role_grants: Configuration to grant a role. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] user: The user to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if privilege_grants is not None:
            pulumi.set(__self__, "privilege_grants", privilege_grants)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if role_grants is not None:
            pulumi.set(__self__, "role_grants", role_grants)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="privilegeGrants")
    def privilege_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]]]:
        """
        Configuration to grant a privilege. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "privilege_grants")

    @privilege_grants.setter
    def privilege_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]]]):
        pulumi.set(self, "privilege_grants", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="roleGrants")
    def role_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]]]:
        """
        Configuration to grant a role. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "role_grants")

    @role_grants.setter
    def role_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]]]):
        pulumi.set(self, "role_grants", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        The user to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _ClickhouseGrantState:
    def __init__(__self__, *,
                 privilege_grants: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_grants: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ClickhouseGrant resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]] privilege_grants: Configuration to grant a privilege. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] role: The role to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]] role_grants: Configuration to grant a role. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] user: The user to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        if privilege_grants is not None:
            pulumi.set(__self__, "privilege_grants", privilege_grants)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if role_grants is not None:
            pulumi.set(__self__, "role_grants", role_grants)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="privilegeGrants")
    def privilege_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]]]:
        """
        Configuration to grant a privilege. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "privilege_grants")

    @privilege_grants.setter
    def privilege_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantPrivilegeGrantArgs']]]]):
        pulumi.set(self, "privilege_grants", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="roleGrants")
    def role_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]]]:
        """
        Configuration to grant a role. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "role_grants")

    @role_grants.setter
    def role_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClickhouseGrantRoleGrantArgs']]]]):
        pulumi.set(self, "role_grants", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        The user to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


class ClickhouseGrant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 privilege_grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantPrivilegeGrantArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantRoleGrantArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Clickhouse Grant resource allows the creation and management of Grants in Aiven Clickhouse services.

        Notes:
        * Due to a ambiguity in the GRANT syntax in clickhouse you should not have users and roles with the same name. It is not clear if a grant refers to the user or the role.
        * Currently changes will first revoke all grants and then reissue the remaining grants for convergence.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        clickhouse = aiven.Clickhouse("clickhouse",
            project=var["aiven_project_name"],
            cloud_name="google-europe-west1",
            plan="startup-8",
            service_name="exapmle-clickhouse")
        demodb = aiven.ClickhouseDatabase("demodb",
            project=clickhouse.project,
            service_name=clickhouse.service_name)
        demo_clickhouse_role = aiven.ClickhouseRole("demoClickhouseRole",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            role="demo-role")
        demo_role_grant = aiven.ClickhouseGrant("demo-role-grant",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            role=demo_clickhouse_role.role,
            privilege_grants=[
                aiven.ClickhouseGrantPrivilegeGrantArgs(
                    privilege="INSERT",
                    database=demodb.name,
                    table="*",
                ),
                aiven.ClickhouseGrantPrivilegeGrantArgs(
                    privilege="SELECT",
                    database=demodb.name,
                    table="*",
                ),
            ])
        demo_clickhouse_user = aiven.ClickhouseUser("demoClickhouseUser",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            username="demo-user")
        demo_user_grant = aiven.ClickhouseGrant("demo-user-grant",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            user=demo_clickhouse_user.username,
            role_grants=[aiven.ClickhouseGrantRoleGrantArgs(
                role=demo_clickhouse_role.role,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantPrivilegeGrantArgs']]]] privilege_grants: Configuration to grant a privilege. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] role: The role to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantRoleGrantArgs']]]] role_grants: Configuration to grant a role. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] user: The user to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClickhouseGrantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Clickhouse Grant resource allows the creation and management of Grants in Aiven Clickhouse services.

        Notes:
        * Due to a ambiguity in the GRANT syntax in clickhouse you should not have users and roles with the same name. It is not clear if a grant refers to the user or the role.
        * Currently changes will first revoke all grants and then reissue the remaining grants for convergence.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        clickhouse = aiven.Clickhouse("clickhouse",
            project=var["aiven_project_name"],
            cloud_name="google-europe-west1",
            plan="startup-8",
            service_name="exapmle-clickhouse")
        demodb = aiven.ClickhouseDatabase("demodb",
            project=clickhouse.project,
            service_name=clickhouse.service_name)
        demo_clickhouse_role = aiven.ClickhouseRole("demoClickhouseRole",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            role="demo-role")
        demo_role_grant = aiven.ClickhouseGrant("demo-role-grant",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            role=demo_clickhouse_role.role,
            privilege_grants=[
                aiven.ClickhouseGrantPrivilegeGrantArgs(
                    privilege="INSERT",
                    database=demodb.name,
                    table="*",
                ),
                aiven.ClickhouseGrantPrivilegeGrantArgs(
                    privilege="SELECT",
                    database=demodb.name,
                    table="*",
                ),
            ])
        demo_clickhouse_user = aiven.ClickhouseUser("demoClickhouseUser",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            username="demo-user")
        demo_user_grant = aiven.ClickhouseGrant("demo-user-grant",
            project=clickhouse.project,
            service_name=clickhouse.service_name,
            user=demo_clickhouse_user.username,
            role_grants=[aiven.ClickhouseGrantRoleGrantArgs(
                role=demo_clickhouse_role.role,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param ClickhouseGrantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClickhouseGrantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 privilege_grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantPrivilegeGrantArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantRoleGrantArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClickhouseGrantArgs.__new__(ClickhouseGrantArgs)

            __props__.__dict__["privilege_grants"] = privilege_grants
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["role"] = role
            __props__.__dict__["role_grants"] = role_grants
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["user"] = user
        super(ClickhouseGrant, __self__).__init__(
            'aiven:index/clickhouseGrant:ClickhouseGrant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            privilege_grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantPrivilegeGrantArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            role_grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantRoleGrantArgs']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            user: Optional[pulumi.Input[str]] = None) -> 'ClickhouseGrant':
        """
        Get an existing ClickhouseGrant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantPrivilegeGrantArgs']]]] privilege_grants: Configuration to grant a privilege. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] role: The role to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClickhouseGrantRoleGrantArgs']]]] role_grants: Configuration to grant a role. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] user: The user to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClickhouseGrantState.__new__(_ClickhouseGrantState)

        __props__.__dict__["privilege_grants"] = privilege_grants
        __props__.__dict__["project"] = project
        __props__.__dict__["role"] = role
        __props__.__dict__["role_grants"] = role_grants
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["user"] = user
        return ClickhouseGrant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="privilegeGrants")
    def privilege_grants(self) -> pulumi.Output[Optional[Sequence['outputs.ClickhouseGrantPrivilegeGrant']]]:
        """
        Configuration to grant a privilege. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "privilege_grants")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        The role to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="roleGrants")
    def role_grants(self) -> pulumi.Output[Optional[Sequence['outputs.ClickhouseGrantRoleGrant']]]:
        """
        Configuration to grant a role. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "role_grants")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[str]]:
        """
        The user to grant privileges or roles to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "user")

