# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceIntegrationEndpointArgs', 'ServiceIntegrationEndpoint']

@pulumi.input_type
class ServiceIntegrationEndpointArgs:
    def __init__(__self__, *,
                 endpoint_name: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 project: pulumi.Input[str],
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] = None,
                 external_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] = None,
                 jolokia_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']] = None,
                 prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']] = None,
                 rsyslog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']] = None,
                 signalfx_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs']] = None):
        """
        The set of arguments for constructing a ServiceIntegrationEndpoint resource.
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint
        :param pulumi.Input[str] endpoint_type: Type of the service integration endpoint
        :param pulumi.Input[str] project: Project the service integration endpoint belongs to
        :param pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs'] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs'] external_aws_cloudwatch_logs_user_config: external AWS CloudWatch Logs specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs'] external_aws_cloudwatch_metrics_user_config: External AWS cloudwatch mertrics specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs'] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs'] external_google_cloud_logging_user_config: external Google Cloud Logginig specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs'] external_kafka_user_config: external Kafka specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs'] external_schema_registry_user_config: External schema registry specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs'] jolokia_user_config: Jolokia specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs'] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs'] rsyslog_user_config: rsyslog specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs'] signalfx_user_config: Signalfx specific user configurable settings
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "project", project)
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if external_aws_cloudwatch_logs_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_logs_user_config", external_aws_cloudwatch_logs_user_config)
        if external_aws_cloudwatch_metrics_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_config", external_aws_cloudwatch_metrics_user_config)
        if external_elasticsearch_logs_user_config is not None:
            pulumi.set(__self__, "external_elasticsearch_logs_user_config", external_elasticsearch_logs_user_config)
        if external_google_cloud_logging_user_config is not None:
            pulumi.set(__self__, "external_google_cloud_logging_user_config", external_google_cloud_logging_user_config)
        if external_kafka_user_config is not None:
            pulumi.set(__self__, "external_kafka_user_config", external_kafka_user_config)
        if external_schema_registry_user_config is not None:
            pulumi.set(__self__, "external_schema_registry_user_config", external_schema_registry_user_config)
        if jolokia_user_config is not None:
            pulumi.set(__self__, "jolokia_user_config", jolokia_user_config)
        if prometheus_user_config is not None:
            pulumi.set(__self__, "prometheus_user_config", prometheus_user_config)
        if rsyslog_user_config is not None:
            pulumi.set(__self__, "rsyslog_user_config", rsyslog_user_config)
        if signalfx_user_config is not None:
            pulumi.set(__self__, "signalfx_user_config", signalfx_user_config)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[str]:
        """
        Name of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Project the service integration endpoint belongs to
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]:
        """
        Datadog specific user configurable settings
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]:
        """
        external AWS CloudWatch Logs specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @external_aws_cloudwatch_logs_user_config.setter
    def external_aws_cloudwatch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]:
        """
        External AWS cloudwatch mertrics specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @external_aws_cloudwatch_metrics_user_config.setter
    def external_aws_cloudwatch_metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_metrics_user_config", value)

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]:
        """
        external elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @external_elasticsearch_logs_user_config.setter
    def external_elasticsearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_elasticsearch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfig")
    def external_google_cloud_logging_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]:
        """
        external Google Cloud Logginig specific user configurable settings
        """
        return pulumi.get(self, "external_google_cloud_logging_user_config")

    @external_google_cloud_logging_user_config.setter
    def external_google_cloud_logging_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]):
        pulumi.set(self, "external_google_cloud_logging_user_config", value)

    @property
    @pulumi.getter(name="externalKafkaUserConfig")
    def external_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]:
        """
        external Kafka specific user configurable settings
        """
        return pulumi.get(self, "external_kafka_user_config")

    @external_kafka_user_config.setter
    def external_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]):
        pulumi.set(self, "external_kafka_user_config", value)

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfig")
    def external_schema_registry_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]:
        """
        External schema registry specific user configurable settings
        """
        return pulumi.get(self, "external_schema_registry_user_config")

    @external_schema_registry_user_config.setter
    def external_schema_registry_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]):
        pulumi.set(self, "external_schema_registry_user_config", value)

    @property
    @pulumi.getter(name="jolokiaUserConfig")
    def jolokia_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]:
        """
        Jolokia specific user configurable settings
        """
        return pulumi.get(self, "jolokia_user_config")

    @jolokia_user_config.setter
    def jolokia_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]):
        pulumi.set(self, "jolokia_user_config", value)

    @property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]:
        """
        Prometheus specific user configurable settings
        """
        return pulumi.get(self, "prometheus_user_config")

    @prometheus_user_config.setter
    def prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]):
        pulumi.set(self, "prometheus_user_config", value)

    @property
    @pulumi.getter(name="rsyslogUserConfig")
    def rsyslog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]:
        """
        rsyslog specific user configurable settings
        """
        return pulumi.get(self, "rsyslog_user_config")

    @rsyslog_user_config.setter
    def rsyslog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]):
        pulumi.set(self, "rsyslog_user_config", value)

    @property
    @pulumi.getter(name="signalfxUserConfig")
    def signalfx_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs']]:
        """
        Signalfx specific user configurable settings
        """
        return pulumi.get(self, "signalfx_user_config")

    @signalfx_user_config.setter
    def signalfx_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs']]):
        pulumi.set(self, "signalfx_user_config", value)


@pulumi.input_type
class _ServiceIntegrationEndpointState:
    def __init__(__self__, *,
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']] = None,
                 endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] = None,
                 external_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] = None,
                 jolokia_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']] = None,
                 rsyslog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']] = None,
                 signalfx_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ServiceIntegrationEndpoint resources.
        :param pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs'] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoint_config: Integration endpoint specific backend configuration
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint
        :param pulumi.Input[str] endpoint_type: Type of the service integration endpoint
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs'] external_aws_cloudwatch_logs_user_config: external AWS CloudWatch Logs specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs'] external_aws_cloudwatch_metrics_user_config: External AWS cloudwatch mertrics specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs'] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs'] external_google_cloud_logging_user_config: external Google Cloud Logginig specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs'] external_kafka_user_config: external Kafka specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs'] external_schema_registry_user_config: External schema registry specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs'] jolokia_user_config: Jolokia specific user configurable settings
        :param pulumi.Input[str] project: Project the service integration endpoint belongs to
        :param pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs'] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs'] rsyslog_user_config: rsyslog specific user configurable settings
        :param pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs'] signalfx_user_config: Signalfx specific user configurable settings
        """
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if external_aws_cloudwatch_logs_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_logs_user_config", external_aws_cloudwatch_logs_user_config)
        if external_aws_cloudwatch_metrics_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_config", external_aws_cloudwatch_metrics_user_config)
        if external_elasticsearch_logs_user_config is not None:
            pulumi.set(__self__, "external_elasticsearch_logs_user_config", external_elasticsearch_logs_user_config)
        if external_google_cloud_logging_user_config is not None:
            pulumi.set(__self__, "external_google_cloud_logging_user_config", external_google_cloud_logging_user_config)
        if external_kafka_user_config is not None:
            pulumi.set(__self__, "external_kafka_user_config", external_kafka_user_config)
        if external_schema_registry_user_config is not None:
            pulumi.set(__self__, "external_schema_registry_user_config", external_schema_registry_user_config)
        if jolokia_user_config is not None:
            pulumi.set(__self__, "jolokia_user_config", jolokia_user_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if prometheus_user_config is not None:
            pulumi.set(__self__, "prometheus_user_config", prometheus_user_config)
        if rsyslog_user_config is not None:
            pulumi.set(__self__, "rsyslog_user_config", rsyslog_user_config)
        if signalfx_user_config is not None:
            pulumi.set(__self__, "signalfx_user_config", signalfx_user_config)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]:
        """
        Datadog specific user configurable settings
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Integration endpoint specific backend configuration
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]:
        """
        external AWS CloudWatch Logs specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @external_aws_cloudwatch_logs_user_config.setter
    def external_aws_cloudwatch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]:
        """
        External AWS cloudwatch mertrics specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @external_aws_cloudwatch_metrics_user_config.setter
    def external_aws_cloudwatch_metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_metrics_user_config", value)

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]:
        """
        external elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @external_elasticsearch_logs_user_config.setter
    def external_elasticsearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_elasticsearch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfig")
    def external_google_cloud_logging_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]:
        """
        external Google Cloud Logginig specific user configurable settings
        """
        return pulumi.get(self, "external_google_cloud_logging_user_config")

    @external_google_cloud_logging_user_config.setter
    def external_google_cloud_logging_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]):
        pulumi.set(self, "external_google_cloud_logging_user_config", value)

    @property
    @pulumi.getter(name="externalKafkaUserConfig")
    def external_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]:
        """
        external Kafka specific user configurable settings
        """
        return pulumi.get(self, "external_kafka_user_config")

    @external_kafka_user_config.setter
    def external_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]):
        pulumi.set(self, "external_kafka_user_config", value)

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfig")
    def external_schema_registry_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]:
        """
        External schema registry specific user configurable settings
        """
        return pulumi.get(self, "external_schema_registry_user_config")

    @external_schema_registry_user_config.setter
    def external_schema_registry_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]):
        pulumi.set(self, "external_schema_registry_user_config", value)

    @property
    @pulumi.getter(name="jolokiaUserConfig")
    def jolokia_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]:
        """
        Jolokia specific user configurable settings
        """
        return pulumi.get(self, "jolokia_user_config")

    @jolokia_user_config.setter
    def jolokia_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]):
        pulumi.set(self, "jolokia_user_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project the service integration endpoint belongs to
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]:
        """
        Prometheus specific user configurable settings
        """
        return pulumi.get(self, "prometheus_user_config")

    @prometheus_user_config.setter
    def prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]):
        pulumi.set(self, "prometheus_user_config", value)

    @property
    @pulumi.getter(name="rsyslogUserConfig")
    def rsyslog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]:
        """
        rsyslog specific user configurable settings
        """
        return pulumi.get(self, "rsyslog_user_config")

    @rsyslog_user_config.setter
    def rsyslog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]):
        pulumi.set(self, "rsyslog_user_config", value)

    @property
    @pulumi.getter(name="signalfxUserConfig")
    def signalfx_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs']]:
        """
        Signalfx specific user configurable settings
        """
        return pulumi.get(self, "signalfx_user_config")

    @signalfx_user_config.setter
    def signalfx_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointSignalfxUserConfigArgs']]):
        pulumi.set(self, "signalfx_user_config", value)


class ServiceIntegrationEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]] = None,
                 external_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]] = None,
                 jolokia_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheus_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']]] = None,
                 rsyslog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']]] = None,
                 signalfx_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']]] = None,
                 __props__=None):
        """
        The Service Integration Endpoint resource allows the creation and management of Aiven Service Integration Endpoints.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint
        :param pulumi.Input[str] endpoint_type: Type of the service integration endpoint
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] external_aws_cloudwatch_logs_user_config: external AWS CloudWatch Logs specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']] external_aws_cloudwatch_metrics_user_config: External AWS cloudwatch mertrics specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] external_google_cloud_logging_user_config: external Google Cloud Logginig specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] external_kafka_user_config: external Kafka specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] external_schema_registry_user_config: External schema registry specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']] jolokia_user_config: Jolokia specific user configurable settings
        :param pulumi.Input[str] project: Project the service integration endpoint belongs to
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']] rsyslog_user_config: rsyslog specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']] signalfx_user_config: Signalfx specific user configurable settings
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceIntegrationEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Service Integration Endpoint resource allows the creation and management of Aiven Service Integration Endpoints.

        :param str resource_name: The name of the resource.
        :param ServiceIntegrationEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceIntegrationEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]] = None,
                 external_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]] = None,
                 jolokia_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheus_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']]] = None,
                 rsyslog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']]] = None,
                 signalfx_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceIntegrationEndpointArgs.__new__(ServiceIntegrationEndpointArgs)

            __props__.__dict__["datadog_user_config"] = datadog_user_config
            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__.__dict__["endpoint_name"] = endpoint_name
            if endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["external_aws_cloudwatch_logs_user_config"] = external_aws_cloudwatch_logs_user_config
            __props__.__dict__["external_aws_cloudwatch_metrics_user_config"] = external_aws_cloudwatch_metrics_user_config
            __props__.__dict__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
            __props__.__dict__["external_google_cloud_logging_user_config"] = external_google_cloud_logging_user_config
            __props__.__dict__["external_kafka_user_config"] = external_kafka_user_config
            __props__.__dict__["external_schema_registry_user_config"] = external_schema_registry_user_config
            __props__.__dict__["jolokia_user_config"] = jolokia_user_config
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["prometheus_user_config"] = prometheus_user_config
            __props__.__dict__["rsyslog_user_config"] = rsyslog_user_config
            __props__.__dict__["signalfx_user_config"] = signalfx_user_config
            __props__.__dict__["endpoint_config"] = None
        super(ServiceIntegrationEndpoint, __self__).__init__(
            'aiven:index/serviceIntegrationEndpoint:ServiceIntegrationEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']]] = None,
            endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            endpoint_name: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]] = None,
            external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]] = None,
            external_elasticsearch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]] = None,
            external_google_cloud_logging_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]] = None,
            external_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]] = None,
            external_schema_registry_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]] = None,
            jolokia_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            prometheus_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']]] = None,
            rsyslog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']]] = None,
            signalfx_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']]] = None) -> 'ServiceIntegrationEndpoint':
        """
        Get an existing ServiceIntegrationEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoint_config: Integration endpoint specific backend configuration
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint
        :param pulumi.Input[str] endpoint_type: Type of the service integration endpoint
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] external_aws_cloudwatch_logs_user_config: external AWS CloudWatch Logs specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']] external_aws_cloudwatch_metrics_user_config: External AWS cloudwatch mertrics specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] external_google_cloud_logging_user_config: external Google Cloud Logginig specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] external_kafka_user_config: external Kafka specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] external_schema_registry_user_config: External schema registry specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']] jolokia_user_config: Jolokia specific user configurable settings
        :param pulumi.Input[str] project: Project the service integration endpoint belongs to
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']] rsyslog_user_config: rsyslog specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']] signalfx_user_config: Signalfx specific user configurable settings
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceIntegrationEndpointState.__new__(_ServiceIntegrationEndpointState)

        __props__.__dict__["datadog_user_config"] = datadog_user_config
        __props__.__dict__["endpoint_config"] = endpoint_config
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["external_aws_cloudwatch_logs_user_config"] = external_aws_cloudwatch_logs_user_config
        __props__.__dict__["external_aws_cloudwatch_metrics_user_config"] = external_aws_cloudwatch_metrics_user_config
        __props__.__dict__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
        __props__.__dict__["external_google_cloud_logging_user_config"] = external_google_cloud_logging_user_config
        __props__.__dict__["external_kafka_user_config"] = external_kafka_user_config
        __props__.__dict__["external_schema_registry_user_config"] = external_schema_registry_user_config
        __props__.__dict__["jolokia_user_config"] = jolokia_user_config
        __props__.__dict__["project"] = project
        __props__.__dict__["prometheus_user_config"] = prometheus_user_config
        __props__.__dict__["rsyslog_user_config"] = rsyslog_user_config
        __props__.__dict__["signalfx_user_config"] = signalfx_user_config
        return ServiceIntegrationEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointDatadogUserConfig']]:
        """
        Datadog specific user configurable settings
        """
        return pulumi.get(self, "datadog_user_config")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Integration endpoint specific backend configuration
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[str]:
        """
        Name of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        Type of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig']]:
        """
        external AWS CloudWatch Logs specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig']]:
        """
        External AWS cloudwatch mertrics specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig']]:
        """
        external elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfig")
    def external_google_cloud_logging_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig']]:
        """
        external Google Cloud Logginig specific user configurable settings
        """
        return pulumi.get(self, "external_google_cloud_logging_user_config")

    @property
    @pulumi.getter(name="externalKafkaUserConfig")
    def external_kafka_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalKafkaUserConfig']]:
        """
        external Kafka specific user configurable settings
        """
        return pulumi.get(self, "external_kafka_user_config")

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfig")
    def external_schema_registry_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalSchemaRegistryUserConfig']]:
        """
        External schema registry specific user configurable settings
        """
        return pulumi.get(self, "external_schema_registry_user_config")

    @property
    @pulumi.getter(name="jolokiaUserConfig")
    def jolokia_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointJolokiaUserConfig']]:
        """
        Jolokia specific user configurable settings
        """
        return pulumi.get(self, "jolokia_user_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project the service integration endpoint belongs to
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointPrometheusUserConfig']]:
        """
        Prometheus specific user configurable settings
        """
        return pulumi.get(self, "prometheus_user_config")

    @property
    @pulumi.getter(name="rsyslogUserConfig")
    def rsyslog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointRsyslogUserConfig']]:
        """
        rsyslog specific user configurable settings
        """
        return pulumi.get(self, "rsyslog_user_config")

    @property
    @pulumi.getter(name="signalfxUserConfig")
    def signalfx_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointSignalfxUserConfig']]:
        """
        Signalfx specific user configurable settings
        """
        return pulumi.get(self, "signalfx_user_config")

