#!/bin/bash
#
# Companion script to run_cascade.sh
# provides an overview of the error statistics based on the logfiles
# generated by run_cascade.sh and an overview of the global processing
#

images=`ls $CASCADE_DATA_PATH/data/HST/WFC3/*/SPECTRAL_IMAGES | grep fits | wc -l`
downloaded=`ls -d $CASCADE_DATA_PATH/data/HST/WFC3/*/SPECTRAL_IMAGES | wc -l`
sources=`ls $CASCADE_DATA_PATH/data/HST/WFC3 | awk -F_ '{print $1}' | sort | uniq | wc -l`
spectra=`ls $CASCADE_DATA_PATH/data/HST/WFC3/*/SPECTRA | grep fits | grep COE | wc -l`
extract=`ls -d $CASCADE_DATA_PATH/data/HST/WFC3/*/SPECTRA | wc -l`
started=`ls $CASCADE_DATA_PATH/results/*/*_load_data_step_figure1a.png |wc -l`
reduced=`ls $CASCADE_DATA_PATH/results/*/extract_spectrum_aperture_extracted_data.png|wc -l`
planets=`ls $CASCADE_DATA_PATH/results/*/*_corrected_exoplanet_spectra.fits | wc -l`

clear

errors[0]="MaskError: data size is"
errors[1]="TypeError: buffer is too small for requested array"
errors[2]="TypeError: cannot unpack non-iterable NoneType object"
errors[3]="TypeError: list indices must be integers or slices, not str"
errors[4]="TypeError: 'NoneType' object is not subscriptable"
errors[5]="TypeError: object of type 'NoneType' has no len"
errors[6]="TypeError: only size-1 arrays can be converted to Python scalars"

errors[7]="ValueError: operands could not be broadcast together with shapes"
errors[8]="ValueError: A value in x_new is above the interpolation range"
errors[9]="ValueError: A value in x_new is below the interpolation range"
errors[10]="ValueError: setting an array element with a sequence"
errors[11]="ValueError: Wavelength not defined for each data point"
errors[12]="ValueError: array must not contain infs or NaNs"
errors[13]="out of bounds for axis"

errors[14]="IndexError: list index out of range"

errors[15]="ZeroDivisionError: float division by zero"
errors[16]="ZeroDivisionError: integer division or modulo by zero"
errors[17]="RuntimeError: This function was not imported properly"
errors[18]="RayletError"
errors[19]="redis.exceptions.ConnectionError"
errors[20]="SyntaxError: invalid syntax"
errors[21]="has no attribute"
errors[22]="got an unexpected keyword argument "
errors[23]="Error: No extracted spectra for"
errors[24]="AssertionError: No Timeseries data found in dir"
errors[25]="ini does not excist. Aborting initialization"
#errors[]=""

runs="extract transit background"
for run in $runs; do
    case $run in
     "extract" )
               logfiles="$CASCADE_LOG_PATH/run_cascade/extract_*"
               ;;
     "transit" )
               logfiles="$CASCADE_LOG_PATH/run_cascade/transit_*"
               ;;
     "background" )
               logfiles="$CASCADE_LOG_PATH/run_cascade/background_*"
               ;;
    esac
    eval_str="grep Error \$logfiles"
    nerr=`eval $eval_str | awk -F: '{print $1}' | sort | uniq | wc -l`
    echo "$run: $nerr observations with errors"
    for error in "${errors[@]}"; do
        eval_str="grep \"$error\" \$logfiles"
        nerr=`eval $eval_str | wc -l`
        if [ $nerr -gt 0 ]; then
            echo "$nerr $error" 
            awkstr="$run_"
            case $run in
             "extract" )
                        obj=`eval $eval_str | awk -F'_2020' '{print $1}' | awk -F'extract_' '{print $2}' | uniq`
                       ;;
             "transit" )
                        obj=`eval $eval_str | awk -F'_2020' '{print $1}' | awk -F'transit_' '{print $2}' | uniq`
                       ;;
             "background" )
                        obj=`eval $eval_str | awk -F'_2020' '{print $1}' | awk -F'background_' '{print $2}' | uniq`
                       ;;
            esac
            echo $obj
        fi
    done
    echo ""
done

screen -ls
echo "Locked observations"
ls -l $CASCADE_DATA_PATH/locked
echo ""
echo "$downloaded OBSERVATIONS downloaded with $images IMAGES for $sources SOURCES"
echo "$started observations partly REDUCED"
echo "$spectra SPECTRA EXTRACTED for $extract OBSSERVATIONS"
echo "$planets PLANET SPECTRA extracted"
echo ""
