"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const path = require("path");
const lib_1 = require("../../lib");
const authorizers_1 = require("../../lib/authorizers");
const identity_source_1 = require("../../lib/authorizers/identity-source");
// Against the RestApi endpoint from the stack output, run
// `curl -s -o /dev/null -w "%{http_code}" <url>` should return 401
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' <url>?allow=yes` should return 403
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' <url>?allow=yes` should return 200
const app = new core_1.App();
const stack = new core_1.Stack(app, 'RequestAuthorizerInteg');
const authorizerFn = new lambda.Function(stack, 'MyAuthorizerFunction', {
    runtime: lambda.Runtime.NODEJS_10_X,
    handler: 'index.handler',
    code: lambda.AssetCode.fromAsset(path.join(__dirname, 'integ.request-authorizer.handler')),
});
const restapi = new lib_1.RestApi(stack, 'MyRestApi');
const authorizer = new authorizers_1.RequestAuthorizer(stack, 'MyAuthorizer', {
    handler: authorizerFn,
    identitySources: [identity_source_1.IdentitySource.header('Authorization'), identity_source_1.IdentitySource.queryString('allow')],
});
restapi.root.addMethod('ANY', new lib_1.MockIntegration({
    integrationResponses: [
        { statusCode: '200' },
    ],
    passthroughBehavior: lib_1.PassthroughBehavior.NEVER,
    requestTemplates: {
        'application/json': '{ "statusCode": 200 }',
    },
}), {
    methodResponses: [
        { statusCode: '200' },
    ],
    authorizer,
});
//# sourceMappingURL=data:application/json;base64,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