from typing import Any

from pony.converting import str2timedelta as str2timedelta
from pony.converting import timedelta2str as timedelta2str
from pony.orm import core as core
from pony.orm import dbapiprovider as dbapiprovider
from pony.orm import dbschema as dbschema
from pony.orm import ormtypes as ormtypes
from pony.orm import sqltranslation as sqltranslation
from pony.orm.core import log_orm as log_orm
from pony.orm.dbapiprovider import DBAPIProvider as DBAPIProvider
from pony.orm.dbapiprovider import Pool as Pool
from pony.orm.dbapiprovider import get_version_tuple as get_version_tuple
from pony.orm.dbapiprovider import wrap_dbapi_exceptions as wrap_dbapi_exceptions
from pony.orm.sqlbuilding import Param as Param
from pony.orm.sqlbuilding import SQLBuilder as SQLBuilder
from pony.orm.sqlbuilding import Value as Value
from pony.orm.sqlbuilding import join as join
from pony.orm.sqltranslation import SQLTranslator as SQLTranslator
from pony.orm.sqltranslation import TranslationError as TranslationError
from pony.py23compat import buffer as buffer
from pony.py23compat import int_types as int_types
from pony.utils import throw as throw

NoneType: Any
mysql_module_name: str

class MySQLColumn(dbschema.Column):
    auto_template: str

class MySQLSchema(dbschema.DBSchema):
    dialect: str
    inline_fk_syntax: bool
    column_class: Any

class MySQLTranslator(SQLTranslator):
    dialect: str
    json_path_wildcard_syntax: bool

class MySQLValue(Value): ...

class MySQLBuilder(SQLBuilder):
    dialect: str
    value_class: Any
    def CONCAT(builder, *args: Any) -> Any: ...
    def TRIM(builder, expr: Any, chars: Any | None = ...) -> Any: ...
    def LTRIM(builder, expr: Any, chars: Any | None = ...) -> Any: ...
    def RTRIM(builder, expr: Any, chars: Any | None = ...) -> Any: ...
    def TO_INT(builder, expr: Any) -> Any: ...
    def TO_REAL(builder, expr: Any) -> Any: ...
    def TO_STR(builder, expr: Any) -> Any: ...
    def YEAR(builder, expr: Any) -> Any: ...
    def MONTH(builder, expr: Any) -> Any: ...
    def DAY(builder, expr: Any) -> Any: ...
    def HOUR(builder, expr: Any) -> Any: ...
    def MINUTE(builder, expr: Any) -> Any: ...
    def SECOND(builder, expr: Any) -> Any: ...
    def DATE_ADD(builder, expr: Any, delta: Any) -> Any: ...
    def DATE_SUB(builder, expr: Any, delta: Any) -> Any: ...
    def DATE_DIFF(builder, expr1: Any, expr2: Any) -> Any: ...
    def DATETIME_ADD(builder, expr: Any, delta: Any) -> Any: ...
    def DATETIME_SUB(builder, expr: Any, delta: Any) -> Any: ...
    def DATETIME_DIFF(builder, expr1: Any, expr2: Any) -> Any: ...
    def JSON_QUERY(builder, expr: Any, path: Any) -> Any: ...
    def JSON_VALUE(builder, expr: Any, path: Any, type: Any) -> Any: ...
    def JSON_NONZERO(builder, expr: Any) -> Any: ...
    def JSON_ARRAY_LENGTH(builder, value: Any) -> Any: ...
    def JSON_EQ(builder, left: Any, right: Any) -> Any: ...
    def JSON_NE(builder, left: Any, right: Any) -> Any: ...
    def JSON_CONTAINS(builder, expr: Any, path: Any, key: Any) -> Any: ...
    @classmethod
    def wrap_param_to_json_array(cls, values: Any) -> Any: ...
    def JSON_PARAM(builder, expr: Any) -> Any: ...

class MySQLStrConverter(dbapiprovider.StrConverter):
    def sql_type(converter) -> Any: ...

class MySQLRealConverter(dbapiprovider.RealConverter):
    def sql_type(converter) -> Any: ...

class MySQLBlobConverter(dbapiprovider.BlobConverter):
    def sql_type(converter) -> Any: ...

class MySQLTimeConverter(dbapiprovider.TimeConverter):
    def sql2py(converter, val: Any) -> Any: ...

class MySQLTimedeltaConverter(dbapiprovider.TimedeltaConverter):
    sql_type_name: str

class MySQLUuidConverter(dbapiprovider.UuidConverter):
    def sql_type(converter) -> Any: ...

class MySQLJsonConverter(dbapiprovider.JsonConverter):
    EQ: str
    NE: str
    def init(self, kwargs: Any) -> None: ...

class MySQLProvider(DBAPIProvider):
    dialect: str
    paramstyle: str
    quote_char: str
    max_name_len: int
    max_params_count: int
    table_if_not_exists_syntax: bool
    index_if_not_exists_syntax: bool
    max_time_precision: int
    default_time_precision: int
    varchar_default_max_len: int
    uint64_support: bool
    dbapi_module: Any
    dbschema_cls: Any
    translator_cls: Any
    sqlbuilder_cls: Any
    fk_types: Any
    converter_classes: Any
    def normalize_name(provider, name: Any) -> Any: ...
    def inspect_connection(provider, connection: Any) -> None: ...
    def should_reconnect(provider, exc: Any) -> Any: ...
    def get_pool(provider, *args: Any, **kwargs: Any) -> Any: ...
    def set_transaction_mode(provider, connection: Any, cache: Any) -> None: ...
    def release(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def table_exists(
        provider, connection: Any, table_name: Any, case_sensitive: bool = ...
    ) -> Any: ...
    def index_exists(
        provider,
        connection: Any,
        table_name: Any,
        index_name: Any,
        case_sensitive: bool = ...,
    ) -> Any: ...
    def fk_exists(
        provider,
        connection: Any,
        table_name: Any,
        fk_name: Any,
        case_sensitive: bool = ...,
    ) -> Any: ...

provider_cls = MySQLProvider

def str2datetime(s: Any) -> Any: ...
