from operator import attrgetter as attrgetter
from typing import Any

from pony import options as options
from pony.converting import timedelta2str as timedelta2str
from pony.orm.ormtypes import Json as Json
from pony.orm.ormtypes import RawSQL as RawSQL
from pony.py23compat import int_types as int_types
from pony.utils import datetime2timestamp as datetime2timestamp
from pony.utils import is_ident as is_ident
from pony.utils import throw as throw

class AstError(Exception): ...

class Param:
    def __init__(
        param,
        paramstyle: Any,
        paramkey: Any,
        converter: Any | None = ...,
        optimistic: bool = ...,
    ) -> None: ...
    def eval(param, values: Any) -> Any: ...

class CompositeParam(Param):
    def __init__(
        param, paramstyle: Any, paramkey: Any, items: Any, func: Any
    ) -> None: ...
    def eval(param, values: Any) -> Any: ...

class Value:
    paramstyle: Any
    value: Any
    def __init__(self, paramstyle: Any, value: Any) -> None: ...
    def quote_str(self, s: Any) -> Any: ...

def flat(tree: Any) -> Any: ...
def flat_conditions(conditions: Any) -> Any: ...
def join(delimiter: Any, items: Any) -> Any: ...
def move_conditions_from_inner_join_to_where(sections: Any) -> Any: ...
def make_binary_op(symbol: Any, default_parentheses: bool = ...) -> Any: ...
def make_unary_func(symbol: Any) -> Any: ...
def indentable(method: Any) -> Any: ...

class SQLBuilder:
    dialect: Any
    param_class: Any
    composite_param_class: Any
    value_class: Any
    indent_spaces: Any
    least_func_name: str
    greatest_func_name: str
    def __init__(builder, provider: Any, ast: Any) -> None: ...
    def __call__(builder, ast: Any) -> Any: ...
    def INSERT(
        builder, table_name: Any, columns: Any, values: Any, returning: Any | None = ...
    ) -> Any: ...
    def DEFAULT(builder) -> Any: ...
    def UPDATE(
        builder, table_name: Any, pairs: Any, where: Any | None = ...
    ) -> Any: ...
    def DELETE(builder, alias: Any, from_ast: Any, where: Any | None = ...) -> Any: ...
    def SELECT(builder, *sections: Any) -> Any: ...
    def SELECT_FOR_UPDATE(
        builder, nowait: Any, skip_locked: Any, *sections: Any
    ) -> Any: ...
    def EXISTS(builder, *sections: Any) -> Any: ...
    def NOT_EXISTS(builder, *sections: Any) -> Any: ...
    def ALL(builder, *expr_list: Any) -> Any: ...
    def DISTINCT(builder, *expr_list: Any) -> Any: ...
    def AGGREGATES(builder, *expr_list: Any) -> Any: ...
    def AS(builder, expr: Any, alias: Any) -> Any: ...
    def compound_name(builder, name_parts: Any) -> Any: ...
    def sql_join(builder, join_type: Any, sources: Any) -> Any: ...
    def FROM(builder, *sources: Any) -> Any: ...
    def INNER_JOIN(builder, *sources: Any) -> Any: ...
    def LEFT_JOIN(builder, *sources: Any) -> Any: ...
    def WHERE(builder, *conditions: Any) -> Any: ...
    def HAVING(builder, *conditions: Any) -> Any: ...
    def GROUP_BY(builder, *expr_list: Any) -> Any: ...
    def UNION(builder, kind: Any, *sections: Any) -> Any: ...
    def INTERSECT(builder, *sections: Any) -> Any: ...
    def EXCEPT(builder, *sections: Any) -> Any: ...
    def ORDER_BY(builder, *order_list: Any) -> Any: ...
    def DESC(builder, expr: Any) -> Any: ...
    def LIMIT(builder, limit: Any, offset: Any | None = ...) -> Any: ...
    def COLUMN(builder, table_alias: Any, col_name: Any) -> Any: ...
    def PARAM(
        builder, paramkey: Any, converter: Any | None = ..., optimistic: bool = ...
    ) -> Any: ...
    def make_param(builder, param_class: Any, paramkey: Any, *args: Any) -> Any: ...
    def make_composite_param(builder, paramkey: Any, items: Any, func: Any) -> Any: ...
    def STAR(builder, table_alias: Any) -> Any: ...
    def ROW(builder, *items: Any) -> Any: ...
    def VALUE(builder, value: Any) -> Any: ...
    def AND(builder, *cond_list: Any) -> Any: ...
    def OR(builder, *cond_list: Any) -> Any: ...
    def NOT(builder, condition: Any) -> Any: ...
    def POW(builder, expr1: Any, expr2: Any) -> Any: ...
    EQ: Any
    NE: Any
    LT: Any
    LE: Any
    GT: Any
    GE: Any
    ADD: Any
    SUB: Any
    MUL: Any
    DIV: Any
    FLOORDIV: Any
    def MOD(builder, a: Any, b: Any) -> Any: ...
    def FLOAT_EQ(builder, a: Any, b: Any) -> Any: ...
    def FLOAT_NE(builder, a: Any, b: Any) -> Any: ...
    def CONCAT(builder, *args: Any) -> Any: ...
    def NEG(builder, expr: Any) -> Any: ...
    def IS_NULL(builder, expr: Any) -> Any: ...
    def IS_NOT_NULL(builder, expr: Any) -> Any: ...
    def LIKE(builder, expr: Any, template: Any, escape: Any | None = ...) -> Any: ...
    def NOT_LIKE(
        builder, expr: Any, template: Any, escape: Any | None = ...
    ) -> Any: ...
    def BETWEEN(builder, expr1: Any, expr2: Any, expr3: Any) -> Any: ...
    def NOT_BETWEEN(builder, expr1: Any, expr2: Any, expr3: Any) -> Any: ...
    def IN(builder, expr1: Any, x: Any) -> Any: ...
    def NOT_IN(builder, expr1: Any, x: Any) -> Any: ...
    def COUNT(builder, distinct: Any, *expr_list: Any) -> Any: ...
    def SUM(builder, distinct: Any, expr: Any) -> Any: ...
    def AVG(builder, distinct: Any, expr: Any) -> Any: ...
    def GROUP_CONCAT(
        builder, distinct: Any, expr: Any, sep: Any | None = ...
    ) -> Any: ...
    UPPER: Any
    LOWER: Any
    LENGTH: Any
    ABS: Any
    def COALESCE(builder, *args: Any) -> Any: ...
    def MIN(builder, distinct: Any, *args: Any) -> Any: ...
    def MAX(builder, distinct: Any, *args: Any) -> Any: ...
    def SUBSTR(builder, expr: Any, start: Any, len: Any | None = ...) -> Any: ...
    def STRING_SLICE(builder, expr: Any, start: Any, stop: Any) -> Any: ...
    def CASE(builder, expr: Any, cases: Any, default: Any | None = ...) -> Any: ...
    def IF(builder, cond: Any, then: Any, else_: Any) -> Any: ...
    def TRIM(builder, expr: Any, chars: Any | None = ...) -> Any: ...
    def LTRIM(builder, expr: Any, chars: Any | None = ...) -> Any: ...
    def RTRIM(builder, expr: Any, chars: Any | None = ...) -> Any: ...
    def REPLACE(builder, str: Any, from_: Any, to: Any) -> Any: ...
    def TO_INT(builder, expr: Any) -> Any: ...
    def TO_STR(builder, expr: Any) -> Any: ...
    def TO_REAL(builder, expr: Any) -> Any: ...
    def TODAY(builder) -> Any: ...
    def NOW(builder) -> Any: ...
    def DATE(builder, expr: Any) -> Any: ...
    def YEAR(builder, expr: Any) -> Any: ...
    def MONTH(builder, expr: Any) -> Any: ...
    def DAY(builder, expr: Any) -> Any: ...
    def HOUR(builder, expr: Any) -> Any: ...
    def MINUTE(builder, expr: Any) -> Any: ...
    def SECOND(builder, expr: Any) -> Any: ...
    def RANDOM(builder) -> Any: ...
    def RAWSQL(builder, sql: Any) -> Any: ...
    def build_json_path(builder, path: Any) -> Any: ...
    @classmethod
    def eval_json_path(cls, values: Any) -> Any: ...
    def JSON_QUERY(builder, expr: Any, path: Any) -> None: ...
    def JSON_VALUE(builder, expr: Any, path: Any, type: Any) -> None: ...
    def JSON_NONZERO(builder, expr: Any) -> None: ...
    def JSON_CONCAT(builder, left: Any, right: Any) -> None: ...
    def JSON_CONTAINS(builder, expr: Any, path: Any, key: Any) -> None: ...
    def JSON_ARRAY_LENGTH(builder, value: Any) -> None: ...
    def JSON_PARAM(builder, expr: Any) -> Any: ...
    def ARRAY_INDEX(builder, col: Any, index: Any) -> None: ...
    def ARRAY_CONTAINS(builder, key: Any, not_in: Any, col: Any) -> None: ...
    def ARRAY_SUBSET(builder, array1: Any, not_in: Any, array2: Any) -> None: ...
    def ARRAY_LENGTH(builder, array: Any) -> None: ...
    def ARRAY_SLICE(builder, array: Any, start: Any, stop: Any) -> None: ...
    def MAKE_ARRAY(builder, *items: Any) -> None: ...
