# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_data.loading.ipynb.

# %% auto 0
__all__ = ['load_kssl']

# %% ../nbs/01_data.loading.ipynb 3
#nbdev_comment from __future__ import annotations
from pathlib import Path
import pickle
import numpy as np
from fastcore.test import *
from typing import List

# %% ../nbs/01_data.loading.ipynb 4
def load_kssl(src_dir:str, # folder path containing data
              fnames:List[str]=['spectra-features.npy', 'spectra-wavenumbers.npy', # filenames to open (in order)
                                'depth-order.npy', 'target.npy',
                                'tax-order-lu.pkl', 'spectra-id.npy'],
             loaders_lut:dict={'.npy': np.load, '.pkl': pickle.load} # loaders lookup table
             ):
    """
    Function loading USDA KSSL dataset focusing here on Exchangeable Potassium (analyte_id=725).

    Returns:
        A tuple (X, X_names, depth_order, y, tax) with:
            X: spectra (numpy.ndarray)
            X_names: spectra wavenumbers (numpy.ndarray)
            depth_order: depth and order of samples (numpy.ndarray)
            y: exchangeable potassium content (numpy.ndarray)
            tax_lookup: look up table order_id -> order_name (Dictionary)
            X_id: unique id of spectra
    """
    fnames = [Path(src_dir)/fname for fname in fnames]
    loaders = [loaders_lut[fname.suffix] for fname in fnames]
    return [loader(open(fname, 'rb')) for loader, fname in zip(loaders, fnames)]
