# Login

[Keycloak](https://www.keycloak.org/) is the name of the open-source user management software that's automatically
deployed within QHub. It's used to store the database of all users in your QHub instance, and can provide connectivity
to other services such as GitHub/Auth0 single sign-on.

As with many user admin tools, in Keycloak you start with an initial login (`root`) that has the ability to administer
and create new users. The `root` user is a Keycloak-specific user. It can only be used to login and manage the Keycloak
identity management section of QHub. It's not a user of the wider QHub data science platform.

## Change Keycloak root password

`root`'s password is generated by the `qhub init` command. If you ran this command while following the steps under
[Usage](usage.md), you should have seen something like the following in your terminal output:

```
Securely generated default random password=<alphanumeric-string> for Keycloak root user
```

The init command also saves the root user password to your `qhub-config.yaml` configuration file under the following
path:

`security.keycloak.initial_root_password`

After the initial deployment, it is **highly** recommended that you change the Keycloak `root` user password as soon as
you can.

> NOTE: Once you change the root password you will not be able to
> [add users from the command line](login.md#add-user-from-the-command-line)

> NOTE: From this point on, the `security.keycloak.initial_root_password` field in `qhub-config.yaml` has no effect. If
> you redeploy QHub it will not reset the password back to the old one (or anything else that might be in the field in
> your YAML file). We strongly recommend you delete this field to prevent later confusion.

1. To change the `root` user password, go to your QHub instance's admin dashboard—e.g., something like
   <https://myqhubsite.com/auth/admin/>—and log in with the password provided.

   ![QHub admin view - Root Login to Keycloak form](../images/keycloak_master_login.png)

2. From there, click on the 'Root' dropdown in the top right of the screen, and select 'Manage account'.

   ![Keycloak root user page - manage account tab selected](../images/keycloak_root_user_manage_account.png)

3. Under 'Account Security' click 'Signing In'.

   ![Keycloak root user page - account security](../images/keycloak_root_user_account_security.png)

4. In the Password section, click the 'Update' button. This will guide you through entering your existing root password,
   and then creating a new password.

   ![Keycloak root user page - account security, update password](../images/keycloak_root_user_update_password.png)

## Adding a QHub user

You will need to add a QHub user in order to log in to your QHub platform. If you have chosen to use GitHub or Auth0
single-sign-on, you must ensure the value you enter in Keycloak under 'Username' exactly matches the usernames from
GitHub or Auth0, respectively.

### Add user using Keycloak console

To add a QHub user from the web console for Keycloak, visit <https://myqhubsite.com/auth/admin/>. Log in using the
username `root`, as shown above.

All QHub users will be part of the `qhub` realm (a realm is a distinct identity provider and set of users in Keycloak).

> NOTE: The root user alone is a member of the `master` realm.

The `qhub` realm is selected by default, we strongly recommend leaving it as is.

Steps to create a new user:

1. Click 'Users' along the left-hand side of the page.

2. Click the 'Add user' button and you will see the new user form:

   ![Keycloak add user tab screenshot - new user form](../images/keycloak_add_users.png)

3. Fill out the three fields outlined above. These are 'Username', 'Email', and 'Groups'. (We explain these fields
   below.) Then click save.

4. Username. Depending on the authentication provider selected ('password', 'GitHub' or 'Auth0'), the values entered
   into the 'Username' field will differ slightly. The following table outlines those differences:

   |          | Password          | GitHub            | Auth0                 |
   | -------- | ----------------- | ----------------- | --------------------- |
   | Username | *unique username* | *GitHub username* | *Email to login with* |

5. Once the 'Username' field is updated, please add a valid email address in the 'Email' field.

   > NOTE: Although not required, users may not be able to log in to Grafana if this field isn't properly set.

6. Lastly, associate the user with one or more of the 'Groups'. Out of the box, QHub is deployed with the following
   groups: 'admin', 'analyst', and 'developer' (see the [Groups](./login.md#groups) section below for more details).

7. Click save.

Once the user is created, you can set a password.

> NOTE: Not needed for GitHub/Auth0 based authentication.

![Keycloak add user > credentials tab screenshot - set password](../images/keycloak_user_password.png)

It's best to put the 'Temporary' toggle in the 'OFF' position. Otherwise the user will be forced to change the password
on first login.

### Add user from the command line

To make adding users easier for new QHub deployments, there is a QHub command that can help.

> NOTE: If you [changed the initial_root_password for Keycloak](login.md#change-keycloak-root-password) this method will
> not work.

> NOTE: This method is primarily used by developers as a quick workaround.

Run:

```shell
qhub keycloak -c qhub-config.yaml adduser <username> <password>
```

This will create a user `<username>` with the initial password provided. Omit the password completely if you are using
GitHub or Auth0.

> NOTE: This will also add the user to the 'analyst' group.

## Login to QHub

Your new user can now log in to the main QHub dashboard (not Keycloak's admin console).

Visit <https://myqhubsite.com/> (or whatever domain you have chosen for your QHub).

Click 'Sign in with Keycloak'. This will take you to the login form:

![QHub - Log in to Keycloak page](../images/keycloak_qhub_login.png)

If you chose GitHub or Auth0 login, click the 'GitHub' button to be taken to a GitHub login page and single-sign-on from
there (as shown in the screenshot above). Otherwise, if you chose 'Password' based authentication, enter the username
and password you chose when you added a user to QHub above.

## Groups

Groups represent a collection of users that perform similar actions and therefore require similar permissions. By
default, QHub is deployed with the following groups: 'admin', 'developer', 'analyst' and 'viewer' (in roughly descending
order of power).

| Group       | Access to QHub Resources                                                                   |
| ----------- | ------------------------------------------------------------------------------------------ |
| 'admin'     | Conda-Store Admin <br> Dask Admin <br> Jupyterhub Admin <br> Grafana Admin                 |
| 'developer' | Conda-Store Developer <br> Dask Developer <br> Jupyterhub Developer <br> Grafana Developer |
| 'analyst'   | Conda-Store Developer <br> Jupyterhub Developer <br> Grafana Viewer                        |

To create new groups or modify (or delete) existing groups, log in as `root` and click 'Groups' on the left-hand side.

As an example, we create a new group named `conda-store-manager`. This group will have administrator access to the
Conda-Store service.

![Keycloak groups tab screenshot - user groups view](../images/keycloak_groups.png)

To create a new group, click 'New' in the upper-right hand corner. First, give the new group an appropriate name.

![Keycloak add group form - name field set to conda-store-manager](../images/keycloak_new_group1.png)

Then under 'Role Mapping', add the appropriate 'Client Roles' as needed; there should be no need to update the 'Realm
Roles'. In this example, the new group only has one mapped role however it's possible to attached multiple 'Client
Roles' to a single group.

![Keycloak group conda-store-manager form - role mappings tab focused with expanded client roles dropdown](../images/keycloak_new_group2.png)

In this example, the new group only has one mapped role (`conda_store_admin`); however it's possible to attached
multiple 'Client Roles' to a single group.

![Keycloak group conda-store-manager form - role mappings tab focused ](../images/keycloak_new_group3.png)

Once complete, return to the 'Users' section in the dashboard and add the relevant users to this newly created group.
