# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from mtmaisdk.clients.rest.models.handoff_message_config import HandoffMessageConfig
from mtmaisdk.clients.rest.models.stop_message_config import StopMessageConfig
from mtmaisdk.clients.rest.models.text_message_config import TextMessageConfig
from mtmaisdk.clients.rest.models.tool_call_message_config import ToolCallMessageConfig
from mtmaisdk.clients.rest.models.tool_call_result_message_config import ToolCallResultMessageConfig
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

AGENTMESSAGECONFIG_ONE_OF_SCHEMAS = ["HandoffMessageConfig", "StopMessageConfig", "TextMessageConfig", "ToolCallMessageConfig", "ToolCallResultMessageConfig"]

class AgentMessageConfig(BaseModel):
    """
    AgentMessageConfig
    """
    # data type: TextMessageConfig
    oneof_schema_1_validator: Optional[TextMessageConfig] = None
    # data type: StopMessageConfig
    oneof_schema_2_validator: Optional[StopMessageConfig] = None
    # data type: HandoffMessageConfig
    oneof_schema_3_validator: Optional[HandoffMessageConfig] = None
    # data type: ToolCallMessageConfig
    oneof_schema_4_validator: Optional[ToolCallMessageConfig] = None
    # data type: ToolCallResultMessageConfig
    oneof_schema_5_validator: Optional[ToolCallResultMessageConfig] = None
    actual_instance: Optional[Union[HandoffMessageConfig, StopMessageConfig, TextMessageConfig, ToolCallMessageConfig, ToolCallResultMessageConfig]] = None
    one_of_schemas: Set[str] = { "HandoffMessageConfig", "StopMessageConfig", "TextMessageConfig", "ToolCallMessageConfig", "ToolCallResultMessageConfig" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AgentMessageConfig.model_construct()
        error_messages = []
        match = 0
        # validate data type: TextMessageConfig
        if not isinstance(v, TextMessageConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TextMessageConfig`")
        else:
            match += 1
        # validate data type: StopMessageConfig
        if not isinstance(v, StopMessageConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StopMessageConfig`")
        else:
            match += 1
        # validate data type: HandoffMessageConfig
        if not isinstance(v, HandoffMessageConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `HandoffMessageConfig`")
        else:
            match += 1
        # validate data type: ToolCallMessageConfig
        if not isinstance(v, ToolCallMessageConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ToolCallMessageConfig`")
        else:
            match += 1
        # validate data type: ToolCallResultMessageConfig
        if not isinstance(v, ToolCallResultMessageConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ToolCallResultMessageConfig`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AgentMessageConfig with oneOf schemas: HandoffMessageConfig, StopMessageConfig, TextMessageConfig, ToolCallMessageConfig, ToolCallResultMessageConfig. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AgentMessageConfig with oneOf schemas: HandoffMessageConfig, StopMessageConfig, TextMessageConfig, ToolCallMessageConfig, ToolCallResultMessageConfig. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into TextMessageConfig
        try:
            instance.actual_instance = TextMessageConfig.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StopMessageConfig
        try:
            instance.actual_instance = StopMessageConfig.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into HandoffMessageConfig
        try:
            instance.actual_instance = HandoffMessageConfig.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ToolCallMessageConfig
        try:
            instance.actual_instance = ToolCallMessageConfig.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ToolCallResultMessageConfig
        try:
            instance.actual_instance = ToolCallResultMessageConfig.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AgentMessageConfig with oneOf schemas: HandoffMessageConfig, StopMessageConfig, TextMessageConfig, ToolCallMessageConfig, ToolCallResultMessageConfig. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AgentMessageConfig with oneOf schemas: HandoffMessageConfig, StopMessageConfig, TextMessageConfig, ToolCallMessageConfig, ToolCallResultMessageConfig. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], HandoffMessageConfig, StopMessageConfig, TextMessageConfig, ToolCallMessageConfig, ToolCallResultMessageConfig]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


